/* 
 * pLinguaCore: A JAVA library for Membrane Computing
 *              http://www.p-lingua.org
 *
 * Copyright (C) 2009  Research Group on Natural Computing
 *                     http://www.gcn.us.es
 *                      
 * This file is part of pLinguaCore.
 *
 * pLinguaCore is free software: you can redistribute it and/or modify
 * it under the terms of the GNU General Public License as published by
 * the Free Software Foundation, either version 3 of the License, or
 * (at your option) any later version.
 *
 * pLinguaCore is distributed in the hope that it will be useful,
 * but WITHOUT ANY WARRANTY; without even the implied warranty of
 * MERCHANTABILITY or FITNESS FOR A PARTICULAR PURPOSE. See the
 * GNU General Public License for more details.
 *
 * You should have received a copy of the GNU General Public License
 * along with pLinguaCore.  If not, see <http://www.gnu.org/licenses/>.
 */

package org.gcn.plinguacore.util.psystem.rule.kernel;

import org.gcn.plinguacore.util.MultiSet;
import org.gcn.plinguacore.util.psystem.membrane.ChangeableMembrane;
import org.gcn.plinguacore.util.psystem.rule.IKernelRule;
import org.gcn.plinguacore.util.psystem.rule.LeftHandRule;
import org.gcn.plinguacore.util.psystem.rule.OuterRuleMembrane;
import org.gcn.plinguacore.util.psystem.rule.RightHandRule;
import org.gcn.plinguacore.util.psystem.rule.AbstractRule;
import org.gcn.plinguacore.util.psystem.rule.guard.Guard;

public class DivisionKernelLikeRule extends AbstractRule implements IKernelRule {

	private Guard guard;
	/**
	 * 
	 */
	private static final long serialVersionUID = -2311858756048522881L;

	protected DivisionKernelLikeRule(boolean dissolves, LeftHandRule leftHandRule,
			RightHandRule rightHandRule) {
		super(dissolves, leftHandRule, rightHandRule);
		
	}
	
	

	protected DivisionKernelLikeRule(boolean dissolves, LeftHandRule leftHandRule,
			RightHandRule rightHandRule, Guard guard) {
		this(dissolves, leftHandRule, rightHandRule);
		this.guard = guard;
	}



	@Override
	protected void checkState() {
		
		super.checkState();
		if (dissolves())
			throw new IllegalArgumentException("Dissolution rules are not allowed");
	}



	@Override
	public long countExecutions(ChangeableMembrane membrane) {
		long executions = 0;
		MultiSet<String> ms = getLeftHandRule().getOuterRuleMembrane().getMultiSet();
		
		if (guard != null){
			guard.setMultiSet(membrane.getMultiSet());
			if(!guard.evaluate()) return 0;			
		}		
		if (!checkLabel(membrane))
			return 0;
		if (ms==null || ms.isEmpty())
			executions = 1;
		else
			executions = multiSetCount(ms, membrane.getMultiSet());
		return executions;
	}

	

	@Override
	protected boolean executeSafe(ChangeableMembrane membrane,
			MultiSet<String> environment, long executions) {
		MultiSet<String> ms = getLeftHandRule().getOuterRuleMembrane().getMultiSet();

		if (ms!=null && !ms.isEmpty())
			subtractMultiSet(ms, membrane.getMultiSet(), executions);
		if (getRightHandRule().getSecondOuterRuleMembrane()!=null)
		{
			ChangeableMembrane m1=membrane.divide();			
			updateMembrane(m1,getRightHandRule().getSecondOuterRuleMembrane(),executions);
		} 
		updateMembrane(membrane, getRightHandRule().getOuterRuleMembrane(),executions);
		return true;
	}

	@Override
	public Guard getGuard() {
		return guard;
	}
	
	@Override
	public String toString()
	{
		String arrow = " --> " ;
		String accumulator = getLeftHandRule().toString()+arrow+getRightHandRule().toString(false);
		if(guard!=null)
			accumulator+=" " + guard.toString();
		return accumulator;
	}



	@Override
	public byte getRuleType() {
		// TODO Auto-generated method stub
		return KernelRuleTypes.DIVISION;
	}



	@Override
	protected void updateMembrane(ChangeableMembrane m, OuterRuleMembrane orm,
			long executions) {
		// TODO Auto-generated method stub
		super.updateMembrane(m, orm, executions);
		m.setLabelObj(orm.getLabelObj());
	}
	
	
}
