package org.gcn.plinguacore.parser.input.plingua;

import java.util.LinkedList;
import java.util.List;
import java.util.ListIterator;
import java.util.Set;
import java.util.Stack;

import org.gcn.plinguacore.parser.input.plingua.PlinguaJavaCcParser.Range;
import org.gcn.plinguacore.util.HashMultiSet;
import org.gcn.plinguacore.util.MultiSet;
import org.gcn.plinguacore.util.psystem.rule.guard.AndJoinedGuard;
import org.gcn.plinguacore.util.psystem.rule.guard.Guard;
import org.gcn.plinguacore.util.psystem.rule.guard.LogicOperatedGuard;
import org.gcn.plinguacore.util.psystem.rule.guard.OrJoinedGuard;
import org.gcn.plinguacore.util.psystem.rule.guard.UnitGuard;

import sun.rmi.runtime.Log;

public class ObjectRangeExpander {
	
	protected static boolean checkSafeMode(PlinguaEnvironment environment, List<Range> rangeList){
		if(environment.isSafeMode()){
			ListIterator<Range> rangesIterator = rangeList.listIterator();
			Range currentRange = rangesIterator.next();
			String variable = currentRange.variable;
			environment.setVariable(variable, 0);
			return true;
		}
		return false;
	}
	public static void expandObject(MultiSet<String> ms, List<Range> rangeList, Stack<Token> ranges, PlinguaEnvironment environment, Set<String> nonCheckedVariables) throws PlinguaSemanticsException, ObjectRangeException{
		if(checkSafeMode(environment, rangeList)) return;			
		for(String object : ms){
			String replacedObject=object;
			ListIterator<Range> rangesIterator = rangeList.listIterator();
			while(rangesIterator.hasNext())
			{
 
				Range currentRange = rangesIterator.next();
				String variable = currentRange.variable;
				//nonCheckedVariables.remove(variable);
				int begin, end;
				begin = currentRange.
				beginNumber.
				intValue();
				if(currentRange.firstOperation==Range.LESS_OPERATION) begin++;
				end = currentRange.
				endNumber.
				intValue();
				if(currentRange.secondOperation==Range.LESS_OPERATION) end--;
				boolean changed=false;
				String originalObject = object; 
				for(int i= begin; i<=end; i++)
				{
					
					String previousObject=originalObject;
					replacedObject = originalObject.replaceAll(variable, ""+i);
					int n = PlinguaEnvironment.unknownValAssociations.get(variable);
					
					if (replacedObject.contains(""+(n+1)))
						throw new ObjectRangeException();
					replacedObject = replacedObject.replaceAll(n+"",  ""+i);
					boolean localChanged = !replacedObject.equals(previousObject);
					changed|=localChanged;
					if(localChanged)
						ms.add(replacedObject, ms.count(originalObject));
				}
				if(changed)
					ms.remove(originalObject);
			}
			return;


		}

	}
	
	
	public static Range processRanges(Stack<Token> ranges, List<Range> rangeList, PlinguaEnvironment environment, boolean diff, boolean op1, boolean op2, Token rangeToken, Number n1, Number n2, String variable){
	    if (ranges != null)
	    {
	      if (!diff) ranges.push(rangeToken);
	      else ranges.add(0, rangeToken);
	    }
	    Range builtRange = new Range(n1, op1, variable, op2, n2);
	    if(rangeList!=null) rangeList.add(builtRange);
	    return environment.isSafeMode() ? null : builtRange;
	}

	public static LogicOperatedGuard expandGuard(LogicOperatedGuard logicOperatedGuard,
			List<Range> rangeList, Stack<Token> ranges,
			PlinguaEnvironment currentEnvironment,
			Set<String> nonCheckedVariables) throws PlinguaSemanticsException, ObjectRangeException{
		if(checkSafeMode(currentEnvironment, rangeList)) return null;	
		
		ListIterator<Range> rangesIterator = rangeList.listIterator();
		List<String> guardStrings = new LinkedList<String>();
		guardStrings.add(logicOperatedGuard.toString());
		while(rangesIterator.hasNext()){
			Range currentRange = rangesIterator.next();
			String variable = currentRange.variable;
			//nonCheckedVariables.remove(variable);
			int begin, end;
			begin = currentRange.
					beginNumber.
					intValue();
			if(currentRange.firstOperation==Range.LESS_OPERATION) begin++;
			end = currentRange.
					endNumber.
					intValue();
			if(currentRange.secondOperation==Range.LESS_OPERATION) end--;
			//LogicOperatedGuard localAndGuard = new OrJoinedGuard();
				//boolean changed=false;
				//String originalObject = unitGuard.getObj();
			
			
			List<String> newGuardStrings = new LinkedList<String>();
			for(int i= begin; i<=end; i++)
			{
				for (String currentGuard : guardStrings){
					if (currentGuard == null){
						throw new ObjectRangeException("Range operation <> not allowed in guard ranges");
					}
					String newGuard = currentGuard.replaceAll(variable, ""+i);
					int n = PlinguaEnvironment.unknownValAssociations.get(variable);
					
					//if (newGuard.contains(""+(n+1)))
					//	throw new ObjectRangeException();
					newGuard = newGuard.replaceAll(n+"",  ""+i);
					newGuardStrings.add(newGuard);
				}				
			}
			guardStrings = newGuardStrings;
			
		}
		
		LogicOperatedGuard resultingGuard = new OrJoinedGuard();
		for (String guardString : guardStrings){
			resultingGuard.addGuard(new AndJoinedGuard(guardString));
		}
		
		return resultingGuard;
		
	}


}
