/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb.lib;

import java.io.File;
import java.io.FileWriter;
import java.io.PrintWriter;
import java.io.Writer;
import org.hsqldb.HsqlDateTime;
import org.hsqldb.lib.FileUtil;

public class SimpleLog {
    public static final int LOG_NONE = 0;
    public static final int LOG_ERROR = 1;
    public static final int LOG_NORMAL = 2;
    private PrintWriter writer;
    private int level;
    private boolean isSystem;
    private String filePath;

    public SimpleLog(String string, int n) {
        this.isSystem = string == null;
        this.filePath = string;
        this.setLevel(n);
    }

    private void setupWriter() {
        if (this.level == 0) {
            this.close();
            return;
        }
        if (this.writer == null) {
            if (this.isSystem) {
                this.writer = new PrintWriter(System.out);
            } else {
                File file = new File(this.filePath);
                this.setupLog(file);
            }
        }
    }

    private void setupLog(File file) {
        try {
            FileUtil.getFileUtil().makeParentDirectories(file);
            this.writer = new PrintWriter((Writer)new FileWriter(file.getPath(), true), true);
        }
        catch (Exception exception) {
            this.isSystem = true;
            this.writer = new PrintWriter(System.out);
        }
    }

    public int getLevel() {
        return this.level;
    }

    public void setLevel(int n) {
        this.level = n;
        this.setupWriter();
    }

    public PrintWriter getPrintWriter() {
        return this.writer;
    }

    public synchronized void sendLine(int n, String string) {
        if (this.level >= n) {
            this.writer.println(HsqlDateTime.getSytemTimeString() + " " + string);
        }
    }

    public synchronized void logContext(int n, String string) {
        if (this.level < n) {
            return;
        }
        String string2 = HsqlDateTime.getSytemTimeString();
        Throwable throwable = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable.getStackTrace();
        if (stackTraceElementArray.length > 1) {
            string2 = string2 + " " + stackTraceElementArray[1].getClassName() + "." + stackTraceElementArray[1].getMethodName();
        }
        this.writer.println(string2 + " " + string);
    }

    public synchronized void logContext(Throwable throwable, String string) {
        String string2 = string;
        if (this.level == 0) {
            return;
        }
        String string3 = HsqlDateTime.getSytemTimeString();
        Throwable throwable2 = new Throwable();
        StackTraceElement[] stackTraceElementArray = throwable2.getStackTrace();
        if (stackTraceElementArray.length > 1) {
            string3 = string3 + " " + stackTraceElementArray[1].getClassName() + "." + stackTraceElementArray[1].getMethodName();
        }
        if ((stackTraceElementArray = throwable.getStackTrace()).length > 0) {
            string3 = string3 + " " + stackTraceElementArray[0].getClassName() + "." + stackTraceElementArray[0].getMethodName();
        }
        if (string2 == null) {
            string2 = "";
        }
        if (this.writer != null) {
            this.writer.println(string3 + " " + throwable.toString() + " " + string2);
        }
    }

    public void flush() {
        if (this.writer != null) {
            this.writer.flush();
        }
    }

    public void close() {
        if (this.writer != null && !this.isSystem) {
            this.writer.close();
        }
        this.writer = null;
    }
}

