/*
 * Decompiled with CFR 0.152.
 */
package org.hsqldb;

import org.hsqldb.Expression;
import org.hsqldb.RangeVariable;
import org.hsqldb.Routine;
import org.hsqldb.RoutineSchema;
import org.hsqldb.Session;
import org.hsqldb.error.Error;
import org.hsqldb.lib.ArrayListIdentity;
import org.hsqldb.lib.HsqlList;
import org.hsqldb.lib.Set;
import org.hsqldb.result.Result;
import org.hsqldb.store.ValuePool;
import org.hsqldb.types.Type;

public class FunctionSQLInvoked
extends Expression {
    RoutineSchema routineSchema;
    Routine routine;

    FunctionSQLInvoked(RoutineSchema routineSchema) {
        super(routineSchema.isAggregate() ? 98 : 27);
        this.routineSchema = routineSchema;
    }

    public void setArguments(Expression[] expressionArray) {
        this.nodes = expressionArray;
    }

    @Override
    public HsqlList resolveColumnReferences(RangeVariable[] rangeVariableArray, int n, HsqlList hsqlList, boolean bl) {
        if (this.isSelfAggregate()) {
            if (hsqlList == null) {
                hsqlList = new ArrayListIdentity();
            }
            hsqlList.add(this);
            return hsqlList;
        }
        return super.resolveColumnReferences(rangeVariableArray, n, hsqlList, bl);
    }

    @Override
    public void resolveTypes(Session session, Expression expression) {
        int n;
        Type[] typeArray = new Type[this.nodes.length];
        for (n = 0; n < this.nodes.length; ++n) {
            Expression expression2 = this.nodes[n];
            expression2.resolveTypes(session, this);
            typeArray[n] = expression2.dataType;
        }
        this.routine = this.routineSchema.getSpecificRoutine(typeArray);
        for (n = 0; n < this.nodes.length; ++n) {
            if (this.nodes[n].dataType != null) continue;
            this.nodes[n].dataType = this.routine.getParameterTypes()[n];
        }
        this.dataType = this.routine.getReturnType();
    }

    /*
     * Unable to fully structure code
     */
    private Object getValueInternal(Session var1_1, Object[] var2_2) {
        var3_3 = false;
        var4_4 = this.routine.getVariableCount();
        var6_5 = this.routine.javaMethodWithConnection != false ? 1 : 0;
        var7_6 = ValuePool.emptyObjectArray;
        var8_7 = true;
        if (var6_5 + this.nodes.length > 0) {
            if (this.opType == 98) {
                var7_6 = new Object[this.routine.getParameterCount()];
                for (var9_8 = 0; var9_8 < var2_2.length; ++var9_8) {
                    var7_6[var9_8 + 1] = var2_2[var9_8];
                }
            } else {
                var7_6 = new Object[this.nodes.length + var6_5];
            }
            if (var6_5 > 0) {
                var7_6[0] = var1_1.getInternalConnection();
            }
        }
        var9_9 = this.routine.getParameterTypes();
        for (var10_10 = 0; var10_10 < this.nodes.length; ++var10_10) {
            var11_13 = this.nodes[var10_10];
            var12_15 = var11_13.getValue(var1_1, var9_9[var10_10]);
            if (var12_15 == null) {
                if (this.routine.isNullInputOutput()) {
                    return null;
                }
                if (!this.routine.getParameter(var10_10).isNullable()) {
                    return Result.newErrorResult(Error.error(4811));
                }
            }
            if (this.routine.isPSM()) {
                var7_6[var10_10] = var12_15;
                continue;
            }
            var7_6[var10_10 + var6_5] = var11_13.dataType.convertSQLToJava(var1_1, var12_15);
        }
        if (var8_7) {
            var1_1.sessionContext.push();
        }
        if (this.routine.isPSM()) {
            try {
                var1_1.sessionContext.routineArguments = var7_6;
                var1_1.sessionContext.routineVariables = ValuePool.emptyObjectArray;
                if (var4_4 > 0) {
                    var1_1.sessionContext.routineVariables = new Object[var4_4];
                }
                var5_16 = this.routine.statement.execute(var1_1);
                if (var2_2 == null) ** GOTO lbl56
                for (var10_10 = 0; var10_10 < var2_2.length; ++var10_10) {
                    var2_2[var10_10] = var7_6[var10_10 + 1];
                }
            }
            catch (Throwable var10_11) {
                var5_16 = Result.newErrorResult(var10_11);
            }
        } else {
            if (this.opType == 98) {
                var7_6 = this.routine.convertArgsToJava(var1_1, var7_6);
            }
            var5_16 = this.routine.invokeJavaMethod(var1_1, var7_6);
            if (this.opType == 98) {
                var10_12 = new Object[var7_6.length];
                this.routine.convertArgsToSQL(var1_1, var10_12, var7_6);
                for (var11_14 = 0; var11_14 < var2_2.length; ++var11_14) {
                    var2_2[var11_14] = var10_12[var11_14 + 1];
                }
            }
        }
lbl56:
        // 6 sources

        if (var8_7) {
            var1_1.sessionContext.pop();
        }
        if (var5_16.isError()) {
            throw var5_16.getException();
        }
        if (var3_3) {
            return var5_16.valueData;
        }
        return var5_16;
    }

    @Override
    public Object getValue(Session session) {
        if (this.opType == 5) {
            Object[] objectArray = session.sessionContext.rangeIterators[this.rangePosition].getCurrent();
            return objectArray[this.columnIndex];
        }
        Object object = this.getValueInternal(session, null);
        if (object instanceof Result) {
            Result result = (Result)object;
            if (result.isError()) {
                throw result.getException();
            }
            if (result.isSimpleValue()) {
                object = result.getValueObject();
            } else if (result.isData()) {
                object = result;
            } else {
                throw Error.error(4605, this.routine.getName().name);
            }
        }
        return object;
    }

    @Override
    public Result getResult(Session session) {
        Object object = this.getValueInternal(session, null);
        if (object instanceof Result) {
            return (Result)object;
        }
        return Result.newPSMResult(object);
    }

    @Override
    void collectObjectNames(Set set) {
        set.add(this.routine.getSpecificName());
    }

    @Override
    public String getSQL() {
        StringBuffer stringBuffer = new StringBuffer();
        stringBuffer.append(this.routineSchema.getName().getSchemaQualifiedStatementName());
        stringBuffer.append('(');
        int n = this.nodes.length;
        if (this.opType == 98) {
            n = 1;
        }
        for (int i = 0; i < n; ++i) {
            if (i != 0) {
                stringBuffer.append(',');
            }
            stringBuffer.append(this.nodes[i].getSQL());
        }
        stringBuffer.append(')');
        return stringBuffer.toString();
    }

    @Override
    public String describe(Session session, int n) {
        return super.describe(session, n);
    }

    @Override
    boolean isSelfAggregate() {
        return this.routineSchema.isAggregate();
    }

    public boolean isDeterministic() {
        return this.routine.isDeterministic();
    }

    @Override
    public Object updateAggregatingValue(Session session, Object object) {
        Object[] objectArray = (Object[])object;
        if (objectArray == null) {
            objectArray = new Object[3];
        }
        objectArray[0] = Boolean.FALSE;
        this.getValueInternal(session, objectArray);
        return objectArray;
    }

    @Override
    public Object getAggregatedValue(Session session, Object object) {
        Object[] objectArray = (Object[])object;
        if (objectArray == null) {
            objectArray = new Object[3];
        }
        objectArray[0] = Boolean.TRUE;
        Result result = (Result)this.getValueInternal(session, objectArray);
        if (result.isError()) {
            throw result.getException();
        }
        return result.getValueObject();
    }
}

