/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.mappings;

import java.security.AccessController;
import java.security.PrivilegedActionException;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Hashtable;
import java.util.List;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.changetracking.ChangeTracker;
import org.eclipse.persistence.descriptors.changetracking.CollectionChangeEvent;
import org.eclipse.persistence.descriptors.changetracking.MapChangeEvent;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.DescriptorException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.expressions.Expression;
import org.eclipse.persistence.expressions.ExpressionBuilder;
import org.eclipse.persistence.indirection.IndirectCollection;
import org.eclipse.persistence.internal.descriptors.ObjectBuilder;
import org.eclipse.persistence.internal.descriptors.changetracking.AttributeChangeListener;
import org.eclipse.persistence.internal.descriptors.changetracking.ObjectChangeListener;
import org.eclipse.persistence.internal.expressions.SQLDeleteStatement;
import org.eclipse.persistence.internal.expressions.SQLSelectStatement;
import org.eclipse.persistence.internal.helper.ClassConstants;
import org.eclipse.persistence.internal.helper.DatabaseField;
import org.eclipse.persistence.internal.helper.Helper;
import org.eclipse.persistence.internal.identitymaps.CacheKey;
import org.eclipse.persistence.internal.indirection.TransparentIndirectionPolicy;
import org.eclipse.persistence.internal.queries.ContainerPolicy;
import org.eclipse.persistence.internal.queries.DirectMapContainerPolicy;
import org.eclipse.persistence.internal.queries.JoinedAttributeManager;
import org.eclipse.persistence.internal.security.PrivilegedAccessHelper;
import org.eclipse.persistence.internal.security.PrivilegedClassForName;
import org.eclipse.persistence.internal.security.PrivilegedNewInstanceFromClass;
import org.eclipse.persistence.internal.sessions.AbstractRecord;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.internal.sessions.ChangeRecord;
import org.eclipse.persistence.internal.sessions.DirectMapChangeRecord;
import org.eclipse.persistence.internal.sessions.MergeManager;
import org.eclipse.persistence.internal.sessions.ObjectChangeSet;
import org.eclipse.persistence.internal.sessions.UnitOfWorkImpl;
import org.eclipse.persistence.mappings.DirectCollectionMapping;
import org.eclipse.persistence.mappings.converters.Converter;
import org.eclipse.persistence.mappings.converters.ObjectTypeConverter;
import org.eclipse.persistence.mappings.converters.TypeConversionConverter;
import org.eclipse.persistence.queries.DataReadQuery;
import org.eclipse.persistence.queries.DatabaseQuery;
import org.eclipse.persistence.queries.ObjectBuildingQuery;
import org.eclipse.persistence.queries.WriteObjectQuery;
import org.eclipse.persistence.sessions.DatabaseRecord;

public class DirectMapMapping
extends DirectCollectionMapping {
    protected DatabaseField directKeyField;
    protected Converter keyConverter;
    protected String keyConverterClassName;

    public DirectMapMapping() {
        this.selectionQuery = new DataReadQuery();
        this.containerPolicy = new DirectMapContainerPolicy(ClassConstants.Hashtable_Class);
    }

    public Converter getKeyConverter() {
        return this.keyConverter;
    }

    public void setKeyConverter(Converter keyConverter) {
        this.keyConverter = keyConverter;
    }

    public void setKeyConverterClassName(String keyConverterClassName) {
        this.keyConverterClassName = keyConverterClassName;
    }

    public void addToCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        collectionChangeRecord.addAdditionChange(newKey, newValue);
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object buildCloneForPartObject(Object attributeValue, Object original, Object clone, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        DirectMapContainerPolicy containerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        if (attributeValue == null) {
            return containerPolicy.containerInstance(1);
        }
        Object clonedAttributeValue = containerPolicy.containerInstance(containerPolicy.sizeFor(attributeValue));
        Object temporaryCollection = null;
        Object object = attributeValue;
        synchronized (object) {
            temporaryCollection = containerPolicy.cloneFor(attributeValue);
        }
        Object keysIterator = containerPolicy.iteratorFor(temporaryCollection);
        while (containerPolicy.hasNext(keysIterator)) {
            Object key = containerPolicy.next(keysIterator, unitOfWork);
            Object cloneKey = this.buildKeyClone(key, unitOfWork, isExisting);
            Object cloneValue = this.buildElementClone(containerPolicy.valueFromKey(key, temporaryCollection), unitOfWork, isExisting);
            containerPolicy.addInto(cloneKey, cloneValue, clonedAttributeValue, unitOfWork);
        }
        return clonedAttributeValue;
    }

    protected Object buildKeyClone(Object element, UnitOfWorkImpl unitOfWork, boolean isExisting) {
        Object cloneValue = element;
        if (this.getKeyConverter() != null && this.getKeyConverter().isMutable()) {
            cloneValue = this.getKeyConverter().convertDataValueToObjectValue(this.getKeyConverter().convertObjectValueToDataValue(cloneValue, unitOfWork), unitOfWork);
        }
        return cloneValue;
    }

    public void calculateDeferredChanges(ChangeRecord changeRecord, AbstractSession session) {
        DirectMapChangeRecord collectionRecord = (DirectMapChangeRecord)changeRecord;
        this.compareCollectionsForChange(collectionRecord.getOriginalCollection(), collectionRecord.getLatestCollection(), collectionRecord, session);
    }

    public ChangeRecord compareForChange(Object clone, Object backUp, ObjectChangeSet owner, AbstractSession session) {
        Object cloneAttribute = null;
        Object backUpAttribute = null;
        DirectMapContainerPolicy cp = (DirectMapContainerPolicy)this.getContainerPolicy();
        cloneAttribute = this.getAttributeValueFromObject(clone);
        if (cloneAttribute != null && !this.getIndirectionPolicy().objectIsInstantiated(cloneAttribute)) {
            return null;
        }
        Map cloneObjectCollection = (Map)this.getRealCollectionAttributeValueFromObject(clone, session);
        HashMap originalKeyValues = new HashMap(10);
        HashMap cloneKeyValues = new HashMap(10);
        if (!owner.isNew()) {
            backUpAttribute = this.getAttributeValueFromObject(backUp);
            if (backUpAttribute == null && cloneAttribute == null) {
                return null;
            }
            Map backUpCollection = (Map)this.getRealCollectionAttributeValueFromObject(backUp, session);
            Object backUpIter = cp.iteratorFor(backUpCollection);
            while (cp.hasNext(backUpIter)) {
                Object key = cp.next(backUpIter, session);
                originalKeyValues.put(key, backUpCollection.get(key));
            }
        }
        Object cloneIter = cp.iteratorFor(cloneObjectCollection);
        while (cp.hasNext(cloneIter)) {
            Object firstObject = cp.next(cloneIter, session);
            Object firstValue = cloneObjectCollection.get(firstObject);
            Object backupValue = originalKeyValues.get(firstObject);
            if (!originalKeyValues.containsKey(firstObject)) {
                cloneKeyValues.put(firstObject, cloneObjectCollection.get(firstObject));
                continue;
            }
            if (backupValue == null && firstValue != null || !backupValue.equals(firstValue)) {
                cloneKeyValues.put(firstObject, cloneObjectCollection.get(firstObject));
                continue;
            }
            originalKeyValues.remove(firstObject);
        }
        if (cloneKeyValues.isEmpty() && originalKeyValues.isEmpty() && !owner.isNew()) {
            return null;
        }
        DirectMapChangeRecord changeRecord = new DirectMapChangeRecord(owner);
        changeRecord.setAttribute(this.getAttributeName());
        changeRecord.setMapping(this);
        changeRecord.addAdditionChange(cloneKeyValues);
        changeRecord.addRemoveChange(originalKeyValues);
        return changeRecord;
    }

    public boolean compareObjects(Object firstObject, Object secondObject, AbstractSession session) {
        Object firstObjectMap = this.getRealCollectionAttributeValueFromObject(firstObject, session);
        Object secondObjectMap = this.getRealCollectionAttributeValueFromObject(secondObject, session);
        DirectMapContainerPolicy mapContainerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        return mapContainerPolicy.compareContainers(firstObjectMap, secondObjectMap);
    }

    public void convertClassNamesToClasses(ClassLoader classLoader) {
        super.convertClassNamesToClasses(classLoader);
        if (this.keyConverter != null) {
            if (this.keyConverter instanceof TypeConversionConverter) {
                ((TypeConversionConverter)this.keyConverter).convertClassNamesToClasses(classLoader);
            } else if (this.keyConverter instanceof ObjectTypeConverter) {
                ((ObjectTypeConverter)this.keyConverter).convertClassNamesToClasses(classLoader);
            }
        }
        if (this.keyConverterClassName != null) {
            Converter keyConverter;
            block13: {
                try {
                    if (PrivilegedAccessHelper.shouldUsePrivilegedAccess()) {
                        Class keyConverterClass;
                        try {
                            keyConverterClass = (Class)AccessController.doPrivileged(new PrivilegedClassForName(this.keyConverterClassName, true, classLoader));
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, exception.getException());
                        }
                        try {
                            keyConverter = (Converter)AccessController.doPrivileged(new PrivilegedNewInstanceFromClass(keyConverterClass));
                            break block13;
                        }
                        catch (PrivilegedActionException exception) {
                            throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, exception.getException());
                        }
                    }
                    Class keyConverterClass = PrivilegedAccessHelper.getClassForName(this.keyConverterClassName, true, classLoader);
                    keyConverter = (Converter)PrivilegedAccessHelper.newInstanceFromClass(keyConverterClass);
                }
                catch (ClassNotFoundException exc) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, exc);
                }
                catch (Exception e) {
                    throw ValidationException.classNotFoundWhileConvertingClassNames(this.keyConverterClassName, e);
                }
            }
            this.setKeyConverter(keyConverter);
        }
    }

    public DatabaseField getDirectKeyField() {
        return this.directKeyField;
    }

    public void initialize(AbstractSession session) throws DescriptorException {
        super.initialize(session);
        this.initializeDirectKeyField(session);
        this.initializeContainerPolicy(session);
        if (this.getKeyConverter() != null) {
            this.getKeyConverter().initialize(this, session);
        }
        if (this.getValueConverter() != null) {
            this.getValueConverter().initialize(this, session);
        }
    }

    protected void initializeContainerPolicy(AbstractSession session) {
        ((DirectMapContainerPolicy)this.getContainerPolicy()).setKeyField(this.getDirectKeyField());
        ((DirectMapContainerPolicy)this.getContainerPolicy()).setValueField(this.getDirectField());
        ((DirectMapContainerPolicy)this.getContainerPolicy()).setKeyConverter(this.getKeyConverter());
        ((DirectMapContainerPolicy)this.getContainerPolicy()).setValueConverter(this.getValueConverter());
    }

    protected void initializeDeleteQuery(AbstractSession session) {
        if (!this.getDeleteQuery().hasSessionName()) {
            this.getDeleteQuery().setSessionName(session.getName());
        }
        if (this.hasCustomDeleteQuery()) {
            return;
        }
        ExpressionBuilder builder = new ExpressionBuilder();
        Expression directKeyExp = ((Expression)builder).getField(this.getDirectKeyField()).equal(builder.getParameter(this.getDirectKeyField()));
        Expression expression = null;
        SQLDeleteStatement statement = new SQLDeleteStatement();
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Expression subExp1 = ((Expression)builder).getField(referenceKey);
            Expression subExp2 = builder.getParameter(sourceKey);
            Expression subExpression = subExp1.equal(subExp2);
            expression = subExpression.and(expression);
        }
        expression = expression.and(directKeyExp);
        statement.setWhereClause(expression);
        statement.setTable(this.getReferenceTable());
        this.getDeleteQuery().setSQLStatement(statement);
    }

    protected void initializeDirectKeyField(AbstractSession session) throws DescriptorException {
        if (this.getDirectKeyField() == null) {
            throw DescriptorException.directFieldNameNotSet(this);
        }
        this.getDirectKeyField().setTable(this.getReferenceTable());
        this.getDirectKeyField().setIndex(1);
    }

    protected void initializeInsertQuery(AbstractSession session) {
        super.initializeInsertQuery(session);
        this.getInsertQuery().getModifyRow().put(this.getDirectKeyField(), (Object)null);
    }

    protected void initializeSelectionStatement(AbstractSession session) {
        SQLSelectStatement statement = new SQLSelectStatement();
        statement.addTable(this.getReferenceTable());
        statement.addField((DatabaseField)this.getDirectField().clone());
        statement.addField((DatabaseField)this.getDirectKeyField().clone());
        statement.setWhereClause(this.getSelectionCriteria());
        statement.normalize(session, null);
        this.getSelectionQuery().setSQLStatement(statement);
    }

    public boolean isDirectMapMapping() {
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void mergeChangesIntoObject(Object target, ChangeRecord changeRecord, Object source, MergeManager mergeManager) {
        DirectMapContainerPolicy containerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        Map valueOfTarget = null;
        AbstractSession session = mergeManager.getSession();
        HashMap addObjects = ((DirectMapChangeRecord)changeRecord).getAddObjects();
        HashMap removeObjects = ((DirectMapChangeRecord)changeRecord).getRemoveObjects();
        valueOfTarget = this.isAttributeValueInstantiated(target) && !changeRecord.getOwner().isNew() ? (Map)this.getRealCollectionAttributeValueFromObject(target, session) : (Map)containerPolicy.containerInstance(addObjects.size());
        if (!this.isAttributeValueInstantiated(target)) {
            if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                return;
            }
            Object valueOfSource = this.getRealCollectionAttributeValueFromObject(source, session);
            Object iterator = containerPolicy.iteratorFor(valueOfSource);
            while (containerPolicy.hasNext(iterator)) {
                Object key = containerPolicy.next(iterator, session);
                containerPolicy.addInto(key, ((Map)valueOfSource).get(key), valueOfTarget, session);
            }
        } else {
            Object synchronizationTarget = valueOfTarget;
            if (valueOfTarget instanceof IndirectCollection) {
                synchronizationTarget = ((IndirectCollection)((Object)valueOfTarget)).getDelegateObject();
            }
            Map map = synchronizationTarget;
            synchronized (map) {
                for (Object keyToRemove : removeObjects.keySet()) {
                    containerPolicy.removeFrom(keyToRemove, null, valueOfTarget, session);
                }
                for (Object keyToAdd : addObjects.keySet()) {
                    Object nextItem = addObjects.get(keyToAdd);
                    if (mergeManager.shouldMergeChangesIntoDistributedCache()) {
                        if (containerPolicy.contains(nextItem, valueOfTarget, session)) continue;
                        containerPolicy.addInto(keyToAdd, nextItem, valueOfTarget, session);
                        continue;
                    }
                    containerPolicy.addInto(keyToAdd, nextItem, valueOfTarget, session);
                }
            }
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    public void mergeIntoObject(Object target, boolean isTargetUnInitialized, Object source, MergeManager mergeManager) {
        DirectMapChangeRecord changeRecord;
        ObjectChangeSet changeSet;
        if (isTargetUnInitialized && mergeManager.shouldMergeWorkingCopyIntoOriginal() && !this.isAttributeValueInstantiated(source)) {
            this.setAttributeValueInObject(target, this.getIndirectionPolicy().getOriginalIndirectionObject(this.getAttributeValueFromObject(source), mergeManager.getSession()));
            return;
        }
        if (!this.shouldMergeCascadeReference(mergeManager)) {
            return;
        }
        if (mergeManager.shouldRefreshRemoteObject() && this.usesIndirection()) {
            this.mergeRemoteValueHolder(target, source, mergeManager);
            return;
        }
        if (mergeManager.shouldMergeOriginalIntoWorkingCopy() ? !this.isAttributeValueInstantiated(target) : !this.isAttributeValueInstantiated(source)) {
            return;
        }
        Map valueOfSource = (Map)this.getRealCollectionAttributeValueFromObject(source, mergeManager.getSession());
        DirectMapContainerPolicy containerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        Object valueOfTarget = this.getRealCollectionAttributeValueFromObject(target, mergeManager.getSession());
        Object newContainer = containerPolicy.containerInstance(containerPolicy.sizeFor(valueOfSource));
        boolean fireChangeEvents = false;
        if (this.getDescriptor().getObjectChangePolicy().isObjectChangeTrackingPolicy() && target instanceof ChangeTracker && ((ChangeTracker)target)._persistence_getPropertyChangeListener() != null) {
            fireChangeEvents = true;
            Object iterator = containerPolicy.iteratorFor(valueOfTarget);
            while (containerPolicy.hasNext(iterator)) {
                Object key = containerPolicy.next(iterator, mergeManager.getSession());
                ((ObjectChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).internalPropertyChange(new MapChangeEvent(target, this.getAttributeName(), valueOfTarget, key, ((Map)valueOfTarget).get(key), CollectionChangeEvent.REMOVE));
            }
            if (newContainer instanceof ChangeTracker) {
                ((ChangeTracker)newContainer)._persistence_setPropertyChangeListener(((ChangeTracker)target)._persistence_getPropertyChangeListener());
            }
            if (valueOfTarget instanceof ChangeTracker) {
                ((ChangeTracker)valueOfTarget)._persistence_setPropertyChangeListener(null);
            }
        }
        valueOfTarget = newContainer;
        Object sourceValuesIterator = containerPolicy.iteratorFor(valueOfSource);
        while (containerPolicy.hasNext(sourceValuesIterator)) {
            Object sourceKey = containerPolicy.next(sourceValuesIterator, mergeManager.getSession());
            if (fireChangeEvents) {
                ((ObjectChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).internalPropertyChange(new MapChangeEvent(target, this.getAttributeName(), valueOfTarget, sourceKey, valueOfSource.get(sourceKey), CollectionChangeEvent.ADD));
            }
            containerPolicy.addInto(sourceKey, valueOfSource.get(sourceKey), valueOfTarget, mergeManager.getSession());
        }
        if (fireChangeEvents && this.getDescriptor().getObjectChangePolicy().isAttributeChangeTrackingPolicy() && (changeSet = ((AttributeChangeListener)((ChangeTracker)target)._persistence_getPropertyChangeListener()).getObjectChangeSet()) != null && (changeRecord = (DirectMapChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName())) != null) {
            if (!changeRecord.isDeferred()) {
                if (!changeRecord.hasChanges()) {
                    changeSet.removeChange(this.getAttributeName());
                }
            } else {
                changeRecord.setLatestCollection(valueOfTarget);
            }
        }
        this.setRealAttributeValueInObject(target, valueOfTarget);
    }

    public void postInsert(WriteObjectQuery query) throws DatabaseException {
        DatabaseRecord databaseRow = new DatabaseRecord();
        if (this.isReadOnly()) {
            return;
        }
        Object objects = this.getRealCollectionAttributeValueFromObject(query.getObject(), query.getSession());
        DirectMapContainerPolicy containerPolicy = (DirectMapContainerPolicy)this.getContainerPolicy();
        if (containerPolicy.isEmpty(objects)) {
            return;
        }
        this.prepareTranslationRow(query.getTranslationRow(), query.getObject(), query.getSession());
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Object sourceKeyValue = query.getTranslationRow().get(sourceKey);
            databaseRow.put(referenceKey, sourceKeyValue);
        }
        Object keyIter = containerPolicy.iteratorFor(objects);
        while (containerPolicy.hasNext(keyIter)) {
            Object key = containerPolicy.next(keyIter, query.getSession());
            Object value = containerPolicy.valueFromKey(key, objects);
            if (this.getKeyConverter() != null) {
                key = this.getKeyConverter().convertObjectValueToDataValue(key, query.getSession());
            }
            if (this.getValueConverter() != null) {
                value = this.getValueConverter().convertObjectValueToDataValue(value, query.getSession());
            }
            databaseRow.put(this.getDirectKeyField(), key);
            databaseRow.put(this.getDirectField(), value);
            if (query.shouldCascadeOnlyDependentParts()) {
                Object[] event = new Object[]{"insert", this.getInsertQuery(), databaseRow.clone()};
                query.getSession().getCommitManager().addDataModificationEvent(this, event);
                continue;
            }
            query.getSession().executeQuery((DatabaseQuery)this.getInsertQuery(), databaseRow);
        }
    }

    protected void postUpdateWithChangeSet(WriteObjectQuery writeQuery) throws DatabaseException {
        AbstractRecord thisRow;
        ObjectChangeSet changeSet = writeQuery.getObjectChangeSet();
        DirectMapChangeRecord changeRecord = (DirectMapChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (changeRecord == null) {
            return;
        }
        for (int index = 0; index < this.getReferenceKeyFields().size(); ++index) {
            DatabaseField referenceKey = this.getReferenceKeyFields().get(index);
            DatabaseField sourceKey = this.getSourceKeyFields().get(index);
            Object sourceKeyValue = writeQuery.getTranslationRow().get(sourceKey);
            writeQuery.getTranslationRow().put(referenceKey, sourceKeyValue);
        }
        for (Object key : changeRecord.getRemoveObjects().keySet()) {
            thisRow = (AbstractRecord)writeQuery.getTranslationRow().clone();
            if (this.getKeyConverter() != null) {
                key = this.getKeyConverter().convertObjectValueToDataValue(key, writeQuery.getSession());
            }
            thisRow.add(this.getDirectKeyField(), key);
            Object[] event = new Object[]{"delete", this.getDeleteQuery(), thisRow};
            writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
        }
        for (Object key : changeRecord.getAddObjects().keySet()) {
            thisRow = (AbstractRecord)writeQuery.getTranslationRow().clone();
            Object value = changeRecord.getAddObjects().get(key);
            if (this.getKeyConverter() != null) {
                key = this.getKeyConverter().convertObjectValueToDataValue(key, writeQuery.getSession());
            }
            if (this.getValueConverter() != null) {
                value = this.getValueConverter().convertObjectValueToDataValue(value, writeQuery.getSession());
            }
            thisRow.add(this.getDirectKeyField(), key);
            thisRow.add(this.getDirectField(), value);
            Object[] event = new Object[]{"insert", this.getInsertQuery(), thisRow};
            writeQuery.getSession().getCommitManager().addDataModificationEvent(this, event);
        }
    }

    public void removeFromCollectionChangeRecord(Object newKey, Object newValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        collectionChangeRecord.addRemoveChange(newKey, newValue);
    }

    public void setDirectKeyField(DatabaseField keyField) {
        this.directKeyField = keyField;
    }

    public void setDirectKeyFieldClassification(Class fieldType) {
        this.getDirectKeyField().setType(fieldType);
    }

    public void setDirectKeyFieldName(String fieldName) {
        this.setDirectKeyField(new DatabaseField(fieldName));
    }

    public void updateChangeRecord(Object clone, Object newValue, Object oldValue, ObjectChangeSet objectChangeSet, UnitOfWorkImpl uow) throws DescriptorException {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)objectChangeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(objectChangeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            objectChangeSet.addChange(collectionChangeRecord);
        }
        if (collectionChangeRecord.getOriginalCollection() == null) {
            collectionChangeRecord.setOriginalCollection(oldValue);
        }
        collectionChangeRecord.setLatestCollection(newValue);
        collectionChangeRecord.setIsDeferred(true);
        objectChangeSet.deferredDetectionRequiredOn(this.getAttributeName());
    }

    public void useMapClass(Class concreteClass) {
        if (!Helper.classImplementsInterface(concreteClass, ClassConstants.Map_Class)) {
            throw DescriptorException.illegalContainerClass(concreteClass);
        }
        DirectMapContainerPolicy policy = new DirectMapContainerPolicy(concreteClass);
        this.setContainerPolicy(policy);
    }

    public void useTransparentMap() {
        this.setIndirectionPolicy(new TransparentIndirectionPolicy());
        this.useMapClass(ClassConstants.IndirectMap_Class);
    }

    public void setKeyClass(Class keyClass) {
        TypeConversionConverter converter = new TypeConversionConverter(this);
        converter.setObjectClass(keyClass);
        this.setKeyConverter(converter);
    }

    public Class getKeyClass() {
        if (!(this.getKeyConverter() instanceof TypeConversionConverter)) {
            return null;
        }
        return ((TypeConversionConverter)this.getKeyConverter()).getObjectClass();
    }

    public void setValueClass(Class valueClass) {
        TypeConversionConverter converter = new TypeConversionConverter(this);
        converter.setObjectClass(valueClass);
        this.setValueConverter(converter);
    }

    public void simpleAddToCollectionChangeRecord(Object referenceKey, Object objectToAdd, ObjectChangeSet changeSet, AbstractSession session) {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            collectionChangeRecord.getAddObjects().put(referenceKey, objectToAdd);
            changeSet.addChange(collectionChangeRecord);
        } else if (collectionChangeRecord.getRemoveObjects().containsKey(referenceKey)) {
            collectionChangeRecord.getRemoveObjects().remove(referenceKey);
        } else {
            collectionChangeRecord.getAddObjects().put(referenceKey, objectToAdd);
        }
    }

    public void simpleRemoveFromCollectionChangeRecord(Object referenceKey, Object objectToRemove, ObjectChangeSet changeSet, AbstractSession session) {
        DirectMapChangeRecord collectionChangeRecord = (DirectMapChangeRecord)changeSet.getChangesForAttributeNamed(this.getAttributeName());
        if (collectionChangeRecord == null) {
            collectionChangeRecord = new DirectMapChangeRecord(changeSet);
            collectionChangeRecord.setAttribute(this.getAttributeName());
            collectionChangeRecord.setMapping(this);
            collectionChangeRecord.getRemoveObjects().put(referenceKey, objectToRemove);
            changeSet.addChange(collectionChangeRecord);
        } else if (collectionChangeRecord.getAddObjects().containsKey(referenceKey)) {
            collectionChangeRecord.getAddObjects().remove(referenceKey);
        } else {
            collectionChangeRecord.getRemoveObjects().put(referenceKey, objectToRemove);
        }
    }

    public Class getValueClass() {
        if (!(this.getValueConverter() instanceof TypeConversionConverter)) {
            return null;
        }
        return ((TypeConversionConverter)this.getValueConverter()).getObjectClass();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Object extractResultFromBatchQuery(DatabaseQuery query, AbstractRecord databaseRow, AbstractSession session, AbstractRecord argumentRow) {
        Hashtable referenceDataByKey = null;
        ContainerPolicy mappingContainerPolicy = this.getContainerPolicy();
        DatabaseQuery databaseQuery = query;
        synchronized (databaseQuery) {
            referenceDataByKey = (Hashtable)query.getProperty("batched objects");
            mappingContainerPolicy = this.getContainerPolicy();
            if (referenceDataByKey == null) {
                Vector rows = (Vector)session.executeQuery(query, argumentRow);
                referenceDataByKey = new Hashtable();
                Enumeration rowsEnum = rows.elements();
                while (rowsEnum.hasMoreElements()) {
                    AbstractRecord referenceRow = (AbstractRecord)rowsEnum.nextElement();
                    Object referenceKey = referenceRow.get(this.getDirectKeyField());
                    Object referenceValue = referenceRow.get(this.getDirectField());
                    CacheKey eachCacheKey = new CacheKey(this.extractKeyFromReferenceRow(referenceRow, session));
                    Object container = referenceDataByKey.get(eachCacheKey);
                    if (container == null) {
                        container = mappingContainerPolicy.containerInstance();
                        referenceDataByKey.put(eachCacheKey, container);
                    }
                    if (this.getKeyConverter() != null) {
                        referenceKey = this.getKeyConverter().convertDataValueToObjectValue(referenceKey, query.getSession());
                    }
                    if (this.getValueConverter() != null) {
                        referenceValue = this.getValueConverter().convertDataValueToObjectValue(referenceValue, query.getSession());
                    }
                    mappingContainerPolicy.addInto(referenceKey, referenceValue, container, query.getSession());
                }
                query.setProperty("batched objects", referenceDataByKey);
                query.setSession(null);
            }
        }
        Object result = referenceDataByKey.get(new CacheKey(this.extractPrimaryKeyFromRow(databaseRow, session)));
        if (result == null) {
            return mappingContainerPolicy.containerInstance();
        }
        return result;
    }

    protected Object valueFromRowInternalWithJoin(AbstractRecord row, JoinedAttributeManager joinManager, ObjectBuildingQuery sourceQuery, AbstractSession executionSession) throws DatabaseException {
        ContainerPolicy policy = this.getContainerPolicy();
        Object value = policy.containerInstance();
        ObjectBuilder objectBuilder = this.getDescriptor().getObjectBuilder();
        Vector sourceKey = objectBuilder.extractPrimaryKeyFromRow(row, executionSession);
        CacheKey sourceCacheKey = new CacheKey(sourceKey);
        List rows = joinManager.getDataResultsByPrimaryKey().get(sourceCacheKey);
        HashSet<Object> directValues = new HashSet<Object>();
        Converter keyConverter = this.getKeyConverter();
        Converter valueConverter = this.getValueConverter();
        for (int index = 0; index < rows.size(); ++index) {
            AbstractRecord sourceRow;
            AbstractRecord targetRow = sourceRow = (AbstractRecord)rows.get(index);
            Object directKey = (targetRow = this.trimRowForJoin(targetRow, joinManager, executionSession)).get(this.getDirectKeyField());
            if (directKey == null) {
                return this.getIndirectionPolicy().valueFromRow(value);
            }
            if (directValues.contains(directKey)) continue;
            directValues.add(directKey);
            if (keyConverter != null) {
                directKey = keyConverter.convertDataValueToObjectValue(directKey, executionSession);
            }
            Object directValue = targetRow.get(this.getDirectField());
            if (valueConverter != null) {
                directValue = valueConverter.convertDataValueToObjectValue(directValue, executionSession);
            }
            policy.addInto(directKey, directValue, value, executionSession);
        }
        return this.getIndirectionPolicy().valueFromRow(value);
    }
}

