/*
 * Decompiled with CFR 0.152.
 */
package org.eclipse.persistence.internal.sessions;

import java.sql.Connection;
import java.sql.SQLException;
import java.util.Collection;
import java.util.Date;
import java.util.Enumeration;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;
import java.util.Vector;
import org.eclipse.persistence.descriptors.ClassDescriptor;
import org.eclipse.persistence.exceptions.DatabaseException;
import org.eclipse.persistence.exceptions.EclipseLinkException;
import org.eclipse.persistence.exceptions.IntegrityException;
import org.eclipse.persistence.exceptions.OptimisticLockException;
import org.eclipse.persistence.exceptions.ValidationException;
import org.eclipse.persistence.internal.databaseaccess.Platform;
import org.eclipse.persistence.internal.helper.DBPlatformHelper;
import org.eclipse.persistence.internal.sequencing.Sequencing;
import org.eclipse.persistence.internal.sequencing.SequencingFactory;
import org.eclipse.persistence.internal.sequencing.SequencingHome;
import org.eclipse.persistence.internal.sessions.AbstractSession;
import org.eclipse.persistence.platform.database.DatabasePlatform;
import org.eclipse.persistence.platform.database.OraclePlatform;
import org.eclipse.persistence.platform.server.NoServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatform;
import org.eclipse.persistence.platform.server.ServerPlatformBase;
import org.eclipse.persistence.sequencing.SequencingControl;
import org.eclipse.persistence.sessions.DatabaseSession;
import org.eclipse.persistence.sessions.DatasourceLogin;
import org.eclipse.persistence.sessions.Login;
import org.eclipse.persistence.sessions.Project;

public class DatabaseSessionImpl
extends AbstractSession
implements DatabaseSession {
    private SequencingHome sequencingHome;
    private ServerPlatform serverPlatform;
    private long connectedTime;
    protected volatile boolean isLoggedIn;

    protected void setSequencingHome(SequencingHome sequencingHome) {
        this.sequencingHome = sequencingHome;
    }

    protected SequencingHome getSequencingHome() {
        if (this.sequencingHome == null) {
            this.setSequencingHome(SequencingFactory.createSequencingHome(this));
        }
        return this.sequencingHome;
    }

    public boolean isLoggedIn() {
        return this.isLoggedIn;
    }

    public SequencingControl getSequencingControl() {
        return this.getSequencingHome().getSequencingControl();
    }

    public Sequencing getSequencing() {
        return this.getSequencingHome().getSequencing();
    }

    public boolean isSequencingCallbackRequired() {
        return this.getSequencingHome().isSequencingCallbackRequired();
    }

    public void initializeSequencing() {
        this.getSequencingHome().onDisconnect();
        this.getSequencingHome().onConnect();
    }

    public void releaseJTSConnection() {
        this.getAccessor().closeJTSConnection();
    }

    public DatabaseSessionImpl() {
        this.setServerPlatform(new NoServerPlatform(this));
    }

    public DatabaseSessionImpl(Login login) {
        this(new Project(login));
    }

    public DatabaseSessionImpl(Project project) {
        super(project);
        this.setServerPlatform(new NoServerPlatform(this));
    }

    public void addDescriptor(ClassDescriptor descriptor) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptor(descriptor, this);
    }

    public void addDescriptors(Collection descriptors) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptors(descriptors, this);
    }

    public void addDescriptors(Project project) {
        this.lastDescriptorAccessed = null;
        this.getProject().addDescriptors(project, this);
    }

    public void connect() throws DatabaseException {
        this.getAccessor().connect(this.getDatasourceLogin(), this);
    }

    public void disconnect() throws DatabaseException {
        this.getSequencingHome().onDisconnect();
        this.getAccessor().disconnect(this);
    }

    public ServerPlatform getServerPlatform() {
        return this.serverPlatform;
    }

    public void setServerPlatform(ServerPlatform newServerPlatform) {
        if (this.isLoggedIn) {
            throw ValidationException.serverPlatformIsReadOnlyAfterLogin(newServerPlatform.getClass().getName());
        }
        this.serverPlatform = newServerPlatform;
    }

    protected void finalize() throws DatabaseException {
        if (this.isConnected()) {
            this.logout();
        }
    }

    public DatabasePlatform getPlatform() {
        if (this.platform == null) {
            if (this.isLoggedIn) {
                this.platform = this.getDatasourceLogin().getPlatform();
            } else {
                return this.getDatasourceLogin().getPlatform();
            }
        }
        return (DatabasePlatform)this.platform;
    }

    public Platform getDatasourcePlatform() {
        if (this.platform == null) {
            if (this.isLoggedIn) {
                this.platform = this.getDatasourceLogin().getDatasourcePlatform();
            } else {
                return this.getDatasourceLogin().getDatasourcePlatform();
            }
        }
        return this.platform;
    }

    public Platform getPlatform(Class domainClass) {
        if (this.platform == null) {
            if (this.isLoggedIn) {
                this.platform = this.getDatasourceLogin().getDatasourcePlatform();
            } else {
                return this.getDatasourceLogin().getDatasourcePlatform();
            }
        }
        return this.platform;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDescriptorIfSessionAlive(ClassDescriptor descriptor) {
        if (this.isConnected() && descriptor.requiresInitialization()) {
            try {
                try {
                    this.initializeSequencing();
                    descriptor.preInitialize(this);
                    descriptor.initialize(this);
                    descriptor.postInitialize(this);
                    this.getCommitManager().initializeCommitOrder();
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
                if (this.getIntegrityChecker().hasErrors()) {
                    this.handleException(new IntegrityException(this.getIntegrityChecker()));
                }
            }
            finally {
                this.clearIntegrityChecker();
            }
        }
    }

    public void initializeDescriptors() {
        this.initializeDescriptors((Map)((HashMap)this.getDescriptors()).clone());
        this.processJPAQueries();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDescriptors(Map descriptors) {
        this.initializeSequencing();
        try {
            AbstractSession session;
            for (ClassDescriptor descriptor : descriptors.values()) {
                try {
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (descriptor.requiresInitialization()) {
                        descriptor.preInitialize(session);
                    }
                    if (!descriptor.isAggregateDescriptor() && !descriptor.isAggregateCollectionDescriptor() || !descriptor.isChildDescriptor()) continue;
                    descriptor.initializeAggregateInheritancePolicy(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            for (ClassDescriptor descriptor : descriptors.values()) {
                try {
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization()) continue;
                    descriptor.initialize(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            for (ClassDescriptor descriptor : descriptors.values()) {
                try {
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization()) continue;
                    descriptor.postInitialize(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            try {
                this.getCommitManager().initializeCommitOrder();
            }
            catch (RuntimeException exception) {
                this.getIntegrityChecker().handleError(exception);
            }
            if (this.getIntegrityChecker().hasErrors()) {
                this.handleSevere(new IntegrityException(this.getIntegrityChecker()));
            }
        }
        finally {
            this.clearIntegrityChecker();
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void initializeDescriptors(Collection descriptors) {
        this.initializeSequencing();
        try {
            AbstractSession session;
            ClassDescriptor descriptor;
            Iterator descriptorEnum = descriptors.iterator();
            while (descriptorEnum.hasNext()) {
                try {
                    descriptor = (ClassDescriptor)descriptorEnum.next();
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (descriptor.requiresInitialization()) {
                        descriptor.preInitialize(session);
                    }
                    if (!descriptor.isAggregateDescriptor() || !descriptor.isChildDescriptor()) continue;
                    descriptor.initializeAggregateInheritancePolicy(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            descriptorEnum = descriptors.iterator();
            while (descriptorEnum.hasNext()) {
                try {
                    descriptor = (ClassDescriptor)descriptorEnum.next();
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization()) continue;
                    descriptor.initialize(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            descriptorEnum = descriptors.iterator();
            while (descriptorEnum.hasNext()) {
                try {
                    descriptor = (ClassDescriptor)descriptorEnum.next();
                    session = this.getSessionForClass(descriptor.getJavaClass());
                    if (!descriptor.requiresInitialization()) continue;
                    descriptor.postInitialize(session);
                }
                catch (RuntimeException exception) {
                    this.getIntegrityChecker().handleError(exception);
                }
            }
            try {
                this.getCommitManager().initializeCommitOrder();
            }
            catch (RuntimeException exception) {
                this.getIntegrityChecker().handleError(exception);
            }
            if (this.getIntegrityChecker().hasErrors()) {
                this.handleException(new IntegrityException(this.getIntegrityChecker()));
            }
        }
        finally {
            this.clearIntegrityChecker();
        }
    }

    public boolean isDatabaseSession() {
        return true;
    }

    protected Login getReadLogin() {
        return this.getDatasourceLogin();
    }

    public void loginAndDetectDatasource() throws DatabaseException {
        block13: {
            this.preConnectDatasource();
            Connection conn = null;
            try {
                conn = (Connection)this.getReadLogin().connectToDatasource(null, this);
                this.platform = null;
                String platformName = null;
                try {
                    platformName = DBPlatformHelper.getDBPlatform(conn.getMetaData().getDatabaseProductName(), this.getSessionLog());
                    this.getLogin().setPlatformClassName(platformName);
                }
                catch (EclipseLinkException classNotFound) {
                    if (platformName.indexOf("Oracle") != -1) {
                        this.getLogin().setPlatform(new OraclePlatform());
                        break block13;
                    }
                    throw classNotFound;
                }
            }
            catch (SQLException ex) {
                DatabaseException dbEx = DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
                dbEx.initCause(ex);
                throw dbEx;
            }
            finally {
                if (conn != null) {
                    try {
                        conn.close();
                    }
                    catch (SQLException ex) {
                        DatabaseException dbEx = DatabaseException.errorRetrieveDbMetadataThroughJDBCConnection();
                        dbEx.initCause(ex);
                        throw dbEx;
                    }
                }
            }
        }
        this.connect();
        this.postConnectDatasource();
    }

    public void login() throws DatabaseException {
        this.preConnectDatasource();
        this.connect();
        this.postConnectDatasource();
    }

    protected void preConnectDatasource() {
        if (this.isLoggedIn) {
            throw ValidationException.alreadyLoggedIn(this.getName());
        }
        this.platform = null;
        if (this.isInProfile()) {
            this.getProfiler().initialize();
        }
        this.updateProfile("loginTime", new Date(System.currentTimeMillis()));
        this.getEventManager().preLogin(this);
        this.getServerPlatform().initializeExternalTransactionController();
        this.log(5, null, "topLink_version", DatasourceLogin.getVersion());
        if (this.getServerPlatform().getServerNameAndVersion() != null && !this.getServerPlatform().getServerNameAndVersion().equals(ServerPlatformBase.DEFAULT_SERVER_NAME_AND_VERSION)) {
            this.log(5, null, "application_server_name_and_version", this.getServerPlatform().getServerNameAndVersion());
        }
        this.isLoggingOff = this.getLogLevel() == 8;
    }

    protected void postConnectDatasource() {
        this.initializeDescriptors();
        if (this.getCommandManager() != null) {
            this.getCommandManager().initialize();
        }
        this.log(5, null, "login_successful", this.getName());
        this.getEventManager().postLogin(this);
        this.initializeConnectedTime();
        this.isLoggedIn = true;
        this.platform = null;
        this.getServerPlatform().registerMBean();
    }

    public void login(String userName, String password) throws DatabaseException {
        this.getDatasourceLogin().setUserName(userName);
        this.getDatasourceLogin().setPassword(password);
        this.login();
    }

    public void login(Login login) throws DatabaseException {
        this.setLogin(login);
        this.login();
    }

    public void logout() throws DatabaseException {
        this.lastDescriptorAccessed = null;
        if (this.isInTransaction()) {
            throw DatabaseException.logoutWhileTransactionInProgress();
        }
        if (this.getAccessor() == null) {
            return;
        }
        this.setShouldPropagateChanges(false);
        if (this.getCommandManager() != null) {
            this.getCommandManager().shutdown();
        }
        this.getServerPlatform().unregisterMBean();
        this.disconnect();
        this.getIdentityMapAccessor().initializeIdentityMaps();
        this.isLoggedIn = false;
        this.log(5, null, "logout_successful", this.getName());
    }

    public void initializeConnectedTime() {
        this.connectedTime = System.currentTimeMillis();
    }

    public long getConnectedTime() {
        return this.connectedTime;
    }

    public void writeAllObjects(Collection domainObjects) throws DatabaseException, OptimisticLockException {
        Iterator objectsEnum = domainObjects.iterator();
        while (objectsEnum.hasNext()) {
            this.writeObject(objectsEnum.next());
        }
    }

    public void writeAllObjects(Vector domainObjects) throws DatabaseException, OptimisticLockException {
        Enumeration objectsEnum = domainObjects.elements();
        while (objectsEnum.hasMoreElements()) {
            this.writeObject(objectsEnum.nextElement());
        }
    }
}

