/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.parameterParser;

import cern.jet.random.Normal;
import cern.jet.random.engine.RandomEngine;
import ecoSim.DAOFacade;
import ecoSim.parameterParser.AbstractParameterParser;
import ecoSim.parameterParser.IParameterParserInputData;
import ecoSim.parameterParser.ParameterParserConstants;
import ecoSim.parameterParser.ParameterParserTokenManager;
import ecoSim.parameterParser.ParseException;
import ecoSim.parameterParser.SimpleCharStream;
import ecoSim.parameterParser.Token;
import ecoSim.parameterParser.VoidRangeException;
import java.io.InputStream;
import java.io.Reader;
import java.io.StringReader;
import java.io.UnsupportedEncodingException;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.gcn.plinguacore.util.RandomNumbersGenerator;

class ParameterParser
extends AbstractParameterParser
implements ParameterParserConstants {
    private Map<String, Number> vars;
    private Map<String, Number> pLinguaVars;
    private IParameterParserInputData inputData;
    private Number result1 = null;
    private Number result2 = null;
    private Number result3 = null;
    public ParameterParserTokenManager token_source;
    SimpleCharStream jj_input_stream;
    public Token token;
    public Token jj_nt;
    private int jj_ntk;
    private int jj_gen;
    private final int[] jj_la1 = new int[14];
    private static int[] jj_la1_0;
    private List<int[]> jj_expentries = new ArrayList<int[]>();
    private int[] jj_expentry;
    private int jj_kind = -1;

    static {
        ParameterParser.jj_la1_init_0();
    }

    public ParameterParser(String expression, IParameterParserInputData inputData, Map<String, Number> pLinguaVars) {
        this(new StringReader(expression));
        if (inputData == null) {
            throw new NullPointerException();
        }
        if (pLinguaVars == null) {
            throw new NullPointerException();
        }
        this.pLinguaVars = pLinguaVars;
        this.vars = new HashMap<String, Number>();
        this.inputData = inputData;
    }

    public Map<String, Number> getVars() {
        return this.vars;
    }

    public Number getFirstResult() {
        return this.result1;
    }

    public Number getSecondResult() {
        return this.result2;
    }

    public Number getThirdResult() {
        return this.result3;
    }

    public void parseIndex() throws ParseException, VoidRangeException {
        this.expression();
    }

    public void parseValue() throws ParseException {
        this.result1 = this.number();
    }

    private final void expression() throws ParseException, VoidRangeException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: 
            case 4: 
            case 5: 
            case 11: 
            case 13: 
            case 14: 
            case 19: 
            case 21: 
            case 22: 
            case 23: 
            case 24: 
            case 25: 
            case 26: 
            case 27: 
            case 28: 
            case 29: 
            case 30: {
                this.result1 = this.number();
                break;
            }
            case 9: {
                this.jj_consume_token(9);
                this.result1 = this.number();
                this.jj_consume_token(31);
                this.result2 = this.number();
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 8: {
                        this.jj_consume_token(8);
                        this.result3 = this.number();
                        break;
                    }
                    default: {
                        this.jj_la1[0] = this.jj_gen;
                    }
                }
                this.jj_consume_token(10);
                if (!(this.result1.doubleValue() > this.result2.doubleValue())) break;
                throw new VoidRangeException();
            }
            default: {
                this.jj_la1[1] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
    }

    private final Number pLinguaVar() throws ParseException {
        this.jj_consume_token(4);
        String str = this.token.image;
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 6: {
                this.jj_consume_token(6);
                str = String.valueOf(str) + "{";
                Number n = this.number();
                str = String.valueOf(str) + n.toString();
                block6: while (true) {
                    switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                        case 8: {
                            break;
                        }
                        default: {
                            this.jj_la1[2] = this.jj_gen;
                            break block6;
                        }
                    }
                    this.jj_consume_token(8);
                    n = this.number();
                    str = String.valueOf(str) + "," + n.toString();
                }
                this.jj_consume_token(7);
                str = String.valueOf(str) + "}";
                break;
            }
            default: {
                this.jj_la1[3] = this.jj_gen;
            }
        }
        if (!this.pLinguaVars.containsKey(str)) {
            throw new ParseException("Invalid parameter: " + str);
        }
        return this.pLinguaVars.get(str);
    }

    private final Number max() throws ParseException {
        this.jj_consume_token(28);
        this.jj_consume_token(8);
        Number n1 = this.number();
        this.jj_consume_token(8);
        Number n2 = this.number();
        this.jj_consume_token(20);
        if (n1.doubleValue() > n2.doubleValue()) {
            return n1;
        }
        return n2;
    }

    private final Number func() throws ParseException {
        this.jj_consume_token(29);
        this.jj_consume_token(8);
        this.jj_consume_token(4);
        String funcName = this.token.image;
        ArrayList<Number> ln = new ArrayList<Number>();
        ArrayList<String> mandatoryInterfaces = new ArrayList<String>();
        mandatoryInterfaces.add("algorithms.IAlgorithm");
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 8: {
                    break;
                }
                default: {
                    this.jj_la1[4] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(8);
            Number naux = this.number();
            ln.add(naux);
        }
        this.jj_consume_token(20);
        Number result = DAOFacade.callFunction(funcName, ln, mandatoryInterfaces);
        return result;
    }

    private final Number excel() throws ParseException {
        this.jj_consume_token(30);
        this.jj_consume_token(8);
        String formula = this.string0();
        this.jj_consume_token(20);
        System.out.println("La f\u00f3rmula es: " + formula);
        Number result = DAOFacade.evaluateExcelFormula(formula);
        return result;
    }

    private final String string0() throws ParseException {
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 1: {
                this.jj_consume_token(1);
                return this.token.image.substring(1, this.token.image.length() - 1);
            }
            case 5: {
                Token varTokenInit = this.token.next;
                String str = this.stringVariable();
                Token varTokenEnd = this.token;
                break;
            }
            default: {
                this.jj_la1[5] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        throw new Error("Missing return statement in function");
    }

    private final String stringVariable() throws ParseException {
        this.jj_consume_token(5);
        String result = this.token.image;
        this.jj_consume_token(4);
        return String.valueOf(result) + this.token.image;
    }

    private final Number random() throws ParseException {
        this.jj_consume_token(22);
        this.jj_consume_token(8);
        Number n = this.number();
        this.jj_consume_token(20);
        if (n.intValue() < 1) {
            throw new ParseException("Invalid parameter: " + n);
        }
        return ParameterParser.getNumber(RandomNumbersGenerator.getInstance().nextInt(n.intValue()) + 1);
    }

    private final Number normal() throws ParseException {
        this.jj_consume_token(27);
        this.jj_consume_token(8);
        Number n = this.number();
        this.jj_consume_token(8);
        Number n1 = this.number();
        this.jj_consume_token(8);
        Number n2 = this.number();
        this.jj_consume_token(20);
        return ParameterParser.getNumber(new Normal(n.doubleValue(), n1.doubleValue(), (RandomEngine)RandomNumbersGenerator.getInstance()).cdf(n2.doubleValue()));
    }

    private final Number var() throws ParseException {
        this.jj_consume_token(5);
        Number n = this.number();
        this.jj_consume_token(5);
        return this.vars.get(n.toString());
    }

    private final Number cellValue() throws ParseException {
        this.jj_consume_token(19);
        Number n1 = this.number();
        this.jj_consume_token(8);
        Number n2 = this.number();
        this.jj_consume_token(8);
        Number n3 = this.number();
        this.jj_consume_token(20);
        return ParameterParser.getNumber(this.inputData.getCellValue(n1.intValue(), n2.intValue(), n3.intValue()));
    }

    private final Number rows() throws ParseException {
        this.jj_consume_token(21);
        this.jj_consume_token(8);
        Number n = this.number();
        this.jj_consume_token(20);
        return new Integer(this.inputData.getRows(n.intValue()));
    }

    private final Number columns() throws ParseException {
        this.jj_consume_token(23);
        this.jj_consume_token(8);
        Number n = this.number();
        this.jj_consume_token(20);
        return new Integer(this.inputData.getColumns(n.intValue()));
    }

    private final Number cycles() throws ParseException {
        this.jj_consume_token(24);
        return new Integer(this.inputData.getSimulatedCycles());
    }

    private final Number sims() throws ParseException {
        this.jj_consume_token(25);
        return new Integer(this.inputData.getSimulationsByCycle());
    }

    private final Number steps() throws ParseException {
        this.jj_consume_token(26);
        return new Integer(this.inputData.getStepsByCycle());
    }

    private final Number constant() throws ParseException {
        this.jj_consume_token(3);
        return ParameterParser.getNumber(Double.parseDouble(this.token.image));
    }

    private final Number number0() throws ParseException {
        Number n;
        boolean neg = false;
        block0 : switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 13: 
            case 14: {
                switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                    case 13: {
                        this.jj_consume_token(13);
                        break block0;
                    }
                    case 14: {
                        this.jj_consume_token(14);
                        neg = true;
                        break block0;
                    }
                }
                this.jj_la1[6] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
            default: {
                this.jj_la1[7] = this.jj_gen;
            }
        }
        switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
            case 3: {
                n = this.constant();
                break;
            }
            case 24: {
                n = this.cycles();
                break;
            }
            case 25: {
                n = this.sims();
                break;
            }
            case 26: {
                n = this.steps();
                break;
            }
            case 21: {
                n = this.rows();
                break;
            }
            case 23: {
                n = this.columns();
                break;
            }
            case 19: {
                n = this.cellValue();
                break;
            }
            case 5: {
                n = this.var();
                break;
            }
            case 4: {
                n = this.pLinguaVar();
                break;
            }
            case 27: {
                n = this.normal();
                break;
            }
            case 22: {
                n = this.random();
                break;
            }
            case 28: {
                n = this.max();
                break;
            }
            case 29: {
                n = this.func();
                break;
            }
            case 30: {
                n = this.excel();
                break;
            }
            case 11: {
                this.jj_consume_token(11);
                n = this.number();
                this.jj_consume_token(12);
                break;
            }
            default: {
                this.jj_la1[8] = this.jj_gen;
                this.jj_consume_token(-1);
                throw new ParseException();
            }
        }
        if (neg && n != null) {
            return ParameterParser.getNumber(-n.doubleValue());
        }
        return n;
    }

    private final Number number1() throws ParseException {
        Number n1 = this.number0();
        block3: while (true) {
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 18: {
                    break;
                }
                default: {
                    this.jj_la1[9] = this.jj_gen;
                    break block3;
                }
            }
            this.jj_consume_token(18);
            Number n2 = this.number0();
            n1 = ParameterParser.getNumber(Math.pow(n1.doubleValue(), n2.doubleValue()));
        }
        return n1;
    }

    private final Number number2() throws ParseException {
        Number n1 = this.number1();
        block13: while (true) {
            int op;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: 
                case 16: 
                case 17: {
                    break;
                }
                default: {
                    this.jj_la1[10] = this.jj_gen;
                    break block13;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 15: {
                    this.jj_consume_token(15);
                    op = 1;
                    break;
                }
                case 16: {
                    this.jj_consume_token(16);
                    op = 2;
                    break;
                }
                case 17: {
                    this.jj_consume_token(17);
                    op = 3;
                    break;
                }
                default: {
                    this.jj_la1[11] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Number n2 = this.number1();
            switch (op) {
                case 1: {
                    n1 = ParameterParser.getNumber(n1.doubleValue() * n2.doubleValue());
                    break;
                }
                case 2: {
                    n1 = ParameterParser.getNumber(n1.doubleValue() / n2.doubleValue());
                    break;
                }
                case 3: {
                    n1 = ParameterParser.getNumber(n1.doubleValue() % n2.doubleValue());
                }
            }
        }
        return n1;
    }

    private final Number number() throws ParseException {
        Number n1 = this.number2();
        block11: while (true) {
            int op;
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: 
                case 14: {
                    break;
                }
                default: {
                    this.jj_la1[12] = this.jj_gen;
                    break block11;
                }
            }
            switch (this.jj_ntk == -1 ? this.jj_ntk() : this.jj_ntk) {
                case 13: {
                    this.jj_consume_token(13);
                    op = 1;
                    break;
                }
                case 14: {
                    this.jj_consume_token(14);
                    op = 2;
                    break;
                }
                default: {
                    this.jj_la1[13] = this.jj_gen;
                    this.jj_consume_token(-1);
                    throw new ParseException();
                }
            }
            Number n2 = this.number2();
            switch (op) {
                case 1: {
                    n1 = ParameterParser.getNumber(n1.doubleValue() + n2.doubleValue());
                    break;
                }
                case 2: {
                    n1 = ParameterParser.getNumber(n1.doubleValue() - n2.doubleValue());
                }
            }
        }
        return n1;
    }

    private static void jj_la1_init_0() {
        jj_la1_0 = new int[]{256, 2145937976, 256, 64, 256, 34, 24576, 24576, 2145912888, 262144, 229376, 229376, 24576, 24576};
    }

    public ParameterParser(InputStream stream) {
        this(stream, null);
    }

    public ParameterParser(InputStream stream, String encoding) {
        try {
            this.jj_input_stream = new SimpleCharStream(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source = new ParameterParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 14) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(InputStream stream) {
        this.ReInit(stream, null);
    }

    public void ReInit(InputStream stream, String encoding) {
        try {
            this.jj_input_stream.ReInit(stream, encoding, 1, 1);
        }
        catch (UnsupportedEncodingException e) {
            throw new RuntimeException(e);
        }
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 14) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public ParameterParser(Reader stream) {
        this.jj_input_stream = new SimpleCharStream(stream, 1, 1);
        this.token_source = new ParameterParserTokenManager(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 14) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(Reader stream) {
        this.jj_input_stream.ReInit(stream, 1, 1);
        this.token_source.ReInit(this.jj_input_stream);
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 14) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public ParameterParser(ParameterParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 14) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    public void ReInit(ParameterParserTokenManager tm) {
        this.token_source = tm;
        this.token = new Token();
        this.jj_ntk = -1;
        this.jj_gen = 0;
        int i = 0;
        while (i < 14) {
            this.jj_la1[i] = -1;
            ++i;
        }
    }

    private Token jj_consume_token(int kind) throws ParseException {
        Token oldToken = this.token;
        this.token = oldToken.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        if (this.token.kind == kind) {
            ++this.jj_gen;
            return this.token;
        }
        this.token = oldToken;
        this.jj_kind = kind;
        throw this.generateParseException();
    }

    public final Token getNextToken() {
        this.token = this.token.next != null ? this.token.next : (this.token.next = this.token_source.getNextToken());
        this.jj_ntk = -1;
        ++this.jj_gen;
        return this.token;
    }

    public final Token getToken(int index) {
        Token t = this.token;
        int i = 0;
        while (i < index) {
            t = t.next != null ? t.next : (t.next = this.token_source.getNextToken());
            ++i;
        }
        return t;
    }

    private int jj_ntk() {
        this.jj_nt = this.token.next;
        if (this.jj_nt == null) {
            this.token.next = this.token_source.getNextToken();
            this.jj_ntk = this.token.next.kind;
            return this.jj_ntk;
        }
        this.jj_ntk = this.jj_nt.kind;
        return this.jj_ntk;
    }

    public ParseException generateParseException() {
        this.jj_expentries.clear();
        boolean[] la1tokens = new boolean[32];
        if (this.jj_kind >= 0) {
            la1tokens[this.jj_kind] = true;
            this.jj_kind = -1;
        }
        int i = 0;
        while (i < 14) {
            if (this.jj_la1[i] == this.jj_gen) {
                int j = 0;
                while (j < 32) {
                    if ((jj_la1_0[i] & 1 << j) != 0) {
                        la1tokens[j] = true;
                    }
                    ++j;
                }
            }
            ++i;
        }
        i = 0;
        while (i < 32) {
            if (la1tokens[i]) {
                this.jj_expentry = new int[1];
                this.jj_expentry[0] = i;
                this.jj_expentries.add(this.jj_expentry);
            }
            ++i;
        }
        int[][] exptokseq = new int[this.jj_expentries.size()][];
        int i2 = 0;
        while (i2 < this.jj_expentries.size()) {
            exptokseq[i2] = this.jj_expentries.get(i2);
            ++i2;
        }
        return new ParseException(this.token, exptokseq, tokenImage);
    }

    public final void enable_tracing() {
    }

    public final void disable_tracing() {
    }
}

