/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui.swing;

import ecoSim.data.EcoSimStateEvent;
import ecoSim.data.EcoSimStateListener;
import ecoSim.gui.AbstractEcoSimGUI;
import ecoSim.gui.menu.EcoSimMenu;
import ecoSim.gui.menu.block.EcoSimEditMenuBlock;
import ecoSim.gui.menu.block.EcoSimFileMenuBlock;
import ecoSim.gui.menu.block.EcoSimHelpMenuBlock;
import ecoSim.gui.menu.block.EcoSimModelMenuBlock;
import ecoSim.gui.menu.block.EcoSimPluginsBlock;
import ecoSim.gui.menu.block.EcoSimSimulationBlock;
import javax.swing.JMenuBar;

public class JMenuListener
implements EcoSimStateListener {
    private AbstractEcoSimGUI gui;
    private JMenuBar jMenu;
    private static final long serialVersionUID = 3485238933419752134L;

    public JMenuListener(AbstractEcoSimGUI gui) {
        if (gui == null) {
            throw new NullPointerException();
        }
        this.gui = gui;
        this.jMenu = null;
        this.ecoSimStateChanged(new EcoSimStateEvent(gui.getData(), 0, 0, "Set Model"));
    }

    @Override
    public void ecoSimStateChanged(EcoSimStateEvent event) {
        if (event != null && event.getDescription() != null && event.getDescription().equals("Set Model")) {
            EcoSimMenu menu = new EcoSimMenu("GeneralMenu", 0, this.gui);
            menu.addMenu("Scenario", new EcoSimFileMenuBlock(this.gui));
            menu.addMenu("Edit", new EcoSimEditMenuBlock(this.gui));
            if (!this.gui.getData().isUserMode()) {
                menu.addMenu("Model", new EcoSimModelMenuBlock(this.gui));
            }
            menu.addMenu("Simulation", new EcoSimSimulationBlock(this.gui));
            menu.addMenu("Plugins", new EcoSimPluginsBlock(this.gui));
            menu.addMenu("Help", new EcoSimHelpMenuBlock(this.gui));
            this.jMenu = (JMenuBar)menu.getView();
            if (this.gui != null && this.gui.getFrame() != null) {
                this.gui.getFrame().setJMenuBar(this.jMenu);
            }
        }
    }

    public JMenuBar getjMenu() {
        return this.jMenu;
    }
}

