/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui.swing;

import ecoSim.data.AbstractEcoSimData;
import ecoSim.data.EcoSimStateEvent;
import ecoSim.data.EcoSimStateListener;
import ecoSim.factory.CustomEcoSimData;
import java.io.File;
import javax.swing.JLabel;

public class JLabelListener
extends JLabel
implements EcoSimStateListener {
    private static final long serialVersionUID = -3012202295459056370L;
    private AbstractEcoSimData data;

    public JLabelListener(AbstractEcoSimData data) {
        if (data == null) {
            throw new NullPointerException();
        }
        this.data = data;
        this.setText("");
        this.ecoSimStateChanged(null);
    }

    @Override
    public void ecoSimStateChanged(EcoSimStateEvent event) {
        File pf;
        String text = null;
        String datatext = null;
        String modeltext = null;
        File df = this.data.getDataFile();
        if (df != null) {
            if (df.exists()) {
                datatext = "<B>Scenario Data:</B> ";
                if (df.equals(this.data.getDefaultDataFile())) {
                    if (this.data.isUserMode()) {
                        datatext = "<FONT COLOR=\"green\">{default data}</FONT>";
                    } else {
                        datatext = String.valueOf(datatext) + df.getAbsolutePath();
                        datatext = String.valueOf(datatext) + "<FONT COLOR=\"green\"> {default data}</FONT>";
                    }
                } else {
                    datatext = String.valueOf(datatext) + df.getAbsolutePath();
                }
                if (this.data.getState() == 3) {
                    datatext = String.valueOf(datatext) + "<FONT COLOR=\"red\"> (unsaved)</FONT>";
                }
            } else {
                datatext = "<B>Scenario Data:</B> <FONT COLOR=\"red\"> Invalid path: " + df.getAbsolutePath() + "</FONT>";
            }
        } else {
            CustomEcoSimData cdata = (CustomEcoSimData)this.data;
            String dataPath = cdata.getDataPath();
            if (dataPath != null && dataPath.length() > 0) {
                datatext = "<B>Scenario Data:</B> <FONT COLOR=\"red\"> Invalid path: " + dataPath + "</FONT>";
            } else if (this.data.getState() == 3) {
                datatext = "<B>Scenario Data:</B> <FONT COLOR=\"red\">(unsaved)</FONT>";
            }
        }
        if ((pf = this.data.getPlinguaFile()) != null) {
            if (pf.exists()) {
                modeltext = "<B>Model:</B> " + pf.getAbsolutePath();
                if (pf.equals(this.data.getDefaultPlinguaFile())) {
                    modeltext = String.valueOf(modeltext) + "<FONT COLOR=\"green\"> {default model}</FONT>";
                }
            } else {
                modeltext = "<B>Model:</B> <FONT COLOR=\"red\"> Invalid path: " + pf.getAbsolutePath() + "</FONT>";
            }
        } else {
            modeltext = "<B>Model:</B> <FONT COLOR=\"red\">(to be set)</FONT>";
        }
        if (this.data.isUserMode()) {
            if (datatext != null) {
                text = datatext;
            }
        } else {
            text = "<FONT COLOR=\"blue\">P SYSTEM USER</FONT><BR>";
            if (datatext == null && modeltext != null) {
                text = String.valueOf(text) + modeltext;
            } else if (datatext != null && modeltext == null) {
                text = String.valueOf(text) + datatext;
            } else if (datatext != null && modeltext != null) {
                text = String.valueOf(text) + datatext + "<BR>" + modeltext;
            }
        }
        if (text != null) {
            if (this.data.getSimulatedCycles() > 0) {
                text = String.valueOf(text) + "<BR>Simulated cycles: " + this.data.getSimulatedCycles();
                text = String.valueOf(text) + "<BR>Simulations by cycle: " + this.data.getSimulationsByCycle();
                if (!this.data.isUserMode()) {
                    text = String.valueOf(text) + "<BR>Steps by cycle: " + this.data.getStepsByCycle();
                }
            } else {
                text = String.valueOf(text) + "<BR><FONT COLOR=\"blue\">Simulate until a halting condition</FONT>";
            }
            if (!this.data.isUserMode() && this.data.getSimulationAlgorithm() != null) {
                text = String.valueOf(text) + "<BR>Selected simulator: " + this.data.getSimulationAlgorithm();
            }
            text = "<HTML>" + text + "</HTML>";
        }
        if (this.getText() != null && text != null && !text.equals(this.getText())) {
            this.setText(text);
            this.data.saveCnfFile();
        } else if (this.getText() != text) {
            this.setText(text);
            this.data.saveCnfFile();
        }
    }
}

