/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui;

import ecoSim.DAOFacade;
import ecoSim.data.AbstractEcoSimData;
import ecoSim.factory.AbstractEcoSimFactory;
import ecoSim.factory.CustomOutputDataBlock;
import ecoSim.factory.CustomOutputSingleton;
import ecoSim.gui.AbstractEcoSimGUI;
import ecoSim.gui.MySwingWorker;
import ecoSim.gui.NullPrintStream;
import java.awt.Cursor;
import java.io.File;
import java.io.PrintStream;
import javax.swing.JOptionPane;
import org.gcn.plinguacore.simulator.ISimulator;

public class SimulationThread
extends MySwingWorker<Void, Void> {
    private static final NullPrintStream nullPrintStream = new NullPrintStream();
    private AbstractEcoSimGUI gui;

    public SimulationThread(AbstractEcoSimGUI gui) {
        this.gui = gui;
    }

    @Override
    protected Void doInBackground() throws Exception {
        try {
            File file;
            CustomOutputSingleton.resetOutputs();
            this.gui.getData().beginSimulationState();
            this.gui.getFrame().setCursor(Cursor.getPredefinedCursor(3));
            AbstractEcoSimData data = this.gui.getData();
            Integer[] integerArray = data.outputDataBlockIndexes();
            int n = integerArray.length;
            int n2 = 0;
            while (n2 < n) {
                Integer ind = integerArray[n2];
                this.gui.getData().getOutputDataBlock(ind).clear();
                ++n2;
            }
            this.gui.getData().readPLinguaFile(null, null, null, AbstractEcoSimFactory.getFactory(this.gui.getData().getFactoryName()).createParametersStrategy(), 0, null, this.gui.getData().getSimulationAlgorithm());
            if (this.gui.getData().getSimulator() == null) {
                JOptionPane.showMessageDialog(null, "Error in P-Lingua file", "Error", 0);
            } else if (this.gui.getData().getSimulatedCycles() == 0) {
                int k;
                file = new File(DAOFacade.getProperty("daikon-summary"));
                if (file.exists()) {
                    file.delete();
                }
                ISimulator sim = this.gui.getData().getSimulator();
                sim.setInfoChannel((PrintStream)nullPrintStream);
                this.gui.getBar().setMinimum(0);
                this.gui.getBar().setMaximum(50);
                boolean continueRunning = true;
                int[] numberOfStepsUntilStop = new int[this.gui.getData().getSimulationsByCycle()];
                int i = 1;
                while (i <= this.gui.getData().getSimulationsByCycle() && continueRunning) {
                    sim.reset();
                    Integer[] integerArray2 = data.outputDataBlockIndexes();
                    int n3 = integerArray2.length;
                    int n4 = 0;
                    while (n4 < n3) {
                        Integer ind = integerArray2[n4];
                        this.gui.getData().getOutputDataBlock(ind).update(0, 0, i, sim);
                        ++n4;
                    }
                    k = 1;
                    while (continueRunning) {
                        continueRunning = sim.step();
                        if (continueRunning) {
                            Integer[] integerArray3 = data.outputDataBlockIndexes();
                            int n5 = integerArray3.length;
                            n3 = 0;
                            while (n3 < n5) {
                                Integer ind = integerArray3[n3];
                                this.gui.getData().getOutputDataBlock(ind).update(k, 1, i, sim);
                                ++n3;
                            }
                        }
                        ++k;
                    }
                    numberOfStepsUntilStop[i - 1] = k - 2;
                    DAOFacade.persistRegisters();
                    continueRunning = true;
                    ++i;
                }
                Integer[] integerArray4 = data.outputDataBlockIndexes();
                int ind = integerArray4.length;
                k = 0;
                while (k < ind) {
                    Integer ind2 = integerArray4[k];
                    CustomOutputDataBlock cdb = (CustomOutputDataBlock)this.gui.getData().getOutputDataBlock(ind2);
                    cdb.generateTable();
                    int i2 = 1;
                    while (i2 <= this.gui.getData().getSimulationsByCycle()) {
                        DAOFacade.generateDaikonFile(i2, cdb, numberOfStepsUntilStop[i2 - 1]);
                        ++i2;
                    }
                    ++k;
                }
                this.gui.getBar().setValue(this.gui.getBar().getMaximum());
                this.gui.showOutput();
            } else {
                file = new File(DAOFacade.getProperty("daikon-summary"));
                if (file.exists()) {
                    file.delete();
                }
                ISimulator sim = this.gui.getData().getSimulator();
                sim.setInfoChannel((PrintStream)nullPrintStream);
                int simulations = this.gui.getData().getSimulationsByCycle() * this.gui.getData().getSimulatedCycles() * this.gui.getData().getStepsByCycle();
                this.gui.getBar().setMinimum(0);
                this.gui.getBar().setMaximum(simulations);
                int cont = 0;
                int i = 1;
                while (i <= this.gui.getData().getSimulationsByCycle()) {
                    sim.reset();
                    Integer[] integerArray5 = data.outputDataBlockIndexes();
                    int n6 = integerArray5.length;
                    int ind = 0;
                    while (ind < n6) {
                        Integer ind3 = integerArray5[ind];
                        this.gui.getData().getOutputDataBlock(ind3).update(0, 0, i, sim);
                        ++ind;
                    }
                    int j = 1;
                    while (j <= this.gui.getData().getSimulatedCycles()) {
                        int k = 1;
                        while (k <= this.gui.getData().getStepsByCycle()) {
                            sim.step();
                            this.gui.getBar().setValue(cont);
                            ++cont;
                            Integer[] integerArray6 = data.outputDataBlockIndexes();
                            int i2 = integerArray6.length;
                            int n7 = 0;
                            while (n7 < i2) {
                                Integer ind4 = integerArray6[n7];
                                this.gui.getData().getOutputDataBlock(ind4).update(k, j, i, sim);
                                ++n7;
                            }
                            ++k;
                        }
                        ++j;
                    }
                    ++i;
                }
                i = 1;
                while (i <= this.gui.getData().getSimulationsByCycle()) {
                    Integer[] integerArray7 = data.outputDataBlockIndexes();
                    int n8 = integerArray7.length;
                    int n9 = 0;
                    while (n9 < n8) {
                        Integer ind = integerArray7[n9];
                        CustomOutputDataBlock cdb = (CustomOutputDataBlock)this.gui.getData().getOutputDataBlock(ind);
                        DAOFacade.generateDaikonFile(i, cdb, this.gui.getData().getStepsByCycle());
                        ++n9;
                    }
                    ++i;
                }
                this.gui.getBar().setValue(this.gui.getBar().getMaximum());
                this.gui.showOutput();
            }
            return null;
        }
        catch (Exception ex) {
            ex.printStackTrace();
            throw ex;
        }
    }

    @Override
    protected void done() {
        this.gui.getFrame().setCursor(null);
        this.gui.getBar().setValue(0);
        this.gui.getData().endSimulationState();
        super.done();
    }
}

