/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui;

import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.IOException;
import javax.swing.JProgressBar;

public class ProgressBarFileInputStream
extends FileInputStream {
    private JProgressBar bar = null;
    private int cont;

    public ProgressBarFileInputStream(File arg0, JProgressBar bar) throws FileNotFoundException {
        super(arg0);
        this.bar = bar;
        if (bar != null) {
            bar.setMaximum((int)arg0.length());
            bar.setMinimum(0);
            bar.setValue(0);
        }
        this.cont = 0;
    }

    @Override
    public int read() throws IOException {
        ++this.cont;
        if (this.bar != null) {
            this.bar.setValue(this.cont);
        }
        return super.read();
    }

    @Override
    public int read(byte[] b, int off, int len) throws IOException {
        this.cont += b.length;
        if (this.bar != null) {
            this.bar.setValue(this.cont);
        }
        return super.read(b, off, len);
    }

    @Override
    public int read(byte[] b) throws IOException {
        this.cont += b.length;
        if (this.bar != null) {
            this.bar.setValue(this.cont);
        }
        return super.read(b);
    }

    @Override
    public long skip(long n) throws IOException {
        this.cont = (int)((long)this.cont + n);
        if (this.bar != null) {
            this.bar.setValue(this.cont);
        }
        return super.skip(n);
    }

    @Override
    public synchronized void reset() throws IOException {
        this.cont = 0;
        if (this.bar != null) {
            this.bar.setValue(0);
        }
        super.reset();
    }
}

