/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui;

import ecoSim.gui.AbstractEcoSimGUI;
import ecoSim.gui.AbstractEcoSimView;
import java.awt.Dimension;
import java.util.ArrayList;
import java.util.List;
import javax.swing.JComponent;
import javax.swing.JList;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.event.ListSelectionEvent;
import javax.swing.event.ListSelectionListener;

public class EcoSimMultiView
extends AbstractEcoSimView
implements ListSelectionListener {
    private List<AbstractEcoSimView> viewList = new ArrayList<AbstractEcoSimView>();
    private JSplitPane splitPanel = null;
    private JList list = null;

    public EcoSimMultiView(String name, boolean border, AbstractEcoSimGUI gui) {
        super(name, border, gui);
    }

    public boolean add(AbstractEcoSimView e) {
        boolean b = this.viewList.add(e);
        this.resetList();
        return b;
    }

    public JList getList() {
        return this.list;
    }

    public void clear() {
        this.viewList.clear();
        this.resetList();
    }

    private void resetList() {
        if (this.list == null) {
            return;
        }
        this.list.setListData(this.viewList.toArray());
    }

    @Override
    protected JComponent createSpecificView() {
        this.splitPanel = new JSplitPane(1);
        this.list = new JList<Object>(this.viewList.toArray());
        this.list.setSelectionMode(0);
        JScrollPane scrollPane = new JScrollPane();
        scrollPane.setViewportView(this.list);
        scrollPane.setName(this.getName());
        scrollPane.setPreferredSize(new Dimension(385, 193));
        this.splitPanel.add(scrollPane);
        this.splitPanel.add(new JPanel());
        this.splitPanel.setDividerLocation(0.2);
        this.list.addListSelectionListener(this);
        if (this.viewList.size() > 0) {
            this.list.setSelectedIndex(0);
        }
        return this.splitPanel;
    }

    @Override
    public void valueChanged(ListSelectionEvent arg0) {
        AbstractEcoSimView view;
        if (!arg0.getValueIsAdjusting() && (view = (AbstractEcoSimView)this.list.getSelectedValue()) != null) {
            this.splitPanel.setRightComponent(view.getView());
            this.splitPanel.setDividerLocation(0.2);
        }
    }
}

