/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.gui;

import ecoSim.DAOFacade;
import ecoSim.MeCoSimConfig;
import ecoSim.data.AbstractEcoSimData;
import ecoSim.data.DataBlockTableModel;
import ecoSim.entities.Tab;
import ecoSim.entities.TableData;
import ecoSim.factory.CustomOutputDataBlock;
import ecoSim.gui.AbstractEcoSimGUI;
import ecoSim.gui.EcoSimConsoleView;
import ecoSim.gui.EcoSimMultiView;
import ecoSim.gui.EcoSimViewTab;
import ecoSim.gui.EcoSimViewTable;
import ecoSim.utils.datatypes.Tree;
import java.util.ArrayList;
import java.util.List;

public class CustomEcoSimGUI
extends AbstractEcoSimGUI {
    private MeCoSimConfig mecosimConfig = new MeCoSimConfig();

    public List<Tree<Tab>> buildTrees(int idApp, int idPadre) {
        ArrayList<Tree<Tab>> list = new ArrayList<Tree<Tab>>();
        List<Tab> res = DAOFacade.getTabs(idApp, idPadre);
        for (Tab tdata : res) {
            Tree<Tab> t1 = new Tree<Tab>(tdata);
            List<Tree<Tab>> children = this.buildTrees(idApp, tdata.getIdTab());
            for (Tree<Tab> child : children) {
                t1.addChild(child);
            }
            list.add(t1);
        }
        return list;
    }

    public Tree<Tab> buildTree(int idApp) {
        Tree<Tab> t = null;
        t = this.buildTrees(idApp, 0).get(0);
        return t;
    }

    public EcoSimViewTab buildTabs(Tree<Tab> t, AbstractEcoSimGUI gui) {
        EcoSimViewTab tab = new EcoSimViewTab(t.getValue().getNombre(), gui);
        for (Tree<Tab> child : t.getChildren()) {
            TableData td = DAOFacade.getTableByTab(child.getValue().getIdApp(), child.getValue().getIdTab());
            if (td != null) {
                this.buildTableInTab(tab, td, gui);
                continue;
            }
            EcoSimViewTab childTab = this.buildTabs(child, gui);
            tab.getTabs().add(childTab);
        }
        return tab;
    }

    private EcoSimMultiView buildMultiView(TableData td, AbstractEcoSimGUI gui) {
        EcoSimMultiView ecMultiView = new EcoSimMultiView(String.valueOf(td.getTableConfig().getNombre()) + " Chart", false, gui);
        return ecMultiView;
    }

    public EcoSimViewTable buildTableInTab(EcoSimViewTab tab, TableData tdata, AbstractEcoSimGUI gui) {
        EcoSimViewTable table = null;
        DataBlockTableModel dataBlock = null;
        if (!tdata.getTableConfig().isOutput()) {
            dataBlock = this.getData().getDataBlock(tdata.getTableConfig().getIdTabla());
            table = new EcoSimViewTable(dataBlock, false, gui);
            tab.getTabs().add(table);
        } else {
            dataBlock = this.getData().getOutputDataBlock(tdata.getTableConfig().getIdTabla());
            table = new EcoSimViewTable(dataBlock, false, gui);
            if (tdata.getTableConfig().getGraphic() != null && !tdata.getTableConfig().getGraphic().equals("") && !tdata.getTableConfig().getGraphic().equals("None")) {
                EcoSimMultiView multiView = this.buildMultiView(tdata, gui);
                CustomOutputDataBlock codBlock = (CustomOutputDataBlock)dataBlock;
                codBlock.setGraphicView(multiView);
                EcoSimViewTab auxTab = new EcoSimViewTab(String.valueOf(tdata.getTableConfig().getNombre()) + " Group", gui);
                auxTab.getTabs().add(table);
                auxTab.getTabs().add(multiView);
                tab.getTabs().add(auxTab);
            } else {
                tab.getTabs().add(table);
            }
        }
        return table;
    }

    public CustomEcoSimGUI(AbstractEcoSimData data, boolean asEndUser) {
        super(data, asEndUser);
        Tree<Tab> arbol = this.buildTree(data.getApplicationID());
        EcoSimViewTab mainTab = this.buildTabs(arbol, this);
        if (!data.isUserMode()) {
            mainTab.getTabs().add(new EcoSimConsoleView(this));
        }
        this.setBody(mainTab);
        this.getMecosimConfig().setPLinguaFile(data.getPlinguaFile());
    }

    @Override
    public void showOutput() {
    }

    public MeCoSimConfig getMecosimConfig() {
        return this.mecosimConfig;
    }
}

