/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.factory;

import ecoSim.factory.PaintElement;
import ecoSim.factory.Tupla;
import java.awt.Color;
import java.awt.GradientPaint;
import java.awt.Paint;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Collections;
import java.util.HashMap;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Set;
import java.util.TreeSet;
import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.chart.LegendItem;
import org.jfree.chart.LegendItemCollection;
import org.jfree.chart.axis.SubCategoryAxis;
import org.jfree.chart.labels.StandardCategoryToolTipGenerator;
import org.jfree.chart.plot.CategoryPlot;
import org.jfree.chart.plot.PlotOrientation;
import org.jfree.chart.renderer.category.GroupedStackedBarRenderer;
import org.jfree.data.KeyToGroupMap;
import org.jfree.data.category.DefaultCategoryDataset;

public class CustomStackedBarChart {
    private String name;
    private String[][] resultTable;
    private String group;
    private String subgroup;
    private String part;
    private String dataName;
    int categoryIndex = 0;
    int subCategoryIndex = 1;
    int seriesIndex = 2;
    int dataIndex = 3;

    public CustomStackedBarChart() {
    }

    public CustomStackedBarChart(String name, String[][] resultTable, String group, String subgroup, String part, String dataName, int categoryIndex, int subCategoryIndex, int seriesIndex, int dataIndex) {
        this.name = name;
        this.resultTable = resultTable;
        this.group = group;
        this.subgroup = subgroup;
        this.part = part;
        this.dataName = dataName;
        this.categoryIndex = categoryIndex;
        this.subCategoryIndex = subCategoryIndex;
        this.seriesIndex = seriesIndex;
    }

    public JFreeChart showGraph(boolean makeVisible) {
        JFreeChart chart = null;
        if (this.resultTable != null && this.resultTable[0] != null && this.resultTable[0].length == 4) {
            Object item;
            Tupla t;
            DefaultCategoryDataset dataset = new DefaultCategoryDataset();
            ArrayList<String> subgroups = new ArrayList<String>();
            ArrayList<String> parts = new ArrayList<String>();
            List<Color> colors = this.generateColors();
            HashMap<String, PaintElement> paintsMap = new HashMap<String, PaintElement>();
            HashMap<String, PaintElement> paintsMap2 = new HashMap<String, PaintElement>();
            Paint[] paints = new Paint[this.resultTable.length];
            int assignedColors = 0;
            int orderedColors = 0;
            LinkedHashMap<String, Tupla> lhm = new LinkedHashMap<String, Tupla>();
            TreeSet<Integer> grupos = new TreeSet<Integer>();
            TreeSet<Integer> subgrupos = new TreeSet<Integer>();
            TreeSet<Object> partes = new TreeSet<Object>();
            int i = 0;
            while (i < this.resultTable.length) {
                String partData = this.resultTable[i][this.seriesIndex];
                String subgroupValue = this.resultTable[i][this.subCategoryIndex];
                String groupValue = this.resultTable[i][this.categoryIndex];
                grupos.add(new Integer(Integer.parseInt(groupValue)));
                subgrupos.add(new Integer(Integer.parseInt(subgroupValue)));
                try {
                    partes.add(new Integer(Integer.parseInt(partData)));
                }
                catch (NumberFormatException numberFormatException) {
                    partes.add(partData);
                }
                ++i;
            }
            for (Integer s1 : grupos) {
                for (Integer s2 : subgrupos) {
                    for (Object e : partes) {
                        t = new Tupla(s1.toString(), s2.toString(), e.toString(), 0.0);
                        lhm.put(t.getClave(), t);
                    }
                }
            }
            i = 0;
            while (i < this.resultTable.length) {
                double value = Double.parseDouble(this.resultTable[i][this.dataIndex]);
                String partData = this.resultTable[i][this.seriesIndex];
                String string = this.resultTable[i][this.subCategoryIndex];
                String groupValue = this.resultTable[i][this.categoryIndex];
                t = new Tupla(groupValue, string, partData, value);
                lhm.put(t.getClave(), t);
                ++i;
            }
            Collection valores = lhm.values();
            String[] paintsMapKeys = new String[valores.size()];
            for (Tupla t2 : valores) {
                System.out.println("A\u00f1adiendo " + t2.valor);
                dataset.addValue(t2.valor, (Comparable)((Object)t2.getElemento(this.part)), (Comparable)((Object)t2.getGroupValue(this.group)));
                if (subgroups.indexOf(t2.subgrupo) == -1) {
                    subgroups.add(t2.subgrupo);
                }
                if (parts.indexOf(t2.getPartValue(this.part)) == -1) {
                    parts.add(t2.getPartValue(this.part));
                    GradientPaint gradientPaint = new GradientPaint(0.0f, 0.0f, colors.get(assignedColors % colors.size()), 0.0f, 0.0f, colors.get(assignedColors % colors.size()));
                    PaintElement pe = new PaintElement();
                    pe.p = gradientPaint;
                    pe.partValue = t2.getPartValue(this.part);
                    pe.partData = t2.partData;
                    paintsMap.put(t2.partData, pe);
                    paints[assignedColors] = ((PaintElement)paintsMap.get((Object)t2.partData)).p;
                    ++assignedColors;
                }
                if (paintsMap2.get(t2.getElemento(this.part)) != null) continue;
                paintsMap2.put(t2.getElemento(this.part), (PaintElement)paintsMap.get(t2.partData));
                paintsMapKeys[orderedColors] = t2.getElemento(this.part);
                ++orderedColors;
            }
            String domain = String.valueOf(this.group) + " / " + this.subgroup + " - " + this.part;
            String range = this.dataName;
            chart = ChartFactory.createStackedBarChart(this.name.concat(" Stacked Bar Chart"), domain, range, dataset, PlotOrientation.VERTICAL, true, true, false);
            GroupedStackedBarRenderer groupedStackedBarRenderer = new GroupedStackedBarRenderer();
            String prefix = "G";
            String defaultGroup = String.valueOf(prefix) + 1;
            KeyToGroupMap map = new KeyToGroupMap((Comparable)((Object)defaultGroup));
            int groupIndex = 1;
            for (String subgroupValue : subgroups) {
                for (String partValue : parts) {
                    String elementName = String.valueOf(subgroupValue) + " (" + partValue + ")";
                    String groupName = String.valueOf(prefix) + groupIndex;
                    map.mapKeyToGroup((Comparable)((Object)elementName), (Comparable)((Object)groupName));
                    System.out.println("Mapeando " + elementName + " con " + groupName);
                }
                ++groupIndex;
            }
            groupedStackedBarRenderer.setSeriesToGroupMap(map);
            groupedStackedBarRenderer.setBaseToolTipGenerator(new StandardCategoryToolTipGenerator());
            LegendItemCollection items = new LegendItemCollection();
            Set keys = paintsMap.keySet();
            ArrayList keysList = new ArrayList(keys);
            ArrayList<Integer> keysListI = new ArrayList<Integer>();
            boolean numericOrder = true;
            Iterator it = keysList.iterator();
            while (it.hasNext() && numericOrder) {
                String s = (String)it.next();
                if (s.matches("[0-9]*(.[0-9])?")) {
                    keysListI.add(new Integer(Integer.parseInt(s)));
                    continue;
                }
                numericOrder = false;
            }
            if (numericOrder) {
                Collections.sort(keysListI);
                for (Integer i2 : keysListI) {
                    item = new LegendItem(((PaintElement)paintsMap.get((Object)i2.toString())).partData, ((PaintElement)paintsMap.get((Object)i2.toString())).p);
                    items.add((LegendItem)item);
                }
            } else {
                for (String s : keysList) {
                    item = new LegendItem(((PaintElement)paintsMap.get((Object)s)).partData, ((PaintElement)paintsMap.get((Object)s)).p);
                    items.add((LegendItem)item);
                }
            }
            int i3 = 0;
            while (i3 < orderedColors) {
                groupedStackedBarRenderer.setSeriesPaint(i3, ((PaintElement)paintsMap2.get((Object)paintsMapKeys[i3])).p);
                ++i3;
            }
            SubCategoryAxis domainAxis = new SubCategoryAxis(domain);
            domainAxis.setCategoryMargin(0.05);
            for (String subgroupValue : subgroups) {
                domainAxis.addSubCategory((Comparable)((Object)subgroupValue));
            }
            CategoryPlot plot = (CategoryPlot)chart.getPlot();
            plot.setDomainAxis(domainAxis);
            plot.setRenderer(groupedStackedBarRenderer);
            plot.setFixedLegendItems(items);
            if (makeVisible) {
                ChartFrame frame = new ChartFrame(this.name, chart);
                frame.pack();
                frame.setVisible(true);
            }
        }
        return chart;
    }

    private List<Color> generateColors() {
        ArrayList<Color> colors = new ArrayList<Color>();
        colors.add(new Color(255, 128, 192));
        colors.add(new Color(255, 255, 128));
        colors.add(new Color(128, 255, 128));
        colors.add(new Color(0, 128, 255));
        colors.add(new Color(255, 0, 0));
        colors.add(new Color(128, 128, 192));
        colors.add(new Color(128, 128, 64));
        colors.add(new Color(255, 128, 64));
        colors.add(new Color(0, 128, 128));
        colors.add(new Color(0, 64, 128));
        colors.add(new Color(0, 128, 0));
        colors.add(new Color(0, 0, 255));
        colors.add(new Color(128, 0, 128));
        colors.add(new Color(128, 128, 0));
        colors.add(new Color(64, 0, 64));
        colors.add(new Color(0, 255, 255));
        colors.add(new Color(128, 0, 255));
        colors.add(new Color(204, 238, 136));
        colors.add(new Color(34, 34, 68));
        colors.add(new Color(68, 102, 68));
        colors.add(new Color(102, 136, 68));
        colors.add(new Color(136, 170, 68));
        colors.add(new Color(170, 204, 68));
        colors.add(new Color(204, 238, 68));
        colors.add(new Color(34, 255, 68));
        colors.add(new Color(255, 102, 68));
        colors.add(new Color(255, 255, 68));
        colors.add(new Color(136, 255, 68));
        colors.add(new Color(170, 170, 68));
        colors.add(new Color(204, 0, 68));
        return colors;
    }
}

