/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.factory;

import org.jfree.chart.ChartFactory;
import org.jfree.chart.ChartFrame;
import org.jfree.chart.JFreeChart;
import org.jfree.data.general.DefaultPieDataset;
import org.jfree.data.general.PieDataset;

public class CustomPieChart {
    private String name;
    private String[][] resultTable;
    private int categoryIndex;
    private int dataIndex;

    public CustomPieChart() {
    }

    public CustomPieChart(String name, String[][] resultTable, int categoryIndex, int dataIndex) {
        this.name = name;
        this.resultTable = resultTable;
        this.categoryIndex = categoryIndex;
        this.dataIndex = dataIndex;
    }

    public JFreeChart showGraph(boolean makeVisible) {
        JFreeChart chart = null;
        if (this.resultTable != null && this.resultTable[0] != null && this.resultTable[0].length == 2) {
            DefaultPieDataset data = new DefaultPieDataset();
            int i = 0;
            while (i < this.resultTable.length) {
                data.setValue((Comparable)((Object)this.resultTable[i][this.categoryIndex]), Double.parseDouble(this.resultTable[i][this.dataIndex]));
                ++i;
            }
            chart = ChartFactory.createPieChart3D(this.name.concat(" Pie Chart"), (PieDataset)data, true, true, false);
            if (makeVisible) {
                ChartFrame frame = new ChartFrame(this.name, chart);
                frame.pack();
                frame.setVisible(true);
            }
        }
        return chart;
    }
}

