/*
 * Decompiled with CFR 0.152.
 */
package ecoSim.factory;

import ecoSim.data.AbstractEcoSimData;
import ecoSim.data.DataBlockTableModel;
import ecoSim.entities.TableColumn;
import ecoSim.entities.TableData;
import java.util.List;

public class CustomDataBlock
extends DataBlockTableModel {
    private TableData data = null;
    private static final long serialVersionUID = 8428360612990021163L;

    public CustomDataBlock(TableData data, AbstractEcoSimData listener) {
        super(data.getTableConfig().getNombre(), listener);
        if (data == null) {
            throw new NullPointerException();
        }
        this.data = data;
        this.clear();
    }

    @Override
    public void clear() {
        this.update(false);
    }

    @Override
    public void update(boolean keepData) {
        if (this.data != null) {
            int nRows = this.data.getTableConfig().getNrows();
            this.setSize(nRows, this.data.getTableConfig().getNcols());
            List<TableColumn> columns = this.data.getColumns();
            int iCol = 0;
            for (TableColumn cdata : columns) {
                this.setColumnName(cdata.getIdCol() - 1, cdata.getNombreCol());
                this.setColumnDescription(cdata.getIdCol() - 1, cdata.getTooltip());
                this.setColumnClass(cdata.getIdCol() - 1, String.class);
                int i = 0;
                while (i < nRows) {
                    this.setCellEditable(i, iCol, cdata.getSave());
                    ++i;
                }
                ++iCol;
            }
        }
    }
}

