/*
 * Decompiled with CFR 0.152.
 */
package ecoSim;

import ecoSim.EcoSimApp;
import ecoSim.Field;
import ecoSim.FieldCriteria;
import ecoSim.FieldCriteriaFormula;
import ecoSim.FieldFormula;
import ecoSim.FieldJoin;
import ecoSim.FunctionCallsManager;
import ecoSim.IField;
import ecoSim.IFieldCriteria;
import ecoSim.IFieldJoin;
import ecoSim.Main;
import ecoSim.OnMemoryDBManager;
import ecoSim.PluginsManager;
import ecoSim.ReflectionManager;
import ecoSim.Zip;
import ecoSim.entities.CurrentApp;
import ecoSim.entities.DBBackupWrapper;
import ecoSim.entities.GeneralData;
import ecoSim.entities.PlinguaParam;
import ecoSim.entities.PlinguaParamIndex;
import ecoSim.entities.PluginDaikonExtraction;
import ecoSim.entities.PluginDaikonIndex;
import ecoSim.entities.PluginDaikonTable;
import ecoSim.entities.SimulationCriteria;
import ecoSim.entities.SimulationRegister;
import ecoSim.entities.SimulationResult;
import ecoSim.entities.SimulationResultConfigData;
import ecoSim.entities.Tab;
import ecoSim.entities.TableColumn;
import ecoSim.entities.TableConfig;
import ecoSim.entities.TableData;
import ecoSim.entities.TablePK;
import ecoSim.factory.CustomOutputDataBlock;
import ecoSim.gui.AbstractEcoSimGUI;
import ecoSim.parameterParser.Parameter;
import ecoSim.properties.PluginsPropertiesStore;
import ecoSim.properties.PropertiesStore;
import ecoSim.properties.UnavailablePropertyException;
import java.io.BufferedReader;
import java.io.BufferedWriter;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.FileReader;
import java.io.FileWriter;
import java.io.IOException;
import java.sql.Connection;
import java.sql.PreparedStatement;
import java.sql.ResultSet;
import java.sql.SQLException;
import java.sql.Statement;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import java.util.Iterator;
import java.util.LinkedHashMap;
import java.util.List;
import java.util.Map;
import java.util.Set;
import java.util.SortedMap;
import java.util.SortedSet;
import java.util.StringTokenizer;
import java.util.TreeMap;
import java.util.TreeSet;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.EntityManagerFactory;
import javax.persistence.Persistence;
import javax.persistence.Query;
import javax.swing.JOptionPane;
import org.apache.poi.hssf.usermodel.HSSFRow;
import org.apache.poi.hssf.usermodel.HSSFSheet;
import org.apache.poi.hssf.usermodel.HSSFWorkbook;
import org.apache.poi.ss.usermodel.Cell;
import org.apache.poi.ss.usermodel.CellValue;
import org.apache.poi.ss.usermodel.CreationHelper;
import org.apache.poi.ss.usermodel.FormulaEvaluator;
import org.apache.poi.ss.usermodel.Row;
import org.gcn.plinguacore.util.Pair;
import org.gcn.plinguacore.util.PlinguaCoreException;
import org.gcn.plinguacore.util.psystem.Psystem;
import org.gcn.plinguacore.util.psystem.factory.AbstractPsystemFactory;

public final class DAOFacade {
    private static Connection memConn = null;
    private static PreparedStatement pstmt = null;
    private static PreparedStatement pstmtP = null;
    private static PreparedStatement pstmtPP = null;
    private static String configFile = null;
    public static final String PROPERTIES_DIR_PATH = "prop/";

    static {
        try {
            DAOFacade.setConfigFile(DAOFacade.getProperty("default-config-file"));
        }
        catch (UnavailablePropertyException e1) {
            e1.printStackTrace();
        }
    }

    public static void restartEnvironment() {
        Statement stmt;
        if (memConn != null) {
            stmt = null;
            try {
                stmt = memConn.createStatement();
                String sql = "DROP TABLE simulation_registers";
                stmt.executeUpdate(sql);
                sql = "DROP TABLE parsed_parameters";
                stmt.executeUpdate(sql);
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        } else {
            memConn = OnMemoryDBManager.getInstance().getConnection();
        }
        try {
            stmt = null;
            String creacion = "CREATE TABLE simulation_registers (appId INTEGER NOT NULL, simulation INTEGER NOT NULL, year INTEGER NOT NULL, step INTEGER NOT NULL, membraneID INTEGER NOT NULL, environmentID VARCHAR(50) NOT NULL, labelID VARCHAR(50) NOT NULL, object VARCHAR(50) NOT NULL, multiplicity BIGINT, PRIMARY KEY (appId,simulation,year,step,membraneID,environmentID,labelID,object))";
            stmt = memConn.createStatement();
            stmt.executeUpdate(creacion);
            Statement stmt2 = null;
            String creacion2 = "CREATE TABLE PUBLIC.PARSED_PARAMETERS (APPID INTEGER NOT NULL, PARAMETER VARCHAR(50) NOT NULL, INDEX1 INTEGER NOT NULL, INDEX2 INTEGER NOT NULL, INDEX3 INTEGER NOT NULL, INDEX4 INTEGER NOT NULL, DATA DOUBLE, PRIMARY KEY (APPID,PARAMETER,INDEX1,INDEX2,INDEX3,INDEX4))";
            stmt2 = memConn.createStatement();
            stmt2.executeUpdate(creacion2);
            pstmt = memConn.prepareStatement("INSERT INTO simulation_registers (appId,simulation,year,step,membraneID,environmentID,labelID,object,multiplicity) VALUES (?,?,?,?,?,?,?,?,?)");
            pstmtPP = memConn.prepareStatement("INSERT INTO parsed_parameters (appId,parameter,index1,index2,index3,index4,data) VALUES (?,?,?,?,?,?,?)");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void closeConnection() {
        if (memConn != null) {
            try {
                Statement st = memConn.createStatement();
                st.executeUpdate("SHUTDOWN");
                st.close();
                memConn.close();
            }
            catch (SQLException e) {
                e.printStackTrace();
            }
        }
    }

    private DAOFacade() {
    }

    public static void runApp(boolean asEndUser) {
        try {
            EcoSimApp.runApp(DAOFacade.getProperty("default-app"), asEndUser);
        }
        catch (UnavailablePropertyException e) {
            e.printStackTrace();
        }
    }

    public static void runApp(String app, boolean asEndUser) {
        try {
            EcoSimApp.runApp(app, asEndUser);
        }
        catch (UnavailablePropertyException e) {
            e.printStackTrace();
        }
    }

    public static String getProperty(String prop) throws UnavailablePropertyException {
        String property = null;
        PropertiesStore propStore = PropertiesStore.getInstance();
        property = propStore.getProperty(prop);
        return property;
    }

    public static void setProperty(String prop, String value) {
        PropertiesStore propStore = PropertiesStore.getInstance();
        propStore.setProperty(prop, value);
    }

    public static void saveProperties() {
        PropertiesStore propStore = PropertiesStore.getInstance();
        propStore.saveProperties();
    }

    public static void saveProperties(String fileName, LinkedHashMap<Object, Object> props) {
        PropertiesStore propStore = PropertiesStore.getInstance();
        propStore.saveProperties(fileName, props);
    }

    public static String getPluginProperty(String prop) throws UnavailablePropertyException {
        String property = null;
        PluginsPropertiesStore almacen = PluginsPropertiesStore.getInstance();
        property = almacen.getProperty(prop);
        return property;
    }

    public static void updateModelFromExcel(boolean saveApp, boolean saveGeneralData, boolean saveTabs, boolean saveTables, boolean saveParams, boolean saveSimulationResults) {
        System.out.println();
        System.out.println("<Initialization of the application>");
        System.out.println();
        System.out.println("\t1. Stating framework for the current application... ");
        if (saveApp) {
            DAOFacade.updateCurrentAppFromExcel();
        }
        System.out.println("\t2. Updating general information of the application... ");
        if (saveGeneralData) {
            DAOFacade.updateGeneralDataFromExcel();
        }
        System.out.println("\t3. Updating the hierarchy of tabs in main window... ");
        if (saveTabs) {
            DAOFacade.updateTabsFromExcel();
        }
        System.out.println("\t4. Updating tables structures (tables, rows, columns, types)... ");
        if (saveTables) {
            DAOFacade.updateTablesFromExcel();
        }
        System.out.println("\t5. Updating parameters to instantiate the initial P System... ");
        if (saveParams) {
            DAOFacade.updateParametersFromExcel();
        }
        System.out.println("\t6. Updating configuration of required outputs of the simulation... ");
        if (saveSimulationResults) {
            DAOFacade.updateSimulationResultsFromExcel();
        }
        System.out.println();
        System.out.println("<The Application has been successfully initialized>");
    }

    public static GeneralData getGeneralData() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        CurrentApp app = em.find(CurrentApp.class, 1);
        em.close();
        emf.close();
        return DAOFacade.getGeneralData(app.getIdApp());
    }

    public static GeneralData getGeneralData(int appId) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        CurrentApp app = em.find(CurrentApp.class, 1);
        GeneralData data = em.find(GeneralData.class, app.getIdApp());
        em.close();
        emf.close();
        return data;
    }

    public static void setGeneralData(GeneralData data) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        GeneralData data1 = em.find(GeneralData.class, data.getIdApp());
        data1.setAppName(data.getAppName());
        data1.setDataPath(data.getDataPath());
        data1.setModelPath(data.getModelPath());
        data1.setSimulatedYears(data.getSimulatedYears());
        data1.setSimulationsByYear(data.getSimulationsByYear());
        data1.setCurrentSimulator(data.getCurrentSimulator());
        data1.setStepsByYear(data.getStepsByYear());
        data1.setSaveParameters(data.isSaveParameters());
        em.getTransaction().begin();
        em.persist(data1);
        em.getTransaction().commit();
        em.close();
        emf.close();
    }

    public static GeneralData setGeneralData_ModelPath(String modelPath) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        CurrentApp app = em.find(CurrentApp.class, 1);
        GeneralData data = em.find(GeneralData.class, app.getIdApp());
        data.setModelPath(modelPath);
        em.getTransaction().begin();
        em.persist(data);
        em.getTransaction().commit();
        em.close();
        emf.close();
        return data;
    }

    public static GeneralData setGeneralData_DataPath(String dataPath) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        CurrentApp app = em.find(CurrentApp.class, 1);
        GeneralData data = em.find(GeneralData.class, app.getIdApp());
        data.setDataPath(dataPath);
        em.getTransaction().begin();
        em.persist(data);
        em.getTransaction().commit();
        em.close();
        emf.close();
        return data;
    }

    public static List<TableData> getTablesData(int idApp, boolean output) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT t FROM TableConfig t WHERE t.idApp = " + idApp + " AND t.output = " + output;
        Query query = em.createQuery(jpql);
        List results = query.getResultList();
        ArrayList<TableData> tablesList = new ArrayList<TableData>();
        for (TableConfig tc : results) {
            TableData table = new TableData();
            table.setTableConfig(tc);
            String jpql2 = "SELECT c FROM TableColumn c WHERE c.idApp = " + idApp + " AND c.idTabla = " + tc.getIdTabla();
            Query query2 = em.createQuery(jpql2);
            List results2 = query2.getResultList();
            table.setColumns(results2);
            tablesList.add(table);
        }
        em.close();
        emf.close();
        return tablesList;
    }

    public static TableData getTableByTab(int idApp, int idTab) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT t FROM TableConfig t WHERE t.idApp = " + idApp + " AND t.idTab = " + idTab;
        Query query = em.createQuery(jpql);
        List results = query.getResultList();
        TableData table = null;
        for (TableConfig tc : results) {
            table = new TableData();
            table.setTableConfig(tc);
            String jpql2 = "SELECT c FROM TableColumn c WHERE c.idApp = " + idApp + " AND c.idTabla = " + tc.getIdTabla();
            Query query2 = em.createQuery(jpql2);
            List results2 = query2.getResultList();
            table.setColumns(results2);
        }
        em.close();
        emf.close();
        return table;
    }

    public static List<Tab> getTabs(int idApp, int idTabPadre) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT t FROM Tab t WHERE t.idApp = " + idApp + " AND t.idTabPadre = " + idTabPadre;
        Query query = em.createQuery(jpql);
        List results = query.getResultList();
        em.close();
        emf.close();
        return results;
    }

    public static List<GeneralData> getApplicationsData() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT g FROM GeneralData g";
        Query query = em.createQuery(jpql);
        List results = query.getResultList();
        em.close();
        emf.close();
        return results;
    }

    private static List<Tab> getTabsData() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT t FROM Tab t";
        Query query = em.createQuery(jpql);
        List results = query.getResultList();
        em.close();
        emf.close();
        return results;
    }

    private static List<TableConfig> getTables() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT t FROM TableConfig t";
        Query query = em.createQuery(jpql);
        List results = query.getResultList();
        em.close();
        emf.close();
        return results;
    }

    public static boolean isSaveAllMode() {
        boolean saveAllMode = false;
        try {
            String saveAll = DAOFacade.getProperty("save-all");
            if (saveAll.equalsIgnoreCase("true")) {
                saveAllMode = true;
            }
        }
        catch (UnavailablePropertyException e) {
            e.printStackTrace();
        }
        return saveAllMode;
    }

    public static Set<Pair<Integer, Integer>> getStepsToSave(int appId) {
        HashSet<Pair<Integer, Integer>> steps = new HashSet<Pair<Integer, Integer>>();
        List<TableData> outputTablesData = DAOFacade.getTablesData(appId, true);
        for (TableData tdata : outputTablesData) {
            int tableId = tdata.getTableConfig().getIdTabla();
            steps.addAll(DAOFacade.getSimulationResultsWhereCriteria(appId, tableId));
        }
        return steps;
    }

    private static List<TableColumn> getTableColumns() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT t FROM TableColumn t";
        Query query = em.createQuery(jpql);
        List results = query.getResultList();
        em.close();
        emf.close();
        return results;
    }

    private static List<PluginDaikonTable> getDaikonTables() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT t FROM PluginDaikonTable t";
        Query query = em.createQuery(jpql);
        List results = query.getResultList();
        em.close();
        emf.close();
        return results;
    }

    private static List<PluginDaikonExtraction> getDaikonExtractions() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT t FROM PluginDaikonExtraction t";
        Query query = em.createQuery(jpql);
        List results = query.getResultList();
        em.close();
        emf.close();
        return results;
    }

    private static List<PluginDaikonIndex> getDaikonIndexes() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT t FROM PluginDaikonIndex t";
        Query query = em.createQuery(jpql);
        List results = query.getResultList();
        em.close();
        emf.close();
        return results;
    }

    private static List<PlinguaParam> getPlinguaParams() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT t FROM PlinguaParam t";
        Query query = em.createQuery(jpql);
        List results = query.getResultList();
        em.close();
        emf.close();
        return results;
    }

    private static List<PlinguaParamIndex> getPlinguaParamIndexes() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT t FROM PlinguaParamIndex t";
        Query query = em.createQuery(jpql);
        List results = query.getResultList();
        em.close();
        emf.close();
        return results;
    }

    private static List<SimulationResult> getSimulationResults() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT t FROM SimulationResult t";
        Query query = em.createQuery(jpql);
        List results = query.getResultList();
        em.close();
        emf.close();
        return results;
    }

    private static List<SimulationCriteria> getSimulationCriteria() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT t FROM SimulationCriteria t";
        Query query = em.createQuery(jpql);
        List results = query.getResultList();
        em.close();
        emf.close();
        return results;
    }

    private static List<SimulationRegister> getSimulationRegister() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT t FROM SimulationRegister t";
        Query query = em.createQuery(jpql);
        List results = query.getResultList();
        em.close();
        emf.close();
        return results;
    }

    public static Object[][] getApplicationsInfoForTbl() {
        List<GeneralData> appsGeneralData = DAOFacade.getApplicationsData();
        Object[][] apps = new Object[appsGeneralData.size()][8];
        int i = 0;
        for (GeneralData gd : appsGeneralData) {
            apps[i][0] = gd.getIdApp();
            apps[i][1] = gd.getAppName();
            apps[i][2] = gd.getModelPath();
            apps[i][3] = gd.getDataPath();
            apps[i][4] = gd.getCurrentSimulator();
            apps[i][5] = gd.getSimulationsByYear();
            apps[i][6] = gd.getSimulatedYears();
            apps[i][7] = gd.getStepsByYear();
            ++i;
        }
        return apps;
    }

    public static List<Parameter> getParameters(int idApp) {
        ArrayList<Parameter> params = new ArrayList<Parameter>();
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        String jpql = "SELECT p FROM PlinguaParam p WHERE p.appId = " + idApp;
        Query query = em.createQuery(jpql);
        List pLinguaParams = query.getResultList();
        for (PlinguaParam par : pLinguaParams) {
            Parameter p = new Parameter(par.getparamName());
            p.setValue(par.getparamValue());
            p.setSec(par.getparamSec());
            String jpql2 = "SELECT pi FROM PlinguaParamIndex pi WHERE pi.appId = " + idApp + " AND pi.paramName = \"" + par.getparamName() + "\" AND pi.paramSec = " + par.getparamSec();
            Query query2 = em.createQuery(jpql2);
            List results2 = query2.getResultList();
            for (PlinguaParamIndex pi : results2) {
                p.getIndexes().add(pi.getParamIndex());
            }
            params.add(p);
        }
        em.close();
        emf.close();
        return params;
    }

    /*
     * Loose catch block
     */
    public static void updateCurrentAppFromExcel() {
        block11: {
            EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
            EntityManager em = emf.createEntityManager();
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(DAOFacade.getConfigFile());
                    HSSFWorkbook wb = new HSSFWorkbook(fis);
                    HSSFSheet sheet = wb.getSheet(DAOFacade.getProperty("default-config-file-info"));
                    HSSFRow row = sheet.getRow(1);
                    int idApp = (int)row.getCell(1).getNumericCellValue();
                    CurrentApp app = em.find(CurrentApp.class, 1);
                    app.setIdApp(idApp);
                    em.getTransaction().begin();
                    em.persist(app);
                    em.getTransaction().commit();
                    fis.close();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    em.close();
                    emf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    em.close();
                    emf.close();
                }
                catch (UnavailablePropertyException e) {
                    e.printStackTrace();
                    try {
                        fis.close();
                    }
                    catch (IOException e1) {
                        e1.printStackTrace();
                    }
                    em.close();
                    emf.close();
                    break block11;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                em.close();
                emf.close();
            }
        }
    }

    public static int getAppIdFromExcel() {
        FileInputStream fis = null;
        int appId = -1;
        try {
            int idApp;
            fis = new FileInputStream(DAOFacade.getConfigFile());
            HSSFWorkbook wb = new HSSFWorkbook(fis);
            HSSFSheet sheet = wb.getSheet(DAOFacade.getProperty("default-config-file-info"));
            HSSFRow row = sheet.getRow(1);
            appId = idApp = (int)row.getCell(1).getNumericCellValue();
            fis.close();
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        catch (UnavailablePropertyException e) {
            e.printStackTrace();
            try {
                fis.close();
            }
            catch (IOException e1) {
                e1.printStackTrace();
            }
        }
        return appId;
    }

    public static void setCurrentApp(int appId) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        CurrentApp app = em.find(CurrentApp.class, 1);
        app.setIdApp(appId);
        em.getTransaction().begin();
        em.persist(app);
        em.getTransaction().commit();
        em.close();
        emf.close();
    }

    public static void deleteInfoForApp(int appId, boolean current) {
        DAOFacade.setCurrentApp(appId);
        DAOFacade.deleteGeneralDataFromBD(current);
        DAOFacade.deleteTabsFromBD(current);
        DAOFacade.deleteTablesFromBD(current);
        DAOFacade.deleteDaikonTablesFromBD(current);
        DAOFacade.deleteParametersFromBD(current);
        DAOFacade.deleteSimulationRegistersForCurrentApp(current);
        DAOFacade.deleteSimulationResultsForCurrentApp(current);
    }

    public static Set<String> listPluginFiles() {
        ReflectionManager.getInstance();
        return ReflectionManager.getPluginFiles();
    }

    public static void exportApp(int appId, String mode, Set<String> excludedFiles, Set<String> selectedPlugins) {
        File newEc2File;
        System.out.println("Renaming the current config file...");
        String configFilePath = "prop/config-properties";
        String tempConfigFilePath = "prop/config-properties.bak";
        File currentConfigFile = new File(configFilePath);
        currentConfigFile.renameTo(new File(tempConfigFilePath));
        System.out.println("Renaming the current plugins file...");
        String pluginsFilePath = "prop/plugins-properties";
        String tempPluginsFilePath = "prop/plugins-properties.bak";
        File currentPluginsFile = new File(pluginsFilePath);
        currentPluginsFile.renameTo(new File(tempPluginsFilePath));
        System.out.println("Generating the new config file for the custom application...");
        LinkedHashMap<Object, Object> map = new LinkedHashMap<Object, Object>();
        map.put("java-max-memory", "512");
        map.put("mecosim-params", "enduser");
        DAOFacade.saveProperties("config-properties", map);
        System.out.println("Generating the plugins file...");
        LinkedHashMap<Object, Object> pluginsMap = new LinkedHashMap<Object, Object>();
        Iterator<String> iterator = selectedPlugins.iterator();
        while (iterator.hasNext()) {
            String s;
            String plugin = s = iterator.next();
            String pluginclass = DAOFacade.getPluginClass(plugin);
            pluginsMap.put(String.valueOf(PluginsManager.pluginPrefix) + plugin, pluginclass);
            String pluginname = DAOFacade.getPluginShowingName(plugin);
            pluginsMap.put(String.valueOf(PluginsManager.pluginNamePrefix) + plugin, pluginname);
            String pluginmethod = DAOFacade.getPluginMethod(plugin);
            pluginsMap.put(String.valueOf(PluginsManager.pluginMethodPrefix) + plugin, pluginmethod);
            int iPar = 1;
            for (String par : DAOFacade.getPluginParameters(plugin)) {
                pluginsMap.put(String.valueOf(PluginsManager.pluginParamPrefix) + plugin + "-" + iPar, par);
                System.out.println(String.valueOf(PluginsManager.pluginParamPrefix) + plugin + "-" + iPar + " = " + par);
                ++iPar;
            }
            int iJar = 1;
            for (String jar : DAOFacade.getPluginJars(plugin)) {
                pluginsMap.put(String.valueOf(PluginsManager.pluginJarPrefix) + plugin + "-" + iJar, jar);
                System.out.println(String.valueOf(PluginsManager.pluginJarPrefix) + plugin + "-" + iJar + " = " + jar);
                ++iJar;
            }
        }
        DAOFacade.saveProperties("plugins-properties", pluginsMap);
        System.out.println("Getting a backup of the inner DB...");
        DBBackupWrapper dbBackup = DAOFacade.getBackupFromDB(appId);
        System.out.println("Params: " + dbBackup.getPlinguaParamIndexes().size());
        System.out.println("Delete info of the other apps...");
        DAOFacade.deleteInfoForApp(appId, false);
        System.out.println("Recovering the previous general data (paths and mode)...");
        GeneralData gd = DAOFacade.getGeneralData(appId);
        File fPli = new File(gd.getModelPath());
        DAOFacade.copyFile(gd.getModelPath(), "model/" + fPli.getName());
        gd.setModelPath("model/" + fPli.getName());
        File fEc2 = new File(gd.getDataPath());
        DAOFacade.copyFile(gd.getDataPath(), fEc2.getName());
        gd.setDataPath(fEc2.getName());
        gd.setMode(mode);
        DAOFacade.setGeneralData(gd);
        System.out.println("Generating release zip file...");
        String zipName = String.valueOf(new File(System.getProperty("user.dir")).getName()) + " - " + DAOFacade.getGeneralData(appId).getAppName();
        excludedFiles.add("config-properties.bak");
        excludedFiles.add("plugins-properties.bak");
        DAOFacade.makeZip(System.getProperty("user.dir"), excludedFiles, zipName);
        System.out.println("Reloading backup to the DB...");
        DAOFacade.loadBackup(dbBackup, appId);
        System.out.println("Restoring previous config file...");
        DAOFacade.copyFile(tempConfigFilePath, configFilePath);
        File f = new File(tempConfigFilePath);
        if (f.exists()) {
            f.delete();
        }
        System.out.println("Restoring previous plugins file...");
        DAOFacade.copyFile(tempPluginsFilePath, pluginsFilePath);
        File pf = new File(tempPluginsFilePath);
        if (pf.exists()) {
            pf.delete();
        }
        System.out.println("Deleting temporal data and model files...");
        File newPliFile = new File(gd.getModelPath());
        if (newPliFile.exists()) {
            newPliFile.delete();
        }
        if ((newEc2File = new File(gd.getDataPath())).exists()) {
            newEc2File.delete();
        }
    }

    private static void loadBackup(DBBackupWrapper dbBackup, int appId) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        System.out.println("General Data...");
        for (GeneralData generalData : dbBackup.getAppsGeneralData()) {
            if (generalData.getIdApp() != appId) {
                em.getTransaction().begin();
                em.persist(generalData);
                em.getTransaction().commit();
                continue;
            }
            GeneralData currentGd = em.find(GeneralData.class, appId);
            currentGd.setMode(generalData.getMode());
            currentGd.setDataPath(generalData.getDataPath());
            currentGd.setModelPath(generalData.getModelPath());
            em.getTransaction().begin();
            em.persist(currentGd);
            em.getTransaction().commit();
        }
        System.out.println("Tabs...");
        for (Tab tab : dbBackup.getTabs()) {
            if (tab.getIdApp() == appId) continue;
            em.getTransaction().begin();
            em.persist(tab);
            em.getTransaction().commit();
        }
        System.out.println("Table config...");
        for (TableConfig tableConfig : dbBackup.getTables()) {
            if (tableConfig.getIdApp() == appId) continue;
            em.getTransaction().begin();
            em.persist(tableConfig);
            em.getTransaction().commit();
        }
        System.out.println("Table column...");
        for (TableColumn tableColumn : dbBackup.getColumns()) {
            if (tableColumn.getIdApp() == appId) continue;
            em.getTransaction().begin();
            em.persist(tableColumn);
            em.getTransaction().commit();
        }
        System.out.println("Plugin daikon table...");
        for (PluginDaikonTable pluginDaikonTable : dbBackup.getDaikonTables()) {
            if (pluginDaikonTable.getAppId() == appId) continue;
            em.getTransaction().begin();
            em.persist(pluginDaikonTable);
            em.getTransaction().commit();
        }
        System.out.println("Plugin daikon extraction...");
        for (PluginDaikonExtraction pluginDaikonExtraction : dbBackup.getDaikonExtractions()) {
            if (pluginDaikonExtraction.getAppId() == appId) continue;
            em.getTransaction().begin();
            em.persist(pluginDaikonExtraction);
            em.getTransaction().commit();
        }
        System.out.println("Plugin daikon index...");
        for (PluginDaikonIndex pluginDaikonIndex : dbBackup.getDaikonIndexes()) {
            if (pluginDaikonIndex.getAppId() == appId) continue;
            em.getTransaction().begin();
            em.persist(pluginDaikonIndex);
            em.getTransaction().commit();
        }
        System.out.println("PlinguaParam...");
        for (PlinguaParam plinguaParam : dbBackup.getPlinguaParams()) {
            if (plinguaParam.getappId() == appId) continue;
            em.getTransaction().begin();
            em.persist(plinguaParam);
            em.getTransaction().commit();
        }
        System.out.println("PlinguaParamIndex...");
        for (PlinguaParamIndex plinguaParamIndex : dbBackup.getPlinguaParamIndexes()) {
            if (plinguaParamIndex.getAppId() == appId) continue;
            em.getTransaction().begin();
            em.persist(plinguaParamIndex);
            em.getTransaction().commit();
        }
        System.out.println("Simulation result...");
        for (SimulationResult simulationResult : dbBackup.getSimulationResult()) {
            if (simulationResult.getAppId() == appId) continue;
            em.getTransaction().begin();
            em.persist(simulationResult);
            em.getTransaction().commit();
        }
        System.out.println("Simulation criteria...");
        for (SimulationCriteria simulationCriteria : dbBackup.getSimulationCriteria()) {
            if (simulationCriteria.getAppId() == appId) continue;
            em.getTransaction().begin();
            em.persist(simulationCriteria);
            em.getTransaction().commit();
        }
        em.close();
        emf.close();
    }

    private static DBBackupWrapper getBackupFromDB(int appId) {
        DAOFacade.setCurrentApp(appId);
        DBBackupWrapper dbBackup = new DBBackupWrapper();
        dbBackup.setAppsGeneralData(DAOFacade.getApplicationsData());
        dbBackup.setTabs(DAOFacade.getTabsData());
        dbBackup.setTables(DAOFacade.getTables());
        dbBackup.setColumns(DAOFacade.getTableColumns());
        dbBackup.setDaikonTables(DAOFacade.getDaikonTables());
        dbBackup.setDaikonExtractions(DAOFacade.getDaikonExtractions());
        dbBackup.setDaikonIndexes(DAOFacade.getDaikonIndexes());
        dbBackup.setPlinguaParams(DAOFacade.getPlinguaParams());
        dbBackup.setPlinguaParamIndexes(DAOFacade.getPlinguaParamIndexes());
        dbBackup.setSimulationResult(DAOFacade.getSimulationResults());
        dbBackup.setSimulationCriteria(DAOFacade.getSimulationCriteria());
        return dbBackup;
    }

    /*
     * Loose catch block
     */
    public static void updateGeneralDataFromExcel() {
        block12: {
            DAOFacade.updateCurrentAppFromExcel();
            DAOFacade.deleteGeneralDataFromBD(true);
            EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
            EntityManager em = emf.createEntityManager();
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(DAOFacade.getConfigFile());
                    HSSFWorkbook wb = new HSSFWorkbook(fis);
                    HSSFSheet sheet = wb.getSheet(DAOFacade.getProperty("default-config-file-info"));
                    HSSFRow row = sheet.getRow(1);
                    int idApp = (int)row.getCell(1).getNumericCellValue();
                    String appName = row.getCell(2).getStringCellValue();
                    String dataPath = row.getCell(5).getStringCellValue();
                    String modelPath = row.getCell(6).getStringCellValue();
                    String mode = row.getCell(10).getStringCellValue();
                    int simulatedYears = (int)row.getCell(7).getNumericCellValue();
                    int simulationsByYear = (int)row.getCell(8).getNumericCellValue();
                    int stepsByYear = (int)row.getCell(9).getNumericCellValue();
                    String versionType = null;
                    if (row.getCell(11) != null) {
                        versionType = row.getCell(11).getStringCellValue();
                    }
                    boolean saveParameters = true;
                    if (row.getCell(12) != null) {
                        saveParameters = row.getCell(12).getBooleanCellValue();
                    }
                    GeneralData data = new GeneralData();
                    data.setAppName(appName);
                    data.setDataPath(dataPath);
                    data.setIdApp(idApp);
                    data.setMode(mode);
                    data.setModelPath(modelPath);
                    data.setSimulatedYears(simulatedYears);
                    data.setSimulationsByYear(simulationsByYear);
                    data.setStepsByYear(stepsByYear);
                    data.setCurrentSimulator("none");
                    if (versionType != null) {
                        data.setVersionType(versionType);
                    }
                    data.setSaveParameters(saveParameters);
                    em.getTransaction().begin();
                    em.persist(data);
                    em.getTransaction().commit();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    em.close();
                    emf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    em.close();
                    emf.close();
                }
                catch (UnavailablePropertyException e) {
                    e.printStackTrace();
                    em.close();
                    emf.close();
                    break block12;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                em.close();
                emf.close();
            }
        }
    }

    /*
     * Loose catch block
     */
    public static void updateTabsFromExcel() {
        block13: {
            DAOFacade.deleteTabsFromBD(true);
            EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
            EntityManager em = emf.createEntityManager();
            FileInputStream fis = null;
            try {
                try {
                    fis = new FileInputStream(DAOFacade.getConfigFile());
                    HSSFWorkbook wb = new HSSFWorkbook(fis);
                    HSSFSheet sheet = wb.getSheet(DAOFacade.getProperty("default-config-file-tabs"));
                    CurrentApp app = em.find(CurrentApp.class, 1);
                    int fila = 0;
                    for (Row row : sheet) {
                        if (fila > 0) {
                            String errorTitle;
                            if (row.getCell(1) == null || row.getCell(1).getStringCellValue() == null || row.getCell(1).getStringCellValue().isEmpty() || row.getCell(1).getStringCellValue().length() == 0) {
                                String error = "{Error} - La fila \"" + fila + "\"" + " de la pesta\u00f1a de TabsHierarchy presenta \nalg\u00fan error, " + "pero se continuar\u00e1 con la carga \ndel programa omitiendo las filas siguientes";
                                errorTitle = "Error en TabsHierarchy";
                                System.out.println("\t" + error.replace("\n", "\n\t"));
                                JOptionPane.showMessageDialog(null, error, errorTitle, 0);
                                break;
                            }
                            if (row.getCell(1).getStringCellValue() == null) {
                                String error = "{Error} - La fila \"" + fila + "\"" + " de la pesta\u00f1a de TabsHierarchy presenta \nalg\u00fan error, " + "pero se continuar\u00e1 con la carga \ndel programa omitiendo las filas siguientes";
                                errorTitle = "Error en TabsHierarchy";
                                System.out.println("\t" + error.replace("\n", "\n\t"));
                                JOptionPane.showMessageDialog(null, error, errorTitle, 0);
                                break;
                            }
                            int idTab = (int)row.getCell(0).getNumericCellValue();
                            String nombre = row.getCell(1).getStringCellValue();
                            int idTabPadre = (int)row.getCell(2).getNumericCellValue();
                            Tab tab = new Tab();
                            tab.setIdApp(app.getIdApp());
                            tab.setIdTab(idTab);
                            tab.setIdTabPadre(idTabPadre);
                            tab.setNombre(nombre);
                            em.getTransaction().begin();
                            em.persist(tab);
                            em.getTransaction().commit();
                        }
                        ++fila;
                    }
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                    em.close();
                    emf.close();
                }
                catch (IOException e) {
                    e.printStackTrace();
                    em.close();
                    emf.close();
                }
                catch (UnavailablePropertyException e) {
                    e.printStackTrace();
                    em.close();
                    emf.close();
                    break block13;
                    {
                        catch (Throwable throwable) {
                            throw throwable;
                        }
                    }
                }
            }
            finally {
                em.close();
                emf.close();
            }
        }
    }

    public static void updateTablesFromExcel() {
        DAOFacade.deleteTablesFromBD(true);
        DAOFacade.deleteDaikonTablesFromBD(true);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(DAOFacade.getConfigFile());
                HSSFWorkbook wb = new HSSFWorkbook(fis);
                CurrentApp app = em.find(CurrentApp.class, 1);
                HSSFSheet sheet = wb.getSheet(DAOFacade.getProperty("default-config-file-table-config"));
                int fila = 0;
                for (Row row : sheet) {
                    if (fila > 0 && row.getCell(1) != null) {
                        String auxG;
                        String nombre = row.getCell(1).getStringCellValue();
                        if (nombre == null || nombre.equals("")) continue;
                        int idTabla = (int)row.getCell(0).getNumericCellValue();
                        int idTab = (int)row.getCell(2).getNumericCellValue();
                        int ncols = (int)row.getCell(3).getNumericCellValue();
                        int nrows = (int)row.getCell(4).getNumericCellValue();
                        boolean save = row.getCell(5).getBooleanCellValue();
                        boolean output = false;
                        if (row.getCell(6) != null) {
                            output = row.getCell(6).toString().toUpperCase().equals("OUTPUT") || row.getCell(6).toString().toUpperCase().equals("SALIDA");
                        }
                        String graphic = "None";
                        if (row.getCell(7) != null && (auxG = row.getCell(7).getStringCellValue()) != null && !auxG.equals("")) {
                            graphic = auxG;
                        }
                        boolean externalView = false;
                        if (row.getCell(8) != null) {
                            externalView = row.getCell(8).getBooleanCellValue();
                        }
                        TableConfig tc = new TableConfig();
                        tc.setIdApp(app.getIdApp());
                        tc.setIdTab(idTab);
                        tc.setIdTabla(idTabla);
                        tc.setNombre(nombre);
                        tc.setNcols(ncols);
                        tc.setNrows(nrows);
                        tc.setSave(save);
                        tc.setOutput(output);
                        tc.setGraphic(graphic);
                        tc.setExternalView(externalView);
                        em.getTransaction().begin();
                        em.persist(tc);
                        em.getTransaction().commit();
                        continue;
                    }
                    ++fila;
                }
                DAOFacade.updateTableColumnsFromExcel();
                DAOFacade.updateDaikonConfigFromExcel();
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    fis.close();
                    em.close();
                    emf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (UnavailablePropertyException e) {
                e.printStackTrace();
                try {
                    fis.close();
                    em.close();
                    emf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        finally {
            try {
                fis.close();
                em.close();
                emf.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * Loose catch block
     */
    private static void updateDaikonConfigFromExcel() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(DAOFacade.getConfigFile());
                HSSFWorkbook wb = new HSSFWorkbook(fis);
                CurrentApp app = em.find(CurrentApp.class, 1);
                String jpql = "SELECT t FROM TableConfig t WHERE t.idApp = " + app.getIdApp();
                Query query = em.createQuery(jpql);
                List tables = query.getResultList();
                for (TableConfig tc : tables) {
                    int extractionId;
                    String prefix;
                    String tab;
                    HSSFSheet sheet;
                    if (!tc.isOutput() || (sheet = wb.getSheet(tab = String.valueOf(prefix = DAOFacade.getProperty("default-config-file-daikon-prefix")) + tc.getNombre())) == null) continue;
                    if (sheet.getRow(2).getCell(0) != null) {
                        PluginDaikonTable dt = new PluginDaikonTable();
                        dt.setAppId(app.getIdApp());
                        dt.setTableId(tc.getIdTabla());
                        dt.setStepIndex((int)sheet.getRow(2).getCell(0).getNumericCellValue());
                        if (sheet.getRow(2).getCell(1) != null) {
                            dt.setEnabled(sheet.getRow(2).getCell(1).getBooleanCellValue());
                        }
                        em.getTransaction().begin();
                        em.persist(dt);
                        em.getTransaction().commit();
                    }
                    int appId = app.getIdApp();
                    int tableId = tc.getIdTabla();
                    int rowi = 0;
                    for (Row row : sheet) {
                        String extractionType;
                        if (rowi > 0 && row.getCell(5) != null && (extractionType = row.getCell(5).getStringCellValue()) != null && !extractionType.equals("")) {
                            int extractionT = extractionType.equals("Named") ? 1 : 2;
                            extractionId = (int)row.getCell(4).getNumericCellValue();
                            String objectName = "";
                            if (row.getCell(6) == null || row.getCell(6).equals("")) {
                                if (extractionType.equals("Named")) {
                                    String error = "{Error} - The extraction id " + extractionId + " in the tab " + tab + " has not an associated name, being of the typed \"Named\"";
                                    String errorTitle = "Daikon extraction error";
                                    JOptionPane.showMessageDialog(null, error, errorTitle, 0);
                                    System.console();
                                }
                            } else {
                                objectName = row.getCell(6).getStringCellValue();
                            }
                            int dataIndex = (int)row.getCell(7).getNumericCellValue();
                            PluginDaikonExtraction de = new PluginDaikonExtraction();
                            de.setAppId(appId);
                            de.setTableId(tableId);
                            de.setExtractionId(extractionId);
                            de.setExtractionType(extractionT);
                            de.setObjectName(objectName);
                            de.setDataIndex(dataIndex);
                            em.getTransaction().begin();
                            em.persist(de);
                            em.getTransaction().commit();
                        }
                        ++rowi;
                    }
                    boolean inIndexesSection = false;
                    rowi = 0;
                    for (Row row : sheet) {
                        if (rowi > 2 && !inIndexesSection) {
                            if (row.getCell(1) != null && row.getCell(1).getStringCellValue().equals("ExtractionOrder")) {
                                inIndexesSection = true;
                            }
                        } else if (inIndexesSection && row.getCell(1) != null) {
                            int extractionOrder = (int)row.getCell(1).getNumericCellValue();
                            if (row.getCell(0) != null && row.getCell(2) != null) {
                                extractionId = (int)row.getCell(0).getNumericCellValue();
                                int extractionIndex = (int)row.getCell(2).getNumericCellValue();
                                PluginDaikonIndex di = new PluginDaikonIndex();
                                di.setAppId(appId);
                                di.setTableId(tableId);
                                di.setExtractionId(extractionId);
                                di.setExtractionOrder(extractionOrder);
                                di.setExtractionIndex(extractionIndex);
                                em.getTransaction().begin();
                                em.persist(di);
                                em.getTransaction().commit();
                            } else {
                                String error = "{Error} - The extraction order " + extractionOrder + " has incomplete information!";
                                String errorTitle = "Daikon order error";
                                JOptionPane.showMessageDialog(null, error, errorTitle, 0);
                                System.console();
                            }
                        }
                        ++rowi;
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    fis.close();
                    em.close();
                    emf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    fis.close();
                    em.close();
                    emf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (UnavailablePropertyException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    fis.close();
                    em.close();
                    emf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        finally {
            try {
                fis.close();
                em.close();
                emf.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * Loose catch block
     */
    private static void updateTableColumnsFromExcel() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(DAOFacade.getConfigFile());
                HSSFWorkbook wb = new HSSFWorkbook(fis);
                CurrentApp app = em.find(CurrentApp.class, 1);
                String jpql = "SELECT t FROM TableConfig t WHERE t.idApp = " + app.getIdApp();
                Query query = em.createQuery(jpql);
                List tables = query.getResultList();
                for (TableConfig tc : tables) {
                    String prefix = DAOFacade.getProperty("default-config-file-columns-prefix");
                    String tab = String.valueOf(prefix) + tc.getNombre();
                    HSSFSheet sheet = wb.getSheet(tab);
                    if (sheet == null) {
                        String error = "{Error} - La pesta\u00f1a \"" + tab + "\"" + " no se encuentra disponible, \ncon lo que no puede proseguir la carga del programa";
                        System.out.println("\t" + error.replace("\n", "\n\t"));
                        String errorTitle = "Error por configuraci\u00f3n de columnas de tabla no existentes";
                        JOptionPane.showMessageDialog(null, error, errorTitle, 0);
                        System.exit(0);
                    }
                    int fila = 0;
                    for (Row row : sheet) {
                        String nombre;
                        if (fila > 0 && row.getCell(1) != null && (nombre = row.getCell(1).getStringCellValue()) != null && !nombre.equals("")) {
                            int idTabla = tc.getIdTabla();
                            int idCol = (int)row.getCell(0).getNumericCellValue();
                            boolean save = row.getCell(3).getBooleanCellValue();
                            String defValue = null;
                            if (row.getCell(2) != null) {
                                defValue = row.getCell(2).getStringCellValue();
                            }
                            String tooltip = row.getCell(4).getStringCellValue();
                            String graphicRole = "";
                            int daikonIndex = -2;
                            if (tc.isOutput() && row.getCell(5) != null) {
                                graphicRole = row.getCell(5).getStringCellValue();
                            }
                            TableColumn tcol = new TableColumn();
                            tcol.setIdApp(app.getIdApp());
                            tcol.setIdCol(idCol);
                            tcol.setDefaultValue(defValue);
                            tcol.setIdTabla(idTabla);
                            tcol.setNombreCol(nombre);
                            tcol.setSave(save);
                            tcol.setTooltip(tooltip);
                            tcol.setGraphicRole(graphicRole);
                            em.getTransaction().begin();
                            em.persist(tcol);
                            em.getTransaction().commit();
                        }
                        ++fila;
                    }
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    fis.close();
                    em.close();
                    emf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    fis.close();
                    em.close();
                    emf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (UnavailablePropertyException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    fis.close();
                    em.close();
                    emf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        finally {
            try {
                fis.close();
                em.close();
                emf.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void updateSimulationResultsFromExcel() {
        DAOFacade.deleteSimulationResultsForCurrentApp(true);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(DAOFacade.getConfigFile());
                HSSFWorkbook wb = new HSSFWorkbook(fis);
                CurrentApp app = em.find(CurrentApp.class, 1);
                String tabName = DAOFacade.getProperty("default-config-file-results");
                HSSFSheet sheet = wb.getSheet(tabName);
                if (sheet == null) {
                    String error = "{Error} - The tab \"" + tabName + "\"" + " is not available, \nso the program will not get visible results \nin the form of output tables. ";
                    System.out.println("\t" + error.replace("\n", "\n\t"));
                    String errorTitle = "Error: tab SimulationResults not found";
                    JOptionPane.showMessageDialog(null, error, errorTitle, 0);
                } else {
                    int fila = 0;
                    for (Row row : sheet) {
                        String resultTableName;
                        if (fila > 0 && row.getCell(1) != null && (resultTableName = row.getCell(1).getStringCellValue()) != null && !resultTableName.equals("")) {
                            TableConfig tc;
                            int resultTableId = (int)row.getCell(0).getNumericCellValue();
                            int tableId = (int)row.getCell(2).getNumericCellValue();
                            int referredResultTableId = (int)row.getCell(3).getNumericCellValue();
                            if (!(tableId == 0 || (tc = em.find(TableConfig.class, new TablePK(app.getIdApp(), tableId))) != null && tc.isOutput())) {
                                String error = "{Error} - The row with number " + (fila + 1) + " in tab SimulationResults does not assign its result to an output table.\n" + "It must assign tableId to the id of an output table, or to 0 if is an auxiliary table.";
                                String errorTitle = "Error: Bad assignment in SimulationResults";
                                System.out.println("\t" + error.replace("\n", "\n\t"));
                                JOptionPane.showMessageDialog(null, error, errorTitle, 0);
                                System.exit(0);
                            }
                            SimulationResult sr = new SimulationResult();
                            sr.setAppId(app.getIdApp());
                            sr.setResultTableId(resultTableId);
                            sr.setResultTableName(resultTableName);
                            sr.setTableId(tableId);
                            sr.setReferredResultTableId(referredResultTableId);
                            em.getTransaction().begin();
                            em.persist(sr);
                            em.getTransaction().commit();
                        }
                        ++fila;
                    }
                    DAOFacade.updateSimulationCriteriaFromExcel();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    fis.close();
                    em.close();
                    emf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (UnavailablePropertyException e) {
                e.printStackTrace();
                try {
                    fis.close();
                    em.close();
                    emf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        finally {
            try {
                fis.close();
                em.close();
                emf.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    /*
     * Could not resolve type clashes
     * Loose catch block
     */
    private static void updateSimulationCriteriaFromExcel() {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(DAOFacade.getConfigFile());
                HSSFWorkbook wb = new HSSFWorkbook(fis);
                CurrentApp app = em.find(CurrentApp.class, 1);
                String jpql = "SELECT sr FROM SimulationResult sr WHERE sr.appId = " + app.getIdApp();
                Query query = em.createQuery(jpql);
                List tables = query.getResultList();
                for (SimulationResult sr : tables) {
                    SimulationCriteria sc;
                    String prefix = DAOFacade.getProperty("default-config-file-resultsData-prefix");
                    String tab = String.valueOf(prefix) + sr.getResultTableName();
                    HSSFSheet sheet = wb.getSheet(tab);
                    ArrayList<FieldJoin> joins = new ArrayList<FieldJoin>();
                    int fila = 0;
                    int lastId = 0;
                    int whereId = 0;
                    if (sheet == null) {
                        String error = "{Error} - La pesta\u00f1a \"" + tab + "\"" + " no se encuentra disponible, \ncon lo que no puede proseguir la carga del programa";
                        System.out.println("\t" + error.replace("\n", "\n\t"));
                        String errorTitle = "Error por inexistencia de pesta\u00f1a con detalle de resultado";
                        JOptionPane.showMessageDialog(null, error, errorTitle, 0);
                        System.exit(0);
                    }
                    for (Row row : sheet) {
                        String criteria;
                        if (fila > 0 && row.getCell(2) != null && (criteria = row.getCell(2).getStringCellValue()) != null && !criteria.equals("")) {
                            String formula;
                            SimulationCriteria sc2;
                            int resultTableId;
                            int criteriaId;
                            lastId = criteriaId = (int)row.getCell(0).getNumericCellValue();
                            String criteriaType = row.getCell(1).getStringCellValue();
                            if (criteriaType != null && criteriaType.equals("Where")) {
                                whereId = criteriaId;
                                criteriaType = sr.getReferredResultTableId() == 0 ? "WhereAux" : "Where";
                            }
                            if (!criteria.equals("parameter")) {
                                resultTableId = sr.getResultTableId();
                                sc2 = new SimulationCriteria();
                                sc2.setAppId(app.getIdApp());
                                sc2.setResultTableId(resultTableId);
                                sc2.setCriteriaId(criteriaId);
                                sc2.setCriteriaType(criteriaType);
                                sc2.setCriteria(criteria);
                                formula = "";
                                if (row.getCell(3) != null && row.getCell(3).getStringCellValue() != "") {
                                    formula = row.getCell(3).getStringCellValue();
                                    sc2.setFormula(formula);
                                }
                                int referredCriteriaId = 0;
                                if (row.getCell(4) != null) {
                                    referredCriteriaId = (int)row.getCell(4).getNumericCellValue();
                                    sc2.setReferredCriteriaId(referredCriteriaId);
                                }
                                String argument = null;
                                if (row.getCell(5) != null) {
                                    if (row.getCell(5).getCellType() == 0 || row.getCell(5).getCellType() == 2) {
                                        int argI = (int)row.getCell(5).getNumericCellValue();
                                        argument = new Integer(argI).toString();
                                    } else if (row.getCell(5).getCellType() == 1) {
                                        argument = row.getCell(5).getStringCellValue();
                                    }
                                    sc2.setArgument(argument);
                                }
                                String qualifiedName = "";
                                if (row.getCell(6) != null && row.getCell(6).getStringCellValue() != "") {
                                    qualifiedName = row.getCell(6).getStringCellValue();
                                    sc2.setQualifiedName(qualifiedName);
                                }
                                String whereConditionType = "";
                                if (row.getCell(7) != null && row.getCell(7).getStringCellValue() != "") {
                                    whereConditionType = row.getCell(7).getStringCellValue();
                                    sc2.setWhereConditionType(whereConditionType);
                                }
                                String whereCondition = "";
                                if (row.getCell(8) != null && row.getCell(8).getStringCellValue() != "") {
                                    whereCondition = row.getCell(8).getStringCellValue();
                                    sc2.setWhereCondition(whereCondition);
                                }
                                em.getTransaction().begin();
                                em.persist(sc2);
                                em.getTransaction().commit();
                            } else {
                                resultTableId = sr.getResultTableId();
                                sc2 = new SimulationCriteria();
                                sc2.setAppId(app.getIdApp());
                                sc2.setResultTableId(resultTableId);
                                sc2.setCriteriaId(criteriaId);
                                sc2.setCriteriaType(criteriaType);
                                sc2.setCriteria("data");
                                formula = "";
                                if (row.getCell(3) != null && row.getCell(3).getStringCellValue() != "") {
                                    formula = row.getCell(3).getStringCellValue();
                                }
                                String argument = null;
                                if (row.getCell(5) != null) {
                                    if (row.getCell(5).getCellType() == 0 || row.getCell(5).getCellType() == 2) {
                                        int argI = (int)row.getCell(5).getNumericCellValue();
                                        argument = new Integer(argI).toString();
                                    } else if (row.getCell(5).getCellType() == 1) {
                                        argument = row.getCell(5).getStringCellValue();
                                    }
                                }
                                String qualifiedName = "";
                                if (row.getCell(6) != null && row.getCell(6).getStringCellValue() != "") {
                                    qualifiedName = row.getCell(6).getStringCellValue();
                                }
                                String whereConditionType = "";
                                if (row.getCell(7) != null && row.getCell(7).getStringCellValue() != "") {
                                    whereConditionType = row.getCell(7).getStringCellValue();
                                }
                                em.getTransaction().begin();
                                em.persist(sc2);
                                em.getTransaction().commit();
                                FieldJoin fj = null;
                                String childName = "";
                                String jpql2 = "SELECT sr FROM SimulationResult sr WHERE sr.appId = " + app.getIdApp() + " AND sr.resultTableId = " + sr.getReferredResultTableId();
                                Query query2 = em.createQuery(jpql2);
                                SimulationResult sr2 = (SimulationResult)query2.getSingleResult();
                                childName = sr2.getResultTableName();
                                fj = new FieldJoin("parsed_parameters", "appId", "", Integer.toString(app.getIdApp()), "Integer");
                                joins.add(fj);
                                if (qualifiedName != null && !qualifiedName.equals("")) {
                                    String columnName = "index" + argument;
                                    fj = new FieldJoin(childName, qualifiedName, "parsed_parameters", columnName, "Integer");
                                    joins.add(fj);
                                }
                                fj = new FieldJoin("parsed_parameters", "parameter", "", formula, "String");
                                joins.add(fj);
                            }
                        }
                        ++fila;
                    }
                    if (sr.getReferredResultTableId() == 0) {
                        sc = new SimulationCriteria();
                        sc.setAppId(app.getIdApp());
                        sc.setResultTableId(sr.getResultTableId());
                        sc.setCriteriaId(++lastId);
                        sc.setCriteriaType("WhereAux");
                        sc.setCriteria("appId");
                        sc.setWhereConditionType("Integer");
                        sc.setWhereCondition("" + app.getIdApp());
                        em.getTransaction().begin();
                        em.persist(sc);
                        em.getTransaction().commit();
                        sc = new SimulationCriteria();
                        sc.setAppId(app.getIdApp());
                        sc.setResultTableId(sr.getResultTableId());
                        sc.setReferredCriteriaId(whereId);
                        sc.setArgument(Integer.toString(lastId));
                        sc.setCriteriaId(++lastId);
                        sc.setCriteriaType("Where");
                        sc.setCriteria("formula");
                        sc.setFormula("AND");
                        em.getTransaction().begin();
                        em.persist(sc);
                        em.getTransaction().commit();
                        continue;
                    }
                    if (joins == null || joins.size() <= 0) continue;
                    for (IFieldJoin join : joins) {
                        if (!(join instanceof FieldJoin)) continue;
                        FieldJoin fjoin = (FieldJoin)join;
                        SimulationCriteria sc3 = new SimulationCriteria();
                        sc3.setAppId(app.getIdApp());
                        int resultTableId = sr.getResultTableId();
                        sc3.setResultTableId(resultTableId);
                        sc3.setCriteriaId(++lastId);
                        sc3.setCriteriaType("Join");
                        sc3.setCriteria(fjoin.getTable1());
                        sc3.setFormula(fjoin.getValue1());
                        sc3.setArgument(fjoin.getTable2());
                        sc3.setQualifiedName(fjoin.getValue2());
                        sc3.setWhereConditionType(fjoin.getClazz());
                        em.getTransaction().begin();
                        em.persist(sc3);
                        em.getTransaction().commit();
                    }
                    sc = new SimulationCriteria();
                    sc.setAppId(app.getIdApp());
                    int resultTableId = sr.getResultTableId();
                    sc.setResultTableId(resultTableId);
                    sc.setCriteriaId(++lastId);
                    sc.setCriteriaType("Group");
                    sc.setCriteria("data");
                    em.getTransaction().begin();
                    em.persist(sc);
                    em.getTransaction().commit();
                }
            }
            catch (FileNotFoundException e) {
                e.printStackTrace();
                try {
                    fis.close();
                    em.close();
                    emf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    fis.close();
                    em.close();
                    emf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (UnavailablePropertyException e) {
                e.printStackTrace();
                {
                    catch (Throwable throwable) {
                        throw throwable;
                    }
                }
                try {
                    fis.close();
                    em.close();
                    emf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        finally {
            try {
                fis.close();
                em.close();
                emf.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static void updateParametersFromExcel() {
        DAOFacade.deleteParametersFromBD(true);
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        FileInputStream fis = null;
        try {
            try {
                fis = new FileInputStream(DAOFacade.getConfigFile());
                HSSFWorkbook wb = new HSSFWorkbook(fis);
                CurrentApp app = em.find(CurrentApp.class, 1);
                HSSFSheet sheet = wb.getSheet(DAOFacade.getProperty("default-config-file-params"));
                HashMap<String, Integer> paramSecs = new HashMap<String, Integer>();
                int iRow = 0;
                for (Row row : sheet) {
                    if (iRow > 0 && row.getCell(0) != null && row.getCell(1) != null) {
                        String paramName = row.getCell(0).getStringCellValue();
                        String paramValue = "";
                        try {
                            paramValue = row.getCell(1).getStringCellValue();
                        }
                        catch (IllegalStateException e) {
                            paramValue = "<@excel,\"" + row.getCell(1).getCellFormula() + "\">";
                        }
                        Integer paramSec = 1;
                        if (paramSecs.get(paramName) != null) {
                            paramSec = (Integer)paramSecs.get(paramName) + 1;
                        }
                        paramSecs.put(paramName, paramSec);
                        PlinguaParam param = new PlinguaParam();
                        param.setappId(app.getIdApp());
                        param.setparamName(paramName);
                        param.setparamValue(paramValue);
                        param.setparamSec(paramSec);
                        em.getTransaction().begin();
                        em.persist(param);
                        em.getTransaction().commit();
                        int iColumn = 0;
                        int nCol = 1;
                        for (Cell cell : row) {
                            if (iColumn > 1 && cell.getStringCellValue() != null && !cell.getStringCellValue().equals("") && !cell.getStringCellValue().startsWith("//")) {
                                String paramIndex = cell.getStringCellValue();
                                PlinguaParamIndex paramIdx = new PlinguaParamIndex();
                                paramIdx.setAppId(app.getIdApp());
                                paramIdx.setParamName(paramName);
                                paramIdx.setParamIndex(paramIndex);
                                paramIdx.setParamSec(paramSec);
                                paramIdx.setParamI(nCol);
                                em.getTransaction().begin();
                                em.persist(paramIdx);
                                em.getTransaction().commit();
                                ++nCol;
                                continue;
                            }
                            ++iColumn;
                        }
                        continue;
                    }
                    ++iRow;
                }
            }
            catch (IOException e) {
                e.printStackTrace();
                try {
                    fis.close();
                    em.close();
                    emf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
            catch (UnavailablePropertyException e) {
                e.printStackTrace();
                try {
                    fis.close();
                    em.close();
                    emf.close();
                }
                catch (IOException ex) {
                    Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
                }
            }
        }
        finally {
            try {
                fis.close();
                em.close();
                emf.close();
            }
            catch (IOException ex) {
                Logger.getLogger(Main.class.getName()).log(Level.SEVERE, null, ex);
            }
        }
    }

    public static Number evaluateExcelFormula(String formula) {
        Double n = null;
        try {
            HSSFWorkbook wbMem = new HSSFWorkbook();
            CreationHelper createHelper = wbMem.getCreationHelper();
            HSSFSheet sheetMem = wbMem.createSheet("New");
            HSSFRow rowMem = sheetMem.createRow(0);
            FormulaEvaluator evaluator = wbMem.getCreationHelper().createFormulaEvaluator();
            rowMem.createCell(0).setCellFormula(formula);
            CellValue cellValueMem = evaluator.evaluate(rowMem.getCell(0));
            switch (cellValueMem.getCellType()) {
                case 4: {
                    break;
                }
                case 0: {
                    n = cellValueMem.getNumberValue();
                    break;
                }
                case 1: {
                    break;
                }
                case 3: {
                    break;
                }
                case 5: {
                    break;
                }
            }
        }
        catch (Exception ex) {
            String os = System.getProperty("os.name").toLowerCase();
            if (os != null && os.startsWith("windows")) {
                System.out.println("Not supported formula using Jakarta POI, so it is written in a file and evaluated by Excel!");
                System.out.println("You can see the list of available formulas in the URL:");
                System.out.println("\thttp://poi.apache.org/spreadsheet/eval-devguide.html#appendixA");
                try {
                    String userdir = System.getProperty("user.dir");
                    String path = String.valueOf(userdir) + "/lib/workbook.xls";
                    FileInputStream fis = new FileInputStream(path);
                    HSSFWorkbook wb = new HSSFWorkbook(fis);
                    HSSFSheet sheet = wb.getSheet("New");
                    HSSFRow row = sheet.getRow(0);
                    row.createCell(0).setCellFormula(formula);
                    fis.close();
                    FileOutputStream fileOut = new FileOutputStream(path);
                    wb.write(fileOut);
                    fileOut.close();
                    fis.close();
                    Runtime run = Runtime.getRuntime();
                    Process comp = run.exec("Cscript.exe lib/script.vbs \"" + path + "\"");
                    comp.waitFor();
                    fis = new FileInputStream(path);
                    wb = new HSSFWorkbook(fis);
                    sheet = wb.getSheet("New");
                    row = sheet.getRow(0);
                    n = row.getCell(0).getNumericCellValue();
                }
                catch (FileNotFoundException e) {
                    e.printStackTrace();
                }
                catch (IOException e) {
                    e.printStackTrace();
                }
                catch (InterruptedException interruptedException) {}
            }
            System.out.println("The formula is not supported by our system");
            System.out.println("You can see the list of available formulas in the URL:");
            System.out.println("\thttp://poi.apache.org/spreadsheet/eval-devguide.html#appendixA");
            n = 0.0;
        }
        return n;
    }

    private static int deleteGeneralDataFromBD(boolean b) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        CurrentApp app = em.find(CurrentApp.class, 1);
        em.getTransaction().begin();
        String condition = "where d.idApp " + (b ? "=" : "<>") + ":app";
        Query query = em.createQuery("delete from GeneralData d " + condition);
        query.setParameter("app", (Object)app.getIdApp());
        int deleted = query.executeUpdate();
        em.getTransaction().commit();
        em.close();
        emf.close();
        return deleted;
    }

    private static void deleteTabsFromBD(boolean b) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        CurrentApp app = em.find(CurrentApp.class, 1);
        em.getTransaction().begin();
        String condition = "where t.idApp " + (b ? "=" : "<>") + ":app";
        Query query = em.createQuery("delete from Tab t " + condition);
        query.setParameter("app", (Object)app.getIdApp());
        int deleted = query.executeUpdate();
        em.getTransaction().commit();
        em.close();
        emf.close();
    }

    private static void deleteTablesFromBD(boolean b) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        CurrentApp app = em.find(CurrentApp.class, 1);
        em.getTransaction().begin();
        String condition = "where t.idApp " + (b ? "=" : "<>") + ":app";
        Query query = em.createQuery("delete from TableConfig t " + condition);
        query.setParameter("app", (Object)app.getIdApp());
        int deleted = query.executeUpdate();
        em.getTransaction().commit();
        em.getTransaction().begin();
        query = em.createQuery("delete from TableColumn t " + condition);
        query.setParameter("app", (Object)app.getIdApp());
        deleted = query.executeUpdate();
        em.getTransaction().commit();
        em.close();
        emf.close();
    }

    private static void deleteDaikonTablesFromBD(boolean b) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        CurrentApp app = em.find(CurrentApp.class, 1);
        em.getTransaction().begin();
        String condition = "where t.appId " + (b ? "=" : "<>") + ":app";
        Query query = em.createQuery("delete from PluginDaikonTable t " + condition);
        query.setParameter("app", (Object)app.getIdApp());
        int deleted = query.executeUpdate();
        em.getTransaction().commit();
        em.getTransaction().begin();
        query = em.createQuery("delete from PluginDaikonExtraction t " + condition);
        query.setParameter("app", (Object)app.getIdApp());
        deleted = query.executeUpdate();
        em.getTransaction().commit();
        em.getTransaction().begin();
        query = em.createQuery("delete from PluginDaikonIndex t " + condition);
        query.setParameter("app", (Object)app.getIdApp());
        deleted = query.executeUpdate();
        em.getTransaction().commit();
        em.close();
        emf.close();
    }

    private static void deleteSimulationResultsForCurrentApp(boolean b) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        CurrentApp app = em.find(CurrentApp.class, 1);
        em.getTransaction().begin();
        String condition = "where sr.appId " + (b ? "=" : "<>") + ":app";
        Query query = em.createQuery("delete from SimulationResult sr " + condition);
        query.setParameter("app", (Object)app.getIdApp());
        int deleted = query.executeUpdate();
        em.getTransaction().commit();
        em.getTransaction().begin();
        condition = "where sc.appId " + (b ? "=" : "<>") + ":app";
        query = em.createQuery("delete from SimulationCriteria sc " + condition);
        query.setParameter("app", (Object)app.getIdApp());
        deleted = query.executeUpdate();
        em.getTransaction().commit();
        em.close();
        emf.close();
    }

    private static void deleteParametersFromBD(boolean b) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        CurrentApp app = em.find(CurrentApp.class, 1);
        em.getTransaction().begin();
        String condition = "where p.appId " + (b ? "=" : "<>") + ":app";
        Query query = em.createQuery("delete from PlinguaParam p " + condition);
        query.setParameter("app", (Object)app.getIdApp());
        int deleted = query.executeUpdate();
        em.getTransaction().commit();
        em.getTransaction().begin();
        query = em.createQuery("delete from PlinguaParamIndex p " + condition);
        query.setParameter("app", (Object)app.getIdApp());
        deleted = query.executeUpdate();
        em.getTransaction().commit();
        em.close();
        emf.close();
    }

    public static void insertSimulationRegister(SimulationRegister register) {
        try {
            pstmt.setInt(1, register.getAppId());
            pstmt.setInt(2, register.getSimulation());
            pstmt.setInt(3, register.getYear());
            pstmt.setInt(4, register.getStep());
            pstmt.setInt(5, register.getMembraneID());
            pstmt.setString(6, register.getEnvironmentID());
            pstmt.setString(7, register.getLabelID());
            pstmt.setString(8, register.getObject());
            pstmt.setLong(9, register.getMultiplicity());
            pstmt.addBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteSimulationRegistersForCurrentApp(boolean b) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        CurrentApp app = em.find(CurrentApp.class, 1);
        em.getTransaction().begin();
        String condition = "where s.appId " + (b ? "=" : "<>") + ":app";
        Query query = em.createQuery("delete from SimulationRegister s " + condition);
        query.setParameter("app", (Object)app.getIdApp());
        int deleted = query.executeUpdate();
        em.getTransaction().commit();
        em.close();
        emf.close();
    }

    public static void printSimulationRegisters() {
        try {
            String query = "select appId, simulation, year, step, environmentID, labelID, object, multiplicity from simulation_registers";
            PreparedStatement pstmt3 = memConn.prepareStatement(query);
            ResultSet rs = pstmt3.executeQuery();
            while (rs.next()) {
                int appId = rs.getInt(1);
                int simulation = rs.getInt(2);
                int year = rs.getInt(3);
                int step = rs.getInt(4);
                String environmentId = rs.getString(5);
                String labelId = rs.getString(6);
                String object = rs.getString(7);
                long multiplicity = rs.getLong(8);
                System.out.println(String.valueOf(appId) + "\t" + simulation + "\t" + year + "\t" + step + "\t" + environmentId + "\t" + labelId + "\t" + object + "\t" + multiplicity);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void persistRegisters() {
        try {
            int[] outputs = pstmt.executeBatch();
            pstmt = memConn.prepareStatement("INSERT INTO simulation_registers (appId,simulation,year,step,membraneID,environmentID,labelID,object,multiplicity) VALUES (?,?,?,?,?,?,?,?,?)");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void deleteRegisters(int appId) {
        try {
            String query = "delete from simulation_registers where appId = ?";
            if (memConn != null) {
                PreparedStatement pstmt2 = memConn.prepareStatement(query);
                pstmt2.setInt(1, appId);
                boolean bl = pstmt2.execute();
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void printOldSummary() {
        try {
            String query = "select appId, simulation, year, environmentID, object, sum(multiplicity)  from simulation_registers where step = 13  group by appId, simulation, year, environmentID, object order by appId, simulation, year, environmentID, object";
            PreparedStatement pstmt3 = memConn.prepareStatement(query);
            ResultSet rs = pstmt3.executeQuery();
            while (rs.next()) {
                int appId = rs.getInt(1);
                int simulation = rs.getInt(2);
                int year = rs.getInt(3);
                String environmentId = rs.getString(4);
                String object = rs.getString(5);
                long multiplicity = rs.getLong(6);
                System.out.println(String.valueOf(appId) + "\t" + simulation + "\t" + year + "\t" + environmentId + "\t" + object + "\t" + multiplicity);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void printHSQLDB(int filterStep) {
        String query = "select appId, simulation, year, step, environmentID, labelID, object, multiplicity from simulation_registers where object like '%X%' and step = " + filterStep;
        try {
            PreparedStatement pstmt4 = memConn.prepareStatement(query);
            ResultSet rs = pstmt4.executeQuery();
            while (rs.next()) {
                int appId = rs.getInt(1);
                int simulation = rs.getInt(2);
                int year = rs.getInt(3);
                int step = rs.getInt(4);
                int environmentId = rs.getInt(5);
                int labelId = rs.getInt(6);
                String object = rs.getString(7);
                int multiplicity = rs.getInt(8);
                System.out.println(String.valueOf(appId) + "\t" + simulation + "\t" + year + "\t" + step + "\t" + environmentId + "\t" + labelId + "\t" + object + "\t" + multiplicity);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void printSummary(int filterStep) {
        try {
            String query = "select appId, year, environmentID,  round(avg(part.nums),0) as averageChamois, round(STDDEV_POP(part.nums),5) as popDeviation, round(STDDEV_SAMP(part.nums),5) as sampDeviation from (select appId, simulation, year, environmentID, sum(multiplicity) as nums from simulation_registers where step = " + filterStep + " and object like '%X%' " + "group by appId, simulation, year, environmentID " + "order by appId, simulation, year, environmentID) part " + "group by appId, year, environmentID order by appId, year, environmentID";
            PreparedStatement pstmt3 = memConn.prepareStatement(query);
            ResultSet rs = pstmt3.executeQuery();
            while (rs.next()) {
                int year = rs.getInt(2);
                String environmentId = rs.getString(3);
                long multiplicity = rs.getLong(4);
                System.out.println(String.valueOf(year) + "\t" + environmentId + "\t" + multiplicity);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void printSummary() {
        try {
            String query = "select appId, simulation, environmentID, object, multiplicity from simulation_registers where object like 'L{%' group by appId, simulation, environment, object order by appId, simulation, environment, object";
            PreparedStatement pstmt3 = memConn.prepareStatement(query);
            ResultSet rs = pstmt3.executeQuery();
            while (rs.next()) {
                int appId = rs.getInt(1);
                int simulation = rs.getInt(2);
                int environment = rs.getInt(3);
                String object = rs.getString(4);
                long multiplicity = rs.getLong(5);
                System.out.println(String.valueOf(appId) + "\t" + simulation + "\t" + environment + "\t" + object + "\t" + multiplicity);
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static String[][] getResult(int filterStep) {
        String[][] result = null;
        try {
            String countQuery = "select count(*) from (select appId, year, environmentID,  round(avg(part.nums),0) as multiplicity, round(STDDEV_POP(part.nums),5) as deviation from (select appId, simulation, year, environmentID, sum(multiplicity) as nums from simulation_registers where step = " + filterStep + " and object like '%X%' " + "group by appId, simulation, year, environmentID " + "order by appId, simulation, year, environmentID) part " + "group by appId, year, environmentID) summary";
            PreparedStatement pstmtCount = memConn.prepareStatement(countQuery);
            ResultSet countRs = pstmtCount.executeQuery();
            int numrows = 100;
            if (countRs.next()) {
                numrows = countRs.getInt(1);
            }
            result = new String[numrows][4];
            System.out.println("Hay " + numrows + " filas!");
            String query = "select appId, year, environmentID,  round(avg(part.nums),0) as averageChamois, round(STDDEV_POP(part.nums),5) as popDeviation, round(STDDEV_SAMP(part.nums),5) as sampDeviation from (select appId, simulation, year, environmentID, sum(multiplicity) as nums from simulation_registers where step = " + filterStep + " and object like '%X%' " + "group by appId, simulation, year, environmentID " + "order by appId, simulation, year, environmentID) part " + "group by appId, year, environmentID order by appId, year, environmentID";
            System.out.println(query);
            PreparedStatement pstmt3 = memConn.prepareStatement(query);
            ResultSet rs = pstmt3.executeQuery();
            int rowIndex = 0;
            while (rs.next()) {
                int year = rs.getInt(2);
                String environmentId = rs.getString(3);
                long multiplicity = rs.getLong(4);
                double deviation = rs.getDouble(5);
                if (rowIndex < result.length) {
                    result[rowIndex][0] = "" + year;
                    result[rowIndex][1] = environmentId;
                    result[rowIndex][2] = "" + multiplicity;
                    result[rowIndex][3] = "" + deviation;
                } else {
                    System.out.println("Algo ha pasado que nos hemos salido de la tabla: ");
                    System.out.println("Fila n\u00famero: " + (rowIndex + 1) + " cuando el m\u00e1ximo es: " + result.length);
                }
                ++rowIndex;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static String[][] getResults(int appId, int tableId) {
        String[][] result = null;
        try {
            SimulationResultConfigData resultConfigData = DAOFacade.getSimulationResultsConfigData(appId, tableId);
            System.out.println("Query: " + resultConfigData.getSQLField());
            String countQuery = "select count(*) from (" + resultConfigData.getSQLField() + ") summary";
            int fieldsNumber = resultConfigData.getFieldsNumber();
            PreparedStatement pstmtCount = memConn.prepareStatement(countQuery);
            ResultSet countRs = pstmtCount.executeQuery();
            int numrows = 100;
            if (countRs.next()) {
                numrows = countRs.getInt(1);
            }
            result = new String[numrows][fieldsNumber];
            System.out.println("Hay " + numrows + " filas!");
            String query = resultConfigData.getSQLField();
            PreparedStatement pstmtResults = memConn.prepareStatement(query);
            ResultSet rs = pstmtResults.executeQuery();
            int rowIndex = 0;
            while (rs.next()) {
                if (rowIndex < result.length) {
                    int columnIndex = 0;
                    while (columnIndex < fieldsNumber) {
                        result[rowIndex][columnIndex] = "" + rs.getObject(columnIndex + 1);
                        ++columnIndex;
                    }
                }
                ++rowIndex;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static void refreshParameters(int appId, Map<String, Number> parameters) {
        DAOFacade.addSimulationParametersToBD(appId, parameters);
    }

    private static void addSimulationParametersToBD(int appId, Map<String, Number> parameters) {
        DAOFacade.deleteSimulationParametersFromBD(appId);
        for (String key : parameters.keySet()) {
            Number n = parameters.get(key);
            double data = n.doubleValue();
            DAOFacade.insertSimulationParameter(appId, key, data);
        }
        DAOFacade.persistParameters();
    }

    private static void deleteSimulationParametersFromBD(int appId) {
        try {
            Statement stmt2 = memConn.createStatement();
            String borradoAppActual2 = "DELETE FROM parsed_parameters where appId = " + appId;
            stmt2.executeUpdate(borradoAppActual2);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void insertSimulationParameter(int appId, String parsedParameter, double data) {
        int[] indexes = new int[]{-1, -1, -1, -1, -1};
        int i = 0;
        String parameter = "";
        StringTokenizer elementos = new StringTokenizer(parsedParameter, "{}");
        while (elementos.hasMoreTokens()) {
            String bloque = elementos.nextToken();
            if (i == 0) {
                parameter = bloque;
                System.out.println(String.valueOf(i) + ". " + parameter);
                ++i;
                continue;
            }
            StringTokenizer indices = new StringTokenizer(bloque, ",");
            while (indices.hasMoreTokens()) {
                String indice = indices.nextToken();
                System.out.println(String.valueOf(i) + ". " + indice);
                indexes[i] = Integer.parseInt(indice);
                ++i;
            }
        }
        DAOFacade.insertParsedParameter(appId, parameter, indexes[1], indexes[2], indexes[3], indexes[4], data);
    }

    private static void insertSimulationParameter(int appId, String environmentID, String parameter, double data) {
        try {
            pstmt.setInt(1, appId);
            pstmt.setString(2, environmentID);
            pstmt.setString(3, parameter);
            pstmt.setDouble(4, data);
            pstmt.addBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void insertParsedParameter(int appId, String parameter, int index1, int index2, int index3, int index4, double data) {
        try {
            pstmtPP.setInt(1, appId);
            pstmtPP.setString(2, parameter);
            pstmtPP.setInt(3, index1);
            pstmtPP.setInt(4, index2);
            pstmtPP.setInt(5, index3);
            pstmtPP.setInt(6, index4);
            pstmtPP.setDouble(7, data);
            pstmtPP.addBatch();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    private static void persistParameters() {
        try {
            int[] outputs = pstmtPP.executeBatch();
            pstmtPP = memConn.prepareStatement("INSERT INTO parsed_parameters (appId,parameter,index1,index2,index3,index4,data) VALUES (?,?,?,?,?,?,?)");
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static String[][] getResults(int appId, int tableId, Map<String, Number> parameters) {
        String[][] result = null;
        try {
            SimulationResultConfigData resultConfigData = DAOFacade.getSimulationResultsConfigData(appId, tableId);
            System.out.println("Query: " + resultConfigData.getSQLField());
            String countQuery = "select count(*) from (" + resultConfigData.getSQLField() + ") summary";
            int fieldsNumber = resultConfigData.getFieldsNumber();
            PreparedStatement pstmtCount = memConn.prepareStatement(countQuery);
            ResultSet countRs = pstmtCount.executeQuery();
            int numrows = 100;
            if (countRs.next()) {
                numrows = countRs.getInt(1);
            }
            result = new String[numrows][fieldsNumber];
            String query = resultConfigData.getSQLField();
            PreparedStatement pstmtResults = memConn.prepareStatement(query);
            ResultSet rs = pstmtResults.executeQuery();
            int rowIndex = 0;
            while (rs.next()) {
                if (rowIndex < result.length) {
                    int columnIndex = 0;
                    while (columnIndex < fieldsNumber) {
                        result[rowIndex][columnIndex] = "" + rs.getObject(columnIndex + 1);
                        ++columnIndex;
                    }
                }
                ++rowIndex;
            }
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static SimulationResultConfigData getSimulationResultsConfigData(int appId, int tableId) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        SimulationResultConfigData result = new SimulationResultConfigData();
        String jpql = "SELECT sr FROM SimulationResult sr WHERE sr.appId = " + appId + " AND sr.tableId = " + tableId;
        Query query = em.createQuery(jpql);
        System.out.println(jpql);
        SimulationResult sr = (SimulationResult)query.getSingleResult();
        result.setSimulationResult(sr);
        int resultTableId = sr.getResultTableId();
        String selectJPQL = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"Select\"";
        Query selectQuery = em.createQuery(selectJPQL);
        List selectResult = selectQuery.getResultList();
        for (SimulationCriteria sc : selectResult) {
            IField selectField = DAOFacade.getIField(sc);
            result.addSelectCriteria(selectField);
        }
        String joinJPQL = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"Join\"";
        Query joinQuery = em.createQuery(joinJPQL);
        List joinResult = joinQuery.getResultList();
        for (SimulationCriteria sc : joinResult) {
            IFieldJoin joinField = DAOFacade.getIFieldJoin(sc);
            result.addJoinCriteria(joinField);
        }
        String whereJPQL = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"Where\"";
        Query whereQuery = em.createQuery(whereJPQL);
        List whereList = whereQuery.getResultList();
        if (whereList != null && whereList.size() > 0) {
            SimulationCriteria whereSC = (SimulationCriteria)whereList.get(0);
            IFieldCriteria whereCondition = DAOFacade.getIFieldCriteria(whereSC);
            result.setWhereCriteria(whereCondition);
        }
        String groupJPQL = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"Group\"";
        Query groupQuery = em.createQuery(groupJPQL);
        List groupResult = groupQuery.getResultList();
        for (SimulationCriteria sc : groupResult) {
            IField groupField = DAOFacade.getIField(sc);
            result.addGroupCriteria(groupField);
        }
        String from = "";
        if (sr.getReferredResultTableId() == 0) {
            from = "simulation_registers";
        } else {
            SimulationResultConfigData innerSelect = DAOFacade.getAuxSimulationResultsConfigData(appId, sr.getReferredResultTableId());
            result.setInnerSelect(innerSelect);
            from = innerSelect.getSimulationResult().getResultTableName();
        }
        result.setFrom(from);
        em.close();
        emf.close();
        return result;
    }

    public static Set<Pair<Integer, Integer>> getSimulationResultsWhereCriteria(int appId, int tableId) {
        HashSet<Pair<Integer, Integer>> steps = new HashSet<Pair<Integer, Integer>>();
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        SimulationResultConfigData result = new SimulationResultConfigData();
        String jpql = "SELECT sr FROM SimulationResult sr WHERE sr.appId = " + appId + " AND sr.tableId = " + tableId;
        Query query = em.createQuery(jpql);
        SimulationResult sr = (SimulationResult)query.getSingleResult();
        result.setSimulationResult(sr);
        int resultTableId = sr.getResultTableId();
        String whereJPQL = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"Where\"";
        Query whereQuery = em.createQuery(whereJPQL);
        List whereList = whereQuery.getResultList();
        if (whereList != null && whereList.size() > 0) {
            SimulationCriteria whereSC = (SimulationCriteria)whereList.get(0);
            Set<Pair<Integer, Integer>> whereCondition = DAOFacade.getIFieldCriteriaWhereCriteria(whereSC);
            steps.addAll(whereCondition);
        }
        if (sr.getReferredResultTableId() != 0) {
            Set<Pair<Integer, Integer>> innerSelect = DAOFacade.getAuxSimulationResultsConfigDataWhereCriteria(appId, sr.getReferredResultTableId());
            steps.addAll(innerSelect);
        }
        em.close();
        emf.close();
        return steps;
    }

    private static Set<Pair<Integer, Integer>> getAuxSimulationResultsConfigDataWhereCriteria(int appId, int resTableId) {
        HashSet<Pair<Integer, Integer>> steps = new HashSet<Pair<Integer, Integer>>();
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        SimulationResultConfigData result = new SimulationResultConfigData();
        String jpql = "SELECT sr FROM SimulationResult sr WHERE sr.appId = " + appId + " AND sr.resultTableId = " + resTableId;
        Query query = em.createQuery(jpql);
        SimulationResult sr = (SimulationResult)query.getSingleResult();
        result.setSimulationResult(sr);
        int resultTableId = sr.getResultTableId();
        String whereJPQL = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"Where\"";
        Query whereQuery = em.createQuery(whereJPQL);
        List whereList = whereQuery.getResultList();
        if (whereList != null && whereList.size() > 0) {
            SimulationCriteria whereSC = (SimulationCriteria)whereList.get(0);
            Set<Pair<Integer, Integer>> whereCondition = DAOFacade.getIFieldCriteriaWhereCriteria(whereSC);
            steps.addAll(whereCondition);
        }
        if (sr.getReferredResultTableId() != 0) {
            Set<Pair<Integer, Integer>> innerSelect = DAOFacade.getAuxSimulationResultsConfigDataWhereCriteria(appId, sr.getReferredResultTableId());
            steps.addAll(innerSelect);
        }
        em.close();
        emf.close();
        return steps;
    }

    public static Set<Pair<Integer, Integer>> getIFieldCriteriaWhereCriteria(SimulationCriteria sc) {
        HashSet<Pair<Integer, Integer>> steps = new HashSet<Pair<Integer, Integer>>();
        String criteria = sc.getCriteria();
        if (criteria.equals("formula")) {
            if (!sc.getFormula().equals("NOT")) {
                IField aux;
                if (sc.getFormula().equals("AND") || sc.getFormula().equals("OR")) {
                    EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
                    EntityManager em = emf.createEntityManager();
                    int appId = sc.getAppId();
                    int resultTableId = sc.getResultTableId();
                    int referredCriteriaId1 = sc.getReferredCriteriaId();
                    String auxJPQL = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"WhereAux\"" + " AND sc.criteriaId = " + referredCriteriaId1;
                    Query auxQuery = em.createQuery(auxJPQL);
                    SimulationCriteria scAux = null;
                    try {
                        scAux = (SimulationCriteria)auxQuery.getSingleResult();
                    }
                    catch (Throwable t) {
                        System.out.println("La que est\u00e1 fallando es: " + auxJPQL);
                    }
                    if (scAux == null) {
                        System.out.println("Null!!!");
                    }
                    Set<Pair<Integer, Integer>> decoratedField1 = DAOFacade.getIFieldCriteriaWhereCriteria(scAux);
                    Set<Pair<Integer, Integer>> decoratedField2 = null;
                    if (sc.getArgument() != null) {
                        String argument = sc.getArgument();
                        int referredCriteriaId2 = Integer.parseInt(argument);
                        auxJPQL = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"WhereAux\"" + " AND sc.criteriaId = " + referredCriteriaId2;
                        auxQuery = em.createQuery(auxJPQL);
                        scAux = (SimulationCriteria)auxQuery.getSingleResult();
                        decoratedField2 = DAOFacade.getIFieldCriteriaWhereCriteria(scAux);
                    }
                    steps.addAll(decoratedField1);
                    steps.addAll(decoratedField2);
                    em.close();
                    emf.close();
                } else if (sc.getFormula().equals("MOD") && (aux = DAOFacade.getIField(sc)).getSQLField().indexOf("step") != -1 && sc.getArgument() != null && !sc.getArgument().equals("") && sc.getWhereCondition() != null && !sc.getWhereCondition().equals("")) {
                    int step = Integer.parseInt(sc.getArgument());
                    int mod = Integer.parseInt(sc.getWhereCondition());
                    Pair par = new Pair((Object)step, (Object)mod);
                    steps.add((Pair<Integer, Integer>)par);
                }
            }
        } else if (sc.getCriteria() != null && sc.getCriteria().equals("step") && sc.getArgument() != null && !sc.getArgument().equals("")) {
            int step = Integer.parseInt(sc.getWhereConditionType());
            int mod = -1;
            Pair par = new Pair((Object)step, (Object)mod);
            steps.add((Pair<Integer, Integer>)par);
        }
        return steps;
    }

    private static SimulationResultConfigData getAuxSimulationResultsConfigData(int appId, int resTableId) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        SimulationResultConfigData result = new SimulationResultConfigData();
        String jpql = "SELECT sr FROM SimulationResult sr WHERE sr.appId = " + appId + " AND sr.resultTableId = " + resTableId;
        Query query = em.createQuery(jpql);
        SimulationResult sr = (SimulationResult)query.getSingleResult();
        result.setSimulationResult(sr);
        int resultTableId = sr.getResultTableId();
        String selectJPQL = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"Select\"";
        Query selectQuery = em.createQuery(selectJPQL);
        List selectResult = selectQuery.getResultList();
        for (SimulationCriteria sc : selectResult) {
            IField selectField = DAOFacade.getIField(sc);
            result.addSelectCriteria(selectField);
        }
        String joinJPQL = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"Join\"";
        Query joinQuery = em.createQuery(joinJPQL);
        List joinResult = joinQuery.getResultList();
        for (SimulationCriteria sc : joinResult) {
            IFieldJoin joinField = DAOFacade.getIFieldJoin(sc);
            result.addJoinCriteria(joinField);
        }
        String whereJPQL = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"Where\"";
        Query whereQuery = em.createQuery(whereJPQL);
        List whereList = whereQuery.getResultList();
        if (whereList != null && whereList.size() > 0) {
            SimulationCriteria whereSC = (SimulationCriteria)whereList.get(0);
            IFieldCriteria whereCondition = DAOFacade.getIFieldCriteria(whereSC);
            result.setWhereCriteria(whereCondition);
        }
        String groupJPQL = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"Group\"";
        Query groupQuery = em.createQuery(groupJPQL);
        List groupResult = groupQuery.getResultList();
        for (SimulationCriteria sc : groupResult) {
            IField groupField = DAOFacade.getIField(sc);
            result.addGroupCriteria(groupField);
        }
        String from = "";
        if (sr.getReferredResultTableId() == 0) {
            from = "simulation_registers";
        } else {
            SimulationResultConfigData innerSelect = DAOFacade.getAuxSimulationResultsConfigData(appId, sr.getReferredResultTableId());
            result.setInnerSelect(innerSelect);
            from = innerSelect.getSimulationResult().getResultTableName();
        }
        result.setFrom(from);
        em.close();
        emf.close();
        return result;
    }

    public static IField getIField(SimulationCriteria sc) {
        IField selectField = null;
        String criteria = sc.getCriteria();
        if (criteria.equals("formula")) {
            EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
            EntityManager em = emf.createEntityManager();
            int appId = sc.getAppId();
            int resultTableId = sc.getResultTableId();
            int referredCriteriaId = sc.getReferredCriteriaId();
            String auxJPQL = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"Auxiliary\"" + " AND sc.criteriaId = " + referredCriteriaId;
            Query auxQuery = em.createQuery(auxJPQL);
            System.out.println("Auxiliar: " + auxJPQL);
            SimulationCriteria scAux = (SimulationCriteria)auxQuery.getSingleResult();
            if (scAux == null) {
                System.out.println("Null!!!");
            }
            IField decoratedField = DAOFacade.getIField(scAux);
            IField decoratedField2 = null;
            ArrayList<Object> arguments = new ArrayList<Object>();
            String whereConditionType = null;
            String whereCondition = null;
            if (sc.getArgument() != null) {
                if (sc.getWhereConditionType() != null) {
                    whereConditionType = sc.getWhereConditionType();
                }
                if (sc.getWhereCondition() != null) {
                    whereCondition = sc.getWhereCondition();
                }
                if (sc.getWhereConditionType() == null || !sc.getWhereConditionType().equals("Reference")) {
                    String argS = sc.getArgument();
                    if (sc.getWhereConditionType() != null && (sc.getWhereConditionType().equals("String") || sc.getWhereConditionType().equals("DirectString"))) {
                        arguments.add(argS);
                    } else {
                        arguments.add(new Integer(sc.getArgument()));
                    }
                } else {
                    String auxJPQL2 = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"Auxiliary\"" + " AND sc.criteriaId = " + Integer.parseInt(sc.getArgument());
                    Query auxQuery2 = em.createQuery(auxJPQL2);
                    System.out.println("Auxiliar2: " + auxJPQL2);
                    SimulationCriteria scAux2 = (SimulationCriteria)auxQuery2.getSingleResult();
                    if (scAux2 == null) {
                        System.out.println("Null!!!");
                    }
                    decoratedField2 = DAOFacade.getIField(scAux2);
                }
            }
            selectField = new FieldFormula(sc.getFormula(), decoratedField, arguments, sc.getQualifiedName(), whereCondition, whereConditionType, decoratedField2);
            em.close();
            emf.close();
        } else if (!criteria.equals("parameter")) {
            selectField = new Field(criteria);
        }
        return selectField;
    }

    public static IFieldJoin getIFieldJoin(SimulationCriteria sc) {
        FieldJoin joinField = null;
        String joinTable1 = sc.getCriteria();
        String joinField1 = sc.getFormula();
        String joinTable2 = sc.getArgument();
        String joinValue2 = sc.getQualifiedName();
        String joinType = sc.getWhereConditionType();
        joinField = new FieldJoin(joinTable1, joinField1, joinTable2, joinValue2, joinType);
        return joinField;
    }

    public static IFieldCriteria getIFieldCriteria(SimulationCriteria sc) {
        IFieldCriteria whereField = null;
        String criteria = sc.getCriteria();
        String whereConditionType = sc.getWhereConditionType();
        String whereCondition = sc.getWhereCondition();
        if (criteria.equals("formula")) {
            if (sc.getFormula().equals("NOT") || sc.getFormula().equals("AND") || sc.getFormula().equals("OR")) {
                EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
                EntityManager em = emf.createEntityManager();
                int appId = sc.getAppId();
                int resultTableId = sc.getResultTableId();
                int referredCriteriaId1 = sc.getReferredCriteriaId();
                String auxJPQL = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"WhereAux\"" + " AND sc.criteriaId = " + referredCriteriaId1;
                Query auxQuery = em.createQuery(auxJPQL);
                SimulationCriteria scAux = null;
                try {
                    scAux = (SimulationCriteria)auxQuery.getSingleResult();
                }
                catch (Throwable t) {
                    System.out.println("La que est\u00e1 fallando es: " + auxJPQL);
                }
                if (scAux == null) {
                    System.out.println("Null!!!");
                }
                IFieldCriteria decoratedField1 = DAOFacade.getIFieldCriteria(scAux);
                IFieldCriteria decoratedField2 = null;
                if (sc.getArgument() != null) {
                    String argument = sc.getArgument();
                    int referredCriteriaId2 = Integer.parseInt(argument);
                    auxJPQL = "SELECT sc FROM SimulationCriteria sc WHERE sc.appId = " + appId + " AND sc.resultTableId = " + resultTableId + " AND sc.criteriaType = \"WhereAux\"" + " AND sc.criteriaId = " + referredCriteriaId2;
                    auxQuery = em.createQuery(auxJPQL);
                    scAux = (SimulationCriteria)auxQuery.getSingleResult();
                    decoratedField2 = DAOFacade.getIFieldCriteria(scAux);
                }
                whereField = new FieldCriteriaFormula(sc.getFormula(), decoratedField1, decoratedField2);
                em.close();
                emf.close();
            } else {
                whereField = new FieldCriteria(DAOFacade.getIField(sc), whereConditionType, whereCondition);
            }
        } else {
            whereField = new FieldCriteria(new Field(criteria), whereConditionType, whereCondition);
        }
        return whereField;
    }

    public static Number callFunction(String methodName, List<Number> parameters) {
        Number result = null;
        result = FunctionCallsManager.getInstance().callFunction(methodName, parameters);
        return result;
    }

    public static Number callFunction(String methodName, List<Number> parameters, List<String> mandatoryInterfaces) {
        Number result = null;
        result = FunctionCallsManager.getInstance().callFunction(methodName, parameters, mandatoryInterfaces);
        return result;
    }

    public static Set<String> getPluginNames() {
        Set<String> result = null;
        try {
            result = PluginsManager.getInstance().getPluginNames();
        }
        catch (UnavailablePropertyException e) {
            e.printStackTrace();
        }
        return result;
    }

    public static List<String> getPluginJars(String pluginName) {
        List<String> pluginJars = null;
        try {
            pluginJars = PluginsManager.getInstance().getPluginJars(pluginName);
        }
        catch (UnavailablePropertyException e) {
            e.printStackTrace();
        }
        return pluginJars;
    }

    public static List<String> getPluginParameters(String pluginName) {
        List<String> pluginParameters = null;
        try {
            pluginParameters = PluginsManager.getInstance().getPluginParameters(pluginName);
        }
        catch (UnavailablePropertyException e) {
            e.printStackTrace();
        }
        return pluginParameters;
    }

    public static String getPluginMethod(String pluginName) {
        String pluginMethod = "";
        try {
            pluginMethod = PluginsManager.getInstance().getPluginMethod(pluginName);
        }
        catch (UnavailablePropertyException e) {
            e.printStackTrace();
        }
        return pluginMethod;
    }

    public static String getPluginClass(String pluginName) {
        String pluginClass = "";
        try {
            pluginClass = PluginsManager.getInstance().getPluginClass(pluginName);
        }
        catch (UnavailablePropertyException e) {
            e.printStackTrace();
        }
        return pluginClass;
    }

    public static void callPluginFunction(String pluginName, AbstractEcoSimGUI gui) {
        PluginsManager.getInstance().callPluginFunction(pluginName, gui);
    }

    public static String getPluginShowingName(String name) {
        String showingName = "";
        try {
            showingName = PluginsManager.getInstance().getPluginShowingName(name);
        }
        catch (UnavailablePropertyException e) {
            e.printStackTrace();
        }
        return showingName;
    }

    public static void ficticiousStart() {
        memConn = OnMemoryDBManager.getInstance().getConnection();
    }

    public static ResultSet executeSelect(String queryEntrada) {
        ResultSet rs = null;
        try {
            String query = queryEntrada;
            PreparedStatement pstmt3 = memConn.prepareStatement(query);
            rs = pstmt3.executeQuery();
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
        return rs;
    }

    public static void executeCreate(String queryEntrada) {
        try {
            Statement stmt = null;
            String creacion = queryEntrada;
            stmt = memConn.createStatement();
            stmt.executeUpdate(creacion);
        }
        catch (SQLException e) {
            e.printStackTrace();
        }
    }

    public static void insertAdhocRegister(SimulationRegister register) {
    }

    public static void generateDaikonFile(int i, CustomOutputDataBlock cdb, int numberOfSteps) {
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        CurrentApp app = em.find(CurrentApp.class, 1);
        int appId = app.getIdApp();
        GeneralData appGD = em.find(GeneralData.class, appId);
        String appName = appGD.getAppName();
        try {
            try {
                PluginDaikonTable dt;
                String dtJPQL = "SELECT dt FROM PluginDaikonTable dt WHERE dt.appId = " + appId + " AND dt.tableId = " + cdb.getData().getTableConfig().getIdTabla();
                Query dtQuery = em.createQuery(dtJPQL);
                List dts = dtQuery.getResultList();
                if (dts != null && dts.size() > 0 && (dt = (PluginDaikonTable)dts.get(0)).isEnabled()) {
                    String daikonFilename = "";
                    String dirPath = DAOFacade.getProperty("daikon-path");
                    if (dirPath != null && !dirPath.equals("")) {
                        daikonFilename = dirPath;
                    }
                    daikonFilename = String.valueOf(daikonFilename) + (DAOFacade.getProperty("daikon-file-include-app").equalsIgnoreCase("yes") ? String.valueOf(appName) + "-" : "") + "sim" + i + "-" + cdb.getName() + "-" + DAOFacade.getProperty("daikon-file");
                    String daikonFiles = DAOFacade.getProperty("daikon-summary");
                    FileWriter fwFiles = new FileWriter(daikonFiles, true);
                    BufferedWriter bwFiles = new BufferedWriter(fwFiles);
                    bwFiles.write(String.valueOf(daikonFilename) + "\n");
                    bwFiles.close();
                    File fichero = new File(daikonFilename);
                    if (fichero.exists()) {
                        fichero.delete();
                    }
                    FileWriter fw = new FileWriter(daikonFilename);
                    BufferedWriter bw = new BufferedWriter(fw);
                    int stepIndex = dt.getStepIndex() - 1;
                    LinkedHashMap<String, Integer> objectsData = new LinkedHashMap<String, Integer>();
                    TreeMap objectNameIndexesPerDaikonExtraction = new TreeMap();
                    String deJPQL = "SELECT de FROM PluginDaikonExtraction de WHERE de.appId = " + appId + " AND de.tableId = " + cdb.getData().getTableConfig().getIdTabla();
                    Query deQuery = em.createQuery(deJPQL);
                    List daikonExtractions = deQuery.getResultList();
                    for (PluginDaikonExtraction de : daikonExtractions) {
                        if (de.getExtractionType() == 1) {
                            objectsData.put(de.getObjectName(), new Integer(0));
                            continue;
                        }
                        String diJPQL = "SELECT di FROM PluginDaikonIndex di WHERE di.appId = " + appId + " AND di.tableId = " + cdb.getData().getTableConfig().getIdTabla() + " AND di.extractionId = " + de.getExtractionId();
                        Query diQuery = em.createQuery(diJPQL);
                        List daikonIndexes = diQuery.getResultList();
                        TreeMap<Integer, Integer> objectNameIndexes = new TreeMap<Integer, Integer>();
                        TreeMap<Integer, SortedSet<String>> elementsToShow = new TreeMap<Integer, SortedSet<String>>();
                        for (PluginDaikonIndex di : daikonIndexes) {
                            objectNameIndexes.put(di.getExtractionOrder(), di.getExtractionIndex() - 1);
                        }
                        objectNameIndexesPerDaikonExtraction.put(de.getExtractionId(), objectNameIndexes);
                        int in = 0;
                        while (in < cdb.getRowCount()) {
                            for (Integer objNameInd : objectNameIndexes.keySet()) {
                                TreeSet<String> valuesInColumn = (TreeSet<String>)elementsToShow.get(objNameInd);
                                if (valuesInColumn == null) {
                                    valuesInColumn = new TreeSet<String>();
                                    elementsToShow.put(objNameInd, valuesInColumn);
                                }
                                valuesInColumn.add((String)cdb.getValueAt(in, (Integer)objectNameIndexes.get(objNameInd)));
                            }
                            ++in;
                        }
                        int size = objectNameIndexes.keySet().size();
                        Integer[] indexes = new Integer[size];
                        int ii = 0;
                        Iterator<Object> iterator = objectNameIndexes.keySet().iterator();
                        while (iterator.hasNext()) {
                            Integer integ;
                            indexes[ii] = integ = (Integer)iterator.next();
                            ++ii;
                        }
                        DAOFacade.generateObjectNames("", indexes, 0, elementsToShow, objectsData);
                    }
                    String header = "";
                    for (String s : objectsData.keySet()) {
                        header = String.valueOf(header) + s + " int ";
                    }
                    System.out.println(header);
                    System.out.println(header);
                    bw.write(String.valueOf(header) + "\n");
                    bw.write(String.valueOf(header) + "\n");
                    TreeMap<Integer, LinkedHashMap> objectsForStep = new TreeMap<Integer, LinkedHashMap>();
                    int st = 0;
                    while (st <= numberOfSteps) {
                        objectsForStep.put(st, (LinkedHashMap)objectsData.clone());
                        ++st;
                    }
                    int in = 0;
                    while (in < cdb.getRowCount()) {
                        int st2 = Integer.parseInt((String)cdb.getValueAt(in, stepIndex));
                        for (PluginDaikonExtraction de : daikonExtractions) {
                            double dataD = Double.parseDouble((String)cdb.getValueAt(in, de.getDataIndex() - 1));
                            int data = Double.valueOf(dataD).intValue();
                            if (de.getExtractionType() == 1) {
                                ((LinkedHashMap)objectsForStep.get(st2)).put(de.getObjectName(), data);
                                continue;
                            }
                            String key = "";
                            for (Integer objNameInd : ((SortedMap)objectNameIndexesPerDaikonExtraction.get(de.getExtractionId())).values()) {
                                key = String.valueOf(key) + "_" + (String)cdb.getValueAt(in, objNameInd);
                            }
                            if (key != null && key.length() > 0) {
                                key = key.substring(1);
                            }
                            ((LinkedHashMap)objectsForStep.get(st2)).put(key, data);
                        }
                        ++in;
                    }
                    st = 0;
                    while (st <= numberOfSteps) {
                        for (Integer val : ((LinkedHashMap)objectsForStep.get(new Integer(st))).values()) {
                            System.out.print(val + "\t");
                            bw.write(val + "\t");
                        }
                        System.out.println();
                        bw.write("\n");
                        if (st != 0 && st != numberOfSteps) {
                            for (Integer val : ((LinkedHashMap)objectsForStep.get(new Integer(st))).values()) {
                                System.out.print(val + "\t");
                                bw.write(val + "\t");
                            }
                            System.out.println();
                            bw.write("\n");
                        }
                        ++st;
                    }
                    bw.close();
                }
            }
            catch (UnavailablePropertyException e1) {
                e1.printStackTrace();
                em.close();
                emf.close();
            }
            catch (IOException e) {
                e.printStackTrace();
                em.close();
                emf.close();
            }
        }
        finally {
            em.close();
            emf.close();
        }
    }

    private static void generateObjectNames(String string, Integer[] indexes, int pointer, SortedMap<Integer, SortedSet<String>> elementsToShow, LinkedHashMap<String, Integer> objectsData) {
        block3: {
            block2: {
                if (pointer >= indexes.length - 1) break block2;
                for (String element : (SortedSet)elementsToShow.get(indexes[pointer])) {
                    String partialString = String.valueOf(string) + "_" + element;
                    DAOFacade.generateObjectNames(partialString, indexes, pointer + 1, elementsToShow, objectsData);
                }
                break block3;
            }
            if (pointer != indexes.length - 1) break block3;
            for (String element : (SortedSet)elementsToShow.get(indexes[pointer])) {
                String finalString = String.valueOf(string) + "_" + element;
                finalString = finalString.substring(1);
                objectsData.put(finalString, new Integer(0));
            }
        }
    }

    public static boolean isDaikonEnabled(int appId, int tableId) {
        String dtJPQL;
        boolean isEnabled = false;
        EntityManagerFactory emf = Persistence.createEntityManagerFactory("EcoSimPersistence");
        EntityManager em = emf.createEntityManager();
        Query dtQuery = em.createQuery(dtJPQL = "SELECT dt FROM PluginDaikonTable dt WHERE dt.appId = " + appId + " AND dt.tableId = " + tableId);
        List dts = dtQuery.getResultList();
        if (dts != null && dts.size() > 0) {
            PluginDaikonTable dt = (PluginDaikonTable)dts.get(0);
            isEnabled = dt.isEnabled();
        }
        em.close();
        emf.close();
        return isEnabled;
    }

    public static void setConfigFile(String configFile) {
        DAOFacade.configFile = configFile;
    }

    public static String getConfigFile() {
        return configFile;
    }

    /*
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    public static Iterator<String> getAvailableSimulatorsForModel(File f) {
        Iterator sims = null;
        try {
            FileReader fr = new FileReader(f);
            BufferedReader br = new BufferedReader(fr);
            boolean commentContext = false;
            String currentLine = br.readLine();
            while (true) {
                if (currentLine == null || !commentContext && currentLine.startsWith("@model")) {
                    String[] differentWords;
                    if (currentLine != null && currentLine.startsWith("@model") && (differentWords = currentLine.split("<")) != null && differentWords.length > 1) {
                        String model = differentWords[1].substring(0, differentWords[1].length() - 1);
                        Psystem ps = AbstractPsystemFactory.createAbstractPsystemFactory((String)model).createPsystem();
                        sims = ps.getSimulatorsIDs();
                    }
                    br.close();
                    fr.close();
                    return sims;
                }
                if (!commentContext) {
                    if (currentLine.startsWith("/*")) {
                        commentContext = true;
                    } else if (!currentLine.trim().equals("")) {
                        return null;
                    }
                } else if (currentLine.endsWith("*/")) {
                    commentContext = false;
                }
                currentLine = br.readLine();
            }
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
            return sims;
        }
        catch (IOException e) {
            e.printStackTrace();
            return sims;
        }
        catch (PlinguaCoreException e) {
            e.printStackTrace();
        }
        return sims;
    }

    public static void makeZip(String path, Set<String> excludeFiles, String zipName) {
        try {
            Zip.makeZip(path, excludeFiles, zipName);
        }
        catch (FileNotFoundException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static void copyFile(String sourceFile, String destinationFile) {
        try {
            int c;
            File inFile = new File(sourceFile);
            File outFile = new File(destinationFile);
            FileInputStream in = new FileInputStream(inFile);
            FileOutputStream out = new FileOutputStream(outFile);
            while ((c = in.read()) != -1) {
                out.write(c);
            }
            in.close();
            out.close();
        }
        catch (IOException e) {
            System.err.println("IO Error!!!");
        }
    }
}

