/*
 * Decompiled with CFR 0.152.
 */
package db;

import db.EcoSimException;
import db.Ecosystem;
import db.Species;
import java.io.Serializable;
import java.util.Iterator;

public class Parameter
implements Serializable {
    private static final long serialVersionUID = -8318491701444092821L;
    private String description;
    private int id;
    private String name;

    public Parameter(int id) {
        this("k", id);
    }

    public Parameter(String name, int id) {
        this.name = name;
        this.id = id;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String description) {
        this.description = description;
    }

    public int getId() {
        return this.id;
    }

    public void setId(int id) throws EcoSimException {
        if (Ecosystem.existsParameter(this.getName(), id + 1)) {
            throw new EcoSimException("Repeated parameter");
        }
        Iterator<Species> it = Ecosystem.getInstance().getSpecies().iterator();
        int oldId = this.getId();
        this.id = id;
        while (it.hasNext()) {
            Species s = it.next();
            String key = String.valueOf(this.getName()) + "{" + (s.getId() + 1) + "," + (oldId + 1) + "}";
            if (!s.getParameters().containsKey(key)) continue;
            double val = s.getParameters().get(key);
            s.getParameters().remove(key);
            Ecosystem.getInstance().setParameterValue(this.getName(), s.getId() + 1, this.getId() + 1, val);
        }
        this.id = id;
    }

    public String getName() {
        if (this.name == null) {
            this.name = "k";
        }
        return this.name;
    }

    public void setName(String name) throws EcoSimException {
        if (Ecosystem.existsParameter(name, this.getId() + 1)) {
            throw new EcoSimException("Repeated parameter");
        }
        Iterator<Species> it = Ecosystem.getInstance().getSpecies().iterator();
        String oldName = this.getName();
        this.name = name;
        while (it.hasNext()) {
            Species s = it.next();
            String key = String.valueOf(oldName) + "{" + (s.getId() + 1) + "," + (this.getId() + 1) + "}";
            if (!s.getParameters().containsKey(key)) continue;
            double val = s.getParameters().get(key);
            s.getParameters().remove(key);
            Ecosystem.getInstance().setParameterValue(s.getId() + 1, this.getId() + 1, val);
        }
    }

    public String toString() {
        return String.valueOf(this.name) + "{i," + this.id + "}";
    }

    public int hashCode() {
        int prime = 31;
        int result = 1;
        result = 31 * result + this.id;
        result = 31 * result + (this.name == null ? 0 : this.name.hashCode());
        return result;
    }

    public boolean equals(Object obj) {
        if (this == obj) {
            return true;
        }
        if (obj == null) {
            return false;
        }
        if (this.getClass() != obj.getClass()) {
            return false;
        }
        Parameter other = (Parameter)obj;
        if (this.id != other.id) {
            return false;
        }
        return !(this.name == null ? other.name != null : !this.name.equals(other.name));
    }
}

