package org.gcn.plinguacore.util.psystem.rule.guard;

public class ComparationMasks {
	public static final short LESS_THAN = 2;
	public static final short LESS_OR_EQUAL_THAN = 3;
	public static final short GREATER_THAN = 4;
	public static final short GREATER_OR_EQUAL_THAN = 5;
	public static final short EQUAL = 6;
	public static final short DIFF = 7;
	public static final short MINUS = 0;
	public static final short PLUS = 1;
	public static final String STRING_LESS_THAN = "<";
	public static final String STRING_LESS_OR_EQUAL_THAN = "<=";
	public static final String STRING_GREATER_THAN = ">";
	public static final String STRING_GREATER_OR_EQUAL_THAN = ">=";
	public static final String STRING_EQUAL = "=";
	public static final String STRING_DIFF = "<>";
	public static final String STRING_MINUS = "-";
	public static final String STRING_PLUS = "+";
	
	
	public static String operationRepresentation(short relOp) {
		// TODO Auto-generated method stub
		switch(relOp){
			case(EQUAL): return "=";
			case(LESS_THAN): return "<";
			case(LESS_OR_EQUAL_THAN): return "<=";
			case(GREATER_OR_EQUAL_THAN): return ">=";
			case(GREATER_THAN): return ">";
			case(DIFF): return "<>";
			case(MINUS): return "-";
			case(PLUS): return "+";
			default: return "";
		}
	}
	
	public static short operationCode(String representation) {
		// TODO Auto-generated method stub
		if(representation.equals(">=")) return GREATER_OR_EQUAL_THAN;
		if(representation.equals("<=")) return LESS_OR_EQUAL_THAN;
		if(representation.equals("<>")) return DIFF;
		if(representation.equals("=")) return EQUAL;
		if(representation.equals("<")) return LESS_THAN;
		if(representation.equals(">")) return GREATER_THAN;
		if(representation.equals("-")) return MINUS;
		if(representation.equals("+")) return PLUS;
		return -1;
	}
}
