/*
 * Decompiled with CFR 0.152.
 */
package mecosim.plugins.promela;

import ecoSim.IMeCoSimConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Container;
import java.awt.Cursor;
import java.awt.FileDialog;
import java.awt.Frame;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.awt.event.WindowAdapter;
import java.awt.event.WindowEvent;
import java.awt.image.BufferedImage;
import java.io.File;
import java.io.FileInputStream;
import java.io.FileNotFoundException;
import java.io.FileOutputStream;
import java.io.IOException;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.Enumeration;
import javax.imageio.ImageIO;
import javax.swing.BorderFactory;
import javax.swing.ImageIcon;
import javax.swing.JButton;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JMenu;
import javax.swing.JMenuBar;
import javax.swing.JMenuItem;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTextArea;
import javax.swing.SwingUtilities;
import javax.swing.UIManager;
import javax.swing.plaf.FontUIResource;
import mecosim.plugins.promela.PromelaFileGenerator;
import mecosim.plugins.promela.SpinRunner;
import org.gcn.plinguacore.simulator.ISimulator;
import org.gcn.plinguacore.util.psystem.Psystem;
import org.gcn.plinguacore.util.psystem.rule.kernel.SimpleKernelLikePsystem;

public class PromelaJFrame
extends JFrame
implements ActionListener {
    private static final long serialVersionUID = 1398994185115152178L;
    ISimulator sim;
    IMeCoSimConfig config;
    String promelaFilename;
    String spinFilename;
    JMenuBar mbar;
    JMenu file;
    JMenu edit;
    JMenu verif;
    JMenuItem itemOpen;
    JMenuItem itemSave;
    JMenuItem itemSaveAs;
    JMenuItem itemExit;
    JMenuItem itemCut;
    JMenuItem itemCopy;
    JMenuItem itemPaste;
    JMenuItem itemDelete;
    JMenuItem itemSelectAll;
    JMenuItem itemPromela;
    JMenuItem itemSpin;
    JPanel mainPanel;
    Container contentPanel;
    JPanel pLinguaPanel;
    JPanel promelaPanel;
    JPanel spinPanel;
    JPanel bPanelPlingua;
    JPanel bPanelPromela;
    JScrollPane plinguaTextSP;
    JScrollPane promelaTextSP;
    JScrollPane spinTextSP;
    JTextArea plinguaText;
    JTextArea promelaText;
    JTextArea spinText;
    JLabel plinguaLbl;
    JLabel promelaLbl;
    JLabel spinLbl;
    String command = " ";
    String str = " ";
    String str1 = " ";
    String str2 = " ";
    String str3 = " ";
    String str4 = " ";
    String str6 = " ";
    String str7 = " ";
    String str8 = " ";
    String str9 = " ";
    int len;
    int len1;
    int pos1;
    int i = 0;
    PanelType panelType = PanelType.NORMAL;
    protected static JSplitPane jsPane;
    protected static JSplitPane jsRightPane;

    public PromelaJFrame() {
    }

    public PromelaJFrame(String str, PanelType panelType, ISimulator sim, IMeCoSimConfig config, String promelaFilename, String spinFilename) {
        super(str);
        try {
            JFrame.setDefaultLookAndFeelDecorated(true);
        }
        catch (Exception exception) {
            // empty catch block
        }
        this.panelType = panelType;
        this.sim = sim;
        this.config = config;
        this.promelaFilename = promelaFilename;
        this.spinFilename = spinFilename;
        this.generateMenu();
        this.generateMainPanel();
    }

    private void generateMenu() {
        this.mbar = new JMenuBar();
        this.setJMenuBar(this.mbar);
        this.file = new JMenu("File");
        this.edit = new JMenu("Edit");
        this.verif = new JMenu("Verification");
        this.itemOpen = new JMenuItem("Open");
        this.file.add(this.itemOpen);
        this.itemSave = new JMenuItem("Save");
        this.file.add(this.itemSave);
        this.itemSaveAs = new JMenuItem("Save As...");
        this.file.add(this.itemSaveAs);
        this.itemExit = new JMenuItem("Exit");
        this.file.add(this.itemExit);
        this.mbar.add(this.file);
        this.itemCut = new JMenuItem("Cut (Ctrl+X)");
        this.edit.add(this.itemCut);
        this.itemCopy = new JMenuItem("Copy (Ctrl+C)");
        this.edit.add(this.itemCopy);
        this.itemPaste = new JMenuItem("Paste (Ctrl+V)");
        this.edit.add(this.itemPaste);
        this.itemDelete = new JMenuItem("Delete");
        this.edit.add(this.itemDelete);
        this.itemSelectAll = new JMenuItem("Select All (Ctrl+A)");
        this.edit.add(this.itemSelectAll);
        this.mbar.add(this.edit);
        this.itemPromela = new JMenuItem("Generate promela file");
        this.verif.add(this.itemPromela);
        this.itemSpin = new JMenuItem("Run Spin");
        this.verif.add(this.itemSpin);
        this.mbar.add(this.verif);
        this.itemOpen.addActionListener(this);
        this.itemSaveAs.addActionListener(this);
        this.itemExit.addActionListener(this);
        this.itemCut.addActionListener(this);
        this.itemCopy.addActionListener(this);
        this.itemPaste.addActionListener(this);
        this.itemDelete.addActionListener(this);
        this.itemSelectAll.addActionListener(this);
        this.itemSave.addActionListener(this);
        this.itemPromela.addActionListener(this);
        this.itemSpin.addActionListener(this);
    }

    private void generateMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = (JPanel)this.getContentPane();
            this.mainPanel.setLayout(new BorderLayout(10, 10));
            this.mainPanel.add((Component)new JPanel(), "North");
            this.mainPanel.add(this.getSouthPanel(), "South");
            this.mainPanel.add((Component)new JPanel(), "East");
            this.mainPanel.add((Component)new JPanel(), "West");
            this.mainPanel.add(this.getContentPanel(this.panelType), "Center");
        }
    }

    private Component getSouthPanel() {
        JPanel southPanel = new JPanel(new BorderLayout(0, 40));
        southPanel.add((Component)new JPanel(), "Center");
        southPanel.add((Component)new JPanel(), "South");
        return southPanel;
    }

    private Component getContentPanel(PanelType panelType) {
        if (this.contentPanel == null) {
            switch (panelType) {
                case NORMAL: {
                    this.contentPanel = this.getNormalPane();
                    break;
                }
                case SPLIT: {
                    this.contentPanel = this.getSplitPane();
                    break;
                }
                default: {
                    this.contentPanel = this.getNormalPane();
                }
            }
        }
        return this.contentPanel;
    }

    private Container getSplitPane() {
        jsPane = new JSplitPane(1);
        jsPane.setLeftComponent(this.getNewCompoundJPanel("P-Lingua", this.getPlinguaText(), true, "Generate promela file", "Generate promela file"));
        jsRightPane = new JSplitPane(1);
        jsRightPane.setLeftComponent(this.getNewCompoundJPanel("Promela", this.getPromelaText(), true, "Run Spin", "Run Spin"));
        jsRightPane.setRightComponent(this.getNewCompoundJPanel("Spin", this.getSpinText(), false, "", ""));
        jsPane.setRightComponent(jsRightPane);
        return jsPane;
    }

    private Container getNormalPane() {
        JPanel panel = new JPanel();
        panel.setLayout(new GridLayout(1, 3));
        panel.add(this.getNewCompoundJPanel("P-Lingua", this.getPlinguaText(), true, "Generate promela file", "Generate promela file"));
        panel.add(this.getNewCompoundJPanel("Promela", this.getPromelaText(), true, "Run Spin", "Run Spin"));
        panel.add(this.getNewCompoundJPanel("Spin", this.getSpinText(), false, "", ""));
        return panel;
    }

    private JPanel getNewCompoundJPanel(String label, Component area, boolean includeNextButton, String commandName, String tooltip) {
        JPanel compoundPanel = new JPanel(new BorderLayout(5, 0));
        compoundPanel.add((Component)new JPanel(), "West");
        JPanel compoundSubPanel = new JPanel(new BorderLayout(0, 20));
        compoundSubPanel.add(this.getNewJLabel(label), "North");
        compoundSubPanel.add(area, "Center");
        compoundPanel.add((Component)compoundSubPanel, "Center");
        Component eastComponent = new JPanel();
        if (includeNextButton) {
            eastComponent = this.getNextButton(commandName, tooltip);
        }
        compoundPanel.add(eastComponent, "East");
        return compoundPanel;
    }

    private Component getNextButton(String commandName, String tooltip) {
        GridLayout gl = new GridLayout(3, 1);
        JPanel panel = new JPanel(gl);
        try {
            panel.add(new JPanel());
            JButton btn = new JButton();
            URL imageUrl = PromelaJFrame.class.getResource("/ecoSim/rsc/Next-icon.png");
            BufferedImage image = ImageIO.read(imageUrl);
            ImageIcon icon = new ImageIcon(image);
            btn.setOpaque(false);
            btn.setBorderPainted(false);
            btn.setContentAreaFilled(false);
            btn.setIcon(icon);
            btn.setActionCommand(commandName);
            btn.setToolTipText(tooltip);
            btn.addActionListener(this);
            panel.add(btn);
            panel.add(new JPanel());
        }
        catch (MalformedURLException e) {
            e.printStackTrace();
        }
        catch (IOException e) {
            e.printStackTrace();
        }
        return panel;
    }

    private Component getNewJLabel(String label) {
        return new JLabel(label);
    }

    private Component getPlinguaText() {
        if (this.plinguaTextSP == null) {
            this.plinguaTextSP = new JScrollPane();
            this.plinguaTextSP.setAutoscrolls(true);
            this.plinguaText = new JTextArea("");
            this.plinguaText.setBorder(BorderFactory.createEtchedBorder(0));
            this.plinguaTextSP.setViewportView(this.plinguaText);
        }
        return this.plinguaTextSP;
    }

    private Component getPromelaText() {
        if (this.promelaTextSP == null) {
            this.promelaTextSP = new JScrollPane();
            this.promelaTextSP.setAutoscrolls(true);
            this.promelaText = new JTextArea("");
            this.promelaText.setBorder(BorderFactory.createEtchedBorder(0));
            this.promelaTextSP.setViewportView(this.promelaText);
        }
        return this.promelaTextSP;
    }

    private Component getSpinText() {
        if (this.spinTextSP == null) {
            this.spinTextSP = new JScrollPane();
            this.spinTextSP.setAutoscrolls(true);
            this.spinText = new JTextArea("");
            this.spinText.setBorder(BorderFactory.createEtchedBorder(0));
            this.spinTextSP.setViewportView(this.spinText);
        }
        return this.spinTextSP;
    }

    @Override
    public void actionPerformed(ActionEvent ae) {
        this.command = ae.getActionCommand();
        try {
            String userDir = this.config.getUserfilesPath();
            if (this.command.equals("New...")) {
                this.dispose();
                PromelaJFrame note1 = new PromelaJFrame("Untitled-Notepad", this.panelType, this.sim, this.config, this.promelaFilename, this.spinFilename);
                note1.setSize(500, 500);
                note1.setVisible(true);
            } else if (this.command.equals("Open")) {
                this.str4 = " ";
                FileDialog dialog = new FileDialog((Frame)this, "Open");
                dialog.setVisible(true);
                this.str1 = dialog.getDirectory();
                this.str2 = dialog.getFile();
                this.str3 = String.valueOf(this.str1) + this.str2;
                File f = new File(this.str3);
                FileInputStream fobj = new FileInputStream(f);
                this.len = (int)f.length();
                int j = 0;
                while (j < this.len) {
                    char str5 = (char)fobj.read();
                    this.str4 = String.valueOf(this.str4) + str5;
                    ++j;
                }
                this.plinguaText.setText(this.str4);
            } else if (this.command.equals("Save As...")) {
                FileDialog dialog1 = new FileDialog((Frame)this, "Save As", 1);
                dialog1.setVisible(true);
                this.str7 = dialog1.getDirectory();
                this.str8 = dialog1.getFile();
                this.str9 = String.valueOf(this.str7) + this.str8;
                this.str6 = this.plinguaText.getText();
                this.len1 = this.str6.length();
                byte[] buf = this.str6.getBytes();
                File f1 = new File(this.str9);
                FileOutputStream fobj1 = new FileOutputStream(f1);
                int k = 0;
                while (k < this.len1) {
                    fobj1.write(buf[k]);
                    ++k;
                }
                fobj1.close();
                this.setTitle("Promela model checker - " + this.str8);
            } else if (this.command.equals("Save")) {
                this.str7 = this.str1;
                this.str8 = this.str2;
                this.str9 = String.valueOf(this.str7) + this.str8;
                this.str6 = this.plinguaText.getText();
                this.len1 = this.str6.length();
                byte[] buf = this.str6.getBytes();
                File f1 = new File(this.str9);
                FileOutputStream fobj1 = new FileOutputStream(f1);
                int k = 0;
                while (k < this.len1) {
                    fobj1.write(buf[k]);
                    ++k;
                }
                fobj1.close();
                this.setTitle("Promela model checker - " + this.str8);
            } else if (this.command.equals("Exit")) {
                this.dispose();
            } else if (this.command.equals("Cut")) {
                this.str = this.plinguaText.getSelectedText();
                this.i = this.plinguaText.getText().indexOf(this.str);
                this.plinguaText.replaceRange(" ", this.i, this.i + this.str.length());
            } else if (this.command.equals("Copy")) {
                this.str = this.plinguaText.getSelectedText();
            } else if (this.command.equals("Paste")) {
                this.pos1 = this.plinguaText.getCaretPosition();
                this.plinguaText.insert(this.str, this.pos1);
            } else if (this.command.equals("Delete")) {
                String msg = this.plinguaText.getSelectedText();
                this.i = this.plinguaText.getText().indexOf(msg);
                this.plinguaText.replaceRange(" ", this.i, this.i + msg.length());
            } else if (this.command.equals("Select All")) {
                String strText = this.plinguaText.getText();
                int strLen = strText.length();
                this.plinguaText.select(0, strLen);
            } else if (this.command.equals("Generate promela file")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                PromelaFileGenerator.generatePromelaFile(new String[]{String.valueOf(userDir) + this.promelaFilename}, this.sim, this.config);
                this.generateText(userDir, this.promelaFilename, this.promelaText);
                this.setCursor(Cursor.getDefaultCursor());
                String message = "Promela file successfully created!";
                JOptionPane.showMessageDialog(null, message, "Promela file - Successful", 1);
            } else if (this.command.equals("Run Spin")) {
                this.setCursor(Cursor.getPredefinedCursor(3));
                SpinRunner.main(new String[]{this.promelaFilename, this.spinFilename, userDir});
                this.generateText(userDir, this.spinFilename, this.spinText);
                this.setCursor(Cursor.getDefaultCursor());
                String message = "Spin output successfully obtained!";
                JOptionPane.showMessageDialog(null, message, "Spin output - Successful", 1);
            }
        }
        catch (IOException iOException) {
            // empty catch block
        }
    }

    public static void main(final String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                PromelaJFrame.openPromelaJFrame(args, null, null);
            }
        });
    }

    public static void openPromelaJFrame(String[] args, IMeCoSimConfig config, ISimulator sim) {
        if (sim == null) {
            JOptionPane.showMessageDialog(null, "Simulator object not found!");
        } else {
            Psystem ps = sim.getPsystem();
            boolean split = false;
            if (ps instanceof SimpleKernelLikePsystem) {
                PromelaJFrame note = null;
                String panelTypeS = "";
                PanelType panelType = PanelType.valueOf("NORMAL");
                String message = "";
                String promelaFile = "promela-file.pml";
                String spinFile = "spin-output-file.txt";
                if (args != null && args.length > 0) {
                    panelTypeS = args[0];
                    try {
                        panelType = PanelType.valueOf(panelTypeS);
                        if (panelType == PanelType.valueOf("SPLIT")) {
                            split = true;
                        }
                    }
                    catch (IllegalArgumentException ex) {
                        panelType = PanelType.valueOf("NORMAL");
                        message = "<Calling Error> The introduced panel type is not valid";
                    }
                    if (args.length > 1) {
                        promelaFile = args[1];
                        if (args.length > 2) {
                            spinFile = args[2];
                        }
                    }
                }
                if (config != null) {
                    File pLinguaFile = config.getPLinguaFile();
                    String dir = String.valueOf(pLinguaFile.getParent()) + "\\";
                    String filename = pLinguaFile.getName();
                    note = new PromelaJFrame("Promela model checker - " + filename, panelType, sim, config, promelaFile, spinFile);
                    if (!message.equals("")) {
                        System.out.println(message);
                    }
                    note.generateText(dir, filename, note.plinguaText);
                } else {
                    note = new PromelaJFrame("Untitled", panelType, sim, config, promelaFile, spinFile);
                }
                note.setSize(800, 600);
                note.setLocationRelativeTo(null);
                note.setExtendedState(6);
                if (split) {
                    note.addWindowListener(new WindowAdapter(){

                        @Override
                        public void windowOpened(WindowEvent e) {
                            jsRightPane.setDividerLocation(0.4);
                            jsPane.setDividerLocation(0.35);
                        }
                    });
                }
                note.setVisible(true);
            } else {
                String message = "This functionality has been developed for Kernel P Systems!\nIt is not available for other models.";
                JOptionPane.showMessageDialog(null, message, "Non-compatible model", 2);
            }
        }
    }

    public static void setUIFont(FontUIResource f) {
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            UIManager.put(key, f);
        }
    }

    public static FontUIResource getUIFont() {
        FontUIResource font = null;
        Enumeration keys = UIManager.getDefaults().keys();
        while (keys.hasMoreElements()) {
            Object key = keys.nextElement();
            Object value = UIManager.get(key);
            if (!(value instanceof FontUIResource)) continue;
            font = (FontUIResource)UIManager.get(key);
        }
        return font;
    }

    public void generateText(String dir, String file, JTextArea area) {
        this.str4 = "";
        this.str1 = dir;
        this.str2 = file;
        this.str3 = String.valueOf(this.str1) + this.str2;
        File f = new File(this.str3);
        FileInputStream fobj = null;
        try {
            fobj = new FileInputStream(f);
        }
        catch (FileNotFoundException e) {
            String message = "The file " + f.getAbsolutePath() + " could not be found.";
            JOptionPane.showMessageDialog(null, message, "File Not found error", 2);
        }
        area.setText("");
        this.len = (int)f.length();
        int j = 0;
        while (j < this.len) {
            char str5 = 'a';
            try {
                str5 = (char)fobj.read();
            }
            catch (IOException e) {
                e.printStackTrace();
            }
            this.str4 = String.valueOf(this.str4) + str5;
            if (str5 == '\n') {
                area.append(this.str4);
                this.str4 = "";
            }
            ++j;
        }
        area.append(this.str4);
        area.setCaretPosition(0);
    }

    private static enum PanelType {
        NORMAL,
        SPLIT;

    }
}

