/*
 * Decompiled with CFR 0.152.
 */
package mecosim.plugins.promela;

import ecoSim.IMeCoSimConfig;
import java.io.File;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import javax.swing.JOptionPane;
import org.gcn.plinguacore.parser.output.promela.PromelaOutputParserFactory;
import org.gcn.plinguacore.simulator.ISimulator;
import org.gcn.plinguacore.util.psystem.Psystem;
import org.gcn.plinguacore.util.psystem.rule.kernel.SimpleKernelLikePsystem;

public class PromelaFileGenerator {
    public static void generatePromelaFile(String[] args, ISimulator sim, IMeCoSimConfig config) {
        if (sim == null) {
            JOptionPane.showMessageDialog(null, "Simulator object not found!");
        } else {
            Psystem ps = sim.getPsystem();
            if (ps instanceof SimpleKernelLikePsystem) {
                FileWriter fw = null;
                File pf = null;
                try {
                    String searchPath;
                    String path = "userfiles/promela-file.pml";
                    if (args != null && args.length > 0 && (searchPath = args[0]) != null && !searchPath.equals("")) {
                        path = searchPath;
                    }
                    pf = new File(path);
                    fw = new FileWriter(pf);
                    PromelaOutputParserFactory op = new PromelaOutputParserFactory();
                    op.setSimulationStepCount(config.getGeneralData().getStepsByCycle());
                    op.parse(ps, (Writer)fw);
                    fw.close();
                }
                catch (IOException e) {
                    String message = "File " + pf.getAbsolutePath() + " not found";
                    JOptionPane.showMessageDialog(null, message, "File not found!", 0);
                    e.printStackTrace();
                }
            } else {
                String message = "This functionality has been developed for Kernel P Systems!\nIt is not available for other models.";
                JOptionPane.showMessageDialog(null, message, "Non-compatible model", 2);
            }
        }
    }
}

