/*
 * Decompiled with CFR 0.152.
 */
package mecosim.plugins.basics;

import java.awt.Component;
import javax.swing.JFrame;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import mecosim.plugins.basics.Tree;
import org.dyno.visual.swing.layouts.Constraints;
import org.dyno.visual.swing.layouts.GroupLayout;
import org.dyno.visual.swing.layouts.Leading;

public class TreeViewer
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JTree viewerJTree;
    private JScrollPane viewerJSPane;
    private Tree<String> innerTree;
    private String name;
    private static final String PREFERRED_LOOK_AND_FEEL = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";

    public TreeViewer() {
        this.initComponents();
        this.innerTree = new Tree<String>("Void tree");
        this.name = "Tree Testing";
    }

    public TreeViewer(Tree<String> t, String name) {
        this.innerTree = t;
        this.initComponents();
        this.name = name;
    }

    private void initComponents() {
        this.setLayout(new GroupLayout());
        this.add((Component)this.getViewerJSPane(), new Constraints(new Leading(22, 700, 10, 10), new Leading(7, 299, 10, 10)));
        this.setSize(765, 316);
    }

    private JScrollPane getViewerJSPane() {
        if (this.viewerJSPane == null) {
            this.viewerJSPane = new JScrollPane();
            this.viewerJSPane.setViewportView(this.getJTree());
        }
        return this.viewerJSPane;
    }

    private JTree getJTree() {
        if (this.viewerJTree == null) {
            this.viewerJTree = new JTree();
            DefaultTreeModel treeModel = this.generateTree(this.innerTree);
            this.viewerJTree.setModel(treeModel);
        }
        return this.viewerJTree;
    }

    private DefaultTreeModel generateTree(Tree<String> mainTree) {
        DefaultMutableTreeNode initialNode = this.generateSubtree(mainTree);
        DefaultTreeModel treeModel = new DefaultTreeModel(initialNode);
        return treeModel;
    }

    private DefaultMutableTreeNode generateSubtree(Tree<String> rootedTree) {
        DefaultMutableTreeNode node0 = new DefaultMutableTreeNode(rootedTree.getValue());
        for (Tree<String> t : rootedTree.getChildren()) {
            node0.add(this.generateSubtree(t));
        }
        return node0;
    }

    public void visualizeTree(String[] args) {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.name);
        this.getContentPane().setPreferredSize(this.getSize());
        this.pack();
        this.setLocationRelativeTo(null);
        this.setVisible(true);
    }

    private static void installLnF() {
        try {
            JFrame.setDefaultLookAndFeelDecorated(true);
        }
        catch (Exception e) {
            System.err.println("Cannot install com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel on this platform:" + e.getMessage());
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeViewer.installLnF();
                TreeViewer frame = new TreeViewer();
                frame.setDefaultCloseOperation(3);
                frame.setTitle("SwingTest");
                frame.getContentPane().setPreferredSize(frame.getSize());
                frame.pack();
                frame.setAlwaysOnTop(true);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    public static void visualizeTreeStatic(String[] args, final Tree<String> t) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                TreeViewer frame = new TreeViewer(t, "Tree Testing");
                frame.setDefaultCloseOperation(2);
                frame.setTitle("PruebaSwing");
                frame.getContentPane().setPreferredSize(frame.getSize());
                frame.pack();
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }
}

