/*
 * Decompiled with CFR 0.152.
 */
package mecosim.plugins.basics;

import java.util.Set;
import mecosim.plugins.basics.Tree;
import mecosim.plugins.basics.TreeViewer;
import org.gcn.plinguacore.simulator.ISimulator;
import org.gcn.plinguacore.simulator.cellLike.probabilistic.AbstractProbabilisticSimulator;
import org.gcn.plinguacore.util.MultiSet;
import org.gcn.plinguacore.util.psystem.Psystem;
import org.gcn.plinguacore.util.psystem.cellLike.CellLikePsystem;
import org.gcn.plinguacore.util.psystem.cellLike.membrane.CellLikeNoSkinMembrane;
import org.gcn.plinguacore.util.psystem.cellLike.membrane.CellLikeSkinMembrane;
import org.gcn.plinguacore.util.psystem.membrane.Membrane;
import org.gcn.plinguacore.util.psystem.membrane.MembraneStructure;
import org.gcn.plinguacore.util.psystem.spiking.SpikingPsystem;
import org.gcn.plinguacore.util.psystem.spiking.membrane.SpikingMembraneStructure;
import org.gcn.plinguacore.util.psystem.tissueLike.TissueLikePsystem;
import org.gcn.plinguacore.util.psystem.tissueLike.membrane.TissueLikeMembrane;
import org.gcn.plinguacore.util.psystem.tissueLike.membrane.TissueLikeMembraneStructure;

public class MembraneStructureViewer {
    public static void visualizeMembraneStructure(String[] args, ISimulator sim) {
        MembraneStructureViewer.visualizeStructure(args, sim, false);
    }

    public static void visualizeMultiSets(String[] args, ISimulator sim) {
        MembraneStructureViewer.visualizeStructure(args, sim, true);
    }

    public static void visualizeStructure(String[] args, ISimulator sim, boolean showMultiSets) {
        Psystem ps = sim.getPsystem();
        if (ps instanceof CellLikePsystem) {
            Tree<String> membraneStructureTree = MembraneStructureViewer.generateTreeStructure(sim, showMultiSets);
            TreeViewer membraneStructureTreeViewer = new TreeViewer(membraneStructureTree, "Membrane Structure");
            membraneStructureTreeViewer.visualizeTree(args);
        } else if (ps instanceof TissueLikePsystem) {
            Tree<String> membraneStructureTree = MembraneStructureViewer.generateTreeStructure(sim, showMultiSets);
            TreeViewer membraneStructureTreeViewer = new TreeViewer(membraneStructureTree, "Cells Structure");
            membraneStructureTreeViewer.visualizeTree(args);
        } else if (ps instanceof SpikingPsystem) {
            Tree<String> membraneStructureTree = MembraneStructureViewer.generateTreeStructure(sim, showMultiSets);
            TreeViewer membraneStructureTreeViewer = new TreeViewer(membraneStructureTree, "Neurons Structure");
            membraneStructureTreeViewer.visualizeTree(args);
        }
    }

    private static Tree<String> generateTreeStructure(ISimulator sim, boolean showMultiSets) {
        Tree<String> t = null;
        Psystem ps = sim.getPsystem();
        if (ps instanceof CellLikePsystem) {
            MembraneStructure ms = sim.getCurrentConfig().getMembraneStructure();
            if (ms instanceof CellLikeSkinMembrane) {
                CellLikeSkinMembrane clms = (CellLikeSkinMembrane)ms;
                t = MembraneStructureViewer.getTreeRootNode(clms, sim instanceof AbstractProbabilisticSimulator, showMultiSets);
            } else {
                t = new Tree<String>("Void tree");
            }
        } else if (ps instanceof TissueLikePsystem) {
            MembraneStructure ms = sim.getCurrentConfig().getMembraneStructure();
            if (ms instanceof TissueLikeMembraneStructure) {
                TissueLikeMembraneStructure tlms = (TissueLikeMembraneStructure)ms;
                String env = tlms.getEnvironmentLabel();
                t = new Tree<String>("Cells");
                for (Membrane m : tlms.getAllMembranes()) {
                    TissueLikeMembrane tlm = (TissueLikeMembrane)m;
                    String label = tlm.getLabelObj().getLabelID();
                    if (label == null || label.equals(env)) continue;
                    Tree<String> childTree = new Tree<String>(String.valueOf(label) + " -- <<cell>> <label: " + label + " - id: " + tlm.getId() + ">");
                    t.addChild(childTree);
                    if (!showMultiSets) continue;
                    MultiSet multiobjects = tlm.getMultiSet();
                    if (multiobjects != null && multiobjects.size() > 0) {
                        Tree<String> msTree = new Tree<String>("Multiset of objects");
                        childTree.addChild(msTree);
                        Set objects = multiobjects.entrySet();
                        for (String s : objects) {
                            long mult = multiobjects.count((Object)s);
                            Tree<String> tObj = new Tree<String>(String.valueOf(s) + " * " + mult);
                            msTree.addChild(tObj);
                        }
                        continue;
                    }
                    childTree.setValue(String.valueOf(childTree.getValue()) + " (This membrane has no objects inside)");
                }
            } else {
                t = new Tree<String>("Void tree");
            }
        } else if (ps instanceof SpikingPsystem) {
            MembraneStructure ms = sim.getCurrentConfig().getMembraneStructure();
            if (ms instanceof SpikingMembraneStructure) {
                SpikingMembraneStructure sms = (SpikingMembraneStructure)ms;
                String env = sms.getEnvironmentLabel();
                t = new Tree<String>("Neurons");
                for (Membrane m : sms.getAllMembranes()) {
                    String label = m.getLabelObj().getLabelID();
                    if (label == null || env.equals(label)) continue;
                    Tree<String> childTree = new Tree<String>(String.valueOf(label) + " -- <<neuron>> <label: " + label + " - id: " + m.getId() + ">");
                    t.addChild(childTree);
                    if (!showMultiSets) continue;
                    MultiSet multiobjects = m.getMultiSet();
                    if (multiobjects != null && multiobjects.size() > 0) {
                        Tree<String> msTree = new Tree<String>("Multiset of objects");
                        childTree.addChild(msTree);
                        Set objects = multiobjects.entrySet();
                        for (String s : objects) {
                            long mult = multiobjects.count((Object)s);
                            Tree<String> tObj = new Tree<String>(String.valueOf(s) + " * " + mult);
                            msTree.addChild(tObj);
                        }
                        continue;
                    }
                    childTree.setValue(String.valueOf(childTree.getValue()) + " (This membrane has no objects inside)");
                }
            }
        } else {
            t = new Tree<String>("Void tree");
        }
        return t;
    }

    private static Tree<String> getTreeRootNode(CellLikeSkinMembrane clms, boolean isMultienvironment, boolean showMultiSets) {
        Tree<String> tR = new Tree<String>("Membranes");
        Tree<String> t = new Tree<String>(clms.getLabel());
        String addComment = "";
        if (showMultiSets) {
            MultiSet multiobjects = clms.getMultiSet();
            if (multiobjects != null && multiobjects.size() > 0) {
                Tree<String> msTree = new Tree<String>("Multiset of objects");
                t.addChild(msTree);
                Set objects = multiobjects.entrySet();
                for (String s : objects) {
                    long mult = multiobjects.count((Object)s);
                    Tree<String> tObj = new Tree<String>(String.valueOf(s) + " * " + mult);
                    msTree.addChild(tObj);
                }
            } else {
                addComment = " (This membrane has no objects inside)";
            }
        }
        for (CellLikeNoSkinMembrane child : clms.getChildMembranes()) {
            t.addChild(MembraneStructureViewer.getTreeNode(child, showMultiSets));
        }
        if (isMultienvironment) {
            tR = t;
            tR.setValue("Environments structure");
        } else {
            t.setValue(String.valueOf(t.getValue()) + " -- <<skin membrane>>");
            tR.addChild(t);
            tR.setValue("Membranes Structure");
        }
        t.setValue(String.valueOf(t.getValue()) + addComment);
        return tR;
    }

    private static Tree<String> getTreeNode(CellLikeNoSkinMembrane memb, boolean showMultiSets) {
        String label = memb.getLabel();
        String env = memb.getLabelObj().getEnvironmentID();
        String id = memb.getLabelObj().getLabelID();
        String node = String.valueOf(label) + " -- ";
        if (env != null && !env.equals("") && env.equals(label)) {
            node = String.valueOf(node) + "<<environment>> <env: " + env + "; label: " + label + "; id: " + id + ">";
        } else {
            node = String.valueOf(node) + "<<membrane>> ";
            node = env != null && !env.equals("") ? String.valueOf(node) + "<env: " + env + "; label: " + label + "; id: " + id + ">" : String.valueOf(node) + "<label: " + label + "; id: " + id + ">";
        }
        Tree<String> t = new Tree<String>(node);
        if (showMultiSets) {
            MultiSet multiobjects = memb.getMultiSet();
            if (multiobjects != null && multiobjects.size() > 0) {
                Tree<String> msTree = new Tree<String>("Multiset of objects");
                t.addChild(msTree);
                Set objects = multiobjects.entrySet();
                for (String s : objects) {
                    long mult = multiobjects.count((Object)s);
                    Tree<String> tObj = new Tree<String>(String.valueOf(s) + " * " + mult);
                    msTree.addChild(tObj);
                }
            } else {
                t.setValue(String.valueOf(t.getValue()) + " (This membrane has no objects inside)");
            }
        }
        for (CellLikeNoSkinMembrane child : memb.getChildMembranes()) {
            t.addChild(MembraneStructureViewer.getTreeNode(child, showMultiSets));
        }
        return t;
    }
}

