/*
 * Decompiled with CFR 0.152.
 */
package mecosim.plugins.promela;

import java.io.BufferedOutputStream;
import java.io.BufferedReader;
import java.io.File;
import java.io.FileOutputStream;
import java.io.IOException;
import java.io.InputStreamReader;
import java.io.PrintStream;

public class SpinRunner {
    public static String outputPath = "spin-output-file.txt";
    public static String inputPath = "promela-file.pml";
    public static String userDir = "userfiles/";
    public static Process p = null;

    public static void main(String[] args) {
        if (args != null && args.length > 0) {
            inputPath = args[0];
            if (args.length > 1) {
                outputPath = args[1];
                if (args.length > 2) {
                    userDir = args[2];
                }
            }
        }
        SpinRunner.run();
    }

    public static void run() {
        PrintStream output = null;
        BufferedReader stdInput = null;
        BufferedReader stdError = null;
        try {
            try {
                Runtime run = Runtime.getRuntime();
                if (p != null) {
                    p.destroy();
                }
                String commandLine = "spin -s " + inputPath;
                System.out.println(commandLine);
                p = run.exec(commandLine, null, new File(userDir));
                stdInput = new BufferedReader(new InputStreamReader(p.getInputStream()));
                stdError = new BufferedReader(new InputStreamReader(p.getErrorStream()));
                output = new PrintStream(new BufferedOutputStream(new FileOutputStream(new File(String.valueOf(userDir) + outputPath), false)));
                String message = "Here is the standard output of the command:\n";
                output.println(message);
                String s = stdInput.readLine();
                while (s != null && !s.equals("spin: type return to proceed")) {
                    output.println(s);
                    s = stdInput.readLine();
                }
                if (s != null && !s.equals("spin: type return to proceed")) {
                    System.out.println("Here is the standard error of the command (if any):\n");
                    s = stdError.readLine();
                    while (s != null) {
                        output.println(s);
                        s = stdError.readLine();
                    }
                }
                output.close();
                p.destroy();
            }
            catch (IOException e) {
                System.out.println("exception happened - here's what I know: ");
                e.printStackTrace();
                if (output != null) {
                    output.close();
                }
                try {
                    if (stdInput == null) {
                        stdInput.close();
                    }
                    if (stdError == null) {
                        stdError.close();
                    }
                }
                catch (IOException e2) {
                    e2.printStackTrace();
                }
            }
        }
        finally {
            try {
                if (stdInput == null) {
                    stdInput.close();
                }
                if (stdError == null) {
                    stdError.close();
                }
            }
            catch (IOException e) {
                e.printStackTrace();
            }
        }
    }
}

