/*
 * Decompiled with CFR 0.152.
 */
package mecosim.plugins.basics;

import java.util.Set;
import java.util.SortedSet;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JOptionPane;
import mecosim.plugins.basics.Tree;
import mecosim.plugins.basics.TreeViewer;
import org.gcn.plinguacore.simulator.ISimulator;
import org.gcn.plinguacore.util.psystem.AlphabetObject;
import org.gcn.plinguacore.util.psystem.Psystem;

public class AlphabetViewer {
    public static void visualizeAlphabet(String[] args, ISimulator sim) {
        if (sim == null) {
            JOptionPane.showMessageDialog(null, "Simulator object not found!");
        } else {
            Psystem ps = sim.getPsystem();
            AlphabetViewer.pluginFunctionality(ps);
        }
    }

    private static void pluginFunctionality(Psystem ps) {
        Tree<String> t = new Tree<String>("Alphabet");
        if (ps != null) {
            SortedSet alphabet = ps.getAlphabet();
            TreeMap objects = new TreeMap();
            for (AlphabetObject ao : alphabet) {
                if (objects.containsKey(ao.getName())) {
                    ((TreeSet)objects.get(ao.getName())).add(ao);
                    continue;
                }
                TreeSet<AlphabetObject> nt = new TreeSet<AlphabetObject>();
                nt.add(ao);
                objects.put(ao.getName(), nt);
            }
            Set keys = objects.keySet();
            for (String k : keys) {
                Tree<String> tP = new Tree<String>(k);
                TreeSet tC = (TreeSet)objects.get(k);
                for (AlphabetObject child : tC) {
                    tP.addChild(new Tree<String>(child.toString()));
                }
                t.addChild(tP);
            }
        }
        TreeViewer tViewer = new TreeViewer(t, "Alphabet Viewer");
        tViewer.visualizeTree(null);
    }

    public static void main(String[] args) {
        AlphabetViewer.pluginFunctionality(null);
    }
}

