/*
 * Decompiled with CFR 0.152.
 */
package mecosim.plugins.graphsPlugin;

import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.EventQueue;
import java.util.HashMap;
import java.util.Map;
import java.util.TreeSet;
import javax.swing.JApplet;
import javax.swing.JFrame;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JSplitPane;
import javax.swing.JTree;
import javax.swing.border.EmptyBorder;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import javax.xml.parsers.ParserConfigurationException;
import mecosim.plugins.graphsPlugin.GraphViewer;
import mecosim.plugins.graphsPlugin.node;
import org.xml.sax.SAXException;

public class SelectGraphJFrame<V>
extends JFrame {
    private JPanel contentPane;
    private HashMap<V, HashMap<V, TreeSet<node>>> graphsMLVers;
    private JPanel innerPane;
    private JPanel westPane;
    private JPanel mainPanel;
    private JTree tree;
    private JScrollPane scrollPane;
    private JScrollPane scrollPaneCenter;
    private JApplet applet;

    public static void main(String[] args) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SelectGraphJFrame frame = new SelectGraphJFrame();
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }

    public SelectGraphJFrame() {
        this.setDefaultCloseOperation(2);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(0, 0));
        this.setContentPane(this.contentPane);
        JScrollPane scrollPane = new JScrollPane();
        this.contentPane.add((Component)scrollPane, "West");
        JSplitPane splitPane = new JSplitPane();
        this.contentPane.add((Component)splitPane, "Center");
        final JTree tree = new JTree();
        splitPane.setLeftComponent(tree);
        tree.addTreeSelectionListener(new TreeSelectionListener(){

            @Override
            public void valueChanged(TreeSelectionEvent arg0) {
                DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)tree.getLastSelectedPathComponent();
                if (node2 == null) {
                    return;
                }
                Object nodeInfo = node2.getUserObject();
                if (node2.isLeaf()) {
                    System.out.println(nodeInfo);
                }
            }
        });
    }

    public SelectGraphJFrame(final HashMap<V, HashMap<V, TreeSet<node>>> graphsMLVers, final boolean isTree, final String nEdgs, final String edgesParam, final boolean extractNode, final boolean isBicolorTree) {
        this.setDefaultCloseOperation(2);
        this.contentPane = new JPanel();
        this.contentPane.setBorder(new EmptyBorder(5, 5, 5, 5));
        this.contentPane.setLayout(new BorderLayout(5, 5));
        this.setContentPane(this.contentPane);
        this.graphsMLVers = graphsMLVers;
        this.scrollPane = new JScrollPane();
        this.scrollPane.setPreferredSize(new Dimension(200, 600));
        this.contentPane.add((Component)this.scrollPane, "West");
        if (graphsMLVers != null) {
            DefaultMutableTreeNode rootNode2 = new DefaultMutableTreeNode("Graphs per membrane");
            for (Object object : graphsMLVers.keySet()) {
                DefaultMutableTreeNode membNode = new DefaultMutableTreeNode(object);
                for (Object object2 : graphsMLVers.get(object).keySet()) {
                    DefaultMutableTreeNode stepNode = new DefaultMutableTreeNode(object2);
                    membNode.add(stepNode);
                }
                rootNode2.add(membNode);
            }
            DefaultTreeModel defaultTreeModel = new DefaultTreeModel(rootNode2);
            this.tree = new JTree(defaultTreeModel);
            this.scrollPane.setViewportView(this.tree);
            this.tree.addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeCollapsed(TreeExpansionEvent arg0) {
                }

                @Override
                public void treeExpanded(TreeExpansionEvent arg0) {
                }
            });
            this.tree.addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent arg0) {
                    DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)SelectGraphJFrame.this.tree.getLastSelectedPathComponent();
                    if (node2 == null) {
                        return;
                    }
                    Object nodeInfo = node2.getUserObject();
                    if (node2.isLeaf()) {
                        DefaultMutableTreeNode memb = (DefaultMutableTreeNode)node2.getParent();
                        if (memb != null) {
                            Object membInfo = memb.getUserObject();
                            GraphViewer.showGraphMLFromVers((TreeSet)((HashMap)graphsMLVers.get(membInfo)).get(nodeInfo), nEdgs, edgesParam, extractNode);
                            SelectGraphJFrame.this.innerPane.removeAll();
                            Component gv = null;
                            try {
                                gv = new GraphViewer(new Dimension((int)(SelectGraphJFrame.this.contentPane.getSize().getWidth() * 0.65), (int)(SelectGraphJFrame.this.contentPane.getSize().getHeight() * 0.72)), isTree, isBicolorTree);
                            }
                            catch (ParserConfigurationException e) {
                                e.printStackTrace();
                            }
                            catch (SAXException e) {
                                e.printStackTrace();
                            }
                            SelectGraphJFrame.this.innerPane.add(gv);
                            gv.repaint();
                            gv.revalidate();
                        }
                    } else if (!node2.isRoot()) {
                        SelectGraphJFrame.this.innerPane.removeAll();
                        for (Map.Entry e : ((HashMap)graphsMLVers.get(nodeInfo)).entrySet()) {
                            GraphViewer.showGraphMLFromVers((TreeSet)e.getValue(), nEdgs, edgesParam, extractNode);
                            Component gv = null;
                            try {
                                gv = new GraphViewer(new Dimension((int)(SelectGraphJFrame.this.contentPane.getSize().getWidth() * 0.65), (int)(SelectGraphJFrame.this.contentPane.getSize().getHeight() * 0.72)), isTree, isBicolorTree);
                            }
                            catch (ParserConfigurationException e1) {
                                e1.printStackTrace();
                            }
                            catch (SAXException e1) {
                                e1.printStackTrace();
                            }
                            SelectGraphJFrame.this.innerPane.add(gv);
                            gv.repaint();
                            gv.revalidate();
                        }
                    }
                }
            });
        }
        this.innerPane = new JPanel();
        this.scrollPaneCenter = new JScrollPane();
        this.scrollPaneCenter.setViewportView(this.innerPane);
        this.mainPanel = new JPanel(new BorderLayout(5, 5));
        this.mainPanel.add((Component)new JPanel(), "North");
        this.mainPanel.add((Component)new JPanel(), "West");
        this.mainPanel.add((Component)this.scrollPaneCenter, "Center");
        this.mainPanel.add((Component)new JPanel(), "East");
        this.mainPanel.add((Component)new JPanel(), "South");
        this.contentPane.add((Component)this.mainPanel, "Center");
    }

    public static <V> void runFrameML(final HashMap<V, HashMap<V, TreeSet<node>>> graphsVers, final boolean isTree, final String nEdgs, final String edgesParam, final boolean extractNode, final boolean isBicolorTree) {
        EventQueue.invokeLater(new Runnable(){

            @Override
            public void run() {
                try {
                    SelectGraphJFrame frame = new SelectGraphJFrame(graphsVers, isTree, nEdgs, edgesParam, extractNode, isBicolorTree);
                    frame.setTitle("Graphs Viewer");
                    frame.setSize(800, 600);
                    frame.setLocationRelativeTo(null);
                    frame.setVisible(true);
                }
                catch (Exception e) {
                    e.printStackTrace();
                }
            }
        });
    }
}

