/*
 * Decompiled with CFR 0.152.
 */
package mecosim.plugins.graphsPlugin;

import ecoSim.IMeCoSimConfig;
import edu.uci.ics.jung.algorithms.layout.CircleLayout;
import edu.uci.ics.jung.algorithms.layout.DAGLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.algorithms.layout.FRLayout2;
import edu.uci.ics.jung.algorithms.layout.ISOMLayout;
import edu.uci.ics.jung.algorithms.layout.KKLayout;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout;
import edu.uci.ics.jung.algorithms.layout.SpringLayout2;
import edu.uci.ics.jung.algorithms.layout.StaticLayout;
import edu.uci.ics.jung.algorithms.layout.TreeLayout;
import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.graph.util.TestGraphs;
import edu.uci.ics.jung.io.GraphMLReader;
import edu.uci.ics.jung.io.GraphMLWriter;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.GraphZoomScrollPane;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.control.CrossoverScalingControl;
import edu.uci.ics.jung.visualization.control.DefaultModalGraphMouse;
import edu.uci.ics.jung.visualization.control.ModalGraphMouse;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import edu.uci.ics.jung.visualization.layout.LayoutTransition;
import edu.uci.ics.jung.visualization.renderers.BasicVertexRenderer;
import edu.uci.ics.jung.visualization.renderers.DefaultVertexLabelRenderer;
import edu.uci.ics.jung.visualization.renderers.Renderer;
import edu.uci.ics.jung.visualization.renderers.VertexLabelAsShapeRenderer;
import edu.uci.ics.jung.visualization.util.Animator;
import java.awt.BasicStroke;
import java.awt.BorderLayout;
import java.awt.Color;
import java.awt.Component;
import java.awt.Container;
import java.awt.Dimension;
import java.awt.Font;
import java.awt.GridLayout;
import java.awt.Paint;
import java.awt.Stroke;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.io.FileWriter;
import java.io.IOException;
import java.lang.reflect.Constructor;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.Map;
import java.util.TreeSet;
import java.util.regex.Matcher;
import java.util.regex.Pattern;
import javax.swing.BorderFactory;
import javax.swing.JApplet;
import javax.swing.JButton;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JOptionPane;
import javax.swing.JPanel;
import javax.xml.parsers.ParserConfigurationException;
import mecosim.plugins.graphsPlugin.EdgeFactory;
import mecosim.plugins.graphsPlugin.SelectGraphJFrame;
import mecosim.plugins.graphsPlugin.SelectParamsJFrame;
import mecosim.plugins.graphsPlugin.VertexFactory;
import mecosim.plugins.graphsPlugin.edge;
import mecosim.plugins.graphsPlugin.node;
import mecosim.plugins.graphsPlugin.vertexPainter;
import org.apache.commons.collections15.BidiMap;
import org.apache.commons.collections15.Transformer;
import org.apache.commons.collections15.functors.ChainedTransformer;
import org.apache.commons.collections15.functors.ConstantTransformer;
import org.xml.sax.SAXException;

public class GraphViewer
extends JApplet {
    private static final long serialVersionUID = 1017336668368978842L;
    Graph<node, edge> graph;
    LinkedHashMap<Number, String> equiv;
    VisualizationViewer<node, edge> vv;
    Layout<node, edge> layout;
    private static IMeCoSimConfig mecosimConfig = null;

    public static void entryPoint(String[] args, IMeCoSimConfig config) {
        String message = "There is no graph mode defined for this application.\nPlease check the plugins-properties file";
        String title = "Unable to run";
        mecosimConfig = config;
        if (args != null && args.length > 0) {
            String mode = args[0];
            if (mode != null && !mode.equals("")) {
                boolean isTree = false;
                boolean twoColorTree = true;
                if (args.length > 1 && args[1].equals("tree")) {
                    isTree = true;
                    twoColorTree = args.length <= 2 || !args[2].equals("onecolor");
                }
                SelectParamsJFrame.chooseParams(config, isTree, twoColorTree);
            } else {
                JOptionPane.showMessageDialog(null, message, title, 2);
            }
        } else {
            JOptionPane.showMessageDialog(null, message, title, 2);
        }
    }

    public static void runGraphFunction(String mode, String n, String ne, String e, String vInfo, String vAttr, boolean extractNode, boolean isTree, boolean twoColorTree) {
        if (mode.equals("numver")) {
            GraphViewer.showGraphFromVertices(mecosimConfig, n, ne, e, isTree, twoColorTree);
        } else if (mode.equals("numedg")) {
            GraphViewer.showGraphFromEdges(mecosimConfig, ne, e, isTree, twoColorTree);
        } else if (mode.equals("texedg")) {
            GraphViewer.showGraphFromTextEdges(mecosimConfig, ne, e, isTree, twoColorTree);
        } else if (mode.equals("treeofgraphs")) {
            GraphViewer.showTreeOfGraphs(mecosimConfig, ne, e, vInfo, vAttr, extractNode, isTree, twoColorTree);
        } else {
            String message = "The selected type of graph is invalid";
            String title = "Unable to run";
            JOptionPane.showMessageDialog(null, message, title, 2);
        }
    }

    public GraphViewer() {
    }

    public GraphViewer(Dimension dimension, boolean isTree, boolean twoColorTree) throws ParserConfigurationException, SAXException {
        this.equiv = new LinkedHashMap();
        try {
            this.graph = this.getGraphML();
            if (this.graph == null || this.graph.getVertices() == null || this.graph.getVertices().size() == 0) {
                return;
            }
        }
        catch (IOException e1) {
            e1.printStackTrace();
        }
        Dimension graphDimension = new Dimension((int)(dimension.getWidth() * 0.9), (int)(dimension.getHeight() * 0.9));
        if (isTree) {
            DelegateTree<node, edge> tree = this.getTreeFromGraph(this.graph, twoColorTree);
            this.layout = new TreeLayout<node, edge>(tree, graphDimension);
        } else {
            this.layout = new FRLayout<node, edge>(this.graph, graphDimension);
        }
        Dimension preferredSize = dimension;
        DefaultVisualizationModel<node, edge> visualizationModel = new DefaultVisualizationModel<node, edge>(this.layout, preferredSize);
        this.vv = new VisualizationViewer<node, edge>(visualizationModel, preferredSize);
        VertexLabelAsShapeRenderer vlasr = new VertexLabelAsShapeRenderer(this.vv.getRenderContext());
        this.vv.getRenderContext().setVertexLabelTransformer(new ChainedTransformer(new Transformer[]{new Transformer<node, String>(){

            @Override
            public String transform(node input) {
                return "<html><center>" + input + (input.getDesc() != null && !input.getDesc().equals("null") ? "<p>" + input.getDesc() : "");
            }
        }}));
        this.vv.getRenderContext().setVertexShapeTransformer(vlasr);
        this.vv.getRenderContext().setVertexLabelRenderer(new DefaultVertexLabelRenderer(Color.yellow));
        this.vv.getRenderContext().setEdgeStrokeTransformer(new ConstantTransformer<Stroke>(new BasicStroke(1.75f)));
        this.vv.getRenderContext().setVertexFontTransformer(new ConstantTransformer<Font>(new Font("Helvetica", 1, 12)));
        this.vv.getRenderContext().setVertexDrawPaintTransformer(new ConstantTransformer<Paint>(Color.blue));
        this.vv.getRenderContext().setVertexFillPaintTransformer(new vertexPainter());
        this.vv.getRenderer().setVertexRenderer(new BasicVertexRenderer());
        this.vv.getRenderer().setVertexLabelRenderer(vlasr);
        this.vv.getRenderer().getVertexLabelRenderer().setPosition(Renderer.VertexLabel.Position.CNTR);
        this.vv.setBackground(Color.white);
        this.vv.setForeground(Color.white);
        this.vv.setVertexToolTipTransformer(new ToStringLabeller());
        DefaultModalGraphMouse graphMouse = new DefaultModalGraphMouse();
        this.vv.setGraphMouse(graphMouse);
        this.vv.addKeyListener(graphMouse.getModeKeyListener());
        Container content = this.getContentPane();
        GraphZoomScrollPane gzsp = new GraphZoomScrollPane(this.vv);
        content.add(gzsp);
        JComboBox modeBox = graphMouse.getModeComboBox();
        modeBox.addItemListener(graphMouse.getModeListener());
        graphMouse.setMode(ModalGraphMouse.Mode.MOVING);
        final CrossoverScalingControl scaler = new CrossoverScalingControl();
        JButton plus = new JButton("+");
        plus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(GraphViewer.this.vv, 1.1f, GraphViewer.this.vv.getCenter());
            }
        });
        JButton minus = new JButton("-");
        minus.addActionListener(new ActionListener(){

            @Override
            public void actionPerformed(ActionEvent e) {
                scaler.scale(GraphViewer.this.vv, 0.9090909f, GraphViewer.this.vv.getCenter());
            }
        });
        JPanel controls = new JPanel();
        JPanel zoomControls = new JPanel(new GridLayout(2, 1));
        zoomControls.setBorder(BorderFactory.createTitledBorder("Zoom"));
        zoomControls.add(plus);
        zoomControls.add(minus);
        controls.add(zoomControls);
        controls.add(modeBox);
        content.add((Component)controls, "South");
    }

    private <V, E> DelegateTree<V, E> getTreeFromGraph(Graph<V, E> graph, boolean twoColorTree) {
        DelegateTree tree = new DelegateTree();
        boolean i = false;
        V root = null;
        for (Object v : graph.getVertices()) {
            int incidentEdges = 0;
            for (Object e : graph.getEdges()) {
                if (!graph.getEndpoints(e).getSecond().equals(v)) continue;
                ++incidentEdges;
                break;
            }
            if (incidentEdges != 0) continue;
            root = v;
            break;
        }
        tree.addVertex(root);
        if (root instanceof node) {
            if (twoColorTree) {
                ((node)root).setColor("red");
                this.appendChildren(tree, root, graph, "green");
            } else {
                this.appendChildren(tree, root, graph);
            }
        } else {
            this.appendChildren(tree, root, graph);
        }
        return tree;
    }

    private <V, E> void appendChildren(DelegateTree<V, E> tree, V parent, Graph<V, E> graph) {
        EdgeFactory ef = new EdgeFactory();
        for (V child : graph.getNeighbors(parent)) {
            if (tree.containsVertex(child)) continue;
            edge ed = ef.create();
            tree.addChild(ed, parent, child);
            this.appendChildren(tree, child, graph);
        }
    }

    private <V, E> void appendChildren(DelegateTree<V, E> tree, V parent, Graph<V, E> graph, String color) {
        EdgeFactory ef = new EdgeFactory();
        for (V child : graph.getNeighbors(parent)) {
            ((node)child).setColor(color);
            if (tree.containsVertex(child)) continue;
            edge ed = ef.create();
            tree.addChild(ed, parent, child);
            this.appendChildren(tree, child, graph, color.equals("green") ? "red" : "green");
        }
    }

    public static void auxShowGraphInFrame(boolean isTree, boolean twoColorTree) throws ParserConfigurationException, SAXException {
        JFrame f = new JFrame("Graph");
        f.setSize(600, 600);
        f.setDefaultCloseOperation(2);
        JPanel mainPanel = new JPanel(new BorderLayout(5, 5));
        mainPanel.add((Component)new JPanel(), "North");
        mainPanel.add((Component)new JPanel(), "South");
        mainPanel.add((Component)new JPanel(), "East");
        mainPanel.add((Component)new JPanel(), "West");
        mainPanel.add((Component)new GraphViewer(new Dimension(450, 360), isTree, twoColorTree), "Center");
        f.getContentPane().add(mainPanel);
        f.setLocationRelativeTo(null);
        f.setAlwaysOnTop(true);
        f.setVisible(true);
    }

    public Graph getGraphML() throws IOException, ParserConfigurationException, SAXException {
        String filename = "userfiles/test.graphml";
        GraphMLReader gmlr = new GraphMLReader(new VertexFactory(), new EdgeFactory());
        this.graph = new UndirectedSparseGraph<node, edge>();
        gmlr.load(filename, this.graph);
        BidiMap vertex_ids = gmlr.getVertexIDs();
        BidiMap edges_ids = gmlr.getEdgeIDs();
        Map vertex_meta = gmlr.getVertexMetadata();
        Map edge_meta = gmlr.getEdgeMetadata();
        Pattern p_nId = Pattern.compile("n[0-9]*");
        boolean intMode_n = true;
        for (node n : this.graph.getVertices()) {
            String id = (String)vertex_ids.get(n);
            Matcher m_nId = p_nId.matcher(id);
            intMode_n = m_nId.matches();
            if (intMode_n) {
                n.setID(Integer.parseInt(id.substring(1)));
            }
            n.setValue(id);
            n.setColor(vertex_meta.get((Object)"d0").transformer.transform(n));
            n.setWeight(vertex_meta.get((Object)"d1").transformer.transform(n));
            n.setDesc(vertex_meta.get((Object)"d2").transformer.transform(n));
            System.out.println("ID: " + n.getID() + ", Value: " + n.getValue() + ", Color: " + n.getColor() + ", Weight: " + n.getWeight() + ", Desc: " + n.getDesc());
        }
        boolean intMode_e = true;
        Pattern p_eId = Pattern.compile("e[0-9]*");
        for (edge e : this.graph.getEdges()) {
            String id = (String)edges_ids.get(e);
            Matcher m_eId = p_eId.matcher(id);
            intMode_e = m_eId.matches();
            if (intMode_e) {
                e.setID(Integer.parseInt(id.substring(1)));
            }
            e.setValue(id);
            System.out.println("Edge ID: " + e.getID() + ", Value: " + e.getValue());
        }
        for (node n : this.graph.getVertices()) {
            this.equiv.put(n.getID(), n.getValue());
        }
        return this.graph;
    }

    public static void showGraphFromVertices(IMeCoSimConfig mecosimConfig2, String nVers, String nEdgs, String edgesParam, boolean isTree, boolean twoColorTree) {
        Graph<String, Number> g = null;
        if (mecosimConfig == null) {
            g = TestGraphs.createTestGraph(false);
        } else {
            Map<String, Number> pars = mecosimConfig.getParameters();
            g = new UndirectedSparseGraph<String, Number>();
            try {
                LinkedHashMap<Integer, node> rels = new LinkedHashMap<Integer, node>();
                TreeSet<node> vertices = new TreeSet<node>();
                Number neN = pars.get(nEdgs);
                if (neN != null) {
                    int i;
                    Number nN = pars.get(nVers);
                    if (nN != null) {
                        Integer n = Integer.parseInt(nN.toString());
                        i = 0;
                        while (i < n) {
                            VertexFactory vf = new VertexFactory();
                            node nod = vf.create();
                            nod.setValue(String.valueOf(i + 1));
                            rels.put(i + 1, nod);
                            g.addVertex((String)((Object)nod));
                            vertices.add((node)rels.get(i + 1));
                            ++i;
                        }
                    }
                    Integer ne = Integer.parseInt(neN.toString());
                    i = 1;
                    while (i <= ne) {
                        Integer n1 = new Integer(pars.get(String.valueOf(edgesParam) + "{" + i + ",1}").intValue());
                        Integer n2 = new Integer(pars.get(String.valueOf(edgesParam) + "{" + i + ",2}").intValue());
                        if (rels.get(n1) != null && rels.get(n2) != null) {
                            EdgeFactory ef = new EdgeFactory();
                            edge ed = ef.create();
                            ed.setValue(String.valueOf(i));
                            g.addEdge((Number)((Object)ed), (String)rels.get(n1), (String)rels.get(n2));
                            vertices.add((node)rels.get(n1));
                            vertices.add((node)rels.get(n2));
                        }
                        ++i;
                    }
                    if (vertices != null && vertices.size() > 0) {
                        GraphViewer.saveGraphML(g);
                        GraphViewer.auxShowGraphInFrame(isTree, twoColorTree);
                    } else {
                        String message = "There is no graph defined for this application.";
                        String title = "Unable to run";
                        JOptionPane.showMessageDialog(null, message, title, 2);
                    }
                } else {
                    String message = "There is no graph defined for this application.";
                    String title = "Unable to run";
                    JOptionPane.showMessageDialog(null, message, title, 2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void showGraphFromEdges(IMeCoSimConfig mecosimConfig, String nEdgs, String edgesParam, boolean isTree, boolean twoColorTree) {
        Graph<String, Number> g = null;
        if (mecosimConfig == null) {
            g = TestGraphs.createTestGraph(false);
        } else {
            Map<String, Number> pars = mecosimConfig.getParameters();
            g = new UndirectedSparseGraph<String, Number>();
            try {
                LinkedHashMap<Number, node> rels = new LinkedHashMap<Number, node>();
                TreeSet<node> vertices = new TreeSet<node>();
                EdgeFactory ef = new EdgeFactory();
                VertexFactory vf = new VertexFactory();
                Number neN = pars.get(nEdgs);
                if (neN != null) {
                    Integer ne = Integer.parseInt(neN.toString());
                    int i = 1;
                    while (i <= ne) {
                        Number n2;
                        node node2;
                        edge ed = ef.create();
                        ed.setValue(String.valueOf(i));
                        Number n1 = pars.get(String.valueOf(edgesParam) + "{" + i + ",1}");
                        node node1 = (node)rels.get(n1);
                        if (node1 == null) {
                            node1 = vf.create();
                            node1.setValue("" + n1);
                            rels.put(n1, node1);
                        }
                        if ((node2 = (node)rels.get(n2 = pars.get(String.valueOf(edgesParam) + "{" + i + ",2}"))) == null) {
                            node2 = vf.create();
                            node2.setValue("" + n2);
                            rels.put(n2, node2);
                        }
                        g.addEdge((Number)((Object)ed), (String)((Object)node1), (String)((Object)node2));
                        vertices.add(node1);
                        vertices.add(node2);
                        ++i;
                    }
                    if (vertices != null && vertices.size() > 0) {
                        GraphViewer.saveGraphML(g);
                        GraphViewer.auxShowGraphInFrame(isTree, twoColorTree);
                    } else {
                        String message = "There is no graph defined for this application.";
                        String title = "Unable to run";
                        JOptionPane.showMessageDialog(null, message, title, 2);
                    }
                } else {
                    String message = "There is no graph defined for this application.";
                    String title = "Unable to run";
                    JOptionPane.showMessageDialog(null, message, title, 2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void showGraphFromTextEdges(IMeCoSimConfig mecosimConfig, String nEdgs, String edgesParam, boolean isTree, boolean twoColorTree) {
        Graph<String, Number> g = null;
        if (mecosimConfig == null) {
            g = TestGraphs.createTestGraph(false);
        } else {
            Map<String, Number> pars = mecosimConfig.getParameters();
            Map<String, String> textPars = mecosimConfig.getTextParameters();
            EdgeFactory ef = new EdgeFactory();
            VertexFactory vf = new VertexFactory();
            g = new UndirectedSparseGraph<String, Number>();
            try {
                LinkedHashMap<String, node> rels = new LinkedHashMap<String, node>();
                TreeSet<node> vertices = new TreeSet<node>();
                boolean errGraph = false;
                Number neN = pars.get(nEdgs);
                if (neN != null) {
                    Integer ne = Integer.parseInt(neN.toString());
                    int i = 1;
                    while (i <= ne) {
                        String n2;
                        edge ed = ef.create();
                        ed.setValue(String.valueOf(i));
                        String n1 = textPars.get(String.valueOf(edgesParam) + "{" + i + ",1}");
                        if (n1 == null) {
                            errGraph = true;
                            break;
                        }
                        node node1 = (node)rels.get(n1);
                        if (node1 == null) {
                            node1 = vf.create();
                            node1.setValue(n1);
                            rels.put(n1, node1);
                        }
                        if ((n2 = textPars.get(String.valueOf(edgesParam) + "{" + i + ",2}")) == null) {
                            errGraph = true;
                            break;
                        }
                        node node2 = (node)rels.get(n2);
                        if (node2 == null) {
                            node2 = vf.create();
                            node2.setValue(n2);
                            rels.put(n2, node2);
                        }
                        g.addEdge((Number)((Object)ed), (String)((Object)node1), (String)((Object)node2));
                        vertices.add(node1);
                        vertices.add(node2);
                        ++i;
                    }
                    if (vertices != null && vertices.size() > 0 && !errGraph) {
                        GraphViewer.saveGraphML(g);
                        GraphViewer.auxShowGraphInFrame(isTree, twoColorTree);
                    } else {
                        String message = "The selected graph has not been defined for this application, or its definition presents errors.";
                        String title = "Unable to run";
                        JOptionPane.showMessageDialog(null, message, title, 2);
                    }
                } else {
                    String message = "There is no graph defined for this application.";
                    String title = "Unable to run";
                    JOptionPane.showMessageDialog(null, message, title, 2);
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
    }

    public static void showTreeOfGraphs(IMeCoSimConfig mecosimConfig, String nEdgs, String edgesParam, String vInfo, String vAttr, boolean extractNode, boolean isTree, boolean twoColorTree) {
        boolean enableIntegerMode = false;
        if (enableIntegerMode) {
            VertexFactory vf = new VertexFactory();
            Graph<node, edge> g = null;
            if (mecosimConfig == null) {
                g = TestGraphs.createTestGraphML(false);
            } else {
                Map<String, String> textPars = mecosimConfig.getTextParameters();
                g = new UndirectedSparseGraph<node, edge>();
                try {
                    TreeSet vertices = new TreeSet();
                    LinkedHashMap graphsVers = new LinkedHashMap();
                    Pattern pVs = Pattern.compile(String.valueOf(vInfo) + "\\{[0-9]*,2\\}");
                    for (Map.Entry<String, String> e2 : textPars.entrySet()) {
                        Matcher mVs = pVs.matcher(e2.getKey());
                        if (!mVs.matches()) continue;
                        Integer memb = Integer.parseInt(e2.getValue());
                        if (((HashMap)graphsVers).get(memb) == null) {
                            graphsVers.put(memb, new LinkedHashMap());
                        }
                        int nver = Integer.parseInt(e2.getKey().substring(e2.getKey().indexOf("{") + 1, e2.getKey().indexOf(",")));
                        Integer step = Integer.parseInt(textPars.get(String.valueOf(vInfo) + "{" + nver + ",1}"));
                        if (((HashMap)((HashMap)graphsVers).get(memb)).get(step) == null) {
                            ((HashMap)((HashMap)graphsVers).get(memb)).put(step, new TreeSet());
                        }
                        node node2 = vf.create();
                        node2.setValue(textPars.get(String.valueOf(vInfo) + "{" + nver + ",3}"));
                        ((TreeSet)((HashMap)((HashMap)graphsVers).get(memb)).get(step)).add(node2);
                    }
                    SelectGraphJFrame.runFrameML(graphsVers, isTree, nEdgs, edgesParam, extractNode, twoColorTree);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        } else {
            VertexFactory vf = new VertexFactory();
            Graph<node, edge> g = null;
            if (mecosimConfig == null) {
                g = TestGraphs.createTestGraphML(false);
            } else {
                Map<String, String> textPars = mecosimConfig.getTextParameters();
                g = new UndirectedSparseGraph<node, edge>();
                try {
                    LinkedHashMap graphsVers = new LinkedHashMap();
                    Pattern pVs = Pattern.compile(String.valueOf(vInfo) + "\\{[0-9]*,2\\}");
                    for (Map.Entry<String, String> e2 : textPars.entrySet()) {
                        Matcher mVs = pVs.matcher(e2.getKey());
                        if (!mVs.matches()) continue;
                        String memb = e2.getValue();
                        if (((HashMap)graphsVers).get(memb) == null) {
                            graphsVers.put(memb, new LinkedHashMap());
                        }
                        int nver = Integer.parseInt(e2.getKey().substring(e2.getKey().indexOf("{") + 1, e2.getKey().indexOf(",")));
                        String step = textPars.get(String.valueOf(vInfo) + "{" + nver + ",1}");
                        if (((HashMap)((HashMap)graphsVers).get(memb)).get(step) == null) {
                            ((HashMap)((HashMap)graphsVers).get(memb)).put(step, new TreeSet());
                        }
                        node n = vf.create();
                        n.setValue(textPars.get(String.valueOf(vInfo) + "{" + nver + ",3}"));
                        ((TreeSet)((HashMap)((HashMap)graphsVers).get(memb)).get(step)).add(n);
                        int iAttr = 1;
                        String attr = textPars.get(String.valueOf(vAttr) + "{" + nver + "," + iAttr++ + "}");
                        while (attr != null) {
                            String attrName = attr.substring(0, attr.indexOf("="));
                            String attrValue = attr.substring(attr.indexOf("=") + 1);
                            if (attrName.equals("desc")) {
                                n.setDesc(attrValue);
                            }
                            attr = textPars.get(String.valueOf(vAttr) + "{" + nver + "," + iAttr++ + "}");
                        }
                    }
                    SelectGraphJFrame.runFrameML(graphsVers, isTree, nEdgs, edgesParam, extractNode, twoColorTree);
                }
                catch (Exception ex) {
                    ex.printStackTrace();
                }
            }
        }
    }

    public static void showGraphMLFromVers(TreeSet<node> vers, String nEdgs, String edgesParam, boolean extractNode) {
        UndirectedSparseGraph<node, edge> g = new UndirectedSparseGraph<node, edge>();
        HashMap<String, node> values = new HashMap<String, node>();
        VertexFactory vf = new VertexFactory();
        for (node node2 : vers) {
            node n1 = vf.create();
            n1.setColor(GraphViewer.getColor(node2.getValue()));
            n1.setValue(node2.getValue());
            n1.setWeight(node2.getWeight());
            n1.setDesc(node2.getDesc());
            if (n1.getValue().startsWith("R_") || n1.getValue().startsWith("R{") || n1.getValue().startsWith("G_") || n1.getValue().startsWith("G{") || n1.getValue().startsWith("B_") || n1.getValue().startsWith("B{") || n1.getValue().startsWith("A_") || n1.getValue().startsWith("A{") || n1.getValue().startsWith("T_") || n1.getValue().startsWith("T{")) {
                if (!extractNode) {
                    n1.setDesc(n1.getValue());
                }
                if (n1.getValue() != null && n1.getValue().length() > 2) {
                    n1.setValue(n1.getValue().substring(2));
                }
                if (n1.getValue().indexOf("}") != -1) {
                    n1.setValue(n1.getValue().replace("}", ""));
                }
            }
            values.put(n1.getValue(), n1);
        }
        for (Map.Entry entry : values.entrySet()) {
            g.addVertex((node)entry.getValue());
        }
        Map<String, Number> map = mecosimConfig.getParameters();
        EdgeFactory ef = new EdgeFactory();
        if (map.get(nEdgs) != null) {
            try {
                Integer ne = Integer.parseInt(map.get(nEdgs).toString());
                int i = 1;
                while (i <= ne) {
                    String source = "" + map.get(String.valueOf(edgesParam) + "{" + i + ",1}");
                    String target = "" + map.get(String.valueOf(edgesParam) + "{" + i + ",2}");
                    node ns = (node)values.get(source);
                    node nt = (node)values.get(target);
                    if (ns != null && nt != null) {
                        edge e = ef.create();
                        e.setValue("e" + e.getID());
                        g.addEdge(e, ns, nt);
                    }
                    ++i;
                }
            }
            catch (Exception ex) {
                ex.printStackTrace();
            }
        }
        GraphViewer.saveGraphML(g);
    }

    public static void saveGraphML(Hypergraph<node, edge> g) {
        GraphMLWriter<node, edge> gmlw = new GraphMLWriter<node, edge>();
        Transformer<node, String> vertex_color = new Transformer<node, String>(){

            @Override
            public String transform(node n) {
                return String.valueOf(n.getColor());
            }
        };
        Transformer<node, String> vertex_weight = new Transformer<node, String>(){

            @Override
            public String transform(node n) {
                return String.valueOf(n.getWeight());
            }
        };
        Transformer<node, String> vertex_desc = new Transformer<node, String>(){

            @Override
            public String transform(node n) {
                return String.valueOf(n.getDesc());
            }
        };
        Transformer<edge, String> edge_value = new Transformer<edge, String>(){

            @Override
            public String transform(edge n) {
                return String.valueOf(n.getValue());
            }
        };
        gmlw.addVertexData("d0", "", "magenta", vertex_color);
        gmlw.addVertexData("d1", "", "1.0", vertex_weight);
        gmlw.addVertexData("d2", "", "desc", vertex_desc);
        gmlw.addEdgeData("value", "integer value for the edge", Integer.toString(-1), edge_value);
        gmlw.setEdgeIDs(edge_value);
        try {
            gmlw.save(g, new FileWriter("userfiles/test.graphml"));
        }
        catch (IOException e) {
            e.printStackTrace();
        }
    }

    public static String getColor(String object) {
        String color = "magenta";
        if (object.startsWith("R_") || object.startsWith("R{")) {
            color = "red";
        } else if (object.startsWith("G_") || object.startsWith("G{")) {
            color = "green";
        } else if (object.startsWith("B_") || object.startsWith("B{")) {
            color = "blue";
        }
        return color;
    }

    private static Class<? extends Layout>[] getLayouts() {
        ArrayList<Class<StaticLayout>> layouts = new ArrayList<Class<StaticLayout>>();
        layouts.add(KKLayout.class);
        layouts.add(FRLayout.class);
        layouts.add(FRLayout2.class);
        layouts.add(DAGLayout.class);
        layouts.add(CircleLayout.class);
        layouts.add(SpringLayout.class);
        layouts.add(SpringLayout2.class);
        layouts.add(ISOMLayout.class);
        layouts.add(StaticLayout.class);
        return layouts.toArray(new Class[0]);
    }

    public static class GraphChooser
    implements ActionListener {
        private JComboBox layout_combo;

        public GraphChooser(JComboBox layout_combo) {
            this.layout_combo = layout_combo;
        }

        @Override
        public void actionPerformed(ActionEvent e) {
            JComboBox cb = (JComboBox)e.getSource();
            this.layout_combo.setSelectedIndex(this.layout_combo.getSelectedIndex());
        }
    }

    private static final class LayoutChooser
    implements ActionListener {
        private final JComboBox jcb;
        private final VisualizationViewer<node, edge> vv;

        private LayoutChooser(JComboBox jcb, VisualizationViewer<node, edge> vv) {
            this.jcb = jcb;
            this.vv = vv;
        }

        @Override
        public void actionPerformed(ActionEvent arg0) {
            Object[] constructorArgs = new Object[]{};
            Class layoutC = (Class)this.jcb.getSelectedItem();
            try {
                Constructor constructor = layoutC.getConstructor(Graph.class);
                Object o = constructor.newInstance(constructorArgs);
                Layout l = (Layout)o;
                l.setInitializer(this.vv.getGraphLayout());
                l.setSize(this.vv.getSize());
                LayoutTransition<node, edge> lt = new LayoutTransition<node, edge>(this.vv, this.vv.getGraphLayout(), l);
                Animator animator = new Animator(lt);
                animator.start();
                this.vv.getRenderContext().getMultiLayerTransformer().setToIdentity();
                this.vv.repaint();
            }
            catch (Exception e) {
                e.printStackTrace();
            }
        }
    }
}

