/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.picking;

import edu.uci.ics.jung.algorithms.layout.GraphElementAccessor;
import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.util.Context;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationServer;
import edu.uci.ics.jung.visualization.picking.ShapePickSupport;
import edu.uci.ics.jung.visualization.transform.MutableTransformerDecorator;
import java.awt.Shape;
import java.awt.geom.AffineTransform;
import java.awt.geom.GeneralPath;
import java.awt.geom.PathIterator;
import java.awt.geom.Point2D;
import java.awt.geom.Rectangle2D;
import java.util.Collection;
import java.util.ConcurrentModificationException;
import java.util.HashSet;

public class ViewLensShapePickSupport<V, E>
extends ShapePickSupport<V, E>
implements GraphElementAccessor<V, E> {
    public ViewLensShapePickSupport(VisualizationServer<V, E> vv, float pickSize) {
        super(vv, pickSize);
    }

    public ViewLensShapePickSupport(VisualizationServer<V, E> vv) {
        this(vv, 2.0f);
    }

    @Override
    public V getVertex(Layout<V, E> layout, double x, double y) {
        V closest = null;
        double minDistance = Double.MAX_VALUE;
        Point2D ip = ((MutableTransformerDecorator)this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW)).getDelegate().inverseTransform(new Point2D.Double(x, y));
        x = ip.getX();
        y = ip.getY();
        while (true) {
            try {
                for (V v : this.getFilteredVertices(layout)) {
                    double dy;
                    Shape shape = this.vv.getRenderContext().getVertexShapeTransformer().transform(v);
                    Point2D p = (Point2D)layout.transform(v);
                    if (p == null) continue;
                    AffineTransform xform = AffineTransform.getTranslateInstance(p.getX(), p.getY());
                    shape = xform.createTransformedShape(shape);
                    Point2D lp = this.vv.getRenderContext().getMultiLayerTransformer().transform(Layer.LAYOUT, p);
                    AffineTransform xlate = AffineTransform.getTranslateInstance(lp.getX() - p.getX(), lp.getY() - p.getY());
                    shape = xlate.createTransformedShape(shape);
                    shape = this.vv.getRenderContext().getMultiLayerTransformer().transform(Layer.VIEW, shape);
                    if (!shape.contains(x, y)) continue;
                    if (this.style == ShapePickSupport.Style.LOWEST) {
                        return v;
                    }
                    if (this.style == ShapePickSupport.Style.HIGHEST) {
                        closest = v;
                        continue;
                    }
                    Rectangle2D bounds = shape.getBounds2D();
                    double dx = bounds.getCenterX() - x;
                    double dist = dx * dx + (dy = bounds.getCenterY() - y) * dy;
                    if (!(dist < minDistance)) continue;
                    minDistance = dist;
                    closest = v;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }

    @Override
    public Collection<V> getVertices(Layout<V, E> layout, Shape rectangle) {
        HashSet<V> pickedVertices = new HashSet<V>();
        rectangle = ((MutableTransformerDecorator)this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW)).getDelegate().inverseTransform(rectangle);
        while (true) {
            try {
                for (V v : this.getFilteredVertices(layout)) {
                    Point2D p = (Point2D)layout.transform(v);
                    if (p == null) continue;
                    Shape shape = this.vv.getRenderContext().getVertexShapeTransformer().transform(v);
                    AffineTransform xform = AffineTransform.getTranslateInstance(p.getX(), p.getY());
                    shape = xform.createTransformedShape(shape);
                    shape = this.vv.getRenderContext().getMultiLayerTransformer().transform(shape);
                    Rectangle2D bounds = shape.getBounds2D();
                    p.setLocation(bounds.getCenterX(), bounds.getCenterY());
                    if (!rectangle.contains(p)) continue;
                    pickedVertices.add(v);
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return pickedVertices;
    }

    @Override
    public E getEdge(Layout<V, E> layout, double x, double y) {
        Point2D ip = ((MutableTransformerDecorator)this.vv.getRenderContext().getMultiLayerTransformer().getTransformer(Layer.VIEW)).getDelegate().inverseTransform(new Point2D.Double(x, y));
        x = ip.getX();
        y = ip.getY();
        Rectangle2D.Float pickArea = new Rectangle2D.Float((float)x - this.pickSize / 2.0f, (float)y - this.pickSize / 2.0f, this.pickSize, this.pickSize);
        E closest = null;
        double minDistance = Double.MAX_VALUE;
        while (true) {
            try {
                for (E e : this.getFilteredEdges(layout)) {
                    float dy;
                    float dx;
                    float dist;
                    Pair<V> pair = layout.getGraph().getEndpoints(e);
                    V v1 = pair.getFirst();
                    V v2 = pair.getSecond();
                    boolean isLoop = v1.equals(v2);
                    Point2D p1 = (Point2D)layout.transform(v1);
                    Point2D p2 = (Point2D)layout.transform(v2);
                    if (p1 == null || p2 == null) continue;
                    float x1 = (float)p1.getX();
                    float y1 = (float)p1.getY();
                    float x2 = (float)p2.getX();
                    float y2 = (float)p2.getY();
                    AffineTransform xform = AffineTransform.getTranslateInstance(x1, y1);
                    Shape edgeShape = this.vv.getRenderContext().getEdgeShapeTransformer().transform(Context.getInstance(this.vv.getGraphLayout().getGraph(), e));
                    if (isLoop) {
                        Shape s2 = this.vv.getRenderContext().getVertexShapeTransformer().transform(v2);
                        Rectangle2D s2Bounds = s2.getBounds2D();
                        xform.scale(s2Bounds.getWidth(), s2Bounds.getHeight());
                        xform.translate(0.0, -edgeShape.getBounds2D().getHeight() / 2.0);
                    } else {
                        float dx2 = x2 - x1;
                        float dy2 = y2 - y1;
                        double theta = Math.atan2(dy2, dx2);
                        xform.rotate(theta);
                        float dist2 = (float)Math.sqrt(dx2 * dx2 + dy2 * dy2);
                        xform.scale(dist2, 1.0);
                    }
                    edgeShape = xform.createTransformedShape(edgeShape);
                    edgeShape = this.vv.getRenderContext().getMultiLayerTransformer().transform(edgeShape);
                    if (!edgeShape.intersects(pickArea)) continue;
                    float cx = 0.0f;
                    float cy = 0.0f;
                    float[] f = new float[6];
                    PathIterator pi = new GeneralPath(edgeShape).getPathIterator(null);
                    if (!pi.isDone()) {
                        pi.next();
                        pi.currentSegment(f);
                        cx = f[0];
                        cy = f[1];
                        if (!pi.isDone()) {
                            pi.currentSegment(f);
                            cx = f[0];
                            cy = f[1];
                        }
                    }
                    if (!((double)(dist = (dx = (float)((double)cx - x)) * dx + (dy = (float)((double)cy - y)) * dy) < minDistance)) continue;
                    minDistance = dist;
                    closest = e;
                }
            }
            catch (ConcurrentModificationException concurrentModificationException) {
                continue;
            }
            break;
        }
        return closest;
    }
}

