/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.DataMetadata;
import edu.uci.ics.jung.io.graphml.EndpointMetadata;
import edu.uci.ics.jung.io.graphml.ExceptionConverter;
import edu.uci.ics.jung.io.graphml.HyperEdgeMetadata;
import edu.uci.ics.jung.io.graphml.parser.AbstractElementParser;
import edu.uci.ics.jung.io.graphml.parser.ParserContext;
import java.util.Iterator;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.Attribute;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;

public class HyperEdgeElementParser<G extends Hypergraph<V, E>, V, E>
extends AbstractElementParser<G, V, E> {
    public HyperEdgeElementParser(ParserContext<G, V, E> parserContext) {
        super(parserContext);
    }

    @Override
    public HyperEdgeMetadata parse(XMLEventReader xmlEventReader, StartElement start) throws GraphIOException {
        try {
            HyperEdgeMetadata edge2 = new HyperEdgeMetadata();
            Iterator<Attribute> iterator = start.getAttributes();
            while (iterator.hasNext()) {
                Attribute attribute = iterator.next();
                String name = attribute.getName().getLocalPart();
                String value = attribute.getValue();
                if (edge2.getId() == null && "id".equals(name)) {
                    edge2.setId(value);
                    continue;
                }
                edge2.setProperty(name, value);
            }
            while (xmlEventReader.hasNext()) {
                XMLEvent event = xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    StartElement element = (StartElement)event;
                    String name = element.getName().getLocalPart();
                    if ("desc".equals(name)) {
                        String desc = (String)this.getParser(name).parse(xmlEventReader, element);
                        edge2.setDescription(desc);
                    } else if ("data".equals(name)) {
                        DataMetadata data = (DataMetadata)this.getParser(name).parse(xmlEventReader, element);
                        edge2.addData(data);
                    } else if ("endpoint".equals(name)) {
                        EndpointMetadata ep = (EndpointMetadata)this.getParser(name).parse(xmlEventReader, element);
                        edge2.addEndpoint(ep);
                    } else {
                        this.getUnknownParser().parse(xmlEventReader, element);
                    }
                }
                if (!event.isEndElement()) continue;
                EndElement end = (EndElement)event;
                this.verifyMatch(start, end);
                break;
            }
            this.applyKeys(edge2);
            return edge2;
        }
        catch (Exception e) {
            ExceptionConverter.convert(e);
            return null;
        }
    }
}

