/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml;

import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.GraphReader;
import edu.uci.ics.jung.io.graphml.EdgeMetadata;
import edu.uci.ics.jung.io.graphml.ExceptionConverter;
import edu.uci.ics.jung.io.graphml.GraphMLDocument;
import edu.uci.ics.jung.io.graphml.GraphMetadata;
import edu.uci.ics.jung.io.graphml.HyperEdgeMetadata;
import edu.uci.ics.jung.io.graphml.Key;
import edu.uci.ics.jung.io.graphml.NodeMetadata;
import edu.uci.ics.jung.io.graphml.parser.ElementParserRegistry;
import edu.uci.ics.jung.io.graphml.parser.GraphMLEventFilter;
import java.io.IOException;
import java.io.Reader;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.XMLInputFactory;
import javax.xml.stream.XMLStreamException;
import javax.xml.stream.events.StartElement;
import javax.xml.stream.events.XMLEvent;
import org.apache.commons.collections15.Transformer;

public class GraphMLReader2<G extends Hypergraph<V, E>, V, E>
implements GraphReader<G, V, E> {
    protected XMLEventReader xmlEventReader;
    protected Reader fileReader;
    protected Transformer<GraphMetadata, G> graphTransformer;
    protected Transformer<NodeMetadata, V> vertexTransformer;
    protected Transformer<EdgeMetadata, E> edgeTransformer;
    protected Transformer<HyperEdgeMetadata, E> hyperEdgeTransformer;
    protected boolean initialized;
    protected final GraphMLDocument document = new GraphMLDocument();
    protected final ElementParserRegistry<G, V, E> parserRegistry;

    public GraphMLReader2(Reader fileReader, Transformer<GraphMetadata, G> graphTransformer, Transformer<NodeMetadata, V> vertexTransformer, Transformer<EdgeMetadata, E> edgeTransformer, Transformer<HyperEdgeMetadata, E> hyperEdgeTransformer) {
        if (fileReader == null) {
            throw new IllegalArgumentException("Argument fileReader must be non-null");
        }
        if (graphTransformer == null) {
            throw new IllegalArgumentException("Argument graphTransformer must be non-null");
        }
        if (vertexTransformer == null) {
            throw new IllegalArgumentException("Argument vertexTransformer must be non-null");
        }
        if (edgeTransformer == null) {
            throw new IllegalArgumentException("Argument edgeTransformer must be non-null");
        }
        if (hyperEdgeTransformer == null) {
            throw new IllegalArgumentException("Argument hyperEdgeTransformer must be non-null");
        }
        this.fileReader = fileReader;
        this.graphTransformer = graphTransformer;
        this.vertexTransformer = vertexTransformer;
        this.edgeTransformer = edgeTransformer;
        this.hyperEdgeTransformer = hyperEdgeTransformer;
        this.parserRegistry = new ElementParserRegistry<G, V, E>(this.document.getKeyMap(), graphTransformer, vertexTransformer, edgeTransformer, hyperEdgeTransformer);
    }

    public Transformer<GraphMetadata, G> getGraphTransformer() {
        return this.graphTransformer;
    }

    public Transformer<NodeMetadata, V> getVertexTransformer() {
        return this.vertexTransformer;
    }

    public Transformer<EdgeMetadata, E> getEdgeTransformer() {
        return this.edgeTransformer;
    }

    public Transformer<HyperEdgeMetadata, E> getHyperEdgeTransformer() {
        return this.hyperEdgeTransformer;
    }

    public void init() throws GraphIOException {
        try {
            if (!this.initialized) {
                XMLInputFactory factory = XMLInputFactory.newInstance();
                this.xmlEventReader = factory.createXMLEventReader(this.fileReader);
                this.xmlEventReader = factory.createFilteredReader(this.xmlEventReader, new GraphMLEventFilter());
                this.initialized = true;
            }
        }
        catch (Exception e) {
            ExceptionConverter.convert(e);
        }
    }

    @Override
    public void close() throws GraphIOException {
        try {
            try {
                this.document.clear();
                if (this.xmlEventReader != null) {
                    this.xmlEventReader.close();
                }
                if (this.fileReader != null) {
                    this.fileReader.close();
                }
            }
            catch (IOException e) {
                throw new GraphIOException(e);
            }
            catch (XMLStreamException e) {
                throw new GraphIOException(e);
            }
        }
        finally {
            this.fileReader = null;
            this.xmlEventReader = null;
            this.graphTransformer = null;
            this.vertexTransformer = null;
            this.edgeTransformer = null;
            this.hyperEdgeTransformer = null;
        }
    }

    public GraphMLDocument getGraphMLDocument() {
        return this.document;
    }

    @Override
    public G readGraph() throws GraphIOException {
        try {
            this.init();
            while (this.xmlEventReader.hasNext()) {
                XMLEvent event = this.xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    StartElement element = (StartElement)event;
                    String name = element.getName().getLocalPart();
                    if ("key".equals(name)) {
                        Key key = (Key)this.parserRegistry.getParser(name).parse(this.xmlEventReader, element);
                        this.document.getKeyMap().addKey(key);
                        continue;
                    }
                    if ("graph".equals(name)) {
                        GraphMetadata graph = (GraphMetadata)this.parserRegistry.getParser(name).parse(this.xmlEventReader, element);
                        this.document.getGraphMetadata().add(graph);
                        return (G)((Hypergraph)graph.getGraph());
                    }
                    if ("graphml".equals(name)) continue;
                    this.parserRegistry.getUnknownElementParser().parse(this.xmlEventReader, element);
                    continue;
                }
                if (!event.isEndDocument()) {
                    continue;
                }
                break;
            }
        }
        catch (Exception e) {
            ExceptionConverter.convert(e);
        }
        throw new GraphIOException("Unable to read Graph from document - the document could be empty");
    }
}

