/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.awt.geom.Point2D;
import java.io.BufferedWriter;
import java.io.FileWriter;
import java.io.IOException;
import java.io.Writer;
import java.util.ArrayList;
import java.util.HashSet;
import java.util.Iterator;
import java.util.TreeSet;
import org.apache.commons.collections15.Transformer;

public class PajekNetWriter<V, E> {
    private TreeSet<V> labels = new TreeSet();

    public void save(Graph<V, E> g, String filename, Transformer<V, String> vs, Transformer<E, Number> nev, Transformer<V, Point2D> vld) throws IOException {
        this.save(g, new FileWriter(filename), vs, nev, vld);
    }

    public void save(Graph<V, E> g, String filename, Transformer<V, String> vs, Transformer<E, Number> nev) throws IOException {
        this.save(g, new FileWriter(filename), vs, nev, null);
    }

    public void save(Graph<V, E> g, String filename) throws IOException {
        this.save(g, filename, null, null, null);
    }

    public void save(Graph<V, E> g, Writer w) throws IOException {
        this.save(g, w, null, null, null);
    }

    public void save(Graph<V, E> g, Writer w, Transformer<V, String> vs, Transformer<E, Number> nev) throws IOException {
        this.save(g, w, vs, nev, null);
    }

    public void setLabels(TreeSet<V> labls) {
        this.labels = labls;
    }

    public void save(Graph<V, E> graph, Writer w, Transformer<V, String> vs, Transformer<E, Number> nev, Transformer<V, Point2D> vld) throws IOException {
        BufferedWriter writer = new BufferedWriter(w);
        if (nev == null) {
            nev = new Transformer<E, Number>(){

                @Override
                public Number transform(E e) {
                    return 1;
                }
            };
        }
        writer.write("*Vertices " + graph.getVertexCount());
        writer.newLine();
        Iterator<V> itLabels = null;
        if (this.labels != null && this.labels.size() > 0) {
            itLabels = this.labels.iterator();
        }
        ArrayList id = new ArrayList(graph.getVertices());
        for (Object currentVertex : graph.getVertices()) {
            Point2D location;
            String label;
            int v_id = id.indexOf(currentVertex) + 1;
            writer.write("" + v_id);
            if (itLabels != null && itLabels.hasNext()) {
                label = itLabels.next().toString();
                if (label != null) {
                    writer.write(" \"" + label + "\"");
                }
            } else if (vs != null && (label = vs.transform(currentVertex)) != null) {
                writer.write(" \"" + label + "\"");
            }
            if (vld != null && (location = vld.transform(currentVertex)) != null) {
                writer.write(" " + location.getX() + " " + location.getY() + " 0.0");
            }
            writer.newLine();
        }
        HashSet d_set = new HashSet();
        HashSet u_set = new HashSet();
        boolean directed = graph instanceof DirectedGraph;
        boolean undirected = graph instanceof UndirectedGraph;
        if (directed) {
            d_set.addAll(graph.getEdges());
        }
        if (undirected) {
            u_set.addAll(graph.getEdges());
        }
        if (!directed && !undirected) {
            u_set.addAll(graph.getEdges());
            d_set.addAll(graph.getEdges());
            for (Object e : graph.getEdges()) {
                if (graph.getEdgeType(e) == EdgeType.UNDIRECTED) {
                    d_set.remove(e);
                    continue;
                }
                u_set.remove(e);
            }
        }
        if (!d_set.isEmpty()) {
            writer.write("*Arcs");
            writer.newLine();
        }
        for (Object e : d_set) {
            int source_id = id.indexOf(graph.getEndpoints(e).getFirst()) + 1;
            int target_id = id.indexOf(graph.getEndpoints(e).getSecond()) + 1;
            float weight = ((Number)nev.transform(e)).floatValue();
            writer.write(String.valueOf(source_id) + " " + target_id + " " + weight);
            writer.newLine();
        }
        if (!u_set.isEmpty()) {
            writer.write("*Edges");
            writer.newLine();
        }
        for (Object e : u_set) {
            Pair<V> endpoints = graph.getEndpoints(e);
            int v1_id = id.indexOf(endpoints.getFirst()) + 1;
            int v2_id = id.indexOf(endpoints.getSecond()) + 1;
            float weight = ((Number)nev.transform(e)).floatValue();
            writer.write(String.valueOf(v1_id) + " " + v2_id + " " + weight);
            writer.newLine();
        }
        writer.close();
    }
}

