/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph.util;

import edu.uci.ics.jung.graph.AbstractTypedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.UndirectedSparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.HashSet;
import mecosim.plugins.graphsPlugin.VertexFactory;
import mecosim.plugins.graphsPlugin.edge;
import mecosim.plugins.graphsPlugin.node;

public class TestGraphs {
    public static String[][] pairs = new String[][]{{"a", "b", "3"}, {"a", "c", "4"}, {"a", "d", "5"}, {"d", "c", "6"}, {"d", "e", "7"}, {"e", "f", "8"}, {"f", "g", "9"}, {"h", "i", "1"}};
    public static String[][] pairsEdges = new String[][]{{"a", "b", "3"}, {"a", "c", "4"}, {"a", "d", "5"}, {"d", "c", "6"}, {"d", "e", "7"}, {"e", "f", "8"}, {"f", "g", "9"}, {"h", "i", "1"}};

    public static Graph<String, Number> createTestGraph(boolean directed) {
        AbstractTypedGraph graph = null;
        graph = directed ? new DirectedSparseMultigraph() : new UndirectedSparseMultigraph();
        int i = 0;
        while (i < pairs.length) {
            String[] pair = pairs[i];
            graph.addEdge((Number)Integer.parseInt(pair[2]), (String)pair[0], (String)pair[1]);
            ++i;
        }
        return graph;
    }

    public static Graph<node, edge> createTestGraphML(boolean directed) {
        AbstractTypedGraph graph = null;
        graph = directed ? new DirectedSparseMultigraph() : new UndirectedSparseMultigraph();
        HashMap<String, node> nodes = new HashMap<String, node>();
        VertexFactory vf = new VertexFactory();
        int i = 0;
        while (i < pairs.length) {
            String s2;
            node n2;
            String[] pair = pairs[i];
            String s1 = pair[0];
            node n1 = (node)nodes.get(s1);
            if (n1 == null) {
                n1 = vf.create();
                n1.setValue(s1);
                n1.setWeight(String.valueOf(i * 2));
                if (i % 2 == 0) {
                    n1.setColor("green");
                } else {
                    n1.setColor("red");
                }
                nodes.put(s1, n1);
            }
            if ((n2 = (node)nodes.get(s2 = pair[1])) == null) {
                n2 = vf.create();
                n2.setValue(s2);
                n2.setWeight(String.valueOf(i * 3));
                if (n1.getColor() == "green") {
                    n2.setColor("red");
                } else {
                    n2.setColor("green");
                }
                nodes.put(s2, n2);
            }
            edge e = new edge(Integer.parseInt(pair[2]));
            e.setValue("e" + e.getID());
            graph.addEdge((edge)e, (node)((node)nodes.get(s1)), (node)((node)nodes.get(s2)));
            ++i;
        }
        return graph;
    }

    public static Graph<String, Number> createChainPlusIsolates(int chain_length, int isolate_count) {
        UndirectedSparseMultigraph<String, Number> g = new UndirectedSparseMultigraph<String, Number>();
        if (chain_length > 0) {
            String[] v = new String[chain_length];
            v[0] = "v0";
            g.addVertex(v[0]);
            int i = 1;
            while (i < chain_length) {
                v[i] = "v" + i;
                g.addVertex(v[i]);
                g.addEdge((Number)new Double(Math.random()), v[i], v[i - 1]);
                ++i;
            }
        }
        int i = 0;
        while (i < isolate_count) {
            String v = "v" + (chain_length + i);
            g.addVertex(v);
            ++i;
        }
        return g;
    }

    public static Graph<String, Number> createDirectedAcyclicGraph(int layers, int maxNodesPerLayer, double linkprob) {
        DirectedSparseMultigraph<String, Number> dag = new DirectedSparseMultigraph<String, Number>();
        HashSet previousLayers = new HashSet();
        HashSet<String> inThisLayer = new HashSet<String>();
        int i = 0;
        while (i < layers) {
            int nodesThisLayer = (int)(Math.random() * (double)maxNodesPerLayer) + 1;
            int j = 0;
            while (j < nodesThisLayer) {
                String v = String.valueOf(i) + ":" + j;
                dag.addVertex(v);
                inThisLayer.add(v);
                for (String v2 : previousLayers) {
                    if (!(Math.random() < linkprob)) continue;
                    Double de = new Double(Math.random());
                    dag.addEdge((Number)de, v, v2);
                }
                ++j;
            }
            previousLayers.addAll(inThisLayer);
            inThisLayer.clear();
            ++i;
        }
        return dag;
    }

    private static void createEdge(Graph<String, Number> g, String v1Label, String v2Label, int weight) {
        g.addEdge((Number)new Double(Math.random()), v1Label, v2Label);
    }

    public static Graph<String, Number> getOneComponentGraph() {
        String i2;
        String i1;
        int j;
        UndirectedSparseMultigraph<String, Number> g = new UndirectedSparseMultigraph<String, Number>();
        int i = 1;
        while (i <= 10) {
            j = i + 1;
            while (j <= 10) {
                i1 = "" + i;
                i2 = "" + j;
                g.addEdge((Number)Math.pow(i + 2, j), i1, i2);
                ++j;
            }
            ++i;
        }
        i = 11;
        while (i <= 20) {
            j = i + 1;
            while (j <= 20) {
                if (!(Math.random() > 0.6)) {
                    i1 = "" + i;
                    i2 = "" + j;
                    g.addEdge((Number)Math.pow(i + 2, j), i1, i2);
                }
                ++j;
            }
            ++i;
        }
        ArrayList index = new ArrayList();
        index.addAll(g.getVertices());
        int i3 = 0;
        while (i3 < index.size() - 1) {
            g.addEdge((Number)new Integer(i3), (String)index.get(i3), (String)index.get(i3 + 1));
            ++i3;
        }
        return g;
    }

    public static Graph<String, Number> getDemoGraph() {
        String i2;
        String i1;
        UndirectedSparseMultigraph<String, Number> g = new UndirectedSparseMultigraph<String, Number>();
        int i = 0;
        while (i < pairs.length) {
            String[] pair = pairs[i];
            TestGraphs.createEdge(g, pair[0], pair[1], Integer.parseInt(pair[2]));
            ++i;
        }
        i = 1;
        while (i <= 10) {
            int j = i + 1;
            while (j <= 10) {
                i1 = "c" + i;
                i2 = "c" + j;
                g.addEdge((Number)Math.pow(i + 2, j), i1, i2);
                ++j;
            }
            ++i;
        }
        i = 11;
        while (i <= 20) {
            int j = i + 1;
            while (j <= 20) {
                if (!(Math.random() > 0.6)) {
                    i1 = "p" + i;
                    i2 = "p" + j;
                    g.addEdge((Number)Math.pow(i + 2, j), i1, i2);
                }
                ++j;
            }
            ++i;
        }
        return g;
    }

    public static Graph<String, Number> getSmallGraph() {
        SparseMultigraph<String, Number> graph = new SparseMultigraph<String, Number>();
        String[] v = new String[3];
        int i = 0;
        while (i < 3) {
            v[i] = String.valueOf(i);
            graph.addVertex(v[i]);
            ++i;
        }
        graph.addEdge(new Double(0.0), v[0], v[1], EdgeType.DIRECTED);
        graph.addEdge(new Double(0.1), v[0], v[1], EdgeType.DIRECTED);
        graph.addEdge(new Double(0.2), v[0], v[1], EdgeType.DIRECTED);
        graph.addEdge(new Double(0.3), v[1], v[0], EdgeType.DIRECTED);
        graph.addEdge(new Double(0.4), v[1], v[0], EdgeType.DIRECTED);
        graph.addEdge(new Double(0.5), v[1], v[2]);
        graph.addEdge(new Double(0.6), v[1], v[2]);
        return graph;
    }
}

