/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.MultiGraph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.apache.commons.collections15.Factory;

public class DirectedOrderedSparseMultigraph<V, E>
extends DirectedSparseMultigraph<V, E>
implements DirectedGraph<V, E>,
MultiGraph<V, E> {
    public static <V, E> Factory<DirectedGraph<V, E>> getFactory() {
        return new Factory<DirectedGraph<V, E>>(){

            @Override
            public DirectedGraph<V, E> create() {
                return new DirectedOrderedSparseMultigraph();
            }
        };
    }

    public DirectedOrderedSparseMultigraph() {
        this.vertices = new LinkedHashMap();
        this.edges = new LinkedHashMap();
    }

    @Override
    public boolean addVertex(V vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex may not be null");
        }
        if (!this.containsVertex(vertex)) {
            this.vertices.put(vertex, new Pair(new LinkedHashSet(), new LinkedHashSet()));
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> getPredecessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        LinkedHashSet preds = new LinkedHashSet();
        for (Object edge2 : this.getIncoming_internal(vertex)) {
            preds.add(this.getSource(edge2));
        }
        return Collections.unmodifiableCollection(preds);
    }

    @Override
    public Collection<V> getSuccessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        LinkedHashSet succs = new LinkedHashSet();
        for (Object edge2 : this.getOutgoing_internal(vertex)) {
            succs.add(this.getDest(edge2));
        }
        return Collections.unmodifiableCollection(succs);
    }

    @Override
    public Collection<V> getNeighbors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        LinkedHashSet neighbors = new LinkedHashSet();
        for (Object edge2 : this.getIncoming_internal(vertex)) {
            neighbors.add(this.getSource(edge2));
        }
        for (Object edge2 : this.getOutgoing_internal(vertex)) {
            neighbors.add(this.getDest(edge2));
        }
        return Collections.unmodifiableCollection(neighbors);
    }

    @Override
    public Collection<E> getIncidentEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        LinkedHashSet incident = new LinkedHashSet();
        incident.addAll(this.getIncoming_internal(vertex));
        incident.addAll(this.getOutgoing_internal(vertex));
        return incident;
    }
}

