/*
 * Decompiled with CFR 0.152.
 */
package GraphMLTest;

import edu.uci.ics.jung.graph.DelegateForest;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import mecosim.plugins.graphsPlugin.edge;
import mecosim.plugins.graphsPlugin.node;

public class TreeBuilder {
    DelegateForest<node, edge> mTree = new DelegateForest();

    TreeBuilder(Graph<node, edge> graph) {
        for (node n : graph.getVertices()) {
            this.mTree.addVertex(n);
        }
        for (edge e : graph.getEdges()) {
            if (graph instanceof DirectedGraph) {
                if (graph.getSource(e) == null || graph.getDest(e) == null) continue;
                this.mTree.addEdge(e, graph.getSource(e), graph.getDest(e));
                continue;
            }
            Pair<node> edges = graph.getEndpoints(e);
            this.mTree.addEdge(e, edges.getFirst(), edges.getSecond());
        }
    }

    public DelegateForest<node, edge> getTree() {
        return this.mTree;
    }
}

