/*
 * Decompiled with CFR 0.152.
 */
package mecosim.plugins.graphsPlugin;

import ecoSim.IMeCoSimConfig;
import java.awt.BorderLayout;
import java.awt.Component;
import java.awt.Dimension;
import java.awt.FlowLayout;
import java.awt.GridLayout;
import java.awt.event.ActionEvent;
import java.awt.event.ActionListener;
import java.util.Iterator;
import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import javax.swing.JButton;
import javax.swing.JCheckBox;
import javax.swing.JComboBox;
import javax.swing.JFrame;
import javax.swing.JLabel;
import javax.swing.JPanel;
import javax.swing.JScrollPane;
import javax.swing.JTree;
import javax.swing.SwingUtilities;
import javax.swing.event.TreeExpansionEvent;
import javax.swing.event.TreeExpansionListener;
import javax.swing.event.TreeSelectionEvent;
import javax.swing.event.TreeSelectionListener;
import javax.swing.tree.DefaultMutableTreeNode;
import javax.swing.tree.DefaultTreeModel;
import mecosim.plugins.graphsPlugin.GraphViewer;
import mecosim.plugins.graphsPlugin.Tree;

public class SelectParamsJFrame
extends JFrame {
    private static final long serialVersionUID = 1L;
    private JTree[] viewerJTree = new JTree[5];
    private JPanel mainPanel;
    private JPanel innerPanel;
    private JPanel[] partialPanel = new JPanel[5];
    private JPanel variablePanel;
    private JScrollPane[] viewerJSPane = new JScrollPane[5];
    private Tree[] innerTree = new Tree[5];
    Tree t;
    Tree tText;
    private String name;
    private static final String PREFERRED_LOOK_AND_FEEL = "com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel";
    private IMeCoSimConfig config;
    private JButton showGraphButton;
    private JButton cancelButton;
    private JCheckBox extractNodeCheck;
    private boolean defaultIsTreeValue = false;
    private boolean defaultIsBicolorTreeValue = true;
    private JCheckBox isTreeCheck;
    private JCheckBox isBicolorTreeCheck;
    private JComboBox graphTypeCombo;
    private String[] selectedParams = new String[]{"n", "ne", "e", "versInfo", "versAttr"};
    private String defaultEdges = "e";
    private String defaultTextEdges = "ed";
    private String[] titles = new String[5];
    private String mode;
    private String[] graphTypesText = new String[]{"Generate numeric graph from vertices number and list of edges", "Generate numeric graph from list of edges", "Generate text graph from list of edges", "Generate tree of graphs"};
    private String[] graphTypes = new String[]{"numver", "numedg", "texedg", "treeofgraphs"};

    public SelectParamsJFrame() {
        this.setTitle("Params");
        int i = 0;
        while (i < 3) {
            this.innerTree[i] = new Tree<String>("Void tree");
            ++i;
        }
        this.initComponents();
        this.name = "Tree Testing";
    }

    public SelectParamsJFrame(Tree<String> t, String name, IMeCoSimConfig config, Tree<String> tText, boolean defaultIsTreeValue, boolean defaultIsBicolorTreeValue) {
        int i = 0;
        while (i < 3) {
            this.innerTree[i] = t;
            ++i;
        }
        i = 3;
        while (i < 5) {
            this.innerTree[i] = tText;
            ++i;
        }
        this.titles[0] = "<html>Vertices number<p>(default: " + this.selectedParams[0] + ")";
        this.titles[1] = "<html>Edges number<p>(default: " + this.selectedParams[1] + ")";
        this.titles[2] = "<html>Edges list<p>(default: " + this.selectedParams[2] + ")";
        this.titles[3] = "<html>Vertex info<p>(default: " + this.selectedParams[3] + ")";
        this.titles[4] = "<html>Vertex attributes<p>(default: " + this.selectedParams[4] + ")";
        this.name = name;
        this.config = config;
        this.mode = this.mode;
        this.defaultIsTreeValue = defaultIsTreeValue;
        this.defaultIsBicolorTreeValue = defaultIsBicolorTreeValue;
        this.t = t;
        this.tText = tText;
        this.initComponents();
    }

    private void initComponents() {
        this.getContentPane().setLayout(new BorderLayout(10, 10));
        this.getContentPane().add((Component)this.getMainPanel(), "Center");
        JPanel panelWest = new JPanel();
        this.getContentPane().add((Component)panelWest, "West");
        JPanel panelNorth = new JPanel();
        this.getContentPane().add((Component)panelNorth, "North");
        JPanel panelSouth = new JPanel();
        this.getContentPane().add((Component)panelSouth, "South");
        JPanel panelEast = new JPanel();
        this.getContentPane().add((Component)panelEast, "East");
    }

    private JPanel getMainPanel() {
        if (this.mainPanel == null) {
            this.mainPanel = new JPanel();
            this.mainPanel.setLayout(new BorderLayout(5, 5));
            this.mainPanel.add((Component)this.getInnerPanel(), "Center");
            this.mainPanel.add((Component)this.getShowGraphButton(), "South");
        }
        return this.mainPanel;
    }

    private JPanel getInnerPanel() {
        if (this.innerPanel == null) {
            this.innerPanel = new JPanel();
            this.innerPanel.setLayout(new GridLayout(1, 5));
            int i = 1;
            while (i < 3) {
                this.innerPanel.add(this.getPartialPanel(i - 1, false));
                ++i;
            }
            this.variablePanel = new JPanel(new GridLayout(1, 1));
            this.variablePanel.add(this.getPartialPanel(2, false));
            this.innerPanel.add(this.variablePanel);
            i = 4;
            while (i < 6) {
                this.innerPanel.add(this.getPartialPanel(i - 1, false));
                ++i;
            }
        }
        return this.innerPanel;
    }

    private JPanel getPartialPanel(int i, boolean forceRecalc) {
        if (this.partialPanel[i] == null || forceRecalc) {
            this.partialPanel[i] = new JPanel();
            this.partialPanel[i].setLayout(new BorderLayout(5, 5));
            this.partialPanel[i].add((Component)new JLabel(this.titles[i]), "North");
            this.partialPanel[i].add((Component)this.getViewerJSPane(i, forceRecalc), "Center");
        }
        return this.partialPanel[i];
    }

    private JScrollPane getViewerJSPane(int i, boolean forceRecalc) {
        if (this.viewerJSPane[i] == null || forceRecalc) {
            this.viewerJSPane[i] = new JScrollPane();
            this.viewerJSPane[i].setViewportView(this.getJTree(i, forceRecalc));
        }
        return this.viewerJSPane[i];
    }

    private JTree getJTree(final int i, boolean forceRecalc) {
        if (this.viewerJTree[i] == null || forceRecalc) {
            this.viewerJTree[i] = new JTree();
            this.viewerJTree[i].addTreeExpansionListener(new TreeExpansionListener(){

                @Override
                public void treeCollapsed(TreeExpansionEvent arg0) {
                }

                @Override
                public void treeExpanded(TreeExpansionEvent arg0) {
                }
            });
            this.viewerJTree[i].addTreeSelectionListener(new TreeSelectionListener(){

                @Override
                public void valueChanged(TreeSelectionEvent arg0) {
                    DefaultMutableTreeNode node2 = (DefaultMutableTreeNode)SelectParamsJFrame.this.viewerJTree[i].getLastSelectedPathComponent();
                    if (node2 == null) {
                        return;
                    }
                    Object nodeInfo = node2.getUserObject();
                    if (!node2.isLeaf() && !node2.isRoot()) {
                        ((SelectParamsJFrame)SelectParamsJFrame.this).selectedParams[i] = nodeInfo.toString();
                    }
                }
            });
            DefaultTreeModel treeModel = this.generateTree(this.innerTree[i]);
            this.viewerJTree[i].setModel(treeModel);
        }
        return this.viewerJTree[i];
    }

    private DefaultTreeModel generateTree(Tree<String> mainTree) {
        DefaultMutableTreeNode initialNode = this.generateSubtree(mainTree);
        DefaultTreeModel treeModel = new DefaultTreeModel(initialNode);
        return treeModel;
    }

    private DefaultMutableTreeNode generateSubtree(Tree<String> rootedTree) {
        DefaultMutableTreeNode node0 = new DefaultMutableTreeNode(rootedTree.getValue());
        for (Tree<String> t : rootedTree.getChildren()) {
            node0.add(this.generateSubtree(t));
        }
        return node0;
    }

    private JPanel getShowGraphButton() {
        JPanel pane = new JPanel(new BorderLayout(0, 0));
        JPanel options = new JPanel(new GridLayout(3, 1));
        JPanel opt2 = new JPanel(new FlowLayout(0));
        opt2.add(this.getCombo());
        options.add(opt2);
        JPanel opt3 = new JPanel(new FlowLayout(0));
        opt3.add(this.getExtractNodeCheck());
        options.add(opt3);
        JPanel opt4 = new JPanel(new FlowLayout(0));
        opt4.add(this.getIsTreeCheck());
        opt4.add(this.getIsBicolorTreeCheck());
        options.add(opt4);
        pane.add((Component)options, "West");
        pane.add((Component)new JPanel(), "Center");
        JPanel bPn = new JPanel(new FlowLayout(2));
        bPn.add(this.getRunButton(this));
        bPn.add(this.getCancelButton(this));
        pane.add((Component)bPn, "South");
        return pane;
    }

    private JComboBox getCombo() {
        if (this.graphTypeCombo == null) {
            this.graphTypeCombo = new JComboBox<String>(this.graphTypesText);
            this.graphTypeCombo.setSelectedIndex(0);
            this.graphTypeCombo.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    boolean changePanel = false;
                    if (SelectParamsJFrame.this.graphTypeCombo.getSelectedIndex() == 2) {
                        if (!SelectParamsJFrame.this.selectedParams[2].equals(SelectParamsJFrame.this.defaultTextEdges)) {
                            ((SelectParamsJFrame)SelectParamsJFrame.this).selectedParams[2] = SelectParamsJFrame.this.defaultTextEdges;
                            ((SelectParamsJFrame)SelectParamsJFrame.this).innerTree[2] = SelectParamsJFrame.this.tText;
                            changePanel = true;
                        }
                    } else if (!SelectParamsJFrame.this.selectedParams[2].equals(SelectParamsJFrame.this.defaultEdges)) {
                        ((SelectParamsJFrame)SelectParamsJFrame.this).selectedParams[2] = SelectParamsJFrame.this.defaultEdges;
                        ((SelectParamsJFrame)SelectParamsJFrame.this).innerTree[2] = SelectParamsJFrame.this.t;
                        changePanel = true;
                    }
                    if (changePanel) {
                        ((SelectParamsJFrame)SelectParamsJFrame.this).titles[2] = "<html>Edges list<p>(default: " + SelectParamsJFrame.this.selectedParams[2] + ")";
                        SelectParamsJFrame.this.variablePanel.removeAll();
                        SelectParamsJFrame.this.variablePanel.add(SelectParamsJFrame.this.getPartialPanel(2, true));
                        SelectParamsJFrame.this.variablePanel.repaint();
                        SelectParamsJFrame.this.variablePanel.revalidate();
                    }
                }
            });
        }
        return this.graphTypeCombo;
    }

    private JCheckBox getExtractNodeCheck() {
        if (this.extractNodeCheck == null) {
            this.extractNodeCheck = new JCheckBox("Extract node (that is, replace nodes like R{i} for i).");
            this.extractNodeCheck.setSelected(true);
        }
        return this.extractNodeCheck;
    }

    private JCheckBox getIsTreeCheck() {
        if (this.isTreeCheck == null) {
            this.isTreeCheck = new JCheckBox("Is the graph a tree?");
            this.isTreeCheck.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    if (SelectParamsJFrame.this.isTreeCheck.isSelected()) {
                        SelectParamsJFrame.this.isBicolorTreeCheck.setEnabled(true);
                    } else {
                        SelectParamsJFrame.this.isBicolorTreeCheck.setEnabled(false);
                    }
                }
            });
            this.isTreeCheck.setSelected(this.defaultIsTreeValue);
        }
        return this.isTreeCheck;
    }

    private JCheckBox getIsBicolorTreeCheck() {
        if (this.isBicolorTreeCheck == null) {
            this.isBicolorTreeCheck = new JCheckBox("Bicolor tree?");
            this.isBicolorTreeCheck.setSelected(this.defaultIsBicolorTreeValue);
            if (this.isTreeCheck.isSelected()) {
                this.isBicolorTreeCheck.setEnabled(true);
            } else {
                this.isBicolorTreeCheck.setEnabled(false);
            }
        }
        return this.isBicolorTreeCheck;
    }

    private JButton getRunButton(final SelectParamsJFrame frame) {
        if (this.showGraphButton == null) {
            this.showGraphButton = new JButton("Show Graph");
            this.showGraphButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    frame.setAlwaysOnTop(false);
                    GraphViewer.runGraphFunction(SelectParamsJFrame.this.graphTypes[SelectParamsJFrame.this.graphTypeCombo.getSelectedIndex()], SelectParamsJFrame.this.selectedParams[0], SelectParamsJFrame.this.selectedParams[1], SelectParamsJFrame.this.selectedParams[2], SelectParamsJFrame.this.selectedParams[3], SelectParamsJFrame.this.selectedParams[4], SelectParamsJFrame.this.extractNodeCheck.isSelected(), SelectParamsJFrame.this.isTreeCheck.isSelected(), SelectParamsJFrame.this.isBicolorTreeCheck.isSelected());
                }
            });
        }
        return this.showGraphButton;
    }

    private JButton getCancelButton(final SelectParamsJFrame frame) {
        if (this.cancelButton == null) {
            this.cancelButton = new JButton("Cancel");
            this.cancelButton.addActionListener(new ActionListener(){

                @Override
                public void actionPerformed(ActionEvent arg0) {
                    frame.setAlwaysOnTop(false);
                    frame.dispose();
                }
            });
        }
        return this.cancelButton;
    }

    public void visualizeTree(String[] args) {
        this.setDefaultCloseOperation(2);
        this.setTitle(this.name);
        this.getContentPane().setPreferredSize(new Dimension(800, 400));
        this.setSize(new Dimension(800, 400));
        this.setLocationRelativeTo(null);
        this.setAlwaysOnTop(true);
        this.setVisible(true);
    }

    private static void installLnF() {
        try {
            JFrame.setDefaultLookAndFeelDecorated(true);
        }
        catch (Exception e) {
            System.err.println("Cannot install com.sun.java.swing.plaf.nimbus.NimbusLookAndFeel on this platform:" + e.getMessage());
        }
    }

    public static void main(String[] args) {
        SwingUtilities.invokeLater(new Runnable(){

            @Override
            public void run() {
                SelectParamsJFrame.installLnF();
                SelectParamsJFrame frame = new SelectParamsJFrame();
                frame.setDefaultCloseOperation(3);
                frame.setTitle("SwingTest");
                frame.getContentPane().setPreferredSize(frame.getSize());
                frame.pack();
                frame.setAlwaysOnTop(true);
                frame.setLocationRelativeTo(null);
                frame.setVisible(true);
            }
        });
    }

    public static void chooseParams(IMeCoSimConfig config, boolean defaultIsTreeValue, boolean defaultIsBicolorTreeValue) {
        if (config != null) {
            Map<String, Number> pars = config.getParameters();
            TreeMap params = new TreeMap();
            for (Map.Entry<String, Number> e : pars.entrySet()) {
                String key = e.getKey();
                String parName = key.split("\\{")[0];
                String desc = String.valueOf(key) + ": " + e.getValue();
                if (params.containsKey(parName)) {
                    ((TreeSet)params.get(parName)).add(desc);
                    continue;
                }
                TreeSet<Object> treeSet = new TreeSet<Object>();
                treeSet.add(desc);
                params.put(parName, treeSet);
            }
            String title = "Params";
            Tree<String> t = new Tree<String>(title);
            Set keys = params.keySet();
            for (String k : keys) {
                Tree<String> tree = new Tree<String>(k);
                TreeSet tC = (TreeSet)params.get(k);
                Iterator<Object> iterator = tC.iterator();
                while (iterator.hasNext()) {
                    String child = (String)iterator.next();
                    tree.addChild(new Tree<String>(child.toString()));
                }
                t.addChild(tree);
            }
            Map<String, String> textPars = config.getTextParameters();
            TreeMap textParams = new TreeMap();
            for (Map.Entry entry : textPars.entrySet()) {
                String key = (String)entry.getKey();
                String parName = key.split("\\{")[0];
                String desc = String.valueOf(key) + ": " + (String)entry.getValue();
                if (textParams.containsKey(parName)) {
                    ((TreeSet)textParams.get(parName)).add(desc);
                    continue;
                }
                TreeSet<String> nt = new TreeSet<String>();
                nt.add(desc);
                textParams.put(parName, nt);
            }
            title = "Text params";
            Tree<String> tree = new Tree<String>(title);
            Set keysText = textParams.keySet();
            for (String k : keysText) {
                Tree<String> tP = new Tree<String>(k);
                TreeSet tC = (TreeSet)textParams.get(k);
                for (String child : tC) {
                    tP.addChild(new Tree<String>(child.toString()));
                }
                tree.addChild(tP);
            }
            title = "Choose parameters for generating graph";
            SelectParamsJFrame tv = new SelectParamsJFrame(t, title, config, tree, defaultIsTreeValue, defaultIsBicolorTreeValue);
            tv.visualizeTree(null);
        }
    }
}

