/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization.subLayout;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.graph.util.TreeUtils;
import java.awt.geom.Point2D;

public class TreeCollapser {
    public void collapse(Layout layout, Forest tree, Object subRoot) throws InstantiationException, IllegalAccessException {
        Tree subTree = TreeUtils.getSubTree(tree, subRoot);
        Object parent = null;
        Object edge2 = null;
        if (tree.getPredecessorCount(subRoot) > 0) {
            parent = tree.getPredecessors(subRoot).iterator().next();
            edge2 = tree.getInEdges(subRoot).iterator().next();
        }
        tree.removeVertex(subRoot);
        if (parent != null) {
            tree.addEdge(edge2, parent, subTree);
        } else {
            tree.addVertex(subTree);
        }
        layout.setLocation(subTree, (Point2D)layout.transform(subRoot));
    }

    public void expand(Forest tree, Forest subTree) {
        Forest parent = null;
        Object edge2 = null;
        if (tree.getPredecessorCount(subTree) > 0) {
            parent = tree.getPredecessors(subTree).iterator().next();
            edge2 = tree.getInEdges(subTree).iterator().next();
        }
        tree.removeVertex(subTree);
        TreeUtils.addSubTree(tree, subTree, parent, edge2);
    }
}

