/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.visualization;

import edu.uci.ics.jung.algorithms.layout.Layout;
import edu.uci.ics.jung.visualization.BasicVisualizationServer;
import edu.uci.ics.jung.visualization.DefaultVisualizationModel;
import edu.uci.ics.jung.visualization.Layer;
import edu.uci.ics.jung.visualization.VisualizationModel;
import edu.uci.ics.jung.visualization.control.GraphMouseListener;
import edu.uci.ics.jung.visualization.control.MouseListenerTranslator;
import java.awt.Dimension;
import java.awt.event.KeyListener;
import java.awt.event.MouseAdapter;
import java.awt.event.MouseEvent;
import java.awt.event.MouseListener;
import java.awt.event.MouseMotionListener;
import java.awt.event.MouseWheelListener;
import java.awt.geom.Point2D;
import javax.swing.ToolTipManager;
import org.apache.commons.collections15.Transformer;

public class VisualizationViewer<V, E>
extends BasicVisualizationServer<V, E> {
    protected Transformer<V, String> vertexToolTipTransformer;
    protected Transformer<E, String> edgeToolTipTransformer;
    protected Transformer<MouseEvent, String> mouseEventToolTipTransformer;
    protected GraphMouse graphMouse;
    protected MouseListener requestFocusListener = new MouseAdapter(){

        @Override
        public void mouseClicked(MouseEvent e) {
            VisualizationViewer.this.requestFocusInWindow();
        }
    };

    public VisualizationViewer(Layout<V, E> layout) {
        this(new DefaultVisualizationModel<V, E>(layout));
    }

    public VisualizationViewer(Layout<V, E> layout, Dimension preferredSize) {
        this(new DefaultVisualizationModel<V, E>(layout, preferredSize), preferredSize);
    }

    public VisualizationViewer(VisualizationModel<V, E> model) {
        this(model, new Dimension(600, 600));
    }

    public VisualizationViewer(VisualizationModel<V, E> model, Dimension preferredSize) {
        super(model, preferredSize);
        this.setFocusable(true);
        this.addMouseListener(this.requestFocusListener);
    }

    public void setGraphMouse(GraphMouse graphMouse) {
        this.graphMouse = graphMouse;
        MouseListener[] ml = this.getMouseListeners();
        int i = 0;
        while (i < ml.length) {
            if (ml[i] instanceof GraphMouse) {
                this.removeMouseListener(ml[i]);
            }
            ++i;
        }
        MouseMotionListener[] mml = this.getMouseMotionListeners();
        int i2 = 0;
        while (i2 < mml.length) {
            if (mml[i2] instanceof GraphMouse) {
                this.removeMouseMotionListener(mml[i2]);
            }
            ++i2;
        }
        MouseWheelListener[] mwl = this.getMouseWheelListeners();
        int i3 = 0;
        while (i3 < mwl.length) {
            if (mwl[i3] instanceof GraphMouse) {
                this.removeMouseWheelListener(mwl[i3]);
            }
            ++i3;
        }
        this.addMouseListener(graphMouse);
        this.addMouseMotionListener(graphMouse);
        this.addMouseWheelListener(graphMouse);
    }

    public GraphMouse getGraphMouse() {
        return this.graphMouse;
    }

    public void addGraphMouseListener(GraphMouseListener<V> gel) {
        this.addMouseListener(new MouseListenerTranslator(gel, this));
    }

    @Override
    public synchronized void addKeyListener(KeyListener l) {
        super.addKeyListener(l);
    }

    public void setEdgeToolTipTransformer(Transformer<E, String> edgeToolTipTransformer) {
        this.edgeToolTipTransformer = edgeToolTipTransformer;
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setMouseEventToolTipTransformer(Transformer<MouseEvent, String> mouseEventToolTipTransformer) {
        this.mouseEventToolTipTransformer = mouseEventToolTipTransformer;
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    public void setVertexToolTipTransformer(Transformer<V, String> vertexToolTipTransformer) {
        this.vertexToolTipTransformer = vertexToolTipTransformer;
        ToolTipManager.sharedInstance().registerComponent(this);
    }

    @Override
    public String getToolTipText(MouseEvent event) {
        Layout layout = this.getGraphLayout();
        Point2D p = null;
        if (this.vertexToolTipTransformer != null) {
            p = event.getPoint();
            Object vertex = this.getPickSupport().getVertex(layout, ((Point2D)p).getX(), ((Point2D)p).getY());
            if (vertex != null) {
                return this.vertexToolTipTransformer.transform(vertex);
            }
        }
        if (this.edgeToolTipTransformer != null) {
            Object edge2;
            if (p == null) {
                p = this.renderContext.getMultiLayerTransformer().inverseTransform(Layer.VIEW, event.getPoint());
            }
            if ((edge2 = this.getPickSupport().getEdge(layout, ((Point2D)p).getX(), ((Point2D)p).getY())) != null) {
                return this.edgeToolTipTransformer.transform(edge2);
            }
        }
        if (this.mouseEventToolTipTransformer != null) {
            return this.mouseEventToolTipTransformer.transform(event);
        }
        return super.getToolTipText(event);
    }

    public static interface GraphMouse
    extends MouseListener,
    MouseMotionListener,
    MouseWheelListener {
    }
}

