/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml.parser;

import edu.uci.ics.jung.graph.Hypergraph;
import edu.uci.ics.jung.io.GraphIOException;
import edu.uci.ics.jung.io.graphml.ExceptionConverter;
import edu.uci.ics.jung.io.graphml.Key;
import edu.uci.ics.jung.io.graphml.parser.AbstractElementParser;
import edu.uci.ics.jung.io.graphml.parser.ParserContext;
import javax.xml.stream.XMLEventReader;
import javax.xml.stream.events.EndElement;
import javax.xml.stream.events.StartElement;

public class KeyElementParser<G extends Hypergraph<V, E>, V, E>
extends AbstractElementParser<G, V, E> {
    public KeyElementParser(ParserContext<G, V, E> parserContext) {
        super(parserContext);
    }

    /*
     * Unable to fully structure code
     */
    @Override
    public Key parse(XMLEventReader xmlEventReader, StartElement start) throws GraphIOException {
        try {
            key = new Key();
            iterator = start.getAttributes();
            while (iterator.hasNext()) {
                attribute = iterator.next();
                name = attribute.getName().getLocalPart();
                value = attribute.getValue();
                if (key.getId() == null && "id".equals(name)) {
                    key.setId(value);
                    continue;
                }
                if (key.getAttributeName() == null && "attr.name".equals(name)) {
                    key.setAttributeName(value);
                    continue;
                }
                if (key.getAttributeType() == null && "attr.type".equals(name)) {
                    key.setAttributeType(value);
                    continue;
                }
                if (!"for".equals(name)) continue;
                key.setForType(KeyElementParser.convertFor(value));
            }
            if (key.getId() != null) ** GOTO lbl40
            throw new GraphIOException("Element 'key' is missing attribute 'id'");
lbl-1000:
            // 1 sources

            {
                event = xmlEventReader.nextEvent();
                if (event.isStartElement()) {
                    element = (StartElement)event;
                    name = element.getName().getLocalPart();
                    if ("desc".equals(name)) {
                        desc = (String)this.getParser(name).parse(xmlEventReader, element);
                        key.setDescription(desc);
                    } else if ("default".equals(name)) {
                        defaultValue = (String)this.getParser(name).parse(xmlEventReader, element);
                        key.setDefaultValue(defaultValue);
                    } else {
                        this.getUnknownParser().parse(xmlEventReader, element);
                    }
                }
                if (!event.isEndElement()) continue;
                end = (EndElement)event;
                this.verifyMatch(start, end);
                break;
lbl40:
                // 2 sources

                ** while (xmlEventReader.hasNext())
            }
lbl41:
            // 2 sources

            return key;
        }
        catch (Exception e) {
            ExceptionConverter.convert(e);
            return null;
        }
    }

    public static Key.ForType convertFor(String value) {
        if (value != null) {
            if ("graph".equals(value)) {
                return Key.ForType.GRAPH;
            }
            if ("edge".equals(value)) {
                return Key.ForType.EDGE;
            }
            if ("endpoint".equals(value)) {
                return Key.ForType.ENDPOINT;
            }
            if ("hyperedge".equals(value)) {
                return Key.ForType.HYPEREDGE;
            }
            if ("node".equals(value)) {
                return Key.ForType.NODE;
            }
            if ("port".equals(value)) {
                return Key.ForType.PORT;
            }
        }
        return Key.ForType.ALL;
    }
}

