/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io.graphml;

import edu.uci.ics.jung.io.graphml.AbstractMetadata;
import edu.uci.ics.jung.io.graphml.EdgeMetadata;
import edu.uci.ics.jung.io.graphml.HyperEdgeMetadata;
import edu.uci.ics.jung.io.graphml.Metadata;
import edu.uci.ics.jung.io.graphml.NodeMetadata;
import java.util.HashMap;
import java.util.Map;

public class GraphMetadata
extends AbstractMetadata {
    private String id;
    private EdgeDefault edgeDefault;
    private String description;
    private Object graph;
    private final Map<Object, NodeMetadata> nodes = new HashMap<Object, NodeMetadata>();
    private final Map<Object, EdgeMetadata> edges = new HashMap<Object, EdgeMetadata>();
    private final Map<Object, HyperEdgeMetadata> hyperEdges = new HashMap<Object, HyperEdgeMetadata>();

    public String getId() {
        return this.id;
    }

    public void setId(String id) {
        this.id = id;
    }

    public EdgeDefault getEdgeDefault() {
        return this.edgeDefault;
    }

    public void setEdgeDefault(EdgeDefault edgeDefault) {
        this.edgeDefault = edgeDefault;
    }

    public String getDescription() {
        return this.description;
    }

    public void setDescription(String desc) {
        this.description = desc;
    }

    public void addNodeMetadata(Object vertex, NodeMetadata metadata) {
        this.nodes.put(vertex, metadata);
    }

    public NodeMetadata getNodeMetadata(Object vertex) {
        return this.nodes.get(vertex);
    }

    public Map<Object, NodeMetadata> getNodeMap() {
        return this.nodes;
    }

    public void addEdgeMetadata(Object edge2, EdgeMetadata metadata) {
        this.edges.put(edge2, metadata);
    }

    public EdgeMetadata getEdgeMetadata(Object edge2) {
        return this.edges.get(edge2);
    }

    public Map<Object, EdgeMetadata> getEdgeMap() {
        return this.edges;
    }

    public void addHyperEdgeMetadata(Object edge2, HyperEdgeMetadata metadata) {
        this.hyperEdges.put(edge2, metadata);
    }

    public HyperEdgeMetadata getHyperEdgeMetadata(Object edge2) {
        return this.hyperEdges.get(edge2);
    }

    public Map<Object, HyperEdgeMetadata> getHyperEdgeMap() {
        return this.hyperEdges;
    }

    public Object getGraph() {
        return this.graph;
    }

    public void setGraph(Object graph) {
        this.graph = graph;
    }

    @Override
    public Metadata.MetadataType getMetadataType() {
        return Metadata.MetadataType.GRAPH;
    }

    public String getVertexProperty(Object vertex, String key) throws IllegalArgumentException {
        NodeMetadata metadata = this.getNodeMetadata(vertex);
        if (metadata == null) {
            throw new IllegalArgumentException("Metadata does not exist for provided vertex");
        }
        return metadata.getProperty(key);
    }

    public String getEdgeProperty(Object edge2, String key) throws IllegalArgumentException {
        EdgeMetadata em = this.getEdgeMetadata(edge2);
        if (em != null) {
            return em.getProperty(key);
        }
        HyperEdgeMetadata hem = this.getHyperEdgeMetadata(edge2);
        if (hem != null) {
            return hem.getProperty(key);
        }
        throw new IllegalArgumentException("Metadata does not exist for provided edge");
    }

    public static enum EdgeDefault {
        DIRECTED,
        UNDIRECTED;

    }
}

