/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.io;

import edu.uci.ics.jung.algorithms.util.MapSettableTransformer;
import edu.uci.ics.jung.algorithms.util.SettableTransformer;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.awt.geom.Point2D;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.io.Reader;
import java.util.ArrayList;
import java.util.HashMap;
import java.util.LinkedHashSet;
import java.util.List;
import java.util.Set;
import java.util.StringTokenizer;
import org.apache.commons.collections15.Factory;
import org.apache.commons.collections15.Predicate;
import org.apache.commons.collections15.functors.OrPredicate;

public class PajekNetReader<G extends Graph<V, E>, V, E> {
    protected Factory<V> vertex_factory;
    protected Factory<E> edge_factory;
    int nodeCount = 0;
    int edgeCount = 0;
    private SettableTransformer<V, String> vertex_labels = new MapSettableTransformer(new HashMap());
    private LinkedHashSet<String> labels = new LinkedHashSet();
    protected SettableTransformer<V, Point2D> vertex_locations = new MapSettableTransformer(new HashMap());
    protected SettableTransformer<E, Number> edge_weights = new MapSettableTransformer(new HashMap());
    private static final Predicate<String> v_pred = new StartsWithPredicate("*vertices");
    private static final Predicate<String> a_pred = new StartsWithPredicate("*arcs");
    private static final Predicate<String> e_pred = new StartsWithPredicate("*edges");
    private static final Predicate<String> t_pred = new StartsWithPredicate("*");
    private static final Predicate<String> c_pred = OrPredicate.getInstance(a_pred, e_pred);
    protected static final Predicate<String> l_pred = ListTagPred.getInstance();

    public PajekNetReader(Factory<V> vertex_factory, Factory<E> edge_factory) {
        this.vertex_factory = vertex_factory;
        this.edge_factory = edge_factory;
    }

    public PajekNetReader(Factory<E> edge_factory) {
        this(null, edge_factory);
    }

    public G load(String filename, Factory<? extends G> graph_factory) throws IOException {
        return (G)this.load((Reader)new FileReader(filename), (Graph)graph_factory.create());
    }

    public G load(Reader reader, Factory<? extends G> graph_factory) throws IOException {
        return (G)this.load(reader, (Graph)graph_factory.create());
    }

    public G load(String filename, G g) throws IOException {
        if (g == null) {
            throw new IllegalArgumentException("Graph provided must be non-null");
        }
        if (this.vertex_factory == null) {
            this.vertex_factory = new Factory<Integer>(){

                @Override
                public Integer create() {
                    return PajekNetReader.this.nodeCount++;
                }
            };
        }
        return this.load((Reader)new FileReader(filename), g);
    }

    public G load(Reader reader, G g) throws IOException {
        BufferedReader br = new BufferedReader(reader);
        String curLine = this.skip(br, v_pred);
        if (curLine == null) {
            return g;
        }
        StringTokenizer st = new StringTokenizer(curLine);
        st.nextToken();
        int num_vertices = Integer.parseInt(st.nextToken());
        ArrayList id = null;
        if (this.vertex_factory != null) {
            int i = 1;
            while (i <= num_vertices) {
                g.addVertex(this.vertex_factory.create());
                ++i;
            }
            id = new ArrayList(g.getVertices());
        }
        curLine = null;
        while (br.ready()) {
            curLine = br.readLine();
            if (curLine == null || t_pred.evaluate(curLine)) break;
            if (curLine == "") continue;
            try {
                this.readVertex(curLine, id, num_vertices, g);
            }
            catch (IllegalArgumentException iae) {
                br.close();
                reader.close();
                throw iae;
            }
        }
        curLine = this.readArcsOrEdges(curLine, br, (Graph<V, E>)g, id, this.edge_factory);
        this.readArcsOrEdges(curLine, br, (Graph<V, E>)g, id, this.edge_factory);
        br.close();
        reader.close();
        return g;
    }

    private void readVertex(String curLine, List<V> id, int num_vertices, G g) {
        String index;
        String[] parts = null;
        int coord_idx = -1;
        String label = null;
        if (curLine.indexOf(34) != -1) {
            String[] initial_split = curLine.trim().split("\"");
            if (initial_split.length < 2 || initial_split.length > 3) {
                throw new IllegalArgumentException("Unbalanced (or too many) quote marks in " + curLine);
            }
            index = initial_split[0].trim();
            label = initial_split[1].trim();
            if (initial_split.length == 3) {
                parts = initial_split[2].trim().split("\\s+", -1);
            }
            coord_idx = 0;
        } else {
            parts = curLine.trim().split("\\s+", -1);
            index = parts[0];
            switch (parts.length) {
                case 1: {
                    break;
                }
                case 2: {
                    label = parts[1];
                    break;
                }
                case 3: {
                    coord_idx = 1;
                    break;
                }
                default: {
                    coord_idx = 2;
                }
            }
        }
        int v_id = Integer.parseInt(index) - 1;
        if (v_id >= num_vertices || v_id < 0) {
            throw new IllegalArgumentException("Vertex number " + v_id + "is not in the range [1," + num_vertices + "]");
        }
        Object v = id != null ? id.get(v_id) : new Integer(v_id);
        if (label != null && label.length() > 0 && this.getVertex_labels() != null) {
            this.vertex_labels.set(v, label);
            this.labels.add(label);
        }
        if (coord_idx != -1 && parts != null && parts.length >= coord_idx + 2 && this.vertex_locations != null) {
            double x = Double.parseDouble(parts[coord_idx]);
            double y = Double.parseDouble(parts[coord_idx + 1]);
            this.vertex_locations.set(v, new Point2D.Double(x, y));
        }
    }

    private void readVertex(String curLine, List<V> id, int num_vertices) {
        String index;
        String[] parts = null;
        int coord_idx = -1;
        String label = null;
        if (curLine.indexOf(34) != -1) {
            String[] initial_split = curLine.trim().split("\"");
            if (initial_split.length < 2 || initial_split.length > 3) {
                throw new IllegalArgumentException("Unbalanced (or too many) quote marks in " + curLine);
            }
            index = initial_split[0].trim();
            label = initial_split[1].trim();
            if (initial_split.length == 3) {
                parts = initial_split[2].trim().split("\\s+", -1);
            }
            coord_idx = 0;
        } else {
            parts = curLine.trim().split("\\s+", -1);
            index = parts[0];
            switch (parts.length) {
                case 1: {
                    break;
                }
                case 2: {
                    label = parts[1];
                    break;
                }
                case 3: {
                    coord_idx = 1;
                    break;
                }
                default: {
                    coord_idx = 2;
                }
            }
        }
        int v_id = Integer.parseInt(index) - 1;
        if (v_id >= num_vertices || v_id < 0) {
            throw new IllegalArgumentException("Vertex number " + v_id + "is not in the range [1," + num_vertices + "]");
        }
        Object v = id != null ? id.get(v_id) : new Integer(v_id);
        if (label != null && label.length() > 0 && this.getVertex_labels() != null) {
            this.vertex_labels.set(v, label);
            this.labels.add(label);
        }
        if (coord_idx != -1 && parts != null && parts.length >= coord_idx + 2 && this.vertex_locations != null) {
            double x = Double.parseDouble(parts[coord_idx]);
            double y = Double.parseDouble(parts[coord_idx + 1]);
            this.vertex_locations.set(v, new Point2D.Double(x, y));
        }
    }

    private String readArcsOrEdges(String curLine, BufferedReader br, Graph<V, E> g, List<V> id, Factory<E> edge_factory) throws IOException {
        String nextLine = curLine;
        if (!c_pred.evaluate(curLine)) {
            nextLine = this.skip(br, c_pred);
        }
        boolean reading_arcs = false;
        boolean reading_edges = false;
        EdgeType directedness = null;
        if (a_pred.evaluate(nextLine)) {
            if (g instanceof UndirectedGraph) {
                throw new IllegalArgumentException("Supplied undirected-only graph cannot be populated with directed edges");
            }
            reading_arcs = true;
            directedness = EdgeType.DIRECTED;
        }
        if (e_pred.evaluate(nextLine)) {
            if (g instanceof DirectedGraph) {
                throw new IllegalArgumentException("Supplied directed-only graph cannot be populated with undirected edges");
            }
            reading_edges = true;
            directedness = EdgeType.UNDIRECTED;
        }
        if (!reading_arcs && !reading_edges) {
            return nextLine;
        }
        boolean is_list = l_pred.evaluate(nextLine);
        while (br.ready()) {
            nextLine = br.readLine();
            if (nextLine == null || t_pred.evaluate(nextLine)) break;
            if (curLine == "") continue;
            StringTokenizer st = new StringTokenizer(nextLine.trim());
            int vid1 = Integer.parseInt(st.nextToken()) - 1;
            Object v1 = id != null ? id.get(vid1) : new Integer(vid1);
            if (is_list) {
                do {
                    this.createAddEdge(st, v1, directedness, g, id, edge_factory);
                } while (st.hasMoreTokens());
                continue;
            }
            E e = this.createAddEdge(st, v1, directedness, g, id, edge_factory);
            if (this.edge_weights == null || !st.hasMoreTokens()) continue;
            this.edge_weights.set(e, new Float(st.nextToken()));
        }
        return nextLine;
    }

    protected E createAddEdge(StringTokenizer st, V v1, EdgeType directed, Graph<V, E> g, List<V> id, Factory<E> edge_factory) {
        int vid2 = Integer.parseInt(st.nextToken()) - 1;
        Object v2 = id != null ? id.get(vid2) : new Integer(vid2);
        E e = edge_factory.create();
        g.addEdge(e, v1, v2, directed);
        return e;
    }

    protected String skip(BufferedReader br, Predicate<String> p) throws IOException {
        while (br.ready()) {
            String curLine = br.readLine();
            if (curLine == null) break;
            if (!p.evaluate(curLine = curLine.trim())) continue;
            return curLine;
        }
        return null;
    }

    public SettableTransformer<V, Point2D> getVertexLocationTransformer() {
        return this.vertex_locations;
    }

    public void setVertexLocationTransformer(SettableTransformer<V, Point2D> vertex_locations) {
        this.vertex_locations = vertex_locations;
    }

    public SettableTransformer<V, String> getVertexLabeller() {
        return this.vertex_labels;
    }

    public void setVertexLabeller(SettableTransformer<V, String> vertex_labels) {
        this.vertex_labels = vertex_labels;
    }

    public SettableTransformer<E, Number> getEdgeWeightTransformer() {
        return this.edge_weights;
    }

    public void setEdgeWeightTransformer(SettableTransformer<E, Number> edge_weights) {
        this.edge_weights = edge_weights;
    }

    public Set<String> getVertex_labels() {
        return this.labels;
    }

    protected static class ListTagPred
    implements Predicate<String> {
        protected static ListTagPred instance;

        protected ListTagPred() {
        }

        protected static ListTagPred getInstance() {
            if (instance == null) {
                instance = new ListTagPred();
            }
            return instance;
        }

        @Override
        public boolean evaluate(String s) {
            return s != null && s.toLowerCase().endsWith("list");
        }
    }

    protected static class StartsWithPredicate
    implements Predicate<String> {
        private String tag;

        protected StartsWithPredicate(String s) {
            this.tag = s;
        }

        @Override
        public boolean evaluate(String str) {
            return str != null && str.toLowerCase().startsWith(this.tag);
        }
    }
}

