/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.MultiGraph;
import edu.uci.ics.jung.graph.SparseMultigraph;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.Collection;
import java.util.Collections;
import java.util.LinkedHashMap;
import java.util.LinkedHashSet;
import org.apache.commons.collections15.Factory;

public class OrderedSparseMultigraph<V, E>
extends SparseMultigraph<V, E>
implements MultiGraph<V, E> {
    public static <V, E> Factory<Graph<V, E>> getFactory() {
        return new Factory<Graph<V, E>>(){

            @Override
            public Graph<V, E> create() {
                return new OrderedSparseMultigraph();
            }
        };
    }

    public OrderedSparseMultigraph() {
        this.vertices = new LinkedHashMap();
        this.edges = new LinkedHashMap();
        this.directedEdges = new LinkedHashSet();
    }

    @Override
    public boolean addVertex(V vertex) {
        if (vertex == null) {
            throw new IllegalArgumentException("vertex may not be null");
        }
        if (!this.containsVertex(vertex)) {
            this.vertices.put(vertex, new Pair(new LinkedHashSet(), new LinkedHashSet()));
            return true;
        }
        return false;
    }

    @Override
    public Collection<V> getPredecessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        LinkedHashSet<V> preds = new LinkedHashSet<V>();
        for (Object edge2 : this.getIncoming_internal(vertex)) {
            if (this.getEdgeType(edge2) == EdgeType.DIRECTED) {
                preds.add(this.getSource(edge2));
                continue;
            }
            preds.add(this.getOpposite(vertex, edge2));
        }
        return Collections.unmodifiableCollection(preds);
    }

    @Override
    public Collection<V> getSuccessors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        LinkedHashSet<V> succs = new LinkedHashSet<V>();
        for (Object edge2 : this.getOutgoing_internal(vertex)) {
            if (this.getEdgeType(edge2) == EdgeType.DIRECTED) {
                succs.add(this.getDest(edge2));
                continue;
            }
            succs.add(this.getOpposite(vertex, edge2));
        }
        return Collections.unmodifiableCollection(succs);
    }

    @Override
    public Collection<V> getNeighbors(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        LinkedHashSet<V> out = new LinkedHashSet<V>();
        out.addAll(this.getPredecessors(vertex));
        out.addAll(this.getSuccessors(vertex));
        return out;
    }

    @Override
    public Collection<E> getIncidentEdges(V vertex) {
        if (!this.containsVertex(vertex)) {
            return null;
        }
        LinkedHashSet out = new LinkedHashSet();
        out.addAll(this.getInEdges(vertex));
        out.addAll(this.getOutEdges(vertex));
        return out;
    }
}

