/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.graph;

import edu.uci.ics.jung.graph.DelegateTree;
import edu.uci.ics.jung.graph.DirectedGraph;
import edu.uci.ics.jung.graph.DirectedSparseGraph;
import edu.uci.ics.jung.graph.Forest;
import edu.uci.ics.jung.graph.GraphDecorator;
import edu.uci.ics.jung.graph.Tree;
import edu.uci.ics.jung.graph.util.EdgeType;
import edu.uci.ics.jung.graph.util.Pair;
import edu.uci.ics.jung.graph.util.TreeUtils;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.List;

public class DelegateForest<V, E>
extends GraphDecorator<V, E>
implements Forest<V, E> {
    public DelegateForest() {
        this(new DirectedSparseGraph());
    }

    public DelegateForest(DirectedGraph<V, E> delegate) {
        super(delegate);
    }

    @Override
    public boolean addEdge(E e, V v1, V v2, EdgeType edgeType) {
        if (!this.delegate.getVertices().contains(v1)) {
            throw new IllegalArgumentException("Tree must already contain " + v1);
        }
        if (this.delegate.getVertices().contains(v2)) {
            throw new IllegalArgumentException("Tree must not already contain " + v2);
        }
        return this.delegate.addEdge(e, v1, v2, edgeType);
    }

    @Override
    public boolean addVertex(V vertex) {
        this.setRoot(vertex);
        return true;
    }

    @Override
    public boolean removeEdge(E edge2) {
        return this.removeEdge(edge2, true);
    }

    public boolean removeEdge(E edge2, boolean remove_subtree) {
        if (!this.delegate.containsEdge(edge2)) {
            return false;
        }
        Object child = this.getDest(edge2);
        if (remove_subtree) {
            return this.removeVertex(child);
        }
        this.delegate.removeEdge(edge2);
        return false;
    }

    @Override
    public boolean removeVertex(V vertex) {
        return this.removeVertex(vertex, true);
    }

    public boolean removeVertex(V vertex, boolean remove_subtrees) {
        if (!this.delegate.containsVertex(vertex)) {
            return false;
        }
        if (remove_subtrees) {
            for (V v : new ArrayList<V>(this.delegate.getSuccessors(vertex))) {
                this.removeVertex(v, true);
            }
        }
        return this.delegate.removeVertex(vertex);
    }

    public List<V> getPath(V child) {
        if (!this.delegate.containsVertex(child)) {
            return null;
        }
        ArrayList<V> list = new ArrayList<V>();
        list.add(child);
        V parent = this.getParent(child);
        while (parent != null) {
            list.add(list.size(), parent);
            parent = this.getParent(parent);
        }
        return list;
    }

    @Override
    public V getParent(V child) {
        if (!this.delegate.containsVertex(child)) {
            return null;
        }
        Collection<V> parents = this.delegate.getPredecessors(child);
        if (parents.size() > 0) {
            return parents.iterator().next();
        }
        return null;
    }

    public V getRoot() {
        return null;
    }

    public void setRoot(V root) {
        this.delegate.addVertex(root);
    }

    public boolean removeChild(V orphan) {
        return this.removeVertex(orphan);
    }

    public int getDepth(V v) {
        return this.getPath(v).size();
    }

    public int getHeight() {
        int height = 0;
        for (Object v : this.getVertices()) {
            height = Math.max(height, this.getDepth(v));
        }
        return height;
    }

    public boolean isInternal(V v) {
        return !this.isLeaf(v) && !this.isRoot(v);
    }

    public boolean isLeaf(V v) {
        return this.getChildren(v).size() == 0;
    }

    @Override
    public Collection<V> getChildren(V v) {
        return this.delegate.getSuccessors(v);
    }

    public boolean isRoot(V v) {
        return this.getParent(v) == null;
    }

    @Override
    public int getIncidentCount(E edge2) {
        return 2;
    }

    @Override
    public boolean addEdge(E edge2, Collection<? extends V> vertices) {
        Pair<V> pair = null;
        pair = vertices instanceof Pair ? (Pair<V>)vertices : new Pair<V>(vertices);
        return this.addEdge(edge2, pair.getFirst(), pair.getSecond());
    }

    public Collection<V> getRoots() {
        HashSet roots = new HashSet();
        for (Object v : this.delegate.getVertices()) {
            if (this.delegate.getPredecessorCount(v) != 0) continue;
            roots.add(v);
        }
        return roots;
    }

    @Override
    public Collection<Tree<V, E>> getTrees() {
        HashSet trees = new HashSet();
        for (V v : this.getRoots()) {
            DelegateTree tree = new DelegateTree();
            tree.addVertex(v);
            TreeUtils.growSubTree(this, tree, v);
            trees.add(tree);
        }
        return trees;
    }

    public void addTree(Tree<V, E> tree) {
        TreeUtils.addSubTree(this, tree, null, null);
    }

    @Override
    public int getChildCount(V vertex) {
        return this.delegate.getSuccessorCount(vertex);
    }

    @Override
    public Collection<E> getChildEdges(V vertex) {
        return this.delegate.getOutEdges(vertex);
    }

    @Override
    public E getParentEdge(V vertex) {
        if (this.isRoot(vertex)) {
            return null;
        }
        return this.delegate.getInEdges(vertex).iterator().next();
    }
}

