/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import edu.uci.ics.jung.algorithms.scoring.PageRankWithPriors;
import edu.uci.ics.jung.algorithms.scoring.util.ScoringUtils;
import edu.uci.ics.jung.graph.Hypergraph;
import org.apache.commons.collections15.Transformer;

public class KStepMarkov<V, E>
extends PageRankWithPriors<V, E> {
    private boolean cumulative;

    public KStepMarkov(Hypergraph<V, E> graph, Transformer<E, ? extends Number> edge_weights, Transformer<V, Double> vertex_priors, int steps) {
        super(graph, edge_weights, vertex_priors, 0.0);
        this.initialize(steps);
    }

    public KStepMarkov(Hypergraph<V, E> graph, Transformer<V, Double> vertex_priors, int steps) {
        super(graph, vertex_priors, 0.0);
        this.initialize(steps);
    }

    public KStepMarkov(Hypergraph<V, E> graph, int steps) {
        super(graph, ScoringUtils.getUniformRootPrior(graph.getVertices()), 0.0);
        this.initialize(steps);
    }

    private void initialize(int steps) {
        this.acceptDisconnectedGraph(false);
        if (steps <= 0) {
            throw new IllegalArgumentException("Number of steps must be > 0");
        }
        this.max_iterations = steps;
        this.tolerance = -1.0;
        this.cumulative = false;
    }

    public void setCumulative(boolean cumulative) {
        this.cumulative = cumulative;
    }

    @Override
    public double update(V v) {
        if (!this.cumulative) {
            return super.update(v);
        }
        this.collectDisappearingPotential(v);
        double v_input = 0.0;
        for (Object e : this.graph.getInEdges(v)) {
            int incident_count = this.getAdjustedIncidentCount(e);
            for (Object w : this.graph.getIncidentVertices(e)) {
                if (w.equals(v) && !this.hyperedges_are_self_loops) continue;
                v_input += (Double)this.getCurrentValue(w) * this.getEdgeWeight(w, e).doubleValue() / (double)incident_count;
            }
        }
        double new_value = this.alpha > 0.0 ? v_input * (1.0 - this.alpha) + (Double)this.getVertexPrior(v) * this.alpha : v_input;
        this.setOutputValue(v, new_value + (Double)this.getCurrentValue(v));
        return Math.abs((Double)this.getCurrentValue(v) - new_value);
    }
}

