/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.matrix;

import cern.colt.matrix.DoubleMatrix1D;
import cern.colt.matrix.DoubleMatrix2D;
import cern.colt.matrix.impl.DenseDoubleMatrix1D;
import cern.colt.matrix.impl.SparseDoubleMatrix2D;
import cern.colt.matrix.linalg.Algebra;
import edu.uci.ics.jung.algorithms.matrix.MatrixElementOperations;
import edu.uci.ics.jung.algorithms.util.ConstantMap;
import edu.uci.ics.jung.algorithms.util.Indexer;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.UndirectedGraph;
import java.util.ArrayList;
import java.util.Collection;
import java.util.Map;
import org.apache.commons.collections15.BidiMap;
import org.apache.commons.collections15.Factory;

public class GraphMatrixOperations {
    public static <V, E> Graph<V, E> square(Graph<V, E> g, Factory<E> edgeFactory, MatrixElementOperations<E> meo) {
        Graph squaredGraph = null;
        try {
            squaredGraph = (Graph)g.getClass().newInstance();
        }
        catch (InstantiationException e3) {
            e3.printStackTrace();
        }
        catch (IllegalAccessException e3) {
            e3.printStackTrace();
        }
        Collection vertices = g.getVertices();
        for (Object v : vertices) {
            squaredGraph.addVertex(v);
        }
        for (Object v : vertices) {
            for (V src : g.getPredecessors(v)) {
                Object e1 = g.findEdge(src, v);
                for (V dest : g.getSuccessors(v)) {
                    Object e2 = g.findEdge(v, dest);
                    Number pathData = meo.computePathData(e1, e2);
                    Object e = squaredGraph.findEdge(src, dest);
                    if (e == null) {
                        e = edgeFactory.create();
                        squaredGraph.addEdge(e, src, dest);
                    }
                    meo.mergePaths(e, pathData);
                }
            }
        }
        return squaredGraph;
    }

    public static <V, E> Graph<V, E> matrixToGraph(DoubleMatrix2D matrix, Factory<? extends Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory, Map<E, Number> nev) {
        if (matrix.rows() != matrix.columns()) {
            throw new IllegalArgumentException("Matrix must be square.");
        }
        int size = matrix.rows();
        Graph<Object, E> graph = graphFactory.create();
        int i = 0;
        while (i < size) {
            V vertex = vertexFactory.create();
            graph.addVertex(vertex);
            ++i;
        }
        ArrayList vertices = new ArrayList(graph.getVertices());
        int i2 = 0;
        while (i2 < size) {
            int j = 0;
            while (j < size) {
                E e;
                double value = matrix.getQuick(i2, j);
                if (value != 0.0 && graph.addEdge(e = edgeFactory.create(), vertices.get(i2), vertices.get(j)) && e != null && nev != null) {
                    nev.put(e, value);
                }
                ++j;
            }
            ++i2;
        }
        return graph;
    }

    public static <V, E> Graph<V, E> matrixToGraph(DoubleMatrix2D matrix, Factory<? extends Graph<V, E>> graphFactory, Factory<V> vertexFactory, Factory<E> edgeFactory) {
        return GraphMatrixOperations.matrixToGraph(matrix, graphFactory, vertexFactory, edgeFactory, null);
    }

    public static <V, E> SparseDoubleMatrix2D graphToSparseMatrix(Graph<V, E> g) {
        return GraphMatrixOperations.graphToSparseMatrix(g, null);
    }

    public static <V, E> SparseDoubleMatrix2D graphToSparseMatrix(Graph<V, E> g, Map<E, Number> nev) {
        if (nev == null) {
            nev = new ConstantMap<E, Integer>(1);
        }
        int numVertices = g.getVertexCount();
        SparseDoubleMatrix2D matrix = new SparseDoubleMatrix2D(numVertices, numVertices);
        BidiMap indexer = Indexer.create(g.getVertices());
        int i = 0;
        for (Object v : g.getVertices()) {
            for (E e : g.getOutEdges(v)) {
                V w = g.getOpposite(v, e);
                int j = (Integer)indexer.get(w);
                matrix.set(i, j, matrix.getQuick(i, j) + nev.get(e).doubleValue());
            }
            ++i;
        }
        return matrix;
    }

    public static <V, E> SparseDoubleMatrix2D createVertexDegreeDiagonalMatrix(Graph<V, E> graph) {
        int numVertices = graph.getVertexCount();
        SparseDoubleMatrix2D matrix = new SparseDoubleMatrix2D(numVertices, numVertices);
        int i = 0;
        for (Object v : graph.getVertices()) {
            matrix.set(i, i, graph.degree(v));
            ++i;
        }
        return matrix;
    }

    public static <V, E> DoubleMatrix2D computeVoltagePotentialMatrix(UndirectedGraph<V, E> graph) {
        int numVertices = graph.getVertexCount();
        SparseDoubleMatrix2D A = GraphMatrixOperations.graphToSparseMatrix(graph, null);
        SparseDoubleMatrix2D D = GraphMatrixOperations.createVertexDegreeDiagonalMatrix(graph);
        SparseDoubleMatrix2D temp = new SparseDoubleMatrix2D(numVertices - 1, numVertices - 1);
        int i = 0;
        while (i < numVertices - 1) {
            int j = 0;
            while (j < numVertices - 1) {
                temp.set(i, j, D.get(i, j) - A.get(i, j));
                ++j;
            }
            ++i;
        }
        Algebra algebra = new Algebra();
        DoubleMatrix2D tempInverse = algebra.inverse(temp);
        SparseDoubleMatrix2D T = new SparseDoubleMatrix2D(numVertices, numVertices);
        int i2 = 0;
        while (i2 < numVertices - 1) {
            int j = 0;
            while (j < numVertices - 1) {
                T.set(i2, j, tempInverse.get(i2, j));
                ++j;
            }
            ++i2;
        }
        return T;
    }

    public static <V> DoubleMatrix1D mapTo1DMatrix(Map<V, Number> map) {
        int numVertices = map.size();
        DenseDoubleMatrix1D vector = new DenseDoubleMatrix1D(numVertices);
        int i = 0;
        for (V v : map.keySet()) {
            vector.set(i, map.get(v).doubleValue());
            ++i;
        }
        return vector;
    }

    public static <V, E> DoubleMatrix2D computeMeanFirstPassageMatrix(Graph<V, E> G, Map<E, Number> edgeWeights, DoubleMatrix1D stationaryDistribution) {
        SparseDoubleMatrix2D temp = GraphMatrixOperations.graphToSparseMatrix(G, edgeWeights);
        int i = 0;
        while (i < temp.rows()) {
            int j = 0;
            while (j < temp.columns()) {
                double value = -1.0 * temp.get(i, j) + stationaryDistribution.get(j);
                if (i == j) {
                    value += 1.0;
                }
                if (value != 0.0) {
                    temp.set(i, j, value);
                }
                ++j;
            }
            ++i;
        }
        Algebra algebra = new Algebra();
        DoubleMatrix2D fundamentalMatrix = algebra.inverse(temp);
        temp = new SparseDoubleMatrix2D(temp.rows(), temp.columns());
        int i2 = 0;
        while (i2 < temp.rows()) {
            int j = 0;
            while (j < temp.columns()) {
                double value = -1.0 * fundamentalMatrix.get(i2, j);
                value += fundamentalMatrix.get(j, j);
                if (i2 == j) {
                    value += 1.0;
                }
                if (value != 0.0) {
                    temp.set(i2, j, value);
                }
                ++j;
            }
            ++i2;
        }
        SparseDoubleMatrix2D stationaryMatrixDiagonal = new SparseDoubleMatrix2D(temp.rows(), temp.columns());
        int numVertices = stationaryDistribution.size();
        int i3 = 0;
        while (i3 < numVertices) {
            stationaryMatrixDiagonal.set(i3, i3, 1.0 / stationaryDistribution.get(i3));
            ++i3;
        }
        DoubleMatrix2D meanFirstPassageMatrix = algebra.mult((DoubleMatrix2D)temp, stationaryMatrixDiagonal);
        return meanFirstPassageMatrix;
    }
}

