/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.generators;

import edu.uci.ics.jung.algorithms.generators.GraphGenerator;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.EdgeType;
import java.util.ArrayList;
import java.util.List;
import org.apache.commons.collections15.Factory;

public class Lattice2DGenerator<V, E>
implements GraphGenerator<V, E> {
    protected int row_count;
    protected int col_count;
    protected boolean is_toroidal;
    protected boolean is_directed;
    protected Factory<? extends Graph<V, E>> graph_factory;
    protected Factory<V> vertex_factory;
    protected Factory<E> edge_factory;
    private List<V> v_array;

    public Lattice2DGenerator(Factory<? extends Graph<V, E>> graph_factory, Factory<V> vertex_factory, Factory<E> edge_factory, int latticeSize, boolean isToroidal) {
        this(graph_factory, vertex_factory, edge_factory, latticeSize, latticeSize, isToroidal);
    }

    public Lattice2DGenerator(Factory<? extends Graph<V, E>> graph_factory, Factory<V> vertex_factory, Factory<E> edge_factory, int row_count, int col_count, boolean isToroidal) {
        if (row_count < 2 || col_count < 2) {
            throw new IllegalArgumentException("Row and column counts must each be at least 2.");
        }
        this.row_count = row_count;
        this.col_count = col_count;
        this.is_toroidal = isToroidal;
        this.graph_factory = graph_factory;
        this.vertex_factory = vertex_factory;
        this.edge_factory = edge_factory;
        this.is_directed = graph_factory.create().getDefaultEdgeType() == EdgeType.DIRECTED;
    }

    @Override
    public Graph<V, E> create() {
        int j;
        int vertex_count = this.row_count * this.col_count;
        Graph<V, E> graph = this.graph_factory.create();
        this.v_array = new ArrayList<V>(vertex_count);
        int i = 0;
        while (i < vertex_count) {
            V v = this.vertex_factory.create();
            graph.addVertex(v);
            this.v_array.add(i, v);
            ++i;
        }
        int start = this.is_toroidal ? 0 : 1;
        int end_row = this.is_toroidal ? this.row_count : this.row_count - 1;
        int end_col = this.is_toroidal ? this.col_count : this.col_count - 1;
        int i2 = 0;
        while (i2 < end_row) {
            j = 0;
            while (j < this.col_count) {
                graph.addEdge(this.edge_factory.create(), this.getVertex(i2, j), this.getVertex(i2 + 1, j));
                ++j;
            }
            ++i2;
        }
        i2 = 0;
        while (i2 < this.row_count) {
            j = 0;
            while (j < end_col) {
                graph.addEdge(this.edge_factory.create(), this.getVertex(i2, j), this.getVertex(i2, j + 1));
                ++j;
            }
            ++i2;
        }
        if (graph.getDefaultEdgeType() == EdgeType.DIRECTED) {
            i2 = start;
            while (i2 < this.row_count) {
                j = 0;
                while (j < this.col_count) {
                    graph.addEdge(this.edge_factory.create(), this.getVertex(i2, j), this.getVertex(i2 - 1, j));
                    ++j;
                }
                ++i2;
            }
            i2 = 0;
            while (i2 < this.row_count) {
                j = start;
                while (j < this.col_count) {
                    graph.addEdge(this.edge_factory.create(), this.getVertex(i2, j), this.getVertex(i2, j - 1));
                    ++j;
                }
                ++i2;
            }
        }
        return graph;
    }

    public int getGridEdgeCount() {
        int boundary_adjustment = this.is_toroidal ? 0 : 1;
        int vertical_edge_count = this.col_count * (this.row_count - boundary_adjustment);
        int horizontal_edge_count = this.row_count * (this.col_count - boundary_adjustment);
        return (vertical_edge_count + horizontal_edge_count) * (this.is_directed ? 2 : 1);
    }

    protected int getIndex(int i, int j) {
        return this.mod(i, this.row_count) * this.col_count + this.mod(j, this.col_count);
    }

    protected int mod(int i, int modulus) {
        int i_mod = i % modulus;
        return i_mod >= 0 ? i_mod : i_mod + modulus;
    }

    protected V getVertex(int i, int j) {
        return this.v_array.get(this.getIndex(i, j));
    }

    protected V getVertex(int i) {
        return this.v_array.get(i);
    }

    protected int getRow(int i) {
        return i / this.row_count;
    }

    protected int getCol(int i) {
        return i % this.col_count;
    }
}

