/*
 * Decompiled with CFR 0.152.
 */
package GraphMLTest;

import GraphMLTest.EdgeFactory;
import GraphMLTest.TreeBuilder;
import GraphMLTest.VertexFactory;
import GraphMLTest.vertexPainter;
import edu.uci.ics.jung.algorithms.layout.FRLayout;
import edu.uci.ics.jung.graph.AbstractTypedGraph;
import edu.uci.ics.jung.graph.DirectedSparseMultigraph;
import edu.uci.ics.jung.graph.UndirectedSparseGraph;
import edu.uci.ics.jung.io.GraphMLReader;
import edu.uci.ics.jung.visualization.VisualizationViewer;
import edu.uci.ics.jung.visualization.decorators.ToStringLabeller;
import java.io.IOException;
import java.util.Map;
import javax.swing.JFrame;
import javax.xml.parsers.ParserConfigurationException;
import mecosim.plugins.graphsPlugin.edge;
import mecosim.plugins.graphsPlugin.node;
import org.apache.commons.collections15.BidiMap;
import org.xml.sax.SAXException;

class GraphML {
    public GraphML(String filename, boolean isDirected) throws ParserConfigurationException, SAXException, IOException {
        GraphMLReader gmlr = null;
        AbstractTypedGraph graph = null;
        if (isDirected) {
            gmlr = new GraphMLReader(new VertexFactory(), new EdgeFactory());
            graph = new DirectedSparseMultigraph();
            gmlr.load(filename, graph);
        } else {
            gmlr = new GraphMLReader(new VertexFactory(), new EdgeFactory());
            graph = new UndirectedSparseGraph();
            gmlr.load(filename, graph);
        }
        BidiMap vertex_ids = gmlr.getVertexIDs();
        Map vertex_color = gmlr.getVertexMetadata();
        Map edge_meta = gmlr.getEdgeMetadata();
        for (node n : graph.getVertices()) {
            n.setValue((String)vertex_ids.get(n));
            n.setColor(vertex_color.get((Object)"d0").transformer.transform(n));
            n.setWeight(vertex_color.get((Object)"d1").transformer.transform(n));
            System.out.println("ID: " + n.getID() + ", Value: " + n.getValue() + ", Color: " + n.getColor() + ", Weight: " + n.getWeight());
        }
        for (edge e : graph.getEdges()) {
            e.setValue(edge_meta.get((Object)"d1").transformer.transform(e));
            System.out.println("Edge ID: " + e.getID() + ", Value: " + e.getValue());
        }
        TreeBuilder treeBuilder = new TreeBuilder(graph);
        VisualizationViewer vv = new VisualizationViewer(new FRLayout(graph));
        vv.getRenderContext().setVertexFillPaintTransformer(new vertexPainter());
        vv.getRenderContext().setVertexLabelTransformer(new ToStringLabeller());
        vv.getRenderContext().setEdgeLabelTransformer(new ToStringLabeller());
        JFrame frame = new JFrame();
        frame.setTitle("GraphMLReader for Trees - Reading in Attributes");
        frame.setDefaultCloseOperation(3);
        frame.getContentPane().add(vv);
        frame.pack();
        frame.setVisible(true);
    }
}

