/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.util;

import java.util.Collection;
import java.util.Iterator;

public class DiscreteDistribution {
    public static double KullbackLeibler(double[] dist, double[] reference) {
        double distance = 0.0;
        DiscreteDistribution.checkLengths(dist, reference);
        int i = 0;
        while (i < dist.length) {
            if (dist[i] > 0.0 && reference[i] > 0.0) {
                distance += dist[i] * Math.log(dist[i] / reference[i]);
            }
            ++i;
        }
        return distance;
    }

    public static double symmetricKL(double[] dist, double[] reference) {
        return DiscreteDistribution.KullbackLeibler(dist, reference) + DiscreteDistribution.KullbackLeibler(reference, dist);
    }

    public static double squaredError(double[] dist, double[] reference) {
        double error = 0.0;
        DiscreteDistribution.checkLengths(dist, reference);
        int i = 0;
        while (i < dist.length) {
            double difference = dist[i] - reference[i];
            error += difference * difference;
            ++i;
        }
        return error;
    }

    public static double cosine(double[] dist, double[] reference) {
        double v_prod = 0.0;
        double w_prod = 0.0;
        double vw_prod = 0.0;
        DiscreteDistribution.checkLengths(dist, reference);
        int i = 0;
        while (i < dist.length) {
            vw_prod += dist[i] * reference[i];
            v_prod += dist[i] * dist[i];
            w_prod += reference[i] * reference[i];
            ++i;
        }
        return vw_prod / (Math.sqrt(v_prod) * Math.sqrt(w_prod));
    }

    public static double entropy(double[] dist) {
        double total = 0.0;
        int i = 0;
        while (i < dist.length) {
            if (dist[i] > 0.0) {
                total += dist[i] * Math.log(dist[i]);
            }
            ++i;
        }
        return -total;
    }

    protected static void checkLengths(double[] dist, double[] reference) {
        if (dist.length != reference.length) {
            throw new IllegalArgumentException("Arrays must be of the same length");
        }
    }

    public static void normalize(double[] counts, double alpha) {
        double total_count = 0.0;
        int i = 0;
        while (i < counts.length) {
            total_count += counts[i];
            ++i;
        }
        i = 0;
        while (i < counts.length) {
            counts[i] = (counts[i] + alpha) / (total_count + (double)counts.length * alpha);
            ++i;
        }
    }

    public static double[] mean(Collection<double[]> distributions) {
        if (distributions.isEmpty()) {
            throw new IllegalArgumentException("Distribution collection must be non-empty");
        }
        Iterator<double[]> iter = distributions.iterator();
        double[] first = iter.next();
        double[][] d_array = new double[distributions.size()][first.length];
        d_array[0] = first;
        int i = 1;
        while (i < d_array.length) {
            d_array[i] = iter.next();
            ++i;
        }
        return DiscreteDistribution.mean(d_array);
    }

    public static double[] mean(double[][] distributions) {
        double[] d_mean = new double[distributions[0].length];
        int j = 0;
        while (j < d_mean.length) {
            d_mean[j] = 0.0;
            ++j;
        }
        int i = 0;
        while (i < distributions.length) {
            int j2 = 0;
            while (j2 < d_mean.length) {
                int n = j2;
                d_mean[n] = d_mean[n] + distributions[i][j2] / (double)distributions.length;
                ++j2;
            }
            ++i;
        }
        return d_mean;
    }
}

