/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.scoring;

import edu.uci.ics.jung.algorithms.scoring.AbstractIterativeScorerWithPriors;
import edu.uci.ics.jung.algorithms.scoring.util.UniformDegreeWeight;
import edu.uci.ics.jung.graph.Hypergraph;
import org.apache.commons.collections15.Transformer;

public class PageRankWithPriors<V, E>
extends AbstractIterativeScorerWithPriors<V, E, Double> {
    protected double disappearing_potential = 0.0;

    public PageRankWithPriors(Hypergraph<V, E> graph, Transformer<E, ? extends Number> edge_weights, Transformer<V, Double> vertex_priors, double alpha) {
        super(graph, edge_weights, vertex_priors, alpha);
    }

    public PageRankWithPriors(Hypergraph<V, E> graph, Transformer<V, Double> vertex_priors, double alpha) {
        super(graph, vertex_priors, alpha);
        this.edge_weights = new UniformDegreeWeight<V, E>(graph);
    }

    @Override
    public double update(V v) {
        this.collectDisappearingPotential(v);
        double v_input = 0.0;
        for (Object e : this.graph.getInEdges(v)) {
            int incident_count = this.getAdjustedIncidentCount(e);
            for (Object w : this.graph.getIncidentVertices(e)) {
                if (w.equals(v) && !this.hyperedges_are_self_loops) continue;
                v_input += (Double)this.getCurrentValue(w) * this.getEdgeWeight(w, e).doubleValue() / (double)incident_count;
            }
        }
        double new_value = this.alpha > 0.0 ? v_input * (1.0 - this.alpha) + (Double)this.getVertexPrior(v) * this.alpha : v_input;
        this.setOutputValue(v, new_value);
        return Math.abs((Double)this.getCurrentValue(v) - new_value);
    }

    @Override
    protected void afterStep() {
        if (this.disappearing_potential > 0.0) {
            for (Object v : this.graph.getVertices()) {
                this.setOutputValue(v, (Double)this.getOutputValue(v) + (1.0 - this.alpha) * (this.disappearing_potential * (Double)this.getVertexPrior(v)));
            }
            this.disappearing_potential = 0.0;
        }
        super.afterStep();
    }

    @Override
    protected void collectDisappearingPotential(V v) {
        if (this.graph.outDegree(v) == 0) {
            if (this.isDisconnectedGraphOK()) {
                this.disappearing_potential += ((Double)this.getCurrentValue(v)).doubleValue();
            } else {
                throw new IllegalArgumentException("Outdegree of " + v + " must be > 0");
            }
        }
    }
}

