/*
 * Decompiled with CFR 0.152.
 */
package edu.uci.ics.jung.algorithms.filters;

import edu.uci.ics.jung.algorithms.filters.Filter;
import edu.uci.ics.jung.graph.Graph;
import edu.uci.ics.jung.graph.util.Pair;
import java.util.ArrayList;
import java.util.Collection;
import java.util.HashSet;
import java.util.Set;

public class KNeighborhoodFilter<V, E>
implements Filter<V, E> {
    private Set<V> rootNodes;
    private int radiusK;
    private EdgeType edgeType;

    public KNeighborhoodFilter(Set<V> rootNodes, int radiusK, EdgeType edgeType) {
        this.rootNodes = rootNodes;
        this.radiusK = radiusK;
        this.edgeType = edgeType;
    }

    public KNeighborhoodFilter(V rootNode, int radiusK, EdgeType edgeType) {
        this.rootNodes = new HashSet<V>();
        this.rootNodes.add(rootNode);
        this.radiusK = radiusK;
        this.edgeType = edgeType;
    }

    @Override
    public Graph<V, E> transform(Graph<V, E> graph) {
        int currentDepth = 0;
        ArrayList<V> currentVertices = new ArrayList<V>();
        HashSet<V> visitedVertices = new HashSet<V>();
        HashSet visitedEdges = new HashSet();
        HashSet<V> acceptedVertices = new HashSet<V>();
        for (V currentRoot : this.rootNodes) {
            visitedVertices.add(currentRoot);
            acceptedVertices.add(currentRoot);
            currentVertices.add(currentRoot);
        }
        ArrayList<V> newVertices = null;
        while (currentDepth < this.radiusK) {
            newVertices = new ArrayList<V>();
            for (Object currentVertex : currentVertices) {
                Collection edges = null;
                switch (this.edgeType) {
                    case IN_OUT: {
                        edges = graph.getIncidentEdges(currentVertex);
                        break;
                    }
                    case IN: {
                        edges = graph.getInEdges(currentVertex);
                        break;
                    }
                    case OUT: {
                        edges = graph.getOutEdges(currentVertex);
                    }
                }
                for (Object currentEdge : edges) {
                    V currentNeighbor = graph.getOpposite(currentVertex, currentEdge);
                    if (visitedEdges.contains(currentEdge)) continue;
                    visitedEdges.add(currentEdge);
                    if (visitedVertices.contains(currentNeighbor)) continue;
                    visitedVertices.add(currentNeighbor);
                    acceptedVertices.add(currentNeighbor);
                    newVertices.add(currentNeighbor);
                }
            }
            currentVertices = newVertices;
            ++currentDepth;
        }
        Graph ug = null;
        try {
            ug = (Graph)graph.getClass().newInstance();
            for (Object edge2 : graph.getEdges()) {
                Pair<V> endpoints = graph.getEndpoints(edge2);
                if (!acceptedVertices.containsAll(endpoints)) continue;
                ug.addEdge(edge2, endpoints.getFirst(), endpoints.getSecond());
            }
        }
        catch (InstantiationException e) {
            throw new RuntimeException("Unable to create copy of existing graph: ", e);
        }
        catch (IllegalAccessException e) {
            throw new RuntimeException("Unable to create copy of existing graph: ", e);
        }
        return ug;
    }

    public static enum EdgeType {
        IN_OUT,
        IN,
        OUT;

    }
}

