package org.gcn.plinguacore.simulator.cellLike.probabilistic.bddcb;


import java.util.Collection;
import java.util.HashMap;
import java.util.Iterator;
import java.util.Map;


import org.gcn.plinguacore.util.ExtendedLinkedHashSet;
import org.gcn.plinguacore.util.Pair;
import org.gcn.plinguacore.util.Triple;
import org.gcn.plinguacore.util.psystem.Psystem;
import org.gcn.plinguacore.util.psystem.cellLike.CellLikePsystem;
import org.gcn.plinguacore.util.psystem.cellLike.membrane.CellLikeSkinMembrane;
import org.gcn.plinguacore.util.psystem.rule.IRule;
import org.gcn.plinguacore.util.psystem.rule.RulesSet;



public class StaticMatrix {
	
	private ExtendedLinkedHashSet<MatrixColumn>columns;
	private ExtendedLinkedHashSet<MatrixRow>rows; 
	private Map<MatrixKey,Double>staticMatrix;
	private Map<String,String>environmentLabels;
	private CellLikePsystem ps;
	
	public StaticMatrix(Psystem ps)
	{
		if (ps==null)
			throw new NullPointerException();
		if (!(ps instanceof CellLikePsystem))
			throw new IllegalArgumentException();
		this.ps = (CellLikePsystem)ps;
		initColumns();
		initRowsAndCells();
		//ps.setRules(null);
		
		
	}

	
	private void initRowsAndCells()
	{
		rows = new ExtendedLinkedHashSet<MatrixRow>();
		staticMatrix = new HashMap<MatrixKey,Double>();
		Map<String,String>parents = StaticMethods.getParents((CellLikeSkinMembrane)ps.getMembraneStructure());
	
		for (MatrixColumn column:columns)
		{
			Collection<Triple<String,String,Long>>ternas=column.getLeftHandRuleObjects(parents);
			for (Triple<String,String,Long>t:ternas)
			{
				MatrixRow row = new MatrixRow(t.getFirst(),t.getSecond()); 
				rows.add(row); /* Al ser un SET se evitan repeticiones */
				MatrixKey key = new MatrixKey(row,column);
				staticMatrix.put(key,1/(double)t.getThird());
				
			}
		}
	
	}
	

	private void initColumns()
	{
		RulesSet rulesSet = ps.getRules();
		environmentLabels = StaticMethods.getEnvironments((CellLikeSkinMembrane)ps.getMembraneStructure());
		columns = new ExtendedLinkedHashSet<MatrixColumn>();
		SkeletonRulesBlock b2,b1=new SkeletonRulesBlock();
		SkeletonRightHandRule rhr2,rhr1 = new SkeletonRightHandRule();
		EnvironmentRulesBlock e2,e1 = new EnvironmentRulesBlock();
		
		Iterator<IRule> it=rulesSet.iterator();
		while(it.hasNext())
		{
			IRule r = it.next();
			if (StaticMethods.isSkeletonRule(r,environmentLabels))
			{
				b1.getSkeletonLeftHandRule().set(r);
				b2 = (SkeletonRulesBlock)columns.get(b1);
				if (b2==null)
				{
					b2 = (SkeletonRulesBlock)b1.clone();
					columns.add(b2);
				}
				rhr1.set(r);
				rhr2=b2.getSkeletonRightHandRules().get(rhr1);
				if (rhr2==null)
				{
					rhr2 = (SkeletonRightHandRule)rhr1.clone();
					b2.getSkeletonRightHandRules().add(rhr2);
				}
				rhr2.setProbability(StaticMethods.getEnvironment(r), StaticMethods.getProbability(r));
			}
			else
			{
				e1.getEnvironmentLeftHandRule().set(r);
				e2 = (EnvironmentRulesBlock)columns.get(e1);
				if (e2==null)
				{
					e2 = (EnvironmentRulesBlock)e1.clone();
					columns.add(e2);
				}
				EnvironmentRightHandRule erhr=new EnvironmentRightHandRule();
				erhr.set(r);
				e2.getEnvironmentRightHandRules().add(erhr);
				
			}
		}
		
	}
	
	
	

	public ExtendedLinkedHashSet<MatrixRow> getRows() {
		return rows;
	}


	public Map<MatrixKey, Double> getStaticMatrix() {
		return staticMatrix;
	}


	public ExtendedLinkedHashSet<MatrixColumn> getColumns() {
		return columns;
	}

	
	

	public Map<String, String> getEnvironmentLabels() {
		return environmentLabels;
	}


	@Override
	public String toString() {
		// TODO Auto-generated method stub
		String str = "Columns: ";
		str+=columns.toString()+"\n";
		str+="Rows: "+rows.toString()+"\n";
		str+="Cells: "+staticMatrix.toString();
		return str;
	}
	
	

}
